/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.ofc.BarChartCompiler;
import net.sf.jasperreports.components.ofc.BarDataset;
import net.sf.jasperreports.components.ofc.BarSeries;
import net.sf.jasperreports.components.ofc.DefaultBarSeries;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseElementDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class CompiledBarDataset
extends JRBaseElementDataset
implements BarDataset {
    private static final long serialVersionUID = 1L;
    private List seriesList;

    public CompiledBarDataset(BarDataset dataset, JRBaseObjectFactory factory) {
        super((JRElementDataset)dataset, factory);
        List series = dataset.getSeries();
        this.seriesList = new ArrayList(series.size());
        for (BarSeries barSeries : series) {
            DefaultBarSeries compiledSeries = new DefaultBarSeries();
            compiledSeries.setSeriesExpression(factory.getExpression(barSeries.getSeriesExpression()));
            compiledSeries.setCategoryExpression(factory.getExpression(barSeries.getCategoryExpression()));
            compiledSeries.setValueExpression(factory.getExpression(barSeries.getValueExpression()));
            this.seriesList.add(compiledSeries);
        }
    }

    public void collectExpressions(JRExpressionCollector collector) {
        BarChartCompiler.collectExpressions(this, collector);
    }

    public List getSeries() {
        return this.seriesList;
    }
}

