/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.olap4j.OlapConnection;
import org.olap4j.OlapDatabaseMetaData;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.driver.xmla.Factory;
import org.olap4j.driver.xmla.XmlaHelper;
import org.olap4j.driver.xmla.XmlaOlap4jCatalog;
import org.olap4j.driver.xmla.XmlaOlap4jCube;
import org.olap4j.driver.xmla.XmlaOlap4jDatabaseMetaData;
import org.olap4j.driver.xmla.XmlaOlap4jDimension;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.XmlaOlap4jHierarchy;
import org.olap4j.driver.xmla.XmlaOlap4jLevel;
import org.olap4j.driver.xmla.XmlaOlap4jMeasure;
import org.olap4j.driver.xmla.XmlaOlap4jMember;
import org.olap4j.driver.xmla.XmlaOlap4jNamedSet;
import org.olap4j.driver.xmla.XmlaOlap4jProperty;
import org.olap4j.driver.xmla.XmlaOlap4jSchema;
import org.olap4j.driver.xmla.XmlaOlap4jStatement;
import org.olap4j.driver.xmla.XmlaOlap4jUtil;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jCachedProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxyException;
import org.olap4j.impl.ConnectStringParser;
import org.olap4j.impl.Named;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.UnmodifiableArrayList;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.MdxParserFactory;
import org.olap4j.mdx.parser.MdxValidator;
import org.olap4j.mdx.parser.impl.DefaultMdxParserImpl;
import org.olap4j.metadata.Catalog;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jConnection
implements OlapConnection {
    final XmlaHelper helper = new XmlaHelper();
    private XmlaOlap4jSchema olap4jSchema;
    private final XmlaOlap4jDatabaseMetaData olap4jDatabaseMetaData;
    private static final String CONNECT_STRING_PREFIX = "jdbc:xmla:";
    final XmlaOlap4jDriver driver;
    final Factory factory;
    final XmlaOlap4jProxy proxy;
    private boolean closed;
    final URL serverUrl;
    private Locale locale;
    private String catalogName;
    private static final boolean DEBUG = false;
    private String roleName;
    private String providerName;
    private String datasourceName;
    private String nativeDatasourceName;
    private boolean autoCommit;
    private boolean readOnly;
    private static final String DATA_SOURCE_NAME = "DATA_SOURCE_NAME";
    private static final String PROVIDER_NAME = "PROVIDER_NAME";
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile(".*[a-z].*");

    XmlaOlap4jConnection(Factory factory, XmlaOlap4jDriver driver, XmlaOlap4jProxy proxy, String url, Properties info) throws SQLException {
        this.factory = factory;
        this.driver = driver;
        this.proxy = proxy;
        if (!XmlaOlap4jConnection.acceptsURL(url)) {
            throw new AssertionError((Object)"does not start with 'jdbc:xmla:'");
        }
        Map<String, String> map = XmlaOlap4jConnection.parseConnectString(url, info);
        this.providerName = map.get(XmlaOlap4jDriver.Property.Provider.name());
        this.datasourceName = map.get(XmlaOlap4jDriver.Property.DataSource.name());
        this.catalogName = map.get(XmlaOlap4jDriver.Property.Catalog.name());
        String serverUrl = map.get(XmlaOlap4jDriver.Property.Server.name());
        if (serverUrl == null) {
            throw this.getHelper().createException("Connection property '" + XmlaOlap4jDriver.Property.Server.name() + "' must be specified");
        }
        if (map.containsKey("user") && map.containsKey("password")) {
            serverUrl = serverUrl.replaceFirst(":\\/\\/([^@]*@){0,1}", "://".concat(map.get("user")).concat(":").concat(map.get("password").concat("@")));
        }
        this.initSoapCache(map);
        try {
            this.serverUrl = new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw this.getHelper().createException("Error while creating connection", e);
        }
        this.olap4jDatabaseMetaData = factory.newDatabaseMetaData(this);
    }

    private final XmlaHelper getHelper() {
        return this.helper;
    }

    private void initSoapCache(Map<String, String> map) throws OlapException {
        if (map.containsKey(XmlaOlap4jDriver.Property.Cache.name().toUpperCase())) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!entry.getKey().startsWith(XmlaOlap4jDriver.Property.Cache.name().toUpperCase() + ".")) continue;
                props.put(entry.getKey().substring(XmlaOlap4jDriver.Property.Cache.name().length() + 1), entry.getValue());
            }
            ((XmlaOlap4jCachedProxy)this.proxy).setCache(map, props);
        }
    }

    static Map<String, String> parseConnectString(String url, Properties info) {
        String x = url.substring(CONNECT_STRING_PREFIX.length());
        Map<String, String> map = ConnectStringParser.parseConnectString(x);
        for (Map.Entry<String, String> entry : XmlaOlap4jConnection.toMap(info).entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    static boolean acceptsURL(String url) {
        return url.startsWith(CONNECT_STRING_PREFIX);
    }

    String getDataSourceInfo() throws OlapException {
        if (this.nativeDatasourceName != null) {
            return this.nativeDatasourceName;
        }
        ResultSet rSet = null;
        try {
            String currentDatasource;
            rSet = this.olap4jDatabaseMetaData.getDatasources();
            if (this.datasourceName != null || this.providerName != null) {
                while (rSet.next()) {
                    currentDatasource = rSet.getString(DATA_SOURCE_NAME);
                    String currentProvider = rSet.getString(PROVIDER_NAME);
                    if (!(currentDatasource.equals(this.datasourceName) && currentProvider.equals(this.providerName) || currentDatasource.equals(this.datasourceName) && this.providerName == null) && (!currentProvider.equals(this.providerName) || this.datasourceName != null)) continue;
                    this.nativeDatasourceName = currentDatasource;
                    break;
                }
            } else if (rSet.first()) {
                this.nativeDatasourceName = rSet.getString(DATA_SOURCE_NAME);
            }
            if (this.nativeDatasourceName == null) {
                throw this.getHelper().createException("No datasource could be found.");
            }
            currentDatasource = this.nativeDatasourceName;
            return currentDatasource;
        }
        catch (OlapException e) {
            throw e;
        }
        catch (SQLException e) {
            throw this.getHelper().createException("Datasource name not found.", e);
        }
        finally {
            try {
                if (rSet != null) {
                    rSet.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    @Override
    public OlapStatement createStatement() {
        return new XmlaOlap4jStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public OlapDatabaseMetaData getMetaData() {
        return this.olap4jDatabaseMetaData;
    }

    @Override
    public NamedList<Catalog> getCatalogs() {
        return this.olap4jDatabaseMetaData.getCatalogObjects();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.catalogName = catalog;
    }

    @Override
    public String getCatalog() throws OlapException {
        if (this.catalogName == null) {
            NamedList<Catalog> catalogs = this.getCatalogs();
            if (catalogs.size() == 0) {
                throw new OlapException("There is no catalog available to query against.");
            }
            this.catalogName = ((Catalog)catalogs.get(0)).getName();
        } else {
            Catalog buf = this.getCatalogs().get(this.catalogName);
            if (buf != null) {
                this.catalogName = buf.getName();
            } else {
                throw new OlapException("There is no catalog named " + this.catalogName + " available to query against.");
            }
        }
        return this.catalogName;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.getHelper().createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public PreparedOlapStatement prepareOlapStatement(String mdx) throws OlapException {
        return this.factory.newPreparedStatement(mdx, this);
    }

    @Override
    public MdxParserFactory getParserFactory() {
        return new MdxParserFactory(){

            public MdxParser createMdxParser(OlapConnection connection) {
                return new DefaultMdxParserImpl(connection);
            }

            public MdxValidator createMdxValidator(OlapConnection connection) {
                return new XmlaOlap4jMdxValidator(connection);
            }
        };
    }

    @Override
    public synchronized Schema getSchema() throws OlapException {
        if (this.olap4jSchema == null) {
            XmlaOlap4jCatalog catalog = (XmlaOlap4jCatalog)this.olap4jDatabaseMetaData.getCatalogObjects().get(this.getCatalog());
            this.olap4jSchema = (XmlaOlap4jSchema)catalog.getSchemas().get(0);
        }
        return this.olap4jSchema;
    }

    public static Map<String, String> toMap(final Properties properties) {
        return new AbstractMap<String, String>(){

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                return Olap4jUtil.cast(properties.entrySet());
            }
        };
    }

    String getURL() {
        throw Olap4jUtil.needToImplement(this);
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null");
        }
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setRoleName(String roleName) throws OlapException {
        this.roleName = roleName;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    <T extends Named> void populateList(List<T> list, Context context, MetadataRequest metadataRequest, Handler<T> handler, Object[] restrictions) throws OlapException {
        String request = this.generateRequest(context, metadataRequest, restrictions);
        Element root = this.xxx(request);
        for (Element o : XmlaOlap4jUtil.childElements(root)) {
            if (!o.getLocalName().equals("row")) continue;
            handler.handle(o, context, list);
        }
        handler.sortList(list);
    }

    Element xxx(String request) throws OlapException {
        Document doc;
        byte[] bytes;
        try {
            bytes = this.proxy.get(this.serverUrl, request);
        }
        catch (IOException e) {
            throw this.getHelper().createException(e);
        }
        catch (XmlaOlap4jProxyException e) {
            throw this.getHelper().createException("This connection encountered an exception while executing a query.", e);
        }
        try {
            doc = XmlaOlap4jUtil.parse(bytes);
        }
        catch (IOException e) {
            throw this.getHelper().createException("error discovering metadata", e);
        }
        catch (SAXException e) {
            throw this.getHelper().createException("error discovering metadata", e);
        }
        Element envelope = doc.getDocumentElement();
        assert (envelope.getLocalName().equals("Envelope"));
        assert (envelope.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        Element body = XmlaOlap4jUtil.findChild(envelope, "http://schemas.xmlsoap.org/soap/envelope/", "Body");
        Element fault = XmlaOlap4jUtil.findChild(body, "http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        if (fault != null) {
            throw this.getHelper().createException("XMLA provider gave exception: " + XmlaOlap4jUtil.prettyPrint(fault) + "\n" + "Request was:\n" + request);
        }
        Element discoverResponse = XmlaOlap4jUtil.findChild(body, "urn:schemas-microsoft-com:xml-analysis", "DiscoverResponse");
        Element returnElement = XmlaOlap4jUtil.findChild(discoverResponse, "urn:schemas-microsoft-com:xml-analysis", "return");
        return XmlaOlap4jUtil.findChild(returnElement, "urn:schemas-microsoft-com:xml-analysis:rowset", "root");
    }

    public String generateRequest(Context context, MetadataRequest metadataRequest, Object[] restrictions) throws OlapException {
        String content = "Data";
        String encoding = this.proxy.getEncodingCharsetName();
        StringBuilder buf = new StringBuilder("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n" + "<SOAP-ENV:Envelope\n" + "    xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\n" + "    SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n" + "  <SOAP-ENV:Body>\n" + "    <Discover xmlns=\"urn:schemas-microsoft-com:xml-analysis\"\n" + "        SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n" + "    <RequestType>");
        buf.append(metadataRequest.name());
        buf.append("</RequestType>\n    <Restrictions>\n      <RestrictionList>\n");
        if (restrictions.length > 0) {
            if (restrictions.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < restrictions.length; i += 2) {
                String restriction = (String)restrictions[i];
                Object o = restrictions[i + 1];
                if (o instanceof String) {
                    buf.append("<").append(restriction).append(">");
                    String value = (String)o;
                    buf.append(XmlaOlap4jConnection.xmlEncode(value));
                    buf.append("</").append(restriction).append(">");
                    continue;
                }
                List valueList = (List)o;
                for (String value : valueList) {
                    buf.append("<").append(restriction).append(">");
                    buf.append(XmlaOlap4jConnection.xmlEncode(value));
                    buf.append("</").append(restriction).append(">");
                }
            }
        }
        buf.append("      </RestrictionList>\n    </Restrictions>\n    <Properties>\n      <PropertyList>\n");
        if (metadataRequest.requiresDatasourceName()) {
            buf.append("        <DataSourceInfo>");
            buf.append(XmlaOlap4jConnection.xmlEncode(context.olap4jConnection.getDataSourceInfo()));
            buf.append("</DataSourceInfo>\n");
        }
        if (metadataRequest.requiresCatalogName()) {
            buf.append("        <Catalog>");
            buf.append(XmlaOlap4jConnection.xmlEncode(context.olap4jConnection.getCatalog()));
            buf.append("</Catalog>\n");
        }
        buf.append("        <Content>");
        buf.append(XmlaOlap4jConnection.xmlEncode("Data"));
        buf.append("</Content>\n      </PropertyList>\n    </Properties>\n    </Discover>\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>");
        return buf.toString();
    }

    private static String xmlEncode(String value) {
        value = Olap4jUtil.replace(value, "&", "&amp;");
        value = Olap4jUtil.replace(value, "<", "&lt;");
        value = Olap4jUtil.replace(value, ">", "&gt;");
        value = Olap4jUtil.replace(value, "\"", "&quot;");
        value = Olap4jUtil.replace(value, "'", "&apos;");
        return value;
    }

    private static class XmlaOlap4jMdxValidator
    implements MdxValidator {
        private final OlapConnection connection;

        XmlaOlap4jMdxValidator(OlapConnection connection) {
            this.connection = connection;
        }

        public SelectNode validateSelect(SelectNode selectNode) throws OlapException {
            StringWriter sw = new StringWriter();
            selectNode.unparse(new ParseTreeWriter(new PrintWriter(sw)));
            String mdx = sw.toString();
            XmlaOlap4jConnection olap4jConnection = (XmlaOlap4jConnection)this.connection;
            return selectNode;
        }
    }

    static class MetadataColumn {
        final String name;
        final String xmlaName;

        MetadataColumn(String xmlaName, String name) {
            this.xmlaName = xmlaName;
            this.name = name;
        }

        MetadataColumn(String xmlaName) {
            this.xmlaName = xmlaName;
            String name = xmlaName;
            if (LOWERCASE_PATTERN.matcher(name).matches()) {
                name = Olap4jUtil.camelToUpper(name);
            }
            if (name.equals("VALUE")) {
                name = "PROPERTY_VALUE";
            }
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MetadataRequest {
        DISCOVER_DATASOURCES(new MetadataColumn("DataSourceName"), new MetadataColumn("DataSourceDescription"), new MetadataColumn("URL"), new MetadataColumn("DataSourceInfo"), new MetadataColumn("ProviderName"), new MetadataColumn("ProviderType"), new MetadataColumn("AuthenticationMode")),
        DISCOVER_SCHEMA_ROWSETS(new MetadataColumn("SchemaName"), new MetadataColumn("SchemaGuid"), new MetadataColumn("Restrictions"), new MetadataColumn("Description")),
        DISCOVER_ENUMERATORS(new MetadataColumn("EnumName"), new MetadataColumn("EnumDescription"), new MetadataColumn("EnumType"), new MetadataColumn("ElementName"), new MetadataColumn("ElementDescription"), new MetadataColumn("ElementValue")),
        DISCOVER_PROPERTIES(new MetadataColumn("PropertyName"), new MetadataColumn("PropertyDescription"), new MetadataColumn("PropertyType"), new MetadataColumn("PropertyAccessType"), new MetadataColumn("IsRequired"), new MetadataColumn("Value")),
        DISCOVER_KEYWORDS(new MetadataColumn("Keyword")),
        DISCOVER_LITERALS(new MetadataColumn("LiteralName"), new MetadataColumn("LiteralValue"), new MetadataColumn("LiteralInvalidChars"), new MetadataColumn("LiteralInvalidStartingChars"), new MetadataColumn("LiteralMaxLength")),
        DBSCHEMA_CATALOGS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("ROLES"), new MetadataColumn("DATE_MODIFIED")),
        DBSCHEMA_COLUMNS(new MetadataColumn("TABLE_CATALOG"), new MetadataColumn("TABLE_SCHEMA"), new MetadataColumn("TABLE_NAME"), new MetadataColumn("COLUMN_NAME"), new MetadataColumn("ORDINAL_POSITION"), new MetadataColumn("COLUMN_HAS_DEFAULT"), new MetadataColumn("COLUMN_FLAGS"), new MetadataColumn("IS_NULLABLE"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("CHARACTER_MAXIMUM_LENGTH"), new MetadataColumn("CHARACTER_OCTET_LENGTH"), new MetadataColumn("NUMERIC_PRECISION"), new MetadataColumn("NUMERIC_SCALE")),
        DBSCHEMA_PROVIDER_TYPES(new MetadataColumn("TYPE_NAME"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("COLUMN_SIZE"), new MetadataColumn("LITERAL_PREFIX"), new MetadataColumn("LITERAL_SUFFIX"), new MetadataColumn("IS_NULLABLE"), new MetadataColumn("CASE_SENSITIVE"), new MetadataColumn("SEARCHABLE"), new MetadataColumn("UNSIGNED_ATTRIBUTE"), new MetadataColumn("FIXED_PREC_SCALE"), new MetadataColumn("AUTO_UNIQUE_VALUE"), new MetadataColumn("IS_LONG"), new MetadataColumn("BEST_MATCH")),
        DBSCHEMA_TABLES(new MetadataColumn("TABLE_CATALOG"), new MetadataColumn("TABLE_SCHEMA"), new MetadataColumn("TABLE_NAME"), new MetadataColumn("TABLE_TYPE"), new MetadataColumn("TABLE_GUID"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("TABLE_PROPID"), new MetadataColumn("DATE_CREATED"), new MetadataColumn("DATE_MODIFIED")),
        DBSCHEMA_TABLES_INFO(new MetadataColumn("TABLE_CATALOG"), new MetadataColumn("TABLE_SCHEMA"), new MetadataColumn("TABLE_NAME"), new MetadataColumn("TABLE_TYPE"), new MetadataColumn("TABLE_GUID"), new MetadataColumn("BOOKMARKS"), new MetadataColumn("BOOKMARK_TYPE"), new MetadataColumn("BOOKMARK_DATATYPE"), new MetadataColumn("BOOKMARK_MAXIMUM_LENGTH"), new MetadataColumn("BOOKMARK_INFORMATION"), new MetadataColumn("TABLE_VERSION"), new MetadataColumn("CARDINALITY"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("TABLE_PROPID")),
        DBSCHEMA_SCHEMATA(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("SCHEMA_OWNER")),
        MDSCHEMA_ACTIONS(new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("ACTION_NAME"), new MetadataColumn("COORDINATE"), new MetadataColumn("COORDINATE_TYPE")),
        MDSCHEMA_CUBES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("CUBE_TYPE"), new MetadataColumn("CUBE_GUID"), new MetadataColumn("CREATED_ON"), new MetadataColumn("LAST_SCHEMA_UPDATE"), new MetadataColumn("SCHEMA_UPDATED_BY"), new MetadataColumn("LAST_DATA_UPDATE"), new MetadataColumn("DATA_UPDATED_BY"), new MetadataColumn("IS_DRILLTHROUGH_ENABLED"), new MetadataColumn("IS_WRITE_ENABLED"), new MetadataColumn("IS_LINKABLE"), new MetadataColumn("IS_SQL_ENABLED"), new MetadataColumn("DESCRIPTION")),
        MDSCHEMA_DIMENSIONS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("DIMENSION_GUID"), new MetadataColumn("DIMENSION_CAPTION"), new MetadataColumn("DIMENSION_ORDINAL"), new MetadataColumn("DIMENSION_TYPE"), new MetadataColumn("DIMENSION_CARDINALITY"), new MetadataColumn("DEFAULT_HIERARCHY"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("IS_VIRTUAL"), new MetadataColumn("IS_READWRITE"), new MetadataColumn("DIMENSION_UNIQUE_SETTINGS"), new MetadataColumn("DIMENSION_MASTER_UNIQUE_NAME"), new MetadataColumn("DIMENSION_IS_VISIBLE")),
        MDSCHEMA_FUNCTIONS(new MetadataColumn("FUNCTION_NAME"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("PARAMETER_LIST"), new MetadataColumn("RETURN_TYPE"), new MetadataColumn("ORIGIN"), new MetadataColumn("INTERFACE_NAME"), new MetadataColumn("LIBRARY_NAME"), new MetadataColumn("CAPTION")),
        MDSCHEMA_HIERARCHIES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_GUID"), new MetadataColumn("HIERARCHY_CAPTION"), new MetadataColumn("DIMENSION_TYPE"), new MetadataColumn("HIERARCHY_CARDINALITY"), new MetadataColumn("DEFAULT_MEMBER"), new MetadataColumn("ALL_MEMBER"), new MetadataColumn("DESCRIPTION"), new MetadataColumn("STRUCTURE"), new MetadataColumn("IS_VIRTUAL"), new MetadataColumn("IS_READWRITE"), new MetadataColumn("DIMENSION_UNIQUE_SETTINGS"), new MetadataColumn("DIMENSION_IS_VISIBLE"), new MetadataColumn("HIERARCHY_ORDINAL"), new MetadataColumn("DIMENSION_IS_SHARED"), new MetadataColumn("PARENT_CHILD")),
        MDSCHEMA_LEVELS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("LEVEL_NAME"), new MetadataColumn("LEVEL_UNIQUE_NAME"), new MetadataColumn("LEVEL_GUID"), new MetadataColumn("LEVEL_CAPTION"), new MetadataColumn("LEVEL_NUMBER"), new MetadataColumn("LEVEL_CARDINALITY"), new MetadataColumn("LEVEL_TYPE"), new MetadataColumn("CUSTOM_ROLLUP_SETTINGS"), new MetadataColumn("LEVEL_UNIQUE_SETTINGS"), new MetadataColumn("LEVEL_IS_VISIBLE"), new MetadataColumn("DESCRIPTION")),
        MDSCHEMA_MEASURES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("MEASURE_NAME"), new MetadataColumn("MEASURE_UNIQUE_NAME"), new MetadataColumn("MEASURE_CAPTION"), new MetadataColumn("MEASURE_GUID"), new MetadataColumn("MEASURE_AGGREGATOR"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("MEASURE_IS_VISIBLE"), new MetadataColumn("LEVELS_LIST"), new MetadataColumn("DESCRIPTION")),
        MDSCHEMA_MEMBERS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("LEVEL_UNIQUE_NAME"), new MetadataColumn("LEVEL_NUMBER"), new MetadataColumn("MEMBER_ORDINAL"), new MetadataColumn("MEMBER_NAME"), new MetadataColumn("MEMBER_UNIQUE_NAME"), new MetadataColumn("MEMBER_TYPE"), new MetadataColumn("MEMBER_GUID"), new MetadataColumn("MEMBER_CAPTION"), new MetadataColumn("CHILDREN_CARDINALITY"), new MetadataColumn("PARENT_LEVEL"), new MetadataColumn("PARENT_UNIQUE_NAME"), new MetadataColumn("PARENT_COUNT"), new MetadataColumn("TREE_OP"), new MetadataColumn("DEPTH")),
        MDSCHEMA_PROPERTIES(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("DIMENSION_UNIQUE_NAME"), new MetadataColumn("HIERARCHY_UNIQUE_NAME"), new MetadataColumn("LEVEL_UNIQUE_NAME"), new MetadataColumn("MEMBER_UNIQUE_NAME"), new MetadataColumn("PROPERTY_NAME"), new MetadataColumn("PROPERTY_CAPTION"), new MetadataColumn("PROPERTY_TYPE"), new MetadataColumn("DATA_TYPE"), new MetadataColumn("PROPERTY_CONTENT_TYPE"), new MetadataColumn("DESCRIPTION")),
        MDSCHEMA_SETS(new MetadataColumn("CATALOG_NAME"), new MetadataColumn("SCHEMA_NAME"), new MetadataColumn("CUBE_NAME"), new MetadataColumn("SET_NAME"), new MetadataColumn("SCOPE"));

        final List<MetadataColumn> columns;
        final Map<String, MetadataColumn> columnsByName;

        private MetadataRequest(MetadataColumn ... columns) {
            if (this.name().equals("DBSCHEMA_CATALOGS")) {
                columns = new MetadataColumn[]{new MetadataColumn("CATALOG_NAME", "TABLE_CAT")};
            } else if (this.name().equals("DBSCHEMA_SCHEMATA")) {
                columns = new MetadataColumn[]{new MetadataColumn("SCHEMA_NAME", "TABLE_SCHEM"), new MetadataColumn("CATALOG_NAME", "TABLE_CAT")};
            }
            this.columns = UnmodifiableArrayList.asCopyOf(columns);
            HashMap<String, MetadataColumn> map = new HashMap<String, MetadataColumn>();
            for (MetadataColumn column : columns) {
                map.put(column.name, column);
            }
            this.columnsByName = Collections.unmodifiableMap(map);
        }

        public boolean requiresDatasourceName() {
            return this != DISCOVER_DATASOURCES;
        }

        public boolean requiresCatalogName() {
            return this != DBSCHEMA_CATALOGS && this != DISCOVER_DATASOURCES;
        }

        public MetadataColumn getColumn(String name) {
            return this.columnsByName.get(name);
        }
    }

    static class Context {
        final XmlaOlap4jConnection olap4jConnection;
        final XmlaOlap4jDatabaseMetaData olap4jDatabaseMetaData;
        final XmlaOlap4jCatalog olap4jCatalog;
        final XmlaOlap4jSchema olap4jSchema;
        final XmlaOlap4jCube olap4jCube;
        final XmlaOlap4jDimension olap4jDimension;
        final XmlaOlap4jHierarchy olap4jHierarchy;
        final XmlaOlap4jLevel olap4jLevel;

        Context(XmlaOlap4jConnection olap4jConnection, XmlaOlap4jDatabaseMetaData olap4jDatabaseMetaData, XmlaOlap4jCatalog olap4jCatalog, XmlaOlap4jSchema olap4jSchema, XmlaOlap4jCube olap4jCube, XmlaOlap4jDimension olap4jDimension, XmlaOlap4jHierarchy olap4jHierarchy, XmlaOlap4jLevel olap4jLevel) {
            this.olap4jConnection = olap4jConnection;
            this.olap4jDatabaseMetaData = olap4jDatabaseMetaData;
            this.olap4jCatalog = olap4jCatalog;
            this.olap4jSchema = olap4jSchema;
            this.olap4jCube = olap4jCube;
            this.olap4jDimension = olap4jDimension;
            this.olap4jHierarchy = olap4jHierarchy;
            this.olap4jLevel = olap4jLevel;
            assert (!(olap4jDatabaseMetaData == null && olap4jCatalog != null || olap4jCatalog == null && olap4jSchema != null || olap4jSchema == null && olap4jCube != null || olap4jCube == null && olap4jDimension != null || olap4jDimension == null && olap4jHierarchy != null || olap4jHierarchy == null && olap4jLevel != null));
        }

        Context(XmlaOlap4jCube olap4jCube, XmlaOlap4jDimension olap4jDimension, XmlaOlap4jHierarchy olap4jHierarchy, XmlaOlap4jLevel olap4jLevel) {
            this(olap4jCube.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection, olap4jCube.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData, olap4jCube.olap4jSchema.olap4jCatalog, olap4jCube.olap4jSchema, olap4jCube, olap4jDimension, olap4jHierarchy, olap4jLevel);
        }

        Context(XmlaOlap4jLevel olap4jLevel) {
            this(olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube, olap4jLevel.olap4jHierarchy.olap4jDimension, olap4jLevel.olap4jHierarchy, olap4jLevel);
        }

        XmlaOlap4jHierarchy getHierarchy(Element row) {
            if (this.olap4jHierarchy != null) {
                return this.olap4jHierarchy;
            }
            String hierarchyUniqueName = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_UNIQUE_NAME");
            return this.getCube((Element)row).hierarchiesByUname.get(hierarchyUniqueName);
        }

        XmlaOlap4jCube getCube(Element row) {
            if (this.olap4jCube != null) {
                return this.olap4jCube;
            }
            throw new UnsupportedOperationException();
        }

        XmlaOlap4jDimension getDimension(Element row) {
            if (this.olap4jDimension != null) {
                return this.olap4jDimension;
            }
            String dimensionUniqueName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_UNIQUE_NAME");
            return this.getCube((Element)row).dimensionsByUname.get(dimensionUniqueName);
        }

        public XmlaOlap4jLevel getLevel(Element row) {
            if (this.olap4jLevel != null) {
                return this.olap4jLevel;
            }
            String levelUniqueName = XmlaOlap4jUtil.stringElement(row, "LEVEL_UNIQUE_NAME");
            return this.getCube((Element)row).levelsByUname.get(levelUniqueName);
        }

        public XmlaOlap4jCatalog getCatalog(Element row) throws OlapException {
            if (this.olap4jCatalog != null) {
                return this.olap4jCatalog;
            }
            String catalogName = XmlaOlap4jUtil.stringElement(row, "CATALOG_NAME");
            return (XmlaOlap4jCatalog)this.olap4jConnection.getCatalogs().get(catalogName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class HandlerImpl<T extends Named>
    implements Handler<T> {
        HandlerImpl() {
        }

        @Override
        public void sortList(List<T> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Handler<T extends Named> {
        public void handle(Element var1, Context var2, List<T> var3) throws OlapException;

        public void sortList(List<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyHandler
    extends HandlerImpl<XmlaOlap4jProperty> {
        PropertyHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jProperty> list) throws OlapException {
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            String uniqueName = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            String caption = XmlaOlap4jUtil.stringElement(row, "PROPERTY_CAPTION");
            String name = XmlaOlap4jUtil.stringElement(row, "PROPERTY_NAME");
            Datatype dataType = Datatype.forXmlaOrdinal(XmlaOlap4jUtil.integerElement(row, "DATA_TYPE"));
            Integer contentTypeOrdinal = XmlaOlap4jUtil.integerElement(row, "PROPERTY_CONTENT_TYPE");
            Property.ContentType contentType = contentTypeOrdinal == null ? null : Property.ContentType.forXmlaOrdinal(contentTypeOrdinal);
            int propertyType = XmlaOlap4jUtil.integerElement(row, "PROPERTY_TYPE");
            Set<Property.TypeFlag> type = Property.TypeFlag.forMask(propertyType);
            list.add(new XmlaOlap4jProperty(uniqueName, name, caption, description, dataType, type, contentType));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CatalogSchemaHandler
    extends HandlerImpl<XmlaOlap4jSchema> {
        private String catalogName;

        public CatalogSchemaHandler(String catalogName) {
            if (catalogName == null) {
                throw new RuntimeException("The CatalogSchemaHandler handler requires a catalog name.");
            }
            this.catalogName = catalogName;
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jSchema> list) throws OlapException {
            String schemaName = XmlaOlap4jUtil.stringElement(row, "SCHEMA_NAME");
            String catalogName = XmlaOlap4jUtil.stringElement(row, "CATALOG_NAME");
            if (this.catalogName.equals(catalogName)) {
                list.add(new XmlaOlap4jSchema(context.getCatalog(row), schemaName == null ? "" : schemaName));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SchemaHandler
    extends HandlerImpl<XmlaOlap4jSchema> {
        SchemaHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jSchema> list) throws OlapException {
            String schemaName = XmlaOlap4jUtil.stringElement(row, "SCHEMA_NAME");
            list.add(new XmlaOlap4jSchema(context.getCatalog(row), schemaName == null ? "" : schemaName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NamedSetHandler
    extends HandlerImpl<XmlaOlap4jNamedSet> {
        NamedSetHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jNamedSet> list) {
            String setName = XmlaOlap4jUtil.stringElement(row, "SET_NAME");
            list.add(new XmlaOlap4jNamedSet(context.getCube(row), setName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MemberHandler
    extends HandlerImpl<XmlaOlap4jMember> {
        private static final Set<String> EXCLUDED_PROPERTY_NAMES = new HashSet<String>(Arrays.asList(Property.StandardMemberProperty.CATALOG_NAME.name(), Property.StandardMemberProperty.CUBE_NAME.name(), Property.StandardMemberProperty.DIMENSION_UNIQUE_NAME.name(), Property.StandardMemberProperty.HIERARCHY_UNIQUE_NAME.name(), Property.StandardMemberProperty.LEVEL_UNIQUE_NAME.name(), Property.StandardMemberProperty.PARENT_LEVEL.name(), Property.StandardMemberProperty.PARENT_COUNT.name(), Property.StandardMemberProperty.MEMBER_KEY.name(), Property.StandardMemberProperty.IS_PLACEHOLDERMEMBER.name(), Property.StandardMemberProperty.IS_DATAMEMBER.name(), Property.StandardMemberProperty.LEVEL_NUMBER.name(), Property.StandardMemberProperty.MEMBER_ORDINAL.name(), Property.StandardMemberProperty.MEMBER_UNIQUE_NAME.name(), Property.StandardMemberProperty.MEMBER_NAME.name(), Property.StandardMemberProperty.PARENT_UNIQUE_NAME.name(), Property.StandardMemberProperty.MEMBER_TYPE.name(), Property.StandardMemberProperty.MEMBER_CAPTION.name(), Property.StandardMemberProperty.CHILDREN_CARDINALITY.name(), Property.StandardMemberProperty.DEPTH.name()));

        MemberHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jMember> list) {
            int memberOrdinal = XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.MEMBER_ORDINAL.name());
            String memberUniqueName = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.MEMBER_UNIQUE_NAME.name());
            String memberName = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.MEMBER_NAME.name());
            String parentUniqueName = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.PARENT_UNIQUE_NAME.name());
            Member.Type memberType = Member.Type.values()[XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.MEMBER_TYPE.name())];
            String memberCaption = XmlaOlap4jUtil.stringElement(row, Property.StandardMemberProperty.MEMBER_CAPTION.name());
            int childrenCardinality = XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.CHILDREN_CARDINALITY.name());
            XmlaOlap4jMember member = new XmlaOlap4jMember(context.getLevel(row), memberUniqueName, memberName, memberCaption, "", parentUniqueName, memberType, childrenCardinality, memberOrdinal);
            this.addUserDefinedDimensionProperties(row, member);
            Integer depth = XmlaOlap4jUtil.integerElement(row, Property.StandardMemberProperty.DEPTH.name());
            if (depth != null && depth.intValue() != member.getLevel().getDepth()) {
                member.setProperty(Property.StandardMemberProperty.DEPTH, depth);
            }
            list.add(member);
        }

        private void addUserDefinedDimensionProperties(Element row, XmlaOlap4jMember member) {
            NodeList nodes = row.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (EXCLUDED_PROPERTY_NAMES.contains(node.getLocalName())) continue;
                for (Property property : member.getLevel().getProperties()) {
                    if (!(property instanceof XmlaOlap4jProperty) || !property.getName().equalsIgnoreCase(node.getLocalName())) continue;
                    member.setProperty(property, node.getTextContent());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MeasureHandler
    extends HandlerImpl<XmlaOlap4jMeasure> {
        MeasureHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jMeasure> list) throws OlapException {
            XmlaOlap4jMember member;
            String measureName = XmlaOlap4jUtil.stringElement(row, "MEASURE_NAME");
            String measureUniqueName = XmlaOlap4jUtil.stringElement(row, "MEASURE_UNIQUE_NAME");
            String measureCaption = XmlaOlap4jUtil.stringElement(row, "MEASURE_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            Measure.Aggregator measureAggregator = Measure.Aggregator.forXmlaOrdinal(XmlaOlap4jUtil.integerElement(row, "MEASURE_AGGREGATOR"));
            Datatype datatype = Datatype.forXmlaOrdinal(XmlaOlap4jUtil.integerElement(row, "DATA_TYPE"));
            boolean measureIsVisible = XmlaOlap4jUtil.booleanElement(row, "MEASURE_IS_VISIBLE");
            XmlaOlap4jLevel measuresLevel = (XmlaOlap4jLevel)context.getCube(row).getHierarchies().get("Measures").getLevels().get(0);
            if (list.isEmpty()) {
                List<Member> measureMembers = measuresLevel.getMembers();
                Olap4jUtil.discard(measureMembers);
            }
            int ordinal = (member = context.getCube(row).getMetadataReader().lookupMemberByUniqueName(measureUniqueName)) != null ? member.getOrdinal() : -1;
            list.add(new XmlaOlap4jMeasure(measuresLevel, measureUniqueName, measureName, measureCaption, description, null, measureAggregator, datatype, measureIsVisible, ordinal));
        }

        @Override
        public void sortList(List<XmlaOlap4jMeasure> list) {
            Collections.sort(list, new Comparator<XmlaOlap4jMeasure>(){

                @Override
                public int compare(XmlaOlap4jMeasure o1, XmlaOlap4jMeasure o2) {
                    return o1.getOrdinal() - o2.getOrdinal();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LevelHandler
    extends HandlerImpl<XmlaOlap4jLevel> {
        public static final int MDLEVEL_TYPE_CALCULATED = 2;

        LevelHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jLevel> list) {
            String levelName = XmlaOlap4jUtil.stringElement(row, "LEVEL_NAME");
            String levelUniqueName = XmlaOlap4jUtil.stringElement(row, "LEVEL_UNIQUE_NAME");
            String levelCaption = XmlaOlap4jUtil.stringElement(row, "LEVEL_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            int levelNumber = XmlaOlap4jUtil.integerElement(row, "LEVEL_NUMBER");
            Integer levelTypeCode = XmlaOlap4jUtil.integerElement(row, "LEVEL_TYPE");
            Level.Type levelType = Level.Type.forXmlaOrdinal(levelTypeCode);
            boolean calculated = (levelTypeCode & 2) != 0;
            int levelCardinality = XmlaOlap4jUtil.integerElement(row, "LEVEL_CARDINALITY");
            list.add(new XmlaOlap4jLevel(context.getHierarchy(row), levelUniqueName, levelName, levelCaption, description, levelNumber, levelType, calculated, levelCardinality));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HierarchyHandler
    extends HandlerImpl<XmlaOlap4jHierarchy> {
        HierarchyHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jHierarchy> list) throws OlapException {
            String hierarchyName = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_NAME");
            String hierarchyUniqueName = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_UNIQUE_NAME");
            String hierarchyCaption = XmlaOlap4jUtil.stringElement(row, "HIERARCHY_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            String allMember = XmlaOlap4jUtil.stringElement(row, "ALL_MEMBER");
            String defaultMemberUniqueName = XmlaOlap4jUtil.stringElement(row, "DEFAULT_MEMBER");
            list.add(new XmlaOlap4jHierarchy(context.getDimension(row), hierarchyUniqueName, hierarchyName, hierarchyCaption, description, allMember != null, defaultMemberUniqueName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DimensionHandler
    extends HandlerImpl<XmlaOlap4jDimension> {
        DimensionHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jDimension> list) {
            String dimensionName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_NAME");
            String dimensionUniqueName = XmlaOlap4jUtil.stringElement(row, "DIMENSION_UNIQUE_NAME");
            String dimensionCaption = XmlaOlap4jUtil.stringElement(row, "DIMENSION_CAPTION");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            int dimensionType = XmlaOlap4jUtil.integerElement(row, "DIMENSION_TYPE");
            Dimension.Type type = Dimension.Type.forXmlaOrdinal(dimensionType);
            String defaultHierarchyUniqueName = XmlaOlap4jUtil.stringElement(row, "DEFAULT_HIERARCHY");
            list.add(new XmlaOlap4jDimension(context.olap4jCube, dimensionUniqueName, dimensionName, dimensionCaption, description, type, defaultHierarchyUniqueName));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CubeHandler
    extends HandlerImpl<XmlaOlap4jCube> {
        CubeHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jCube> list) throws OlapException {
            String cubeName = XmlaOlap4jUtil.stringElement(row, "CUBE_NAME");
            String description = XmlaOlap4jUtil.stringElement(row, "DESCRIPTION");
            list.add(new XmlaOlap4jCube(context.olap4jSchema, cubeName, description));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CatalogHandler
    extends HandlerImpl<XmlaOlap4jCatalog> {
        CatalogHandler() {
        }

        @Override
        public void handle(Element row, Context context, List<XmlaOlap4jCatalog> list) {
            String catalogName = XmlaOlap4jUtil.stringElement(row, "CATALOG_NAME");
            list.add(new XmlaOlap4jCatalog(context.olap4jDatabaseMetaData, catalogName));
        }
    }
}

