/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MakerStats {
    private String _name;
    private Map _map;
    private int _count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(String caller, int initSize, int finalSize) {
        SizeSample stat = null;
        Object object = this._map;
        synchronized (object) {
            stat = (SizeSample)this._map.get(caller);
            if (stat == null) {
                stat = new SizeSample(caller, initSize);
                this._map.put(caller, stat);
            }
            ++this._count;
        }
        object = stat;
        synchronized (object) {
            stat.add(finalSize);
            return;
        }
    }

    public void display(PrintStream printer) {
        printer.println("caller,min,max,range,samples,average,initial");
        ArrayList list = new ArrayList(this._map.size());
        list.addAll(this._map.values());
        Collections.sort(list);
        int maxSize = 0;
        int sampleSize = 0;
        int totalSize = 0;
        int i = 0;
        while (i < list.size()) {
            SizeSample stat = (SizeSample)list.get(i);
            printer.print(stat.getCaller());
            printer.print(",");
            printer.print(stat.getMinSize());
            printer.print(",");
            printer.print(stat.getMaxSize());
            printer.print(",");
            printer.print(stat.getMaxSize() - stat.getMinSize());
            printer.print(",");
            printer.print(stat.getSamplesSize());
            printer.print(",");
            printer.print(stat.getTotalSize() / stat.getSamplesSize());
            printer.print(",");
            printer.println(stat.getInitSize());
            sampleSize += stat.getSamplesSize();
            totalSize += stat.getTotalSize();
            if (stat.getMaxSize() > maxSize) {
                maxSize = stat.getMaxSize();
            }
            ++i;
        }
        int avg = 0;
        if (sampleSize > 0) {
            avg = totalSize / sampleSize;
        }
        printer.print("SAMPLES=");
        printer.print(sampleSize);
        printer.print(", AVERAGE=");
        printer.print(avg);
        printer.print(", MAX=");
        printer.println(maxSize);
    }

    private final /* synthetic */ void this() {
        this._map = new HashMap();
    }

    public MakerStats(String name) {
        this.this();
        this._name = name;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SizeSample
    implements Comparable {
        private String _caller;
        private int _initSize;
        private int _maxSize;
        private int _minSize;
        private int _samplesSize;
        private int _totalSize;

        public void add(int finalSize) {
            if (finalSize < this._minSize) {
                this._minSize = finalSize;
            }
            if (finalSize > this._maxSize) {
                this._maxSize = finalSize;
            }
            ++this._samplesSize;
            this._totalSize += finalSize;
        }

        public String getCaller() {
            return this._caller;
        }

        public int getInitSize() {
            return this._initSize;
        }

        public int getMaxSize() {
            return this._maxSize;
        }

        public int getMinSize() {
            return this._minSize;
        }

        public int getSamplesSize() {
            return this._samplesSize;
        }

        public int getTotalSize() {
            return this._totalSize;
        }

        public int compareTo(Object obj) {
            SizeSample other = (SizeSample)obj;
            int thisAvg = 0;
            if (this._samplesSize > 0) {
                thisAvg = this._totalSize / this._samplesSize;
            }
            int otherAvg = 0;
            if (other.getSamplesSize() > 0) {
                otherAvg = other.getTotalSize() / other.getSamplesSize();
            }
            return otherAvg - thisAvg;
        }

        public SizeSample(String caller, int initSize) {
            this._caller = caller;
            this._initSize = initSize;
            this._minSize = Integer.MAX_VALUE;
            this._maxSize = Integer.MIN_VALUE;
        }
    }
}

