/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleSerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buffer;
    private long length;
    private boolean isFreed = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public OracleSerialClob(char[] cArray) throws SQLException {
        this.length = cArray.length;
        this.buffer = new char[(int)this.length];
        int n2 = 0;
        while ((long)n2 < this.length) {
            this.buffer[n2] = cArray[n2];
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleSerialClob(Clob clob) throws SQLException {
        this.length = clob.length();
        this.buffer = new char[(int)this.length];
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
        try {
            try {
                int n2 = 0;
                int n3 = 0;
                do {
                    n2 = bufferedReader.read(this.buffer, n3, (int)(this.length - (long)n3));
                    n3 += n2;
                } while (n2 > 0);
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 347, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 347, iOException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        try {}
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 347, iOException.getMessage());
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bufferedReader == null) return;
        bufferedReader.close();
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new StringBufferInputStream(new String(this.buffer));
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new CharArrayReader(this.buffer);
    }

    public String getSubString(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L || n2 < 0 || (long)n2 > this.length || l2 + (long)n2 - 1L > this.length) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 == 0) {
            return new String();
        }
        return new String(this.buffer, (int)l2 - 1, n2);
    }

    public long length() throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.length;
    }

    public long position(String string, long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 > this.length || l2 + (long)string.length() > this.length) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n2 = (int)(l2 - 1L);
        boolean bl = false;
        long l3 = cArray.length;
        while ((long)n2 < this.length) {
            int n3 = 0;
            long l4 = n2 + 1;
            int n4 = n2;
            while ((long)n3 < l3 && (long)n4 < this.length && cArray[n3] == this.buffer[n4]) {
                ++n4;
                if ((long)(++n3) != l3) continue;
                return l4;
            }
            ++n2;
        }
        return -1L;
    }

    public long position(Clob clob, long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.position(clob.getSubString(0L, (int)clob.length()), l2);
    }

    public int setString(long l2, String string) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public void truncate(long l2) throws SQLException {
        if (this.isFreed) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

