/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CRowidAccessor
extends RowidAccessor {
    T4CMAREngine mare;
    static final int maxLength = 128;
    static final int EXTENDED_ROWID_MAX_LENGTH = 18;
    final int[] meta = new int[1];
    static final int KGRD_EXTENDED_OBJECT = 6;
    static final int KGRD_EXTENDED_BLOCK = 6;
    static final int KGRD_EXTENDED_FILE = 3;
    static final int KGRD_EXTENDED_SLOT = 3;
    static final int kd4_ubridtype_physicall = 1;
    static final int kd4_ubridtype_logical = 2;
    static final int kd4_ubridtype_remote = 3;
    static final int kd4_ubridtype_exttab = 4;
    static final int kd4_ubridlen_typeind = 1;
    static final byte[] kgrd_indbyte_char = new byte[]{65, 42, 45, 40, 41};
    static final byte[] kgrd_basis_64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] kgrd_index_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CRowidAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
        this.defineType = 104;
    }

    T4CRowidAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl, n3, n4, n5, n6, n7, s2);
        this.mare = t4CMAREngine;
        this.definedColumnType = n8;
        this.definedColumnSize = n9;
        this.defineType = 104;
    }

    void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.statement.sqlKind != 1 && this.statement.sqlKind != 4) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind == 1 || this.statement.sqlKind == 4 || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            short s2 = this.mare.unmarshalUB1();
            long l2 = 0L;
            int n2 = 0;
            short s3 = 0;
            long l3 = 0L;
            int n3 = 0;
            if (s2 > 0) {
                l2 = this.mare.unmarshalUB4();
                n2 = this.mare.unmarshalUB2();
                s3 = this.mare.unmarshalUB1();
                l3 = this.mare.unmarshalUB4();
                n3 = this.mare.unmarshalUB2();
            }
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n4 = this.indicatorIndex + this.lastRowProcessed;
        int n5 = this.lengthIndex + this.lastRowProcessed;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n4] = -1;
            this.rowSpaceIndicator[n5] = 0;
            ++this.lastRowProcessed;
            if (this.statement.connection.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n6 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        if (this.describeType != 208) {
            short s4 = this.mare.unmarshalUB1();
            long l4 = 0L;
            int n7 = 0;
            short s5 = 0;
            long l5 = 0L;
            int n8 = 0;
            if (s4 > 0) {
                l4 = this.mare.unmarshalUB4();
                n7 = this.mare.unmarshalUB2();
                s5 = this.mare.unmarshalUB1();
                l5 = this.mare.unmarshalUB4();
                n8 = this.mare.unmarshalUB2();
            }
            if (l4 == 0L && n7 == 0 && s5 == 0 && l5 == 0L && n8 == 0) {
                this.meta[0] = 0;
            } else {
                long[] lArray = new long[]{l4, n7, l5, n8};
                byte[] byArray = T4CRowidAccessor.rowidToString(lArray);
                int n9 = 18;
                if (this.byteLength - 2 < 18) {
                    n9 = this.byteLength - 2;
                }
                System.arraycopy(byArray, 0, this.rowSpaceByte, n6 + 2, n9);
                this.meta[0] = n9;
            }
        } else {
            this.meta[0] = (int)this.mare.unmarshalUB4();
            if (this.meta[0] > 0) {
                byte[] byArray = new byte[this.meta[0]];
                this.mare.unmarshalCLR(byArray, 0, this.meta);
                T4CRowidAccessor.kgrdub2c(byArray, this.meta[0], 0, this.rowSpaceByte, n6 + 2);
            }
        }
        this.rowSpaceByte[n6] = (byte)((this.meta[0] & 0xFF00) >> 8);
        this.rowSpaceByte[n6 + 1] = (byte)(this.meta[0] & 0xFF);
        this.processIndicator(this.meta[0]);
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[n4] = -1;
            this.rowSpaceIndicator[n5] = 0;
        } else {
            this.rowSpaceIndicator[n5] = (short)this.meta[0];
            this.rowSpaceIndicator[n4] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            if (this.describeType != 208 || this.rowSpaceByte[n3] == 1) {
                string = new String(this.rowSpaceByte, n3 + 2, (int)s2);
                long[] lArray = T4CRowidAccessor.stringToRowid(string.getBytes(), 0, string.length());
                string = new String(T4CRowidAccessor.rowidToString(lArray));
            } else {
                string = new String(this.rowSpaceByte, n3 + 2, (int)s2);
            }
        }
        return string;
    }

    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        Object var2_2 = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(n2);
                }
                case -8: {
                    return this.getROWID(n2);
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return var2_2;
    }

    void copyRow() throws SQLException, IOException {
        int n2 = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int n3 = this.columnIndex + this.lastRowProcessed * this.byteLength;
        int n4 = this.columnIndex + n2 * this.byteLength;
        int n5 = this.indicatorIndex + this.lastRowProcessed;
        int n6 = this.indicatorIndex + n2;
        int n7 = this.lengthIndex + this.lastRowProcessed;
        int n8 = this.lengthIndex + n2;
        short s2 = this.rowSpaceIndicator[n8];
        int n9 = this.metaDataIndex + this.lastRowProcessed * 1;
        int n10 = this.metaDataIndex + n2 * 1;
        this.rowSpaceIndicator[n7] = s2;
        this.rowSpaceIndicator[n5] = this.rowSpaceIndicator[n6];
        System.arraycopy(this.rowSpaceByte, n4, this.rowSpaceByte, n3, s2 + 2);
        System.arraycopy(this.rowSpaceMetaData, n10, this.rowSpaceMetaData, n9, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
        int n4 = this.columnIndex + (n3 - 1) * this.byteLength;
        int n5 = this.columnIndexLastRow + (n2 - 1) * this.byteLength;
        int n6 = this.indicatorIndex + n3 - 1;
        int n7 = this.indicatorIndexLastRow + n2 - 1;
        int n8 = this.lengthIndex + n3 - 1;
        int n9 = this.lengthIndexLastRow + n2 - 1;
        short s2 = sArray[n9];
        this.rowSpaceIndicator[n8] = s2;
        this.rowSpaceIndicator[n6] = sArray[n7];
        if (s2 != 0) {
            System.arraycopy(byArray, n5, this.rowSpaceByte, n4, s2 + 2);
        }
    }

    static final byte[] rowidToString(long[] lArray) {
        long l2 = lArray[0];
        long l3 = lArray[1];
        long l4 = lArray[2];
        long l5 = lArray[3];
        int n2 = 18;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        n3 = T4CRowidAccessor.kgrd42b(byArray, l2, 6, n3);
        n3 = T4CRowidAccessor.kgrd42b(byArray, l3, 3, n3);
        n3 = T4CRowidAccessor.kgrd42b(byArray, l4, 6, n3);
        n3 = T4CRowidAccessor.kgrd42b(byArray, l5, 3, n3);
        return byArray;
    }

    static final long[] rcToRowid(byte[] byArray, int n2, int n3) throws SQLException {
        long l2;
        int n4 = 18;
        if (n3 != n4) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] lArray = new long[3];
        String string = new String(byArray, n2, n3);
        long l3 = Long.parseLong(string.substring(0, 8), 16);
        long l4 = Long.parseLong(string.substring(9, 13), 16);
        lArray[0] = l2 = Long.parseLong(string.substring(14, 8), 16);
        lArray[1] = l3;
        lArray[2] = l4;
        return lArray;
    }

    static final byte[] kgrdr2rc(long[] lArray) {
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        int n2 = 18;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        n3 = T4CRowidAccessor.lmx42h(byArray, l3, 8, n3);
        byArray[n3++] = 46;
        n3 = T4CRowidAccessor.lmx42h(byArray, l4, 4, n3);
        byArray[n3++] = 46;
        n3 = T4CRowidAccessor.lmx42h(byArray, l2, 4, n3);
        return byArray;
    }

    static final int lmx42h(byte[] byArray, long l2, int n2, int n3) {
        String string = Long.toHexString(l2);
        int n4 = n2;
        int n5 = 0;
        do {
            if (n5 < string.length()) {
                byArray[n3 + n2 - 1] = (byte)string.charAt(string.length() - n5 - 1);
                ++n5;
                continue;
            }
            byArray[n3 + n2 - 1] = 48;
        } while (--n2 > 0);
        return n4 + n3;
    }

    static final long[] stringToRowid(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = 18;
        if (n3 != n4) {
            throw new SQLException("Rowid size incorrect.");
        }
        long[] lArray = new long[4];
        try {
            lArray[0] = T4CRowidAccessor.kgrdb42(byArray, 6, n2);
            lArray[1] = T4CRowidAccessor.kgrdb42(byArray, 3, n2 += 6);
            lArray[2] = T4CRowidAccessor.kgrdb42(byArray, 6, n2 += 3);
            lArray[3] = T4CRowidAccessor.kgrdb42(byArray, 3, n2 += 6);
            n2 += 3;
        }
        catch (Exception exception) {
            lArray[0] = 0L;
            lArray[1] = 0L;
            lArray[2] = 0L;
            lArray[3] = 0L;
        }
        return lArray;
    }

    static final int kgrd42b(byte[] byArray, long l2, int n2, int n3) {
        int n4 = n2;
        long l3 = l2;
        while (n2 > 0) {
            byArray[n3 + n2 - 1] = kgrd_basis_64[(int)l3 & 0x3F];
            l3 = l3 >>> 6 & 0x3FFFFFFL;
            --n2;
        }
        return n4 + n3;
    }

    static final long kgrdb42(byte[] byArray, int n2, int n3) throws SQLException {
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[n3 + i2];
            if ((by = kgrd_index_64[by]) == -1) {
                throw new SQLException("Char data to rowid conversion failed.");
            }
            l2 <<= 6;
            l2 |= (long)by;
        }
        return l2;
    }

    static final void kgrdub2c(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws SQLException {
        byte by = byArray[n3];
        int n5 = 0;
        int n6 = n2 - 1;
        int n7 = 4 * (n2 / 3) + (n2 % 3 == 0 ? n2 % 3 + 1 : 0);
        int n8 = 1 + n7 - 1;
        if (n8 != 0) {
            byArray2[n4 + 0] = kgrd_indbyte_char[by - 1];
            int n9 = n3 + 1;
            n5 = 1;
            byte by2 = 0;
            while (n6 > 0) {
                byArray2[n4 + n5++] = kgrd_basis_64[(byArray[n9] & 0xFF) >> 2];
                if (n6 == 1) {
                    byArray2[n4 + n5++] = kgrd_basis_64[(byArray[n9] & 3) << 4];
                    break;
                }
                by2 = (byte)(byArray[n9 + 1] & 0xFF);
                byArray2[n4 + n5++] = kgrd_basis_64[(byArray[n9] & 3) << 4 | (by2 & 0xF0) >> 4];
                if (n6 == 2) {
                    byArray2[n4 + n5++] = kgrd_basis_64[(by2 & 0xF) << 2];
                    break;
                }
                byArray2[n4 + n5++] = kgrd_basis_64[(by2 & 0xF) << 2 | (byArray[n9 += 2] & 0xC0) >> 6];
                byArray2[n4 + n5] = kgrd_basis_64[byArray[n9] & 0x3F];
                n6 -= 3;
                ++n9;
                ++n5;
            }
        }
    }
}

