/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ANYDATA;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

class AQMessageI
implements AQMessage {
    private byte[] id = null;
    private AQMessagePropertiesI properties = null;
    private byte[] toid = null;
    private byte[] payload;
    private STRUCT payLoadSTRUCT;
    private ANYDATA payLoadANYDATA;
    private RAW payLoadRAW;
    private XMLType payLoadXMLType;
    private Connection conn;
    private String typeName;
    private TypeDescriptor sd;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    AQMessageI(AQMessagePropertiesI aQMessagePropertiesI, Connection connection) {
        this.properties = aQMessagePropertiesI;
        this.conn = connection;
    }

    AQMessageI(AQMessagePropertiesI aQMessagePropertiesI) throws SQLException {
        this.properties = aQMessagePropertiesI;
    }

    void setTypeName(String string) {
        this.typeName = string;
    }

    void setTypeDescriptor(TypeDescriptor typeDescriptor) {
        this.sd = typeDescriptor;
    }

    public byte[] getMessageId() {
        return this.id;
    }

    void setMessageId(byte[] byArray) throws SQLException {
        this.id = byArray;
    }

    public AQMessageProperties getMessageProperties() {
        return this.properties;
    }

    AQMessagePropertiesI getMessagePropertiesI() {
        return this.properties;
    }

    public void setPayload(byte[] byArray) throws SQLException {
        this.payload = byArray;
        this.toid = TypeDescriptor.RAWTOID;
    }

    public void setPayload(byte[] byArray, byte[] byArray2) throws SQLException {
        this.payload = byArray;
        this.toid = byArray2;
    }

    public void setPayload(STRUCT sTRUCT) throws SQLException {
        this.payload = sTRUCT.toBytes();
        this.payLoadSTRUCT = sTRUCT;
        this.toid = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
    }

    public void setPayload(ANYDATA aNYDATA) throws SQLException {
        this.payload = aNYDATA.toDatum(this.conn).shareBytes();
        this.payLoadANYDATA = aNYDATA;
        this.toid = TypeDescriptor.ANYDATATOID;
    }

    public void setPayload(RAW rAW) throws SQLException {
        this.payload = rAW.shareBytes();
        this.payLoadRAW = rAW;
        this.toid = TypeDescriptor.RAWTOID;
    }

    public void setPayload(XMLType xMLType) throws SQLException {
        this.payload = xMLType.toBytes();
        this.payLoadXMLType = xMLType;
        this.toid = TypeDescriptor.XMLTYPETOID;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public RAW getRAWPayload() throws SQLException {
        RAW rAW = null;
        if (this.payLoadRAW != null) {
            rAW = this.payLoadRAW;
        } else if (this.isRAWPayload()) {
            rAW = this.payLoadRAW = new RAW(this.payload);
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return rAW;
    }

    public boolean isRAWPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return AQMessageI.compareToid(this.toid, TypeDescriptor.RAWTOID);
    }

    public STRUCT getSTRUCTPayload() throws SQLException {
        STRUCT sTRUCT = null;
        if (!this.isSTRUCTPayload()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.payLoadSTRUCT != null) {
            sTRUCT = this.payLoadSTRUCT;
        } else {
            if (this.sd == null) {
                this.typeName = OracleTypeADT.toid2typename(this.conn, this.toid);
                this.sd = TypeDescriptor.getTypeDescriptor(this.typeName, (OracleConnection)this.conn);
            }
            if (this.sd instanceof StructDescriptor) {
                this.payLoadSTRUCT = sTRUCT = new STRUCT((StructDescriptor)this.sd, this.payload, this.conn);
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return sTRUCT;
    }

    public boolean isSTRUCTPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = true;
        boolean bl2 = true;
        for (int i2 = 0; i2 < 15; ++i2) {
            if (this.toid[i2] == 0) continue;
            bl2 = false;
            break;
        }
        if (bl2 || this.isRAWPayload() || this.isANYDATAPayload()) {
            bl = false;
        }
        return bl;
    }

    public ANYDATA getANYDATAPayload() throws SQLException {
        ANYDATA aNYDATA = null;
        if (this.payLoadANYDATA != null) {
            aNYDATA = this.payLoadANYDATA;
        } else if (this.isANYDATAPayload()) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", this.conn);
            OPAQUE oPAQUE = new OPAQUE(opaqueDescriptor, this.payload, this.conn);
            aNYDATA = this.payLoadANYDATA = new ANYDATA(oPAQUE);
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return aNYDATA;
    }

    public boolean isANYDATAPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.typeName != null && this.typeName.equals("SYS.ANYDATA") || AQMessageI.compareToid(this.toid, TypeDescriptor.ANYDATATOID);
    }

    public XMLType getXMLTypePayload() throws SQLException {
        XMLType xMLType = null;
        if (this.payLoadXMLType != null) {
            xMLType = this.payLoadXMLType;
        } else if (this.isXMLTypePayload()) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.XMLTYPE", this.conn);
            OPAQUE oPAQUE = new OPAQUE(opaqueDescriptor, this.payload, this.conn);
            xMLType = this.payLoadXMLType = XMLType.createXML((OPAQUE)oPAQUE);
        } else {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return xMLType;
    }

    public boolean isXMLTypePayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.typeName != null && this.typeName.equals("SYS.XMLTYPE") || AQMessageI.compareToid(this.toid, TypeDescriptor.XMLTYPETOID);
    }

    public byte[] getPayloadTOID() {
        return this.toid;
    }

    static boolean compareToid(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        if (byArray != null) {
            if (byArray == byArray2) {
                bl = true;
            } else if (byArray.length == byArray2.length) {
                boolean bl2 = true;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    if (byArray[i2] == byArray2[i2]) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Message Properties={");
        stringBuffer.append(this.properties);
        stringBuffer.append("} ");
        return stringBuffer.toString();
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

