/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.gui.command.FormatCommand;
import java.awt.Point;
import java.util.Iterator;
import java.util.Vector;

public class FormatCommandEqualsSpaceV
extends FormatCommand {
    int actualY;
    int interDistance;
    Band activeBand;
    ReportElement fardestElement;
    Vector bands = null;

    public FormatCommandEqualsSpaceV() {
        this.operationType = 32;
    }

    boolean preCondition() {
        this.activeBand = ((ReportElement)this.getSelectedElements().firstElement()).getBand();
        int counter = 0;
        Iterator i = this.getSelectedElements().iterator();
        while (i.hasNext()) {
            ReportElement re = (ReportElement)i.next();
            if (re.getBand() != this.activeBand) continue;
            ++counter;
        }
        return counter > 1;
    }

    void executeDeeper() {
        this.resetEnumeration();
        this.preparation();
        this.bands = this.getBands();
        Iterator h = this.bands.iterator();
        while (h.hasNext()) {
            Band b = (Band)h.next();
            Vector bandElements = this.getBandElements(b);
            if ((bandElements = this.sortYX(bandElements.elements())).size() <= 1) continue;
            ReportElement re = (ReportElement)bandElements.firstElement();
            this.actualY = re.getPosition().y + re.getHeight() + this.interDistance;
            bandElements.removeElement(re);
            if (b == this.activeBand) {
                bandElements.remove(bandElements.indexOf(this.fardestElement));
            }
            this.processElements(bandElements.elements());
        }
    }

    void preparation() {
        Band b = this.activeBand;
        int counter = 0;
        int usedSize = 0;
        int minY = 0;
        int maxY = 0;
        ReportElement re = null;
        Iterator i = this.getSelectedElements().iterator();
        while (i.hasNext()) {
            re = (ReportElement)i.next();
            if (re.getBand() != b) continue;
            usedSize += re.getHeight();
            if (++counter == 1) {
                minY = re.getPosition().y;
                maxY = re.getPosition().y + re.getHeight();
                this.fardestElement = re;
                continue;
            }
            if (minY > re.getPosition().y) {
                minY = re.getPosition().y;
            }
            if (maxY >= re.getPosition().y + re.getHeight()) continue;
            maxY = re.getPosition().y + re.getHeight();
            this.fardestElement = re;
        }
        this.interDistance = (maxY - minY - usedSize) / (counter - 1);
    }

    public void modify() {
        this.re.setPosition(new Point(this.re.getPosition().x, this.actualY));
        this.actualY += this.re.getHeight() + this.interDistance;
    }
}

