/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PortletCategory
implements Serializable {
    private String _name;
    private Map _categories;
    private Set _portlets;

    public String getName() {
        return this._name;
    }

    public Collection getCategories() {
        return Collections.unmodifiableCollection(this._categories.values());
    }

    public void addCategory(PortletCategory portletCategory) {
        this._categories.put(portletCategory.getName(), portletCategory);
    }

    public PortletCategory getCategory(String name) {
        return (PortletCategory)this._categories.get(name);
    }

    public Set getPortlets() {
        return this._portlets;
    }

    public void merge(PortletCategory newPortletCategory) {
        this._merge(this, newPortletCategory);
    }

    public void separate(Set portletIds) {
        Iterator<Object> itr = this._categories.values().iterator();
        while (itr.hasNext()) {
            PortletCategory category = (PortletCategory)itr.next();
            category.separate(portletIds);
        }
        itr = this._portlets.iterator();
        while (itr.hasNext()) {
            String portletId = (String)itr.next();
            if (!portletIds.contains(portletId)) continue;
            itr.remove();
        }
    }

    private final void _merge(PortletCategory portletCategory1, PortletCategory portletCategory2) {
        Iterator itr = portletCategory2.getCategories().iterator();
        while (itr.hasNext()) {
            PortletCategory curCategory2 = (PortletCategory)itr.next();
            PortletCategory curCategory1 = portletCategory1.getCategory(curCategory2.getName());
            if (curCategory1 != null) {
                this._merge(curCategory1, curCategory2);
                continue;
            }
            portletCategory1.addCategory(curCategory2);
        }
        Set portlets1 = portletCategory1.getPortlets();
        Set portlets2 = portletCategory2.getPortlets();
        portlets1.addAll(portlets2);
    }

    public PortletCategory() {
        this("root");
    }

    public PortletCategory(String name) {
        this._name = name;
        this._categories = new HashMap();
        this._portlets = new HashSet();
    }
}

