/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.State;
import org.springframework.webflow.TargetStateResolver;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionableState;

public class StaticTargetStateResolver
implements TargetStateResolver {
    private String targetStateId;

    public StaticTargetStateResolver(String targetStateId) {
        Assert.hasText((String)targetStateId, (String)"The target state id is required");
        this.targetStateId = targetStateId;
    }

    public String getTargetStateId() {
        return this.targetStateId;
    }

    public State resolveTargetState(Transition transition, TransitionableState sourceState, RequestContext context) {
        return sourceState.getFlow().getRequiredState(this.targetStateId);
    }

    public String toString() {
        return "[targetStateId = '" + this.targetStateId + "']";
    }
}

