/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.support;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.TransitionCriteria;

public class EventIdTransitionCriteria
implements TransitionCriteria,
Serializable {
    private String eventId;

    public EventIdTransitionCriteria(String eventId) {
        Assert.notNull((Object)eventId, (String)"The event id is required");
        this.eventId = eventId;
    }

    public boolean test(RequestContext context) {
        return this.eventId.equalsIgnoreCase(context.getLastEvent().getId());
    }

    public String toString() {
        return "[eventId = '" + this.eventId + "']";
    }
}

