/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeCollection;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.CollectionUtils;
import org.springframework.webflow.Event;
import org.springframework.webflow.ExternalContext;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowExecutionContext;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.FlowSession;
import org.springframework.webflow.FlowSessionStatus;
import org.springframework.webflow.ParameterMap;
import org.springframework.webflow.State;
import org.springframework.webflow.StateException;
import org.springframework.webflow.Transition;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.impl.FlowExecutionImpl;

class FlowExecutionControlContextImpl
implements FlowExecutionControlContext {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$execution$impl$FlowExecutionControlContextImpl == null ? (class$org$springframework$webflow$execution$impl$FlowExecutionControlContextImpl = FlowExecutionControlContextImpl.class$("org.springframework.webflow.execution.impl.FlowExecutionControlContextImpl")) : class$org$springframework$webflow$execution$impl$FlowExecutionControlContextImpl));
    private FlowExecutionImpl flowExecution;
    private AttributeMap requestScope = new AttributeMap();
    private ExternalContext externalContext;
    private Event lastEvent;
    private Transition lastTransition;
    private UnmodifiableAttributeMap attributes;
    static /* synthetic */ Class class$org$springframework$webflow$execution$impl$FlowExecutionControlContextImpl;

    public FlowExecutionControlContextImpl(FlowExecutionImpl flowExecution, ExternalContext externalContext) {
        Assert.notNull((Object)flowExecution, (String)"The owning flow execution is required");
        this.externalContext = externalContext;
        this.flowExecution = flowExecution;
    }

    public Flow getActiveFlow() {
        return this.flowExecution.getActiveSession().getFlow();
    }

    public State getCurrentState() {
        return this.flowExecution.getActiveSession().getState();
    }

    public AttributeMap getRequestScope() {
        return this.requestScope;
    }

    public AttributeMap getFlowScope() {
        return this.flowExecution.getActiveSession().getScope();
    }

    public AttributeMap getConversationScope() {
        return this.flowExecution.getScope();
    }

    public FlowExecutionContext getFlowExecutionContext() {
        return this.flowExecution;
    }

    public ParameterMap getRequestParameters() {
        return this.externalContext.getRequestParameterMap();
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public Event getLastEvent() {
        return this.lastEvent;
    }

    public Transition getLastTransition() {
        return this.lastTransition;
    }

    public UnmodifiableAttributeMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeCollection attributes) {
        this.attributes = attributes == null ? CollectionUtils.EMPTY_ATTRIBUTE_MAP : attributes.unmodifiable();
    }

    public UnmodifiableAttributeMap getModel() {
        return this.getConversationScope().union(this.getFlowScope()).union(this.getRequestScope()).unmodifiable();
    }

    public void setLastEvent(Event lastEvent) {
        this.lastEvent = lastEvent;
    }

    public void setLastTransition(Transition lastTransition) {
        this.lastTransition = lastTransition;
    }

    public void setCurrentState(State state) {
        this.flowExecution.getListeners().fireStateEntering(this, state);
        State previousState = this.getCurrentState();
        this.flowExecution.setCurrentState(state);
        if (previousState == null) {
            this.flowExecution.getActiveSessionInternal().setStatus(FlowSessionStatus.ACTIVE);
        }
        this.flowExecution.getListeners().fireStateEntered(this, previousState);
    }

    public ViewSelection start(Flow flow, State startState, AttributeMap input) throws StateException {
        if (input == null) {
            input = new AttributeMap();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Activating new session for flow '" + flow.getId() + "' in state '" + (startState != null ? startState.getId() : flow.getStartState().getId()) + "' with input " + input));
        }
        this.flowExecution.getListeners().fireSessionStarting(this, startState, input);
        this.flowExecution.activateSession(flow, input);
        ViewSelection selectedView = flow.start(startState, this);
        this.flowExecution.getListeners().fireSessionStarted(this);
        return selectedView;
    }

    public ViewSelection signalEvent(Event event) throws StateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Signaling event '" + event.getId() + "' in state '" + this.getCurrentState().getId() + "' of flow '" + this.getActiveFlow().getId() + "'"));
        }
        this.setLastEvent(event);
        this.flowExecution.getListeners().fireEventSignaled(this);
        ViewSelection selectedView = this.getActiveFlow().onEvent(event, this);
        return selectedView;
    }

    public FlowSession endActiveFlowSession(AttributeMap sessionOutput) throws IllegalStateException {
        this.flowExecution.getListeners().fireSessionEnding(this, sessionOutput);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ending active session " + this.getFlowExecutionContext().getActiveSession()));
        }
        this.getActiveFlow().end(this, sessionOutput);
        FlowSession endedSession = this.flowExecution.endActiveFlowSession();
        this.flowExecution.getListeners().fireSessionEnded(this, endedSession, sessionOutput.unmodifiable());
        return endedSession;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("externalContext", (Object)this.externalContext).append("requestScope", (Object)this.requestScope).append("executionProperties", (Object)this.attributes).append("flowExecution", (Object)this.flowExecution).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

