/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.util.Assert;
import org.springframework.webflow.Flow;
import org.springframework.webflow.builder.DefaultFlowArtifactFactory;
import org.springframework.webflow.builder.FlowArtifactFactory;
import org.springframework.webflow.builder.FlowBuilder;

public abstract class BaseFlowBuilder
implements FlowBuilder {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Flow flow;
    private FlowArtifactFactory flowArtifactFactory;
    static /* synthetic */ Class class$java$lang$String;

    protected BaseFlowBuilder() {
        this.setFlowArtifactFactory(new DefaultFlowArtifactFactory());
    }

    protected BaseFlowBuilder(FlowArtifactFactory flowArtifactFactory) {
        this.setFlowArtifactFactory(flowArtifactFactory);
    }

    public FlowArtifactFactory getFlowArtifactFactory() {
        return this.flowArtifactFactory;
    }

    protected FlowArtifactFactory getRequiredFlowArtifactFactory() {
        if (this.flowArtifactFactory == null) {
            throw new IllegalStateException("The 'flowArtifactFactory' property must be set before you can use it to load actions, attribute mappers, subflows, and other Flow artifacts needed by this builder");
        }
        return this.getFlowArtifactFactory();
    }

    public void setFlowArtifactFactory(FlowArtifactFactory flowArtifactFactory) {
        Assert.notNull((Object)flowArtifactFactory, (String)"The flow artifact factory is required");
        this.flowArtifactFactory = flowArtifactFactory;
    }

    protected ConversionExecutor fromStringToAliased(String targetAlias) {
        return this.getFlowArtifactFactory().getConversionService().getConversionExecutorByTargetAlias(class$java$lang$String == null ? (class$java$lang$String = BaseFlowBuilder.class$("java.lang.String")) : class$java$lang$String, targetAlias);
    }

    protected ConversionExecutor fromStringTo(Class targetType) throws ConversionException {
        return this.getFlowArtifactFactory().getConversionService().getConversionExecutor(class$java$lang$String == null ? (class$java$lang$String = BaseFlowBuilder.class$("java.lang.String")) : class$java$lang$String, targetType);
    }

    protected Flow getFlow() {
        return this.flow;
    }

    protected void setFlow(Flow flow) {
        this.flow = flow;
    }

    public void buildPostProcess() {
    }

    public void dispose() {
    }

    public Flow getResult() {
        return this.getFlow();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

