/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.Transition;
import org.springframework.webflow.TransitionCriteria;

public class TransitionSet {
    private List transitions = new LinkedList();

    public boolean add(Transition transition) {
        if (this.contains(transition)) {
            return false;
        }
        return this.transitions.add(transition);
    }

    public boolean addAll(Transition[] transitions) {
        if (transitions == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < transitions.length; ++i) {
            if (!this.add(transitions[i]) || changed) continue;
            changed = true;
        }
        return changed;
    }

    public boolean contains(Transition transition) {
        return this.transitions.contains(transition);
    }

    public boolean remove(Transition transition) {
        return this.transitions.remove(transition);
    }

    public int size() {
        return this.transitions.size();
    }

    public Transition[] toArray() {
        return this.transitions.toArray(new Transition[this.transitions.size()]);
    }

    public TransitionCriteria[] getTransitionCriterias() {
        TransitionCriteria[] criterias = new TransitionCriteria[this.transitions.size()];
        int i = 0;
        Iterator it = this.transitions.iterator();
        while (it.hasNext()) {
            criterias[i++] = ((Transition)it.next()).getMatchingCriteria();
        }
        return criterias;
    }

    public Transition getTransition(RequestContext context) {
        Iterator it = this.transitions.iterator();
        while (it.hasNext()) {
            Transition transition = (Transition)it.next();
            if (!transition.matches(context)) continue;
            return transition;
        }
        return null;
    }

    public boolean transitionMatches(RequestContext context) {
        return this.getTransition(context) != null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("transitions", (Object)this.transitions).toString();
    }
}

