/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.webflow.MapAccessor;
import org.springframework.webflow.MapAdaptable;

public class ParameterMap
implements MapAdaptable,
Serializable {
    private Map parameters;
    private transient MapAccessor parameterAccessor;
    private transient ConversionService conversionService;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$springframework$web$multipart$MultipartFile;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public ParameterMap(Map parameters) {
        this.initParameters(parameters);
        this.conversionService = new DefaultConversionService();
    }

    public Map getMap() {
        return this.parameterAccessor.getMap();
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean contains(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public String get(String parameterName) {
        return this.parameterAccessor.getString(parameterName);
    }

    public String[] getArray(String parameterName) {
        return (String[])this.parameterAccessor.getArray(parameterName, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ParameterMap.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
    }

    public MultipartFile getMultipartFile(String parameterName) {
        return (MultipartFile)this.parameterAccessor.get((Object)parameterName, class$org$springframework$web$multipart$MultipartFile == null ? (class$org$springframework$web$multipart$MultipartFile = ParameterMap.class$("org.springframework.web.multipart.MultipartFile")) : class$org$springframework$web$multipart$MultipartFile);
    }

    public Object[] getArray(String parameterName, Class targetElementType) throws ConversionException {
        String[] parameters = (String[])this.parameterAccessor.getArray(parameterName, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ParameterMap.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        return parameters != null ? this.convert(parameters, targetElementType) : null;
    }

    public Object get(String parameterName, Class targetType) throws ConversionException {
        return this.get(parameterName, targetType, null);
    }

    public Object get(String parameterName, Class targetType, Object defaultValue) throws ConversionException {
        String parameter;
        if (defaultValue != null) {
            this.assertAssignableTo(targetType, defaultValue.getClass());
        }
        return (parameter = this.get(parameterName)) != null ? this.convert(parameter, targetType) : defaultValue;
    }

    public String getRequired(String parameterName) throws IllegalArgumentException {
        return this.parameterAccessor.getRequiredString(parameterName);
    }

    public String[] getRequiredArray(String parameterName) throws IllegalArgumentException {
        return (String[])this.parameterAccessor.getRequiredArray(parameterName, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ParameterMap.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
    }

    public MultipartFile getRequiredMultipartFile(String parameterName) throws IllegalArgumentException {
        return (MultipartFile)this.parameterAccessor.getRequired(parameterName, class$org$springframework$web$multipart$MultipartFile == null ? (class$org$springframework$web$multipart$MultipartFile = ParameterMap.class$("org.springframework.web.multipart.MultipartFile")) : class$org$springframework$web$multipart$MultipartFile);
    }

    public Object[] getRequiredArray(String parameterName, Class targetElementType) throws IllegalArgumentException, ConversionException {
        String[] parameters = (String[])this.parameterAccessor.getRequiredArray(parameterName, array$Ljava$lang$String == null ? (array$Ljava$lang$String = ParameterMap.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        return this.convert(parameters, targetElementType);
    }

    public Object getRequired(String parameterName, Class targetType) throws IllegalArgumentException, ConversionException {
        return this.convert(this.parameterAccessor.getRequiredString(parameterName), targetType);
    }

    public Number getNumber(String parameterName, Class targetType) throws ConversionException {
        this.assertAssignableTo(class$java$lang$Number == null ? (class$java$lang$Number = ParameterMap.class$("java.lang.Number")) : class$java$lang$Number, targetType);
        return (Number)this.get(parameterName, targetType);
    }

    public Number getNumber(String parameterName, Class targetType, Number defaultValue) throws ConversionException {
        this.assertAssignableTo(class$java$lang$Number == null ? (class$java$lang$Number = ParameterMap.class$("java.lang.Number")) : class$java$lang$Number, targetType);
        return (Number)this.get(parameterName, targetType, defaultValue);
    }

    public Number getRequiredNumber(String parameterName, Class targetType) throws IllegalArgumentException, ConversionException {
        this.assertAssignableTo(class$java$lang$Number == null ? (class$java$lang$Number = ParameterMap.class$("java.lang.Number")) : class$java$lang$Number, targetType);
        return (Number)this.getRequired(parameterName, targetType);
    }

    public Integer getInteger(String parameterName) throws ConversionException {
        return (Integer)this.get(parameterName, class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterMap.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public Integer getInteger(String parameterName, Integer defaultValue) throws ConversionException {
        return (Integer)this.get(parameterName, class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterMap.class$("java.lang.Integer")) : class$java$lang$Integer, defaultValue);
    }

    public Integer getRequiredInteger(String parameterName) throws IllegalArgumentException, ConversionException {
        return (Integer)this.getRequired(parameterName, class$java$lang$Integer == null ? (class$java$lang$Integer = ParameterMap.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public Long getLong(String parameterName) throws ConversionException {
        return (Long)this.get(parameterName, class$java$lang$Long == null ? (class$java$lang$Long = ParameterMap.class$("java.lang.Long")) : class$java$lang$Long);
    }

    public Long getLong(String parameterName, Long defaultValue) throws ConversionException {
        return (Long)this.get(parameterName, class$java$lang$Long == null ? (class$java$lang$Long = ParameterMap.class$("java.lang.Long")) : class$java$lang$Long, defaultValue);
    }

    public Long getRequiredLong(String parameterName) throws IllegalArgumentException, ConversionException {
        return (Long)this.getRequired(parameterName, class$java$lang$Long == null ? (class$java$lang$Long = ParameterMap.class$("java.lang.Long")) : class$java$lang$Long);
    }

    public Boolean getBoolean(String parameterName) throws ConversionException {
        return (Boolean)this.get(parameterName, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ParameterMap.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public Boolean getBoolean(String parameterName, Boolean defaultValue) throws ConversionException {
        return (Boolean)this.get(parameterName, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ParameterMap.class$("java.lang.Boolean")) : class$java$lang$Boolean, defaultValue);
    }

    public Boolean getRequiredBoolean(String parameterName) throws IllegalArgumentException, ConversionException {
        return (Boolean)this.getRequired(parameterName, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ParameterMap.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    protected void initParameters(Map parameters) {
        this.parameters = parameters;
        this.parameterAccessor = new MapAccessor(this.parameters);
    }

    protected Map getMapInternal() {
        return this.parameters;
    }

    private Object convert(String parameter, Class targetType) throws ConversionException {
        return this.conversionService.getConversionExecutor(class$java$lang$String == null ? (class$java$lang$String = ParameterMap.class$("java.lang.String")) : class$java$lang$String, targetType).execute((Object)parameter);
    }

    private Object[] convert(String[] parameters, Class targetElementType) throws ConversionException {
        ArrayList<Object> list = new ArrayList<Object>(parameters.length);
        ConversionExecutor converter = this.conversionService.getConversionExecutor(class$java$lang$String == null ? (class$java$lang$String = ParameterMap.class$("java.lang.String")) : class$java$lang$String, targetElementType);
        for (int i = 0; i < parameters.length; ++i) {
            list.add(converter.execute((Object)parameters[i]));
        }
        return list.toArray((Object[])Array.newInstance(targetElementType, parameters.length));
    }

    private void assertAssignableTo(Class clazz, Class requiredType) {
        Assert.isTrue((boolean)clazz.isAssignableFrom(requiredType), (String)("The provided required type must be assignable to [" + clazz + "]"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parameterAccessor = new MapAccessor(this.parameters);
        this.conversionService = new DefaultConversionService();
    }

    public String toString() {
        return StylerUtils.style((Object)this.parameters);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

