/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.Action;
import org.springframework.webflow.ActionExecutionException;
import org.springframework.webflow.Event;
import org.springframework.webflow.FlowSessionStatus;
import org.springframework.webflow.RequestContext;

public class ActionExecutor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$ActionExecutor == null ? (class$org$springframework$webflow$ActionExecutor = ActionExecutor.class$("org.springframework.webflow.ActionExecutor")) : class$org$springframework$webflow$ActionExecutor));
    static /* synthetic */ Class class$org$springframework$webflow$ActionExecutor;

    private ActionExecutor() {
    }

    public static Event execute(Action action, RequestContext context) throws ActionExecutionException {
        try {
            if (logger.isDebugEnabled()) {
                if (context.getFlowExecutionContext().getActiveSession().getStatus() == FlowSessionStatus.STARTING) {
                    logger.debug((Object)("Executing start " + action + " for flow '" + context.getActiveFlow().getId() + "'"));
                } else {
                    logger.debug((Object)("Executing " + action + " in state '" + context.getCurrentState().getId() + "' of flow '" + context.getActiveFlow().getId() + "'"));
                }
            }
            return action.execute(context);
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            if (context.getFlowExecutionContext().getActiveSession().getStatus() == FlowSessionStatus.STARTING) {
                throw new ActionExecutionException(context.getActiveFlow(), action, context.getAttributes(), (Throwable)e);
            }
            throw new ActionExecutionException(context.getCurrentState(), action, context.getAttributes(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

