/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectNode
implements ParseTreeNode {
    private final ParseRegion region;
    private final List<ParseTreeNode> withList;
    private final List<AxisNode> axisList;
    private final AxisNode filterAxis;
    private final List<IdentifierNode> cellPropertyList;
    private ParseTreeNode from;

    public SelectNode(ParseRegion region, List<ParseTreeNode> withList, List<AxisNode> axisList, ParseTreeNode from, AxisNode filterAxis, List<IdentifierNode> cellPropertyList) {
        this.region = region;
        this.withList = withList;
        this.axisList = axisList;
        this.from = from;
        this.filterAxis = filterAxis;
        this.cellPropertyList = cellPropertyList;
    }

    public SelectNode() {
        this(null, new ArrayList<ParseTreeNode>(), new ArrayList<AxisNode>(), null, null, new ArrayList<IdentifierNode>());
    }

    @Override
    public ParseRegion getRegion() {
        return this.region;
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Type getType() {
        return null;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        ParseTreeWriter pw = new ParseTreeWriter(new PrintWriter(sw));
        this.unparse(pw);
        sw.flush();
        return sw.toString();
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        PrintWriter pw = writer.getPrintWriter();
        if (!this.withList.isEmpty()) {
            pw.println("WITH");
            for (ParseTreeNode with : this.withList) {
                with.unparse(writer);
                pw.println();
            }
        }
        pw.print("SELECT");
        int k = 0;
        for (AxisNode axis : this.axisList) {
            if (k++ > 0) {
                pw.println(",");
            } else {
                pw.println();
            }
            axis.unparse(writer);
        }
        pw.println();
        pw.print("FROM ");
        this.from.unparse(writer);
        if (this.filterAxis != null) {
            pw.println();
            pw.print("WHERE ");
            this.filterAxis.unparse(writer);
        }
        if (!this.cellPropertyList.isEmpty()) {
            pw.println();
            pw.print("CELL PROPERTIES ");
            k = 0;
            for (IdentifierNode cellProperty : this.cellPropertyList) {
                if (k++ > 0) {
                    pw.print(", ");
                }
                cellProperty.unparse(writer);
            }
        }
    }

    public List<ParseTreeNode> getWithList() {
        return this.withList;
    }

    public List<AxisNode> getAxisList() {
        return this.axisList;
    }

    public AxisNode getFilterAxis() {
        return this.filterAxis;
    }

    public ParseTreeNode getFrom() {
        return this.from;
    }

    public void setFrom(ParseTreeNode fromNode) {
        this.from = fromNode;
    }
}

