/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.cache;

import java.net.URL;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.olap4j.driver.xmla.cache.XmlaOlap4jCacheElement;
import org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache;
import org.olap4j.driver.xmla.cache.XmlaOlap4jSHAEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlaOlap4jConcurrentMemoryCache {
    private static final int DEFAULT_CACHE_TIMEOUT = 60;
    private static final int DEFAULT_CACHE_SIZE = 10;
    private static final XmlaOlap4jNamedMemoryCache.MODE DEFAULT_EVICTION_MODE = XmlaOlap4jNamedMemoryCache.MODE.LFU;
    private Map<String, XmlaOlap4jCacheElement> cacheEntries = new ConcurrentHashMap<String, XmlaOlap4jCacheElement>();
    private int cacheSize = 10;
    private XmlaOlap4jNamedMemoryCache.MODE evictionMode = DEFAULT_EVICTION_MODE;
    private int cacheTimeout = 60;

    public XmlaOlap4jConcurrentMemoryCache(Map<String, String> props) throws IllegalArgumentException {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (XmlaOlap4jNamedMemoryCache.Property.Size.name().equalsIgnoreCase(entry.getKey().toString())) {
                this.setCacheSize(Integer.parseInt(entry.getValue().toString()));
                continue;
            }
            if (XmlaOlap4jNamedMemoryCache.Property.Timeout.name().equalsIgnoreCase(entry.getKey().toString())) {
                this.setCacheTimeout(Integer.parseInt(entry.getValue().toString()));
                continue;
            }
            if (!XmlaOlap4jNamedMemoryCache.Property.Mode.name().equalsIgnoreCase(entry.getKey().toString())) continue;
            this.setCacheMode(entry.getValue().toString());
        }
    }

    private void setCacheSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("The XMLAOLap4jMemoryCache size cannot be less or equal to 0.");
        }
        this.cacheSize = size;
    }

    private void setCacheMode(String mode) {
        if (XmlaOlap4jNamedMemoryCache.MODE.valueOf(mode) == null) {
            throw new IllegalArgumentException("The XMLAOLap4jMemoryCache mode has to be one of XmlaOlap4jMemoryCache.MODE");
        }
        this.evictionMode = XmlaOlap4jNamedMemoryCache.MODE.valueOf(mode);
    }

    private void setCacheTimeout(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("The XMLAOLap4jMemoryCache timeout cannot be less or equal to 0.");
        }
        this.cacheTimeout = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(URL url, byte[] request) {
        Map<String, XmlaOlap4jCacheElement> map = this.cacheEntries;
        synchronized (map) {
            this.cleanExpired(false);
            XmlaOlap4jCacheElement entry = this.cacheEntries.get(XmlaOlap4jSHAEncoder.SHA1(url.toExternalForm() + new String(request)));
            if (entry != null) {
                entry.incrementHitCount();
                entry.refreshTimestamp();
            }
            return entry != null ? new String(entry.getResponse()).getBytes() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(URL url, byte[] request, byte[] response) {
        Map<String, XmlaOlap4jCacheElement> map = this.cacheEntries;
        synchronized (map) {
            this.cleanExpired(true);
            if (this.cacheEntries.size() >= this.cacheSize) {
                throw new RuntimeException("Concurrency error detected.");
            }
            XmlaOlap4jCacheElement entry = new XmlaOlap4jCacheElement();
            entry.setResponse(response);
            this.cacheEntries.put(XmlaOlap4jSHAEncoder.SHA1(String.valueOf(url.toExternalForm()) + new String(request)), entry);
        }
    }

    private void cleanExpired(boolean makeRoom) {
        String toBeEvicted = null;
        if (this.evictionMode == XmlaOlap4jNamedMemoryCache.MODE.FIFO || this.evictionMode == XmlaOlap4jNamedMemoryCache.MODE.LIFO) {
            toBeEvicted = this.timeBasedEviction(makeRoom);
        }
        if (this.evictionMode == XmlaOlap4jNamedMemoryCache.MODE.LFU || this.evictionMode == XmlaOlap4jNamedMemoryCache.MODE.MFU) {
            toBeEvicted = this.hitBasedEviction(makeRoom);
        }
        if (makeRoom && this.cacheEntries.size() >= this.cacheSize && toBeEvicted != null) {
            this.cacheEntries.remove(toBeEvicted);
        }
    }

    private String timeBasedEviction(boolean makeRoom) {
        long currentEvictedTimestamp = this.evictionMode == XmlaOlap4jNamedMemoryCache.MODE.LIFO ? Long.MAX_VALUE : Long.MIN_VALUE;
        String toBeEvicted = null;
        for (Map.Entry<String, XmlaOlap4jCacheElement> entry : this.cacheEntries.entrySet()) {
            if (Calendar.getInstance().getTimeInMillis() > entry.getValue().getTimestamp().longValue() + (long)(this.cacheTimeout * 1000)) {
                this.cacheEntries.remove(entry.getKey());
                continue;
            }
            if ((!makeRoom || this.evictionMode != XmlaOlap4jNamedMemoryCache.MODE.LIFO || entry.getValue().getTimestamp().longValue() >= currentEvictedTimestamp) && (this.evictionMode != XmlaOlap4jNamedMemoryCache.MODE.FIFO || entry.getValue().getTimestamp().longValue() <= currentEvictedTimestamp)) continue;
            currentEvictedTimestamp = entry.getValue().getTimestamp().longValue();
            toBeEvicted = entry.getKey();
        }
        return toBeEvicted;
    }

    private String hitBasedEviction(boolean makeRoom) {
        long currentEvictedHits = this.evictionMode == XmlaOlap4jNamedMemoryCache.MODE.LFU ? Long.MAX_VALUE : Long.MIN_VALUE;
        String toBeEvicted = null;
        for (Map.Entry<String, XmlaOlap4jCacheElement> entry : this.cacheEntries.entrySet()) {
            if (Calendar.getInstance().getTimeInMillis() > entry.getValue().getTimestamp().longValue() + (long)(this.cacheTimeout * 1000)) {
                this.cacheEntries.remove(entry.getKey());
                continue;
            }
            if ((!makeRoom || this.evictionMode != XmlaOlap4jNamedMemoryCache.MODE.LFU || entry.getValue().getHitCount().longValue() >= currentEvictedHits) && (this.evictionMode != XmlaOlap4jNamedMemoryCache.MODE.MFU || entry.getValue().getHitCount().longValue() <= currentEvictedHits)) continue;
            currentEvictedHits = entry.getValue().getHitCount().longValue();
            toBeEvicted = entry.getKey();
        }
        return toBeEvicted;
    }
}

