/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.DefaultEditorKit;
import mondrian.gui.I18n;
import mondrian.gui.JdbcExplorer;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MdxQuery;
import mondrian.gui.PreferencesDialog;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.SelectConnectionDialog;
import mondrian.gui.WorkbenchMenubarPlugin;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.rolap.agg.AggregationManager;
import org.apache.log4j.Logger;
import org.olap4j.CellSet;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.OlapWrapper;
import org.olap4j.layout.CellSetFormatter;
import org.olap4j.layout.RectangularCellSetFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workbench
extends JFrame {
    static String WORKBENCH_USER_HOME_DIR;
    static String WORKBENCH_CONFIG_FILE;
    static int MAX_USED_ITEMS;
    static String LastUsedPrefix;
    static String LastUsedUrlPrefix;
    static String LastUsedConnectionNamePrefix;
    private static final String WorkbenchInfoResourceName = "mondrian.gui.resources.workbenchInfo";
    private static final String GUIResourceName = "mondrian.gui.resources.gui";
    private static final String TextResourceName = "mondrian.gui.resources.text";
    private static final Logger LOGGER;
    public static final boolean USE_OLAP4J = true;
    public static final CellSetFormatter formatter;
    private String jdbcConnectionName;
    private ConnectionDetails conNameDetails;
    private Map<String, ConnectionDetails> connectionDetailsMap = new HashMap<String, ConnectionDetails>();
    private final ClassLoader myClassLoader;
    private Class schemaExplorerClass;
    private Class mdxQueryClass;
    private Class jdbcExplorerClass;
    private Properties workbenchProperties;
    private ResourceBundle workbenchInfoResourceBundle = null;
    private List<ResourceBundle> additionalWorkbenchInfoResourceBundles = new ArrayList<ResourceBundle>();
    private static I18n resourceConverter;
    private static int newSchema;
    private String openFile = null;
    private Map<JInternalFrame, JMenuItem> schemaWindowMap = new HashMap<JInternalFrame, JMenuItem>();
    private final List<JInternalFrame> mdxWindows = new ArrayList<JInternalFrame>();
    private final List<JInternalFrame> jdbcWindows = new ArrayList<JInternalFrame>();
    private int windowMenuMapIndex = 1;
    private JInternalFrame preferencesFrame = null;
    private JButton toolbarSaveAsButton;
    private JMenuItem openMenuItem;
    private JMenuItem[] lastUsedMenuItems;
    private JMenu fileMenu;
    private JMenuItem newQueryMenuItem;
    private JMenuItem newQueryMenuItem2;
    private JPanel jPanel1;
    private JButton toolbarOpenButton;
    private JButton toolbarNewSchemaButton;
    private JButton toolbarNewQueryButton;
    private JButton toolbarNewJDBCExplorerButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JMenuItem cutMenuItem;
    private JMenuBar menuBar;
    private JMenuItem saveMenuItem;
    private JMenuItem newJDBCExplorerMenuItem;
    private JCheckBoxMenuItem viewCubesMenuItem;
    private JButton toolbarSaveButton;
    private JMenuItem copyMenuItem;
    private DesktopPaneWithBackground desktopPane;
    private JMenu viewMenu;
    private JMenu toolsMenu;
    private JMenu newMenu;
    private JMenuItem deleteMenuItem;
    private JMenuItem newSchemaMenuItem;
    private JMenuItem newSchemaMenuItem2;
    private JMenuItem exitMenuItem;
    private JButton toolbarPreferencesButton;
    private JCheckBoxMenuItem viewMeasuresMenuItem;
    private JMenu editMenu;
    private JMenuItem pasteMenuItem;
    private JMenuItem preferencesMenuItem;
    private JCheckBoxMenuItem viewDimensionsMenuItem;
    private JCheckBoxMenuItem viewXmlMenuItem;
    private JMenuItem saveAsMenuItem;
    private JToolBar jToolBar1;
    private JMenu windowMenu;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JMenuItem cascadeMenuItem;
    private JMenuItem tileMenuItem;
    private JMenuItem minimizeMenuItem;
    private JMenuItem maximizeMenuItem;
    private JMenuItem closeAllMenuItem;

    public Workbench(String[] args) {
        this.myClassLoader = this.getClass().getClassLoader();
        this.parseArgs(args);
        resourceConverter = Workbench.getGlobalResourceConverter();
        try {
            WORKBENCH_USER_HOME_DIR = System.getProperty("user.home") + File.separator + ".schemaWorkbench";
            WORKBENCH_CONFIG_FILE = WORKBENCH_USER_HOME_DIR + File.separator + "workbench.properties";
            this.loadWorkbenchProperties();
            this.initDataSources();
            this.initComponents();
            this.loadMenubarPlugins();
            URL imageUrl = this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("productIcon"));
            ImageIcon icon = new ImageIcon(imageUrl);
            this.setIconImage(icon.getImage());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Workbench constructor", (Throwable)e);
        }
    }

    public static void setGlobalResourceConverter(I18n newConverter) {
        resourceConverter = newConverter;
    }

    public static I18n getGlobalResourceConverter() {
        if (resourceConverter == null) {
            ClassLoader currentClassLoader = Workbench.class.getClassLoader();
            ResourceBundle localGuiResourceBundle = ResourceBundle.getBundle(GUIResourceName, Locale.getDefault(), currentClassLoader);
            ResourceBundle localTextResourceBundle = ResourceBundle.getBundle(TextResourceName, Locale.getDefault(), currentClassLoader);
            resourceConverter = new I18n(localGuiResourceBundle, localTextResourceBundle);
        }
        return resourceConverter;
    }

    public void addLanguageResourceBundle(String bundleName) {
        Workbench.getGlobalResourceConverter().addLanguageResourceBundle(bundleName);
    }

    public void addGuiResourceBundle(String bundleName) {
        Workbench.getGlobalResourceConverter().addGuiResourceBundle(bundleName);
    }

    private void loadWorkbenchProperties() {
        this.workbenchProperties = new Properties();
        try {
            this.workbenchInfoResourceBundle = ResourceBundle.getBundle(WorkbenchInfoResourceName, Locale.getDefault(), this.myClassLoader);
            File f = new File(WORKBENCH_CONFIG_FILE);
            if (f.exists()) {
                this.workbenchProperties.load(new FileInputStream(f));
            } else {
                LOGGER.debug((Object)(WORKBENCH_CONFIG_FILE + " does not exist"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"loadWorkbenchProperties", (Throwable)e);
        }
    }

    public void addWorkbenchInfoBundleByName(String newBundleName) {
        this.addResourceBundleByName(newBundleName, this.additionalWorkbenchInfoResourceBundles);
    }

    private void addResourceBundleByName(String bundleName, List<ResourceBundle> currentBundleList) {
        ResourceBundle newBundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), this.myClassLoader);
        if (newBundle != null) {
            currentBundleList.add(newBundle);
        }
    }

    public String getWorkbenchProperty(String key) {
        return this.workbenchProperties.getProperty(key);
    }

    public void removeWorkbenchProperty(String key) {
        this.workbenchProperties.remove(key);
    }

    public void setWorkbenchProperty(String key, String value) {
        this.workbenchProperties.setProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWorkbenchProperties() {
        File dir = new File(WORKBENCH_USER_HOME_DIR);
        try {
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.user.home.not.directory", "{0} is not a directory!\nPlease rename this file and retry to save configuration!", WORKBENCH_USER_HOME_DIR), "", 0);
                    return;
                }
            } else {
                dir.mkdirs();
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"storeWorkbenchProperties: mkdirs", (Throwable)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.user.home.exception", "An error is occurred creating workbench configuration directory:\n{0}\nError is: {1}", WORKBENCH_USER_HOME_DIR, ex.getLocalizedMessage()), "", 0);
            return;
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(WORKBENCH_CONFIG_FILE));
            Properties wp = new Properties();
            Enumeration<?> pns = this.workbenchProperties.propertyNames();
            while (pns.hasMoreElements()) {
                String pname = (String)pns.nextElement();
                if (pname.startsWith("jdbc.")) continue;
                String pvalue = this.getWorkbenchProperty(pname);
                wp.setProperty(pname, pvalue);
            }
            wp.store(out, "Workbench configuration");
            Map<String, ConnectionDetails> cds = this.getConnectionDetailsMap();
            for (Map.Entry<String, ConnectionDetails> anEntry : cds.entrySet()) {
                Properties cdsp = new Properties();
                anEntry.getValue().setProperties(cdsp);
                cdsp.store(out, "JDBC Connection name " + anEntry.getKey());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"storeWorkbenchProperties: store", (Throwable)e);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.save.configuration", "An error is occurred creating workbench configuration file:\n{0}\nError is: {1}", WORKBENCH_CONFIG_FILE, e.getLocalizedMessage()), "", 0);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException eIO) {
                LOGGER.error((Object)"storeWorkbenchProperties: out.close", (Throwable)eIO);
            }
        }
    }

    private void initDataSources() {
        HashMap<String, ConnectionDetails> cnd = new HashMap<String, ConnectionDetails>();
        String firstConName = null;
        this.jdbcConnectionName = null;
        Enumeration<?> pns = this.workbenchProperties.propertyNames();
        while (pns.hasMoreElements()) {
            String pname = (String)pns.nextElement();
            if (!pname.startsWith("jdbc.")) continue;
            String pvalue = this.getWorkbenchProperty(pname);
            String[] psplitter = pname.split("\\.");
            if (psplitter.length < 3) continue;
            String connectionName = psplitter[1];
            String propertyName = psplitter[2];
            ConnectionDetails theDetails = (ConnectionDetails)cnd.get(connectionName);
            if (theDetails == null) {
                theDetails = new ConnectionDetails();
                theDetails.connectionName = connectionName;
                cnd.put(connectionName, theDetails);
            }
            if (firstConName == null) {
                firstConName = connectionName;
            }
            theDetails.put(propertyName, pvalue);
            if (!propertyName.equals("Default") || !theDetails.defaultConnection) continue;
            this.jdbcConnectionName = connectionName;
        }
        if (this.jdbcConnectionName == null) {
            this.jdbcConnectionName = firstConName;
        }
        this.setConnectionDetailsMap(cnd);
        this.setConNameDetails((ConnectionDetails)cnd.get(this.jdbcConnectionName));
        this.upgradePropertiesFromV3_1();
    }

    private void upgradePropertiesFromV3_1() {
        boolean needPropertiesUpdate = false;
        for (int i = 1; i <= 4; ++i) {
            String lastFileName = this.getWorkbenchProperty("lastUsed" + i);
            if (lastFileName == null) continue;
            String lastFileUrl = this.getWorkbenchProperty("lastUsedUrl" + i);
            this.removeWorkbenchProperty("lastUsed" + i);
            this.removeWorkbenchProperty("lastUsedUrl" + i);
            this.setWorkbenchProperty(LastUsedPrefix + i, lastFileName);
            this.setWorkbenchProperty(LastUsedUrlPrefix + i, lastFileUrl);
            needPropertiesUpdate = true;
        }
        String[][] oldNew = new String[][]{{"jdbcUsername", "UserName"}, {"jdbcPassword", "Password"}, {"jdbcConnectionUrl", "JdbcUrl"}, {"jdbcSchema", "Schemas"}, {"requireSchema", "RequireSchemas"}, {"jdbcDriverClassName", "DriverClassName"}};
        boolean needConnectionUpdate = false;
        ConnectionDetails oldDetails = new ConnectionDetails();
        for (String[] mapping : oldNew) {
            String oldValue = this.getWorkbenchProperty(mapping[0]);
            if (oldValue == null) continue;
            this.removeWorkbenchProperty(mapping[0]);
            oldDetails.put(mapping[1], oldValue);
            needConnectionUpdate = true;
        }
        if (this.getConnectionDetailsMap().isEmpty() && needConnectionUpdate) {
            oldDetails.connectionName = this.getResourceConverter().getString("workbench.defaultConnection.name", "Default");
            oldDetails.defaultConnection = true;
            this.getConnectionDetailsMap().put(oldDetails.connectionName, oldDetails);
            this.jdbcConnectionName = oldDetails.connectionName;
            this.setConNameDetails(oldDetails);
        }
        if (needConnectionUpdate || needPropertiesUpdate) {
            this.storeWorkbenchProperties();
        }
    }

    public void setBackgroundImage(Image img) {
        this.desktopPane.setBackgroundImage(img);
    }

    private void initComponents() {
        this.desktopPane = new DesktopPaneWithBackground();
        this.jToolBar1 = new JToolBar();
        this.toolbarNewSchemaButton = new JButton();
        this.toolbarNewQueryButton = new JButton();
        this.toolbarNewJDBCExplorerButton = new JButton();
        this.toolbarOpenButton = new JButton();
        this.toolbarSaveButton = new JButton();
        this.toolbarSaveAsButton = new JButton();
        this.jPanel1 = new JPanel();
        this.toolbarPreferencesButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenu = new JMenu();
        this.newSchemaMenuItem = new JMenuItem();
        this.newQueryMenuItem = new JMenuItem();
        this.newJDBCExplorerMenuItem = new JMenuItem();
        this.newSchemaMenuItem2 = new JMenuItem();
        this.newQueryMenuItem2 = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.preferencesMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.windowMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        this.copyMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        this.pasteMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        this.deleteMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.viewMenu = new JMenu();
        this.viewDimensionsMenuItem = new JCheckBoxMenuItem();
        this.viewMeasuresMenuItem = new JCheckBoxMenuItem();
        this.viewCubesMenuItem = new JCheckBoxMenuItem();
        this.viewXmlMenuItem = new JCheckBoxMenuItem();
        this.setTitle(this.getResourceConverter().getString("workbench.panel.title", "Jaspersoft OLAP Designer"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Workbench.this.storeWorkbenchProperties();
                Workbench.this.closeAllSchemaFrames(true);
            }
        });
        this.getContentPane().add((Component)this.desktopPane, "Center");
        this.toolbarOpenButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("open"))));
        this.toolbarOpenButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.open", "Open"));
        this.toolbarOpenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.openMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarOpenButton);
        this.toolbarSaveButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("save"))));
        this.toolbarSaveButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.save", "Save"));
        this.toolbarSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveButton);
        this.toolbarSaveAsButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("saveAs"))));
        this.toolbarSaveAsButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.saveAs", "Save As..."));
        this.toolbarSaveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveAsButton);
        this.jPanel1.setMaximumSize(new Dimension(8, 8));
        this.jToolBar1.add(this.jPanel1);
        this.toolbarNewSchemaButton.setIcon(new ImageIcon(this.getClass().getResource("/" + this.getResourceConverter().getGUIReference("schema"))));
        this.toolbarNewSchemaButton.setToolTipText(this.getResourceConverter().getString("workbench.menu.newSchema", "New Schema"));
        this.toolbarNewSchemaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newSchemaMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarNewSchemaButton);
        this.toolbarNewQueryButton.setIcon(new ImageIcon(this.getClass().getResource("/" + this.getResourceConverter().getGUIReference("mdxQuery"))));
        this.toolbarNewQueryButton.setToolTipText(this.getResourceConverter().getString("workbench.menu.newQuery", "New MDX Query"));
        this.toolbarNewQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newQueryMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarNewQueryButton);
        this.toolbarNewJDBCExplorerButton.setIcon(new ImageIcon(this.getClass().getResource("/" + this.getResourceConverter().getGUIReference("jdbcExplorer"))));
        this.toolbarNewJDBCExplorerButton.setToolTipText(this.getResourceConverter().getString("workbench.menu.newJDBC", "New JDBC Explorer"));
        this.toolbarNewJDBCExplorerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newJDBCExplorerMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarNewJDBCExplorerButton);
        this.jToolBar1.add(this.jPanel1);
        this.toolbarPreferencesButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("preferences"))));
        this.toolbarPreferencesButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.preferences", "Connection"));
        this.toolbarPreferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.toolbarPreferencesButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarPreferencesButton);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.newMenu.setText(this.getResourceConverter().getString("workbench.menu.new", "New"));
        this.newSchemaMenuItem.setText(this.getResourceConverter().getString("workbench.menu.newSchema", "Schema"));
        this.newSchemaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newSchemaMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newSchemaMenuItem);
        this.newQueryMenuItem.setText(this.getResourceConverter().getString("workbench.menu.newQuery", "MDX Query"));
        this.newQueryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newQueryMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newQueryMenuItem);
        this.newJDBCExplorerMenuItem.setText(this.getResourceConverter().getString("workbench.menu.newJDBC", "JDBC Explorer"));
        this.newJDBCExplorerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newJDBCExplorerMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newJDBCExplorerMenuItem);
        this.openMenuItem.setText(this.getResourceConverter().getString("workbench.menu.open", "Open"));
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.openMenuItemActionPerformed(evt);
            }
        });
        this.saveMenuItem.setText(this.getResourceConverter().getString("workbench.menu.save", "Save"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.saveAsMenuItem.setText(this.getResourceConverter().getString("workbench.menu.saveAsDot", "Save As ..."));
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.exitMenuItem.setText(this.getResourceConverter().getString("workbench.menu.exit", "Exit"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.setText(this.getResourceConverter().getString("workbench.menu.file", "File"));
        this.fileMenu.setMnemonic(70);
        this.fileMenu.add(this.newMenu);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.fileMenu.add(this.exitMenuItem);
        this.updateLastUsedMenuItems(this.fileMenu);
        this.menuBar.add(this.fileMenu);
        this.viewMenu.setText(this.getResourceConverter().getString("workbench.menu.view", "View"));
        this.viewMenu.setMnemonic(86);
        this.viewXmlMenuItem.setText(this.getResourceConverter().getString("workbench.menu.viewXML", "View XML"));
        this.viewXmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.viewXMLMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewXmlMenuItem);
        this.menuBar.add(this.viewMenu);
        this.toolsMenu.setText(this.getResourceConverter().getString("workbench.menu.tools", "Tools"));
        this.toolsMenu.setMnemonic(79);
        this.preferencesMenuItem.setText(this.getResourceConverter().getString("workbench.menu.preferences", "Preferences"));
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.toolbarPreferencesButtonActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.preferencesMenuItem);
        this.menuBar.add(this.toolsMenu);
        this.windowMenu.setText(this.getResourceConverter().getString("workbench.menu.windows", "Windows"));
        this.windowMenu.setMnemonic(87);
        this.cascadeMenuItem = new JMenuItem();
        this.cascadeMenuItem.setText(this.getResourceConverter().getString("workbench.menu.cascadeWindows", "Cascade Windows"));
        this.cascadeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.cascadeMenuItemActionPerformed(evt);
            }
        });
        this.tileMenuItem = new JMenuItem();
        this.tileMenuItem.setText(this.getResourceConverter().getString("workbench.menu.tileWindows", "Tile Windows"));
        this.tileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.tileMenuItemActionPerformed(evt);
            }
        });
        this.closeAllMenuItem = new JMenuItem();
        this.closeAllMenuItem.setText(this.getResourceConverter().getString("workbench.menu.closeAll", "Close All"));
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.closeAllMenuItemActionPerformed(evt);
            }
        });
        this.minimizeMenuItem = new JMenuItem();
        this.minimizeMenuItem.setText(this.getResourceConverter().getString("workbench.menu.minimizeAll", "Minimize All"));
        this.minimizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.minimizeMenuItemActionPerformed(evt);
            }
        });
        this.maximizeMenuItem = new JMenuItem();
        this.maximizeMenuItem.setText(this.getResourceConverter().getString("workbench.menu.maximizeAll", "Maximize All"));
        this.maximizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.maximizeMenuItemActionPerformed(evt);
            }
        });
        this.menuBar.add(this.windowMenu);
        this.aboutMenuItem.setText(this.getResourceConverter().getString("workbench.menu.about", "About"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenu.setText(this.getResourceConverter().getString("workbench.menu.help", "Help"));
        this.helpMenu.setMnemonic(72);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().setBounds(20, 20, 950, 900);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMenubarPlugins() {
        try {
            Enumeration<URL> pluginResources = this.myClassLoader.getResources("workbench_plugins.properties");
            LOGGER.debug((Object)("found plugins: " + pluginResources.hasMoreElements()));
            if (pluginResources == null || !pluginResources.hasMoreElements()) {
                return;
            }
            while (pluginResources.hasMoreElements()) {
                URL aPluginResource = pluginResources.nextElement();
                LOGGER.debug((Object)("loading plugin: " + aPluginResource));
                InputStream pluginStream = null;
                try {
                    Properties props = new Properties();
                    pluginStream = aPluginResource.openStream();
                    if (pluginStream == null) continue;
                    props.load(pluginStream);
                    for (Object key : props.keySet()) {
                        String keystr = (String)key;
                        if (!keystr.startsWith("workbench.menu-plugin.") && !keystr.startsWith("workbench.plugin.")) continue;
                        String val = props.getProperty(keystr);
                        LOGGER.debug((Object)("initializing with plugin: " + val));
                        WorkbenchMenubarPlugin plugin = (WorkbenchMenubarPlugin)Class.forName(val).newInstance();
                        plugin.setWorkbench(this);
                        plugin.addItemsToMenubar(this.menuBar);
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)("plugin read exception: " + aPluginResource), (Throwable)e);
                }
                finally {
                    try {
                        if (pluginStream == null) continue;
                        pluginStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"get plugin resources error", (Throwable)ioe);
        }
    }

    private void updateLastUsedMenuItems(JMenu aMenu) {
        int insertIndex;
        String lastUsed;
        int i = 0;
        for (i = 0; i < MAX_USED_ITEMS && (lastUsed = this.getWorkbenchProperty(LastUsedPrefix + (i + 1))) != null; ++i) {
        }
        if (this.lastUsedMenuItems != null) {
            for (JMenuItem aLastUsedItem : this.lastUsedMenuItems) {
                aMenu.remove(aLastUsedItem);
            }
        }
        if (i == 0) {
            return;
        }
        for (insertIndex = 0; insertIndex < aMenu.getMenuComponentCount() && aMenu.getMenuComponent(insertIndex) != this.saveAsMenuItem; ++insertIndex) {
        }
        if (insertIndex == 0 || insertIndex == aMenu.getItemCount()) {
            throw new RuntimeException("File menu not valid: can't insert last used items");
        }
        if (aMenu.getMenuComponent(insertIndex) != this.jSeparator2) {
            aMenu.add((Component)this.jSeparator2, ++insertIndex);
        }
        this.lastUsedMenuItems = new JMenuItem[i];
        for (int j = 1; j <= i; ++j) {
            JMenuItem current = new JMenuItem();
            current.setText(this.getWorkbenchProperty(LastUsedPrefix + j));
            current.setToolTipText(this.getWorkbenchProperty(LastUsedUrlPrefix + j));
            final int itemId = j;
            current.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Workbench.this.lastUsedMenuItemActionPerformed(evt, itemId);
                }
            });
            this.lastUsedMenuItems[j - 1] = current;
            aMenu.add((Component)current, ++insertIndex);
        }
    }

    public ResourceBundle getWorkbenchResourceBundle() {
        return this.workbenchInfoResourceBundle;
    }

    public I18n getResourceConverter() {
        if (resourceConverter == null) {
            resourceConverter = Workbench.getGlobalResourceConverter();
        }
        return resourceConverter;
    }

    public Class getSchemaExplorerClass() {
        if (this.schemaExplorerClass == null) {
            this.schemaExplorerClass = SchemaExplorer.class;
        }
        return this.schemaExplorerClass;
    }

    public void setSchemaExplorerClass(Class schemaExplorerClass) {
        this.schemaExplorerClass = schemaExplorerClass;
    }

    public Class getJdbcExplorerClass() {
        if (this.jdbcExplorerClass == null) {
            this.jdbcExplorerClass = JdbcExplorer.class;
        }
        return this.jdbcExplorerClass;
    }

    public void setJdbcExplorerClass(Class jdbcExplorerClass) {
        this.jdbcExplorerClass = jdbcExplorerClass;
    }

    public Class getMdxQueryClass() {
        if (this.mdxQueryClass == null) {
            this.mdxQueryClass = MdxQuery.class;
        }
        return this.mdxQueryClass;
    }

    public void setMdxQueryClass(Class mdxQueryClass) {
        this.mdxQueryClass = mdxQueryClass;
    }

    private void tileMenuItemActionPerformed(ActionEvent evt) {
        Dimension dsize = this.desktopPane.getSize();
        int desktopW = (int)dsize.getWidth();
        int desktopH = (int)dsize.getHeight();
        int darea = desktopW * desktopH;
        double eacharea = darea / (this.schemaWindowMap.size() + this.mdxWindows.size() + this.jdbcWindows.size());
        int wh = (int)Math.sqrt(eacharea);
        try {
            int x = 0;
            int y = 0;
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null || sf.isIcon()) continue;
                sf.setMaximum(false);
                sf.moveToFront();
                if (x >= desktopW || (double)((desktopW - x) * wh) < eacharea / 2.0) {
                    y += wh;
                    x = 0;
                }
                int sfwidth = x + wh < desktopW ? wh : desktopW - x;
                int sfheight = y + wh < desktopH ? wh : desktopH - y;
                sf.setBounds(x, y, sfwidth, sfheight);
                x += sfwidth;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"tileMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void cascadeMenuItemActionPerformed(ActionEvent evt) {
        try {
            int sfi = 1;
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null || sf.isIcon()) continue;
                sf.setMaximum(false);
                sf.setLocation(30 * sfi, 30 * sfi);
                sf.moveToFront();
                sf.setSelected(true);
                ++sfi;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"cascadeMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void closeAllMenuItemActionPerformed(ActionEvent evt) {
        this.closeAllSchemaFrames(false);
    }

    private void closeAllSchemaFrames(boolean exitAfterClose) {
        try {
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null) continue;
                if (sf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                    SchemaExplorer se = (SchemaExplorer)sf.getContentPane().getComponent(0);
                    sf.setSelected(true);
                    int response = this.confirmFrameClose(sf, se);
                    switch (response) {
                        case 2: {
                            return;
                        }
                        case 3: {
                            sf.setClosed(true);
                        }
                    }
                    continue;
                }
                sf.setClosed(true);
            }
            if (this.schemaWindowMap.keySet().size() == 0 && exitAfterClose) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"closeAllSchemaFrames", (Throwable)ex);
        }
    }

    private int confirmFrameClose(JInternalFrame schemaFrame, SchemaExplorer se) {
        if (se.isDirty()) {
            JMenuItem schemaMenuItem = this.schemaWindowMap.get(this.desktopPane.getSelectedFrame());
            int answer = JOptionPane.showConfirmDialog(this, this.getResourceConverter().getFormattedString("workbench.saveSchemaOnClose.alert", "Save changes to {0}?", se.getSchemaFile().toString()), this.getResourceConverter().getString("workbench.saveSchemaOnClose.title", "Schema"), 1);
            switch (answer) {
                case 0: {
                    this.saveMenuItemActionPerformed(null);
                    this.schemaWindowMap.remove(schemaFrame);
                    this.updateMDXCatalogList();
                    schemaFrame.dispose();
                    this.windowMenu.remove(schemaMenuItem);
                    break;
                }
                case 1: {
                    schemaFrame.dispose();
                    this.schemaWindowMap.remove(schemaFrame);
                    this.windowMenu.remove(schemaMenuItem);
                    break;
                }
                case 2: {
                    try {
                        schemaFrame.setClosed(false);
                        schemaFrame.show();
                        break;
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)"schemaFrame show", (Throwable)ex);
                    }
                }
            }
            return answer;
        }
        return 3;
    }

    private void minimizeMenuItemActionPerformed(ActionEvent evt) {
        try {
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null || sf.isIcon()) continue;
                sf.setIcon(true);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"minimizeMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void maximizeMenuItemActionPerformed(ActionEvent evt) {
        try {
            for (JInternalFrame sf : this.getAllFrames()) {
                if (sf == null) continue;
                sf.setIcon(false);
                sf.setMaximum(true);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"maximizeMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private Iterable<JInternalFrame> getAllFrames() {
        HashSet<JInternalFrame> set = new HashSet<JInternalFrame>();
        set.addAll(this.schemaWindowMap.keySet());
        set.addAll(this.mdxWindows);
        set.addAll(this.jdbcWindows);
        return set;
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        try {
            JEditorPane jEditorPane = new JEditorPane(this.myClassLoader.getResource(this.getResourceConverter().getGUIReference("version")).toString());
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jScrollPane, "Center");
            JInternalFrame jf = new JInternalFrame();
            jf.setTitle(this.getResourceConverter().getString("workbench.about.title", "About"));
            jf.getContentPane().add(jPanel);
            Dimension screenSize = this.getSize();
            int aboutW = 400;
            int aboutH = 300;
            int width = screenSize.width / 2 - aboutW / 3;
            int height = screenSize.height / 2 - aboutH / 3 - 75;
            jf.setBounds(width, height, aboutW, aboutH);
            jf.setClosable(true);
            this.desktopPane.add(jf);
            jf.setVisible(true);
            jf.show();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"aboutMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void newJDBCExplorerMenuItemActionPerformed(ActionEvent evt) {
        try {
            String selectedConnection = this.selectConnection();
            if (selectedConnection == null) {
                return;
            }
            ConnectionDetails cdetails = this.getConnectionDetailsMap().get(selectedConnection);
            if (cdetails == null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("workbench.connection.required.alert", "Select or create a JDBC Connection"), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
                return;
            }
            JdbcMetaData jdbcMetaData = this.getNewJDBCMetadata(cdetails);
            final JInternalFrame jf = new JInternalFrame();
            jf.setTitle(this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.title", "JDBC Explorer - {0} {1}", jdbcMetaData.getDatabaseProductName(), jdbcMetaData.getJdbcConnectionUrl()));
            Constructor jdbcExplorerConstructor = this.getJdbcExplorerClass().getConstructor(ConnectionDetails.class, JdbcMetaData.class, Workbench.class);
            JdbcExplorer jdbce = (JdbcExplorer)jdbcExplorerConstructor.newInstance(cdetails, jdbcMetaData, this);
            jf.getContentPane().add(jdbce);
            jf.setBounds(0, 0, 500, 480);
            jf.setClosable(true);
            jf.setIconifiable(true);
            jf.setMaximizable(true);
            jf.setResizable(true);
            jf.setVisible(true);
            final JMenuItem jdbcMenuItem = new JMenuItem();
            jdbcMenuItem.setText(this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.menuitem", "{0} JDBC Explorer", Integer.toString(this.windowMenuMapIndex++)));
            jdbcMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (jf.isIcon()) {
                            jf.setIcon(false);
                        } else {
                            jf.setSelected(true);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)"queryMenuItem", (Throwable)ex);
                    }
                }
            });
            jf.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    Workbench.this.jdbcWindows.remove(jf);
                    jf.dispose();
                    Workbench.this.windowMenu.remove(jdbcMenuItem);
                }
            });
            this.desktopPane.add(jf);
            jf.setVisible(true);
            jf.show();
            try {
                jf.setSelected(true);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"newJDBCExplorerMenuItemActionPerformed.setSelected", (Throwable)ex);
            }
            this.jdbcWindows.add(jf);
            this.addMenuItemToWindowMenu(jdbcMenuItem);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.exception", "Database connection not successful.\n{0}", ex.getLocalizedMessage()), this.getResourceConverter().getString("workbench.new.JDBCExplorer.exception.title", "Database Connection Error"), 0);
            LOGGER.error((Object)"newJDBCExplorerMenuItemActionPerformed", (Throwable)ex);
        }
    }

    private void addMenuItemToWindowMenu(JMenuItem newItem) {
        this.windowMenu.add((Component)newItem, -1);
        this.windowMenu.add((Component)this.jSeparator3, -1);
        this.windowMenu.add((Component)this.cascadeMenuItem, -1);
        this.windowMenu.add((Component)this.tileMenuItem, -1);
        this.windowMenu.add((Component)this.minimizeMenuItem, -1);
        this.windowMenu.add((Component)this.maximizeMenuItem, -1);
        this.windowMenu.add((Component)this.closeAllMenuItem, -1);
    }

    public String selectConnection() {
        SelectConnectionDialog connectionDialog = new SelectConnectionDialog((Frame)this, true, this.jdbcConnectionName);
        return connectionDialog.getSelectedConnection();
    }

    private void toolbarPreferencesButtonActionPerformed(ActionEvent evt) {
        if (this.preferencesFrame != null) {
            try {
                if (this.preferencesFrame.isIcon()) {
                    this.preferencesFrame.setIcon(false);
                } else {
                    this.preferencesFrame.setSelected(true);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)"reusePreferencesFrame", (Throwable)ex);
            }
            return;
        }
        final JInternalFrame jf = new JInternalFrame();
        jf.setTitle(this.getResourceConverter().getString("preferences.pane.title", "Database Connection"));
        PreferencesDialog pd = new PreferencesDialog(this);
        jf.getContentPane().add(pd);
        jf.setBounds(0, 0, 700, 400);
        jf.setClosable(true);
        jf.setIconifiable(true);
        jf.setMaximizable(true);
        jf.setResizable(false);
        jf.setVisible(true);
        final JMenuItem preferencesMenuItemForWindow = new JMenuItem();
        preferencesMenuItemForWindow.setText(this.getResourceConverter().getString("workbench.preferences.menuitem", "Connection"));
        preferencesMenuItemForWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (jf.isIcon()) {
                        jf.setIcon(false);
                    } else {
                        jf.setSelected(true);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"preferencesMenuItem", (Throwable)ex);
                }
            }
        });
        jf.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                jf.dispose();
                Workbench.this.windowMenu.remove(preferencesMenuItemForWindow);
                Workbench.this.preferencesFrame = null;
                Workbench.this.updatePreferences();
            }
        });
        this.desktopPane.add(jf);
        jf.setVisible(true);
        jf.show();
        try {
            jf.setSelected(true);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"toolbarPreferencesButtonActionPerformed.setSelected", (Throwable)ex);
        }
        this.addMenuItemToWindowMenu(preferencesMenuItemForWindow);
    }

    private void updatePreferences() {
        String newDefault = null;
        for (ConnectionDetails aDetails : this.getConnectionDetailsMap().values()) {
            if (!aDetails.defaultConnection) continue;
            newDefault = this.jdbcConnectionName = aDetails.connectionName;
        }
        if (newDefault != null) {
            this.setConNameDetails(this.getConnectionDetailsMap().get(this.jdbcConnectionName));
        } else {
            this.jdbcConnectionName = null;
            this.setConNameDetails(null);
        }
        this.resetWorkbench();
    }

    private void newSchemaMenuItemActionPerformed(ActionEvent evt) {
        File outputFile;
        String selectedConnection = this.selectConnection();
        if (selectedConnection == null) {
            return;
        }
        MondrianProperties.instance();
        File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
        while ((outputFile = new File(defaultDir, "Schema" + newSchema++ + ".xml")).exists()) {
        }
        this.openSchemaFrame(outputFile, true, selectedConnection);
    }

    public void newQueryMenuItemActionPerformed(ActionEvent evt) {
        this.newQueryMenuItemActionPerformed(evt, null);
    }

    public void newQueryMenuItemActionPerformed(ActionEvent evt, SchemaExplorer se) {
        MdxQuery qp = null;
        try {
            Constructor mdxQueryConstructor = this.getMdxQueryClass().getConstructor(Workbench.class, SchemaExplorer.class);
            qp = (MdxQuery)mdxQueryConstructor.newInstance(this, se);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"mdxQueryConstructor.newInstance", (Throwable)ex);
            return;
        }
        JMenuItem schemaMenuItem = this.schemaWindowMap.get(this.desktopPane.getSelectedFrame());
        final JInternalFrame jf = new JInternalFrame();
        jf.setTitle(this.getResourceConverter().getString("workbench.new.MDXQuery.title", "MDX Query"));
        jf.getContentPane().add(qp);
        jf.setBounds(0, 0, 600, 480);
        jf.setClosable(true);
        jf.setIconifiable(true);
        jf.setMaximizable(true);
        jf.setResizable(true);
        jf.setVisible(true);
        this.desktopPane.add(jf);
        jf.show();
        try {
            jf.setSelected(true);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"newQueryMenuItemActionPerformed.setSelected", (Throwable)ex);
        }
        this.mdxWindows.add(jf);
        final JMenuItem queryMenuItem = new JMenuItem();
        queryMenuItem.setText(this.getResourceConverter().getFormattedString("workbench.new.MDXQuery.menuitem", "{0} MDX", Integer.toString(this.windowMenuMapIndex)));
        queryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (jf.isIcon()) {
                        jf.setIcon(false);
                    } else {
                        jf.setSelected(true);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"queryMenuItem", (Throwable)ex);
                }
            }
        });
        jf.setDefaultCloseOperation(0);
        jf.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                Workbench.this.mdxWindows.remove(jf);
                jf.dispose();
                Workbench.this.windowMenu.remove(queryMenuItem);
            }
        });
        this.addMenuItemToWindowMenu(queryMenuItem);
        qp.setMenuItem(queryMenuItem);
        qp.setSchemaWindowMap(this.schemaWindowMap);
        qp.setWindowMenuIndex(this.windowMenuMapIndex++);
        if (schemaMenuItem != null) {
            qp.initConnection(schemaMenuItem.getText());
        } else {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("workbench.new.MDXQuery.no.selection", "No Mondrian connection. Select a Schema to connect."), this.getResourceConverter().getString("workbench.new.MDXQuery.no.selection.title", "Alert"), 2);
        }
    }

    private void updateMDXCatalogList() {
        for (JInternalFrame elem : this.mdxWindows) {
            MdxQuery qp = (MdxQuery)elem.getContentPane().getComponent(0);
            qp.setSchemaWindowMap(this.schemaWindowMap);
        }
    }

    public SchemaExplorer getCurrentSchemaExplorer() {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf != null && jf.getContentPane().getComponentCount() > 0 && jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            return (SchemaExplorer)jf.getContentPane().getComponent(0);
        }
        return null;
    }

    public File saveAsMenuItemActionPerformed(ActionEvent evt) {
        return this.saveAsMenuItemActionPerformed(evt, this.getCurrentSchemaExplorer());
    }

    public File saveAsMenuItemActionPerformed(ActionEvent evt, SchemaExplorer se) {
        if (se == null) {
            return null;
        }
        try {
            File newSchemaFile = se.saveNewSchemaFile();
            if (newSchemaFile == null) {
                return null;
            }
            this.setLastUsed(newSchemaFile.getName(), newSchemaFile.toURI().toURL().toString(), se.getJdbcConnectionName());
            JMenuItem sMenuItem = this.schemaWindowMap.get(se.getParentIFrame());
            String[] mtexttokens = sMenuItem.getText().split(" ");
            sMenuItem.setText(mtexttokens[0] + " " + se.getSchemaFile().getName());
            this.updateMDXCatalogList();
            se.getParentIFrame().setTitle(this.getResourceConverter().getFormattedString("workbench.open.schema.title", "Schema - {0}", se.getSchemaFile().getName()));
            return newSchemaFile;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"saveAsMenuItemActionPerformed", (Throwable)ex);
            return null;
        }
    }

    private void viewXMLMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        boolean oldValue = this.viewXmlMenuItem.getState();
        if (jf != null && jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            ((JCheckBoxMenuItem)evt.getSource()).setSelected(se.editMode(evt));
            return;
        }
        this.viewXmlMenuItem.setSelected(!oldValue);
    }

    public void saveMenuItemActionPerformed(ActionEvent evt) {
        this.saveMenuItemActionPerformed(evt, this.getCurrentSchemaExplorer());
    }

    public File saveMenuItemActionPerformed(ActionEvent evt, SchemaExplorer se) {
        if (se == null) {
            return null;
        }
        File schemaFile = se.getSchemaFile();
        if (se.isNewFile()) {
            return this.saveAsMenuItemActionPerformed(evt, se);
        }
        try {
            schemaFile = se.saveCurrentSchemaFile();
            this.setLastUsed(schemaFile.getName(), schemaFile.toURI().toURL().toString(), se.getJdbcConnectionName());
            return schemaFile;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"saveMenuItemActionPerformed", (Throwable)ex);
            return null;
        }
    }

    private void setLastUsed(String name, String url, String cName) {
        int i;
        int match = MAX_USED_ITEMS;
        String luName = null;
        for (i = 1; i <= MAX_USED_ITEMS; ++i) {
            luName = this.getWorkbenchProperty(LastUsedPrefix + i);
            if (luName == null || !luName.equals(name)) continue;
            match = i;
            break;
        }
        for (i = match; i > 1; --i) {
            if (this.getWorkbenchProperty(LastUsedPrefix + (i - 1)) == null) continue;
            this.setWorkbenchProperty(LastUsedPrefix + i, this.getWorkbenchProperty(LastUsedPrefix + (i - 1)));
            this.setWorkbenchProperty(LastUsedUrlPrefix + i, this.getWorkbenchProperty(LastUsedUrlPrefix + (i - 1)));
            if (this.getWorkbenchProperty(LastUsedConnectionNamePrefix + (i - 1)) != null) {
                this.setWorkbenchProperty(LastUsedConnectionNamePrefix + i, this.getWorkbenchProperty(LastUsedConnectionNamePrefix + (i - 1)));
                continue;
            }
            this.removeWorkbenchProperty(LastUsedConnectionNamePrefix + i);
        }
        this.setWorkbenchProperty(LastUsedPrefix + "1", name);
        this.setWorkbenchProperty(LastUsedUrlPrefix + "1", url);
        if (cName != null) {
            this.setWorkbenchProperty(LastUsedConnectionNamePrefix + "1", cName);
        } else {
            this.workbenchProperties.remove(LastUsedConnectionNamePrefix + "1");
        }
        this.storeWorkbenchProperties();
        this.updateLastUsedMenuItems(this.fileMenu);
    }

    private void lastUsedMenuItemActionPerformed(ActionEvent evt, int i) {
        try {
            this.openSchemaFrame(new File(new URI(this.getWorkbenchProperty(LastUsedUrlPrefix + i))), false, this.getWorkbenchProperty(LastUsedConnectionNamePrefix + i));
            this.setLastUsed(this.getWorkbenchProperty(LastUsedPrefix + i), this.getWorkbenchProperty(LastUsedUrlPrefix + i), this.getWorkbenchProperty(LastUsedConnectionNamePrefix + i));
        }
        catch (Exception e) {
            LOGGER.error((Object)("lastUsedMenuItemActionPerformed " + i), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSchemaFrame(File file, boolean newFile, String conName) {
        try {
            String selectedConnection;
            this.setCursor(Cursor.getPredefinedCursor(3));
            ConnectionDetails cdetails = this.getConnectionDetailsMap().get(conName);
            if (cdetails == null) {
                cdetails = this.getConnectionDetailsMap().get(this.jdbcConnectionName);
            }
            if (cdetails == null && (selectedConnection = this.selectConnection()) != null) {
                cdetails = this.getConnectionDetailsMap().get(selectedConnection);
            }
            if (cdetails == null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("workbench.connection.required.alert", "Select or create a JDBC Connection"), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
                return;
            }
            conName = cdetails.connectionName;
            if (!newFile) {
                if (this.checkFileOpen(file)) {
                    return;
                }
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.not.found", "{0} File not found.", file.getAbsolutePath()), this.getResourceConverter().getString("workbench.open.schema.not.found.title", "Alert"), 2);
                    return;
                }
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.not.writeable", "{0} is not writeable.", file.getAbsolutePath()), this.getResourceConverter().getString("workbench.open.schema.not.writeable.title", "Alert"), 2);
                    return;
                }
            }
            final JInternalFrame schemaFrame = new JInternalFrame();
            schemaFrame.setTitle(this.getResourceConverter().getFormattedString("workbench.open.schema.title", "Schema - {0}", file.getName()));
            schemaFrame.setBounds(0, 0, 700, 700);
            schemaFrame.setClosable(true);
            schemaFrame.setIconifiable(true);
            schemaFrame.setMaximizable(true);
            schemaFrame.setResizable(true);
            schemaFrame.setVisible(true);
            this.desktopPane.add(schemaFrame);
            schemaFrame.show();
            schemaFrame.setMaximum(true);
            final JMenuItem schemaMenuItem = new JMenuItem();
            schemaMenuItem.setText(this.windowMenuMapIndex++ + " " + file.getName());
            schemaMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (schemaFrame.isIcon()) {
                            schemaFrame.setIcon(false);
                        } else {
                            schemaFrame.setSelected(true);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)"schemaMenuItem", (Throwable)ex);
                    }
                }
            });
            this.windowMenu.add((Component)schemaMenuItem, 0);
            this.windowMenu.setEnabled(true);
            this.windowMenu.add((Component)this.jSeparator3, -1);
            this.windowMenu.add((Component)this.cascadeMenuItem, -1);
            this.windowMenu.add((Component)this.tileMenuItem, -1);
            this.windowMenu.add((Component)this.minimizeMenuItem, -1);
            this.windowMenu.add((Component)this.maximizeMenuItem, -1);
            this.windowMenu.add((Component)this.closeAllMenuItem, -1);
            this.schemaWindowMap.put(schemaFrame, schemaMenuItem);
            this.updateMDXCatalogList();
            schemaFrame.setDefaultCloseOperation(0);
            schemaFrame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    SchemaExplorer se;
                    int response;
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer && (response = Workbench.this.confirmFrameClose(schemaFrame, se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0))) == 3) {
                        if (se.isNewFile()) {
                            se.getSchemaFile().delete();
                        }
                        Workbench.this.schemaWindowMap.remove(schemaFrame);
                        Workbench.this.updateMDXCatalogList();
                        schemaFrame.dispose();
                        Workbench.this.windowMenu.remove(schemaMenuItem);
                    }
                }
            });
            schemaFrame.setFocusable(true);
            schemaFrame.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                        SchemaExplorer se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0);
                        Workbench.this.viewXmlMenuItem.setSelected(se.isEditModeXML());
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                        SchemaExplorer se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0);
                        Workbench.this.viewXmlMenuItem.setSelected(se.isEditModeXML());
                    }
                }
            });
            this.viewXmlMenuItem.setSelected(false);
            JdbcMetaData jdbcMetaData = this.getNewJDBCMetadata(cdetails);
            Constructor schemaExplorerConstructor = this.getSchemaExplorerClass().getConstructor(Workbench.class, File.class, JdbcMetaData.class, String.class, Boolean.TYPE, JInternalFrame.class);
            SchemaExplorer schemaExplorer = (SchemaExplorer)schemaExplorerConstructor.newInstance(this, file, jdbcMetaData, conName, newFile, schemaFrame);
            schemaFrame.getContentPane().add(schemaExplorer);
            String errorOpening = schemaExplorer.getErrMsg();
            if (errorOpening != null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.error", "Error opening schema - {0}.", errorOpening), this.getResourceConverter().getString("workbench.open.schema.error.title", "Error"), 0);
                schemaFrame.dispose();
                this.schemaWindowMap.remove(schemaFrame);
                this.windowMenu.remove(schemaMenuItem);
                return;
            }
            this.displayWarningOnFailedConnection(jdbcMetaData);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"openSchemaFrame", (Throwable)ex);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        String selectedConnection = this.selectConnection();
        if (selectedConnection == null) {
            return;
        }
        JFileChooser jfc = new JFileChooser();
        try {
            jfc.setFileSelectionMode(0);
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".xml") || pathname.isDirectory();
                }

                public String getDescription() {
                    return Workbench.this.getResourceConverter().getString("workbench.open.schema.file.type", "Mondrian Schema files (*.xml)");
                }
            });
            String lastUsed = this.getLastUsedUrl();
            if (lastUsed != null) {
                jfc.setCurrentDirectory(new File(new URI(this.getLastUsedUrl())).getParentFile());
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Could not set file chooser", (Throwable)ex);
            return;
        }
        MondrianProperties.instance();
        if (jfc.showOpenDialog(this) == 0) {
            try {
                this.setLastUsed(jfc.getSelectedFile().getName(), jfc.getSelectedFile().toURI().toURL().toString(), selectedConnection);
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)"openMenuItemActionPerformed", (Throwable)e);
            }
            this.openSchemaFrame(jfc.getSelectedFile(), false, selectedConnection);
        }
    }

    private boolean checkFileOpen(File file) {
        for (JInternalFrame elem : this.schemaWindowMap.keySet()) {
            File f = ((SchemaExplorer)elem.getContentPane().getComponent(0)).getSchemaFile();
            if (!f.equals(file)) continue;
            try {
                elem.setSelected(true);
                return true;
            }
            catch (Exception ex) {
                this.schemaWindowMap.remove(elem);
                break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdbcMetaData getNewJDBCMetadata(ConnectionDetails connDetails) {
        if (connDetails == null) {
            return null;
        }
        JdbcMetaData jm = null;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            jm = new JdbcMetaData(this, connDetails);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        return jm;
    }

    private void resetWorkbench() {
        JdbcMetaData jdbcMetaData;
        ConnectionDetails cdetails;
        for (JInternalFrame theSchemaFrame : this.schemaWindowMap.keySet()) {
            SchemaExplorer theSchemaExplorer = (SchemaExplorer)theSchemaFrame.getContentPane().getComponent(0);
            cdetails = this.getConnectionDetailsMap().get(theSchemaExplorer.getJdbcConnectionName());
            jdbcMetaData = this.getNewJDBCMetadata(cdetails);
            this.displayWarningOnFailedConnection(jdbcMetaData);
            theSchemaExplorer.resetJdbcMetaData(jdbcMetaData);
            theSchemaExplorer.getTreeUpdater().update();
            theSchemaFrame.updateUI();
        }
        this.updateConNameListOnSchema();
        for (JInternalFrame jdbcFrame : this.jdbcWindows) {
            JdbcExplorer explorer = (JdbcExplorer)jdbcFrame.getContentPane().getComponent(0);
            cdetails = this.getConnectionDetailsMap().get(explorer.getConnectionName());
            jdbcMetaData = this.getNewJDBCMetadata(cdetails);
            this.displayWarningOnFailedConnection(jdbcMetaData);
            explorer.resetMetaData(cdetails, jdbcMetaData);
            jdbcFrame.setTitle(this.getResourceConverter().getFormattedString("workbench.new.JDBCExplorer.title", "JDBC Explorer - {0} {1}", jdbcMetaData.getDatabaseProductName(), jdbcMetaData.getJdbcConnectionUrl()));
            explorer.getTreeUpdater().update();
            explorer.updateUI();
        }
    }

    private void displayWarningOnFailedConnection(JdbcMetaData jdbcMetaData) {
        if (jdbcMetaData != null && jdbcMetaData.getErrMsg() != null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("workbench.open.schema.jdbc.error", "Database connection could not be done.\n{0}\nAll validations related to database will be ignored.", jdbcMetaData.getErrMsg()), this.getResourceConverter().getString("workbench.open.schema.jdbc.error.title", "Alert"), 2);
        }
    }

    public static void setPreferredSizeMaxXY(Component ... components) {
        Dimension newPreferredSize = new Dimension();
        for (Component c : components) {
            Dimension currentPreferredSize = c.getPreferredSize();
            if (currentPreferredSize.height > newPreferredSize.height) {
                newPreferredSize.height = currentPreferredSize.height;
            }
            if (currentPreferredSize.width <= newPreferredSize.width) continue;
            newPreferredSize.width = currentPreferredSize.width;
        }
        for (Component c : components) {
            c.setPreferredSize(newPreferredSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapConnectionHolder checkSchemaFile(File file, ConnectionDetails cDetails) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (cDetails == null) {
                throw new RuntimeException("No Connection Details");
            }
            AggregationManager.instance().getCacheControl(null).flushSchemaCache();
            Class.forName("mondrian.olap4j.MondrianOlap4jDriver");
            StringBuffer sb = new StringBuffer();
            sb.append("jdbc:mondrian:");
            sb.append("Jdbc='" + cDetails.jdbcUrl + "';");
            sb.append("Catalog=" + file.toURL().toString() + ";");
            sb.append("JdbcDrivers=" + cDetails.driverClassName + ";");
            if (cDetails.userName != null && cDetails.userName.length() > 0) {
                sb.append("JdbcUser=" + cDetails.userName + ";");
            }
            if (cDetails.password != null && cDetails.password.length() > 0) {
                sb.append("JdbcPassword=" + cDetails.password + ";");
            }
            Connection con = DriverManager.getConnection(sb.toString());
            OlapConnectionHolder olapConnectionHolder = new OlapConnectionHolder(con);
            return olapConnectionHolder;
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception : Schema file " + file.getAbsolutePath() + " is invalid." + ex.getMessage()), (Throwable)ex);
            OlapConnectionHolder olapConnectionHolder = new OlapConnectionHolder(ex);
            return olapConnectionHolder;
        }
        catch (Error err) {
            LOGGER.error((Object)("Error : Schema file " + file.getAbsolutePath() + " is invalid." + err.getMessage()), (Throwable)err);
            OlapConnectionHolder olapConnectionHolder = new OlapConnectionHolder(err);
            return olapConnectionHolder;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.storeWorkbenchProperties();
        this.closeAllSchemaFrames(true);
    }

    private void parseArgs(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-f=")) continue;
            this.openFile = arg.substring(3);
        }
    }

    public String getTooltip(String titleName) {
        for (ResourceBundle bundle : this.additionalWorkbenchInfoResourceBundles) {
            try {
                return bundle.getString(titleName);
            }
            catch (MissingResourceException ex) {
            }
        }
        try {
            return this.getWorkbenchResourceBundle().getString(titleName);
        }
        catch (MissingResourceException e) {
            LOGGER.error((Object)("No tool tip for " + titleName));
            return this.getResourceConverter().getFormattedString("workbench.tooltip.error", "No help available for {0}", titleName);
        }
    }

    public static void main(String[] args) {
        try {
            File f;
            Workbench w = new Workbench(args);
            w.setSize(800, 600);
            if (w.openFile != null && (f = new File(w.openFile)).canRead()) {
                w.openSchemaFrame(f.getAbsoluteFile(), false, null);
            }
            w.setVisible(true);
        }
        catch (Throwable ex) {
            LOGGER.error((Object)"main", ex);
        }
    }

    public String getLastUsedUrl() {
        return this.getWorkbenchProperty(LastUsedUrlPrefix + "1");
    }

    public JCheckBoxMenuItem getViewXmlMenuItem() {
        return this.viewXmlMenuItem;
    }

    public ConnectionDetails newConnectionDetails() {
        return new ConnectionDetails();
    }

    public ConnectionDetails getConNameDetails() {
        return this.conNameDetails;
    }

    public void setConNameDetails(ConnectionDetails conNameDetails) {
        this.conNameDetails = conNameDetails;
    }

    public Map<String, ConnectionDetails> getConnectionDetailsMap() {
        return this.connectionDetailsMap;
    }

    public void setConnectionDetailsMap(Map<String, ConnectionDetails> conNameDetailsMap) {
        this.connectionDetailsMap = conNameDetailsMap;
    }

    private void updateConNameListOnSchema() {
        for (JInternalFrame sf : this.schemaWindowMap.keySet()) {
            if (!(sf.getContentPane().getComponent(0) instanceof SchemaExplorer)) continue;
            SchemaExplorer se = (SchemaExplorer)sf.getContentPane().getComponent(0);
            se.updateConNameList(this.getConnectionDetailsMap(), se.getJdbcConnectionName());
        }
    }

    public boolean isConNameUsedBySchema(String conName) {
        for (JInternalFrame sf : this.schemaWindowMap.keySet()) {
            SchemaExplorer se;
            if (!(sf.getContentPane().getComponent(0) instanceof SchemaExplorer) || !conName.equals((se = (SchemaExplorer)sf.getContentPane().getComponent(0)).getJdbcConnectionName())) continue;
            return true;
        }
        return false;
    }

    static {
        MAX_USED_ITEMS = 10;
        LastUsedPrefix = "lastUsed-";
        LastUsedUrlPrefix = "lastUsedUrl-";
        LastUsedConnectionNamePrefix = "conName-";
        LOGGER = Logger.getLogger(Workbench.class);
        formatter = new RectangularCellSetFormatter(false);
        resourceConverter = null;
        newSchema = 1;
    }

    public class ConnectionDetails {
        public boolean defaultConnection = false;
        public String connectionName;
        public String driverClassName;
        public String userName;
        public String password;
        public String jdbcUrl;
        public String schemas;
        public String type;
        public String host;
        public String port;
        public String database;
        public boolean requireSchemas;

        public void setProperties(Properties p) {
            this.setProperty(p, "ConnectionName", this.connectionName);
            this.setProperty(p, "DriverClassName", this.driverClassName);
            this.setProperty(p, "JdbcUrl", this.jdbcUrl);
            this.setProperty(p, "Type", this.type);
            this.setProperty(p, "Host", this.host);
            this.setProperty(p, "Port", this.port);
            this.setProperty(p, "Database", this.database);
            this.setProperty(p, "UserName", this.userName);
            this.setProperty(p, "Password", this.password);
            this.setProperty(p, "Schemas", this.schemas);
            this.setProperty(p, "RequireSchemas", Boolean.toString(this.requireSchemas));
            this.setProperty(p, "Default", Boolean.toString(this.defaultConnection));
        }

        private void setProperty(Properties p, String propertyName, String value) {
            p.setProperty("jdbc." + this.connectionName + "." + propertyName, this.stringValue(value));
        }

        public String stringValue(String value) {
            if (value == null || value.trim().length() == 0) {
                return "";
            }
            return value.trim();
        }

        public void put(String propertyName, String value) {
            if (this.matchPropertyName(propertyName, "ConnectionName")) {
                this.connectionName = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "DriverClassName")) {
                this.driverClassName = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "JdbcUrl")) {
                this.jdbcUrl = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "Type")) {
                this.type = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "Host")) {
                this.host = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "Port")) {
                this.port = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "Database")) {
                this.database = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "UserName")) {
                this.userName = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "Password")) {
                this.password = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "Schemas")) {
                this.schemas = this.stringValue(value);
            } else if (this.matchPropertyName(propertyName, "RequireSchemas")) {
                this.requireSchemas = Boolean.parseBoolean(value);
            } else if (this.matchPropertyName(propertyName, "Default")) {
                this.defaultConnection = Boolean.parseBoolean(value);
            } else {
                throw new IllegalArgumentException("Property: " + propertyName + ", value: " + value);
            }
        }

        private boolean matchPropertyName(String candidate, String propertyName) {
            if (candidate == null || candidate.trim().length() == 0) {
                return false;
            }
            return candidate.toLowerCase().startsWith(propertyName.trim().toLowerCase());
        }
    }

    public class OlapConnectionHolder {
        public mondrian.olap.Connection mondrianConnection;
        public Connection olapJdbcConnection;
        public OlapConnection olapConnection = null;
        public Throwable exception = null;

        public OlapConnectionHolder(mondrian.olap.Connection monConn) {
            this.mondrianConnection = monConn;
        }

        public OlapConnectionHolder(Connection olapJdbcConn) throws SQLException {
            this.olapJdbcConnection = olapJdbcConn;
            this.olapConnection = (OlapConnection)((OlapWrapper)this.olapJdbcConnection).unwrap(OlapConnection.class);
        }

        public OlapConnectionHolder(Throwable t) {
            this.exception = t;
        }

        public Connection getOlapJdbcConnection() {
            if (!this.isOlap4J()) {
                throw new IllegalArgumentException("OlapJdbcConnection is not OLAP4J");
            }
            return this.olapJdbcConnection;
        }

        public OlapConnection getOlapConnection() {
            if (!this.isOlap4J()) {
                throw new IllegalArgumentException("OlapConnection is not OLAP4J");
            }
            return this.olapConnection;
        }

        public String getJdbcUrl() throws SQLException {
            if (this.isOlap4J()) {
                String[] parts;
                String fullUrl = this.olapJdbcConnection.getMetaData().getURL();
                for (String part : parts = fullUrl.split(";")) {
                    String[] nameValue = part.split("=");
                    if (!nameValue[0].equals("Jdbc")) continue;
                    return nameValue[1].trim();
                }
                return "unknown";
            }
            return (String)this.mondrianConnection.getProperty("JdbcUrl");
        }

        public boolean isOlap4J() {
            return this.olapJdbcConnection != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printQuery(PrintWriter pw, String query) throws SQLException {
            if (this.isOlap4J()) {
                OlapStatement olapStatement = null;
                CellSet cellSet = null;
                try {
                    olapStatement = this.olapConnection.createStatement();
                    cellSet = olapStatement.executeOlapQuery(query);
                    formatter.format(cellSet, pw);
                }
                finally {
                    if (cellSet != null) {
                        cellSet.close();
                    }
                    if (olapStatement != null) {
                        olapStatement.close();
                    }
                }
            } else {
                Query q = this.mondrianConnection.parseQuery(query);
                Result r = this.mondrianConnection.execute(q);
                this.print(pw, r);
            }
        }

        public void close() throws SQLException {
            if (this.isOlap4J()) {
                this.olapConnection.close();
                this.olapJdbcConnection.close();
                this.olapConnection = null;
                this.olapJdbcConnection = null;
            } else if (this.mondrianConnection != null) {
                this.mondrianConnection.close();
                this.mondrianConnection = null;
            }
        }

        public void print(PrintWriter pw, Result result) {
            for (int i = -1; i < result.getAxes().length; ++i) {
                pw.println("Axis #" + (i + 1) + ":");
                this.printAxis(pw, i < 0 ? result.getSlicerAxis() : result.getAxes()[i]);
            }
            int[] pos = new int[result.getAxes().length];
            this.printRows(pw, result, result.getAxes().length - 1, pos);
        }

        private void printRows(PrintWriter pw, Result result, int axis, int[] pos) {
            Axis _axis = axis < 0 ? result.getSlicerAxis() : result.getAxes()[axis];
            List positions = _axis.getPositions();
            int i = 0;
            for (Position position : positions) {
                if (axis < 0) {
                    if (i > 0) {
                        pw.print(", ");
                    }
                    this.printCell(pw, result, pos);
                } else {
                    pos[axis] = i;
                    if (axis == 0) {
                        int row = axis + 1 < pos.length ? pos[axis + 1] : 0;
                        pw.print("Row #" + row + ": ");
                    }
                    this.printRows(pw, result, axis - 1, pos);
                    if (axis == 0) {
                        pw.println();
                    }
                }
                ++i;
            }
        }

        private void printAxis(PrintWriter pw, Axis axis) {
            List positions = axis.getPositions();
            for (Position position : positions) {
                boolean firstTime = true;
                pw.print("{");
                for (Member member : position) {
                    if (member.getDimension().isHighCardinality()) {
                        pw.println(" -- High cardinality dimension --}");
                        return;
                    }
                    if (!firstTime) {
                        pw.print(", ");
                    }
                    pw.print(member.getUniqueName());
                    for (Property property : member.getProperties()) {
                        pw.print("    ");
                        pw.println(member.getPropertyFormattedValue(property.getName()));
                    }
                    firstTime = false;
                }
                pw.println("}");
            }
        }

        private void printCell(PrintWriter pw, Result result, int[] pos) {
            Cell cell = result.getCell(pos);
            pw.print(cell.getFormattedValue());
        }
    }

    class DesktopPaneWithBackground
    extends JDesktopPane {
        Image img;
        int imgWidth = 0;
        int imgHeight = 0;
        float widthToHeightRatio = 0.0f;

        public DesktopPaneWithBackground() {
        }

        public DesktopPaneWithBackground(Image img) {
            this.setBackgroundImage(img);
        }

        public void setBackgroundImage(Image img) {
            try {
                this.img = img;
                this.imgWidth = img.getWidth(this);
                this.imgHeight = img.getHeight(this);
                this.widthToHeightRatio = new Float(this.imgWidth).floatValue() / new Float(this.imgHeight).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img == null) {
                return;
            }
            int xPos = 0;
            int yPos = 0;
            int width = this.imgWidth;
            int height = this.imgHeight;
            if (this.getWidth() > this.imgWidth) {
                xPos = (this.getWidth() - this.imgWidth) / 2;
            } else {
                width = this.getWidth();
            }
            if (this.getHeight() > this.imgHeight) {
                yPos = (this.getHeight() - this.imgHeight) / 2;
            } else {
                int widthFromHeight = Math.round((float)this.getHeight() * this.widthToHeightRatio);
                if (widthFromHeight < width) {
                    width = widthFromHeight;
                    xPos = (this.getWidth() - width) / 2;
                } else {
                    height = this.getHeight();
                }
            }
            height = Math.round((float)width / this.widthToHeightRatio);
            g.drawImage(this.img, xPos, yPos, width, height, this);
        }
    }
}

