/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import mondrian.gui.I18n;
import mondrian.gui.Workbench;

public class SelectConnectionDialog
extends Dialog {
    private String selectedConnection = null;
    private String currentConnection = null;
    private String[] connectionNames = null;
    private JButton cancelButton;
    private JList connectionList;
    private JScrollPane jScrollPane1;
    private JButton okButton;

    public SelectConnectionDialog(Frame parent, boolean modal, String currentSelection) {
        super(parent, modal);
        this.currentConnection = currentSelection;
        this.initComponents();
        Workbench.setPreferredSizeMaxXY(this.okButton, this.cancelButton);
        this.setVisible(true);
    }

    public String getSelectedConnection() {
        return this.selectedConnection;
    }

    public void setSelectedConnection(String selectedConnection) {
        this.selectedConnection = selectedConnection;
    }

    public String getCurrentConnection() {
        return this.currentConnection;
    }

    public I18n getResourceConverter() {
        if (this.getParent() == null || this.getParent().getClass() != Workbench.class) {
            return Workbench.getGlobalResourceConverter();
        }
        return ((Workbench)this.getParent()).getResourceConverter();
    }

    public String[] getConnectionNames() {
        if (this.connectionNames == null) {
            Map<String, Workbench.ConnectionDetails> connectionMap = ((Workbench)this.getParent()).getConnectionDetailsMap();
            this.connectionNames = connectionMap.keySet().toArray(new String[0]);
        }
        return this.connectionNames;
    }

    private int getInitialSelectionIndex() {
        int i = 0;
        boolean found = false;
        for (String name : this.getConnectionNames()) {
            if (name.equals(this.currentConnection)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.connectionList = new JList<String>(this.getConnectionNames());
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(this.getResourceConverter().getString("connectionDialog.dialog.title", "Select Connection"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SelectConnectionDialog.this.closeDialog(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane1.setPreferredSize(new Dimension(220, 146));
        this.connectionList.setMinimumSize(new Dimension(90, 90));
        this.connectionList.setSelectedIndex(this.getInitialSelectionIndex());
        this.jScrollPane1.setViewportView(this.connectionList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.okButton.setText(this.getResourceConverter().getString("connectionDialog.okButton.title", "OK"));
        this.okButton.setHorizontalTextPosition(0);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectConnectionDialog.this.okAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText(this.getResourceConverter().getString("connectionDialog.cancelButton.title", "Cancel"));
        this.cancelButton.setHorizontalAlignment(11);
        this.cancelButton.setHorizontalTextPosition(0);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectConnectionDialog.this.cancelAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.cancelButton, gridBagConstraints);
        this.pack();
    }

    private void okAction(ActionEvent evt) {
        String selection = (String)this.connectionList.getSelectedValue();
        if (selection == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("connectionDialog.notSelected.alert", "No connection selected"), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
        } else {
            this.setSelectedConnection(selection);
            this.closeDialog(null);
        }
    }

    private void cancelAction(ActionEvent evt) {
        this.setSelectedConnection(null);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SelectConnectionDialog dialog = new SelectConnectionDialog(new Frame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

