/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.Workbench;
import mondrian.gui.validate.ValidationUtils;
import mondrian.gui.validate.impl.WorkbenchJdbcValidator;
import org.eigenbase.xom.ElementDef;

public class SchemaTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ClassLoader myClassLoader = this.getClass().getClassLoader();
    public boolean invalidFlag;
    private JdbcMetaData jdbcMetaData;
    private final Workbench workbench;

    public SchemaTreeCellRenderer(Workbench workbench, JdbcMetaData jdbcMetaData) {
        this.workbench = workbench;
        this.jdbcMetaData = jdbcMetaData;
    }

    public SchemaTreeCellRenderer() {
        this(null, null);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.invalidFlag = this.isInvalid(tree, value, row);
        this.setPreferredSize(null);
        if (value instanceof MondrianGuiDef.Cube) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Cube)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("cube"))));
        } else if (value instanceof MondrianGuiDef.Column) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Column)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.Dimension) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("dimension"))));
            this.setText(this.invalidFlag, ((MondrianGuiDef.CubeDimension)((Object)value)).name);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.DimensionUsage) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("dimensionUsage"))));
            this.setText(this.invalidFlag, ((MondrianGuiDef.CubeDimension)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.KeyExpression) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("key"))));
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.keyExpression.title", "Key Expression"));
        } else if (value instanceof MondrianGuiDef.NameExpression) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("name"))));
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.nameExpression.title", "Name Expression"));
        } else if (value instanceof MondrianGuiDef.OrdinalExpression) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("ordinal"))));
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.ordinalExpression.title", "Ordinal Expression"));
        } else if (value instanceof MondrianGuiDef.ParentExpression) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("parent"))));
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.parentExpression.title", "Parent Expression"));
        } else if (value instanceof MondrianGuiDef.Column) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("column"))));
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.column.title", "Column"));
        } else if (value instanceof MondrianGuiDef.ExpressionView) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("expression"))));
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.expressionView.title", "Expression View"));
        } else if (value instanceof MondrianGuiDef.Expression) {
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("expression"))));
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.expression.title", "Expression"));
        } else if (value instanceof MondrianGuiDef.Hierarchy) {
            String name = ((MondrianGuiDef.Hierarchy)((Object)value)).name;
            if (name == null || name.trim().length() == 0) {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.hierarchy.default.name", "default"));
            } else {
                this.setText(this.invalidFlag, name);
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("hierarchy"))));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.RelationOrJoin) {
            String alias;
            Object parent;
            TreePath parentpath;
            TreePath tpath = tree.getPathForRow(row);
            String prefix = "";
            if (tpath != null && (parentpath = tpath.getParentPath()) != null && (parent = parentpath.getLastPathComponent()) instanceof MondrianGuiDef.Join) {
                MondrianGuiDef.Join parentJoin = (MondrianGuiDef.Join)((Object)parent);
                prefix = parentJoin.left != null && parentJoin.left == value ? this.workbench.getResourceConverter().getString("common.left.title", "Left") + " " : this.workbench.getResourceConverter().getString("common.right.title", "Right") + " ";
            }
            if (value instanceof MondrianGuiDef.Join) {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.join.title", "{0}Join", prefix));
                this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("join"))));
            } else if (value instanceof MondrianGuiDef.Table) {
                MondrianGuiDef.Table theTable = (MondrianGuiDef.Table)((Object)value);
                String theName = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.table.title", "{0}Table: {1}", prefix.length() == 0 ? "" : prefix + " : ", theName));
                this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("table"))));
            } else if (value instanceof MondrianGuiDef.View) {
                alias = ((MondrianGuiDef.View)((Object)value)).alias;
                alias = ValidationUtils.isEmpty(alias) ? "" : ": " + alias;
                this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("view"))));
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.view.title", "View{0}", alias));
            } else if (value instanceof MondrianGuiDef.InlineTable) {
                alias = ((MondrianGuiDef.InlineTable)((Object)value)).alias;
                alias = ValidationUtils.isEmpty(alias) ? "" : ": " + alias;
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.inline.table.title", "Inline Table{0}", alias));
            }
            this.getPreferredSize();
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 35, 24));
        } else if (value instanceof MondrianGuiDef.ColumnDefs) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.inline.table.columnDefs.title", "Column Definitions"));
        } else if (value instanceof MondrianGuiDef.ColumnDef) {
            String name = ((MondrianGuiDef.ColumnDef)((Object)value)).name;
            name = ValidationUtils.isEmpty(name) ? "" : name;
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.inline.table.columnDef.title", "{0}", name));
        } else if (value instanceof MondrianGuiDef.Rows) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.inline.table.rows.title", "Rows"));
        } else if (value instanceof MondrianGuiDef.Row) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.inline.table.row.title", "Row"));
        } else if (value instanceof MondrianGuiDef.Value) {
            String name = ((MondrianGuiDef.Value)((Object)value)).column;
            name = ValidationUtils.isEmpty(name) ? "" : name;
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getFormattedString("schemaTreeCellRenderer.inline.table.row.value.title", "{0}", name));
        } else if (value instanceof MondrianGuiDef.Level) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Level)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("level"))));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + 1, 25));
        } else if (value instanceof MondrianGuiDef.Measure) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Measure)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("measure"))));
        } else if (value instanceof MondrianGuiDef.Formula) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Formula)((Object)value)).getName());
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("formula"))));
        } else if (value instanceof MondrianGuiDef.MemberReaderParameter) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.MemberReaderParameter)((Object)value)).name);
        } else if (value instanceof MondrianGuiDef.Property) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Property)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("property"))));
        } else if (value instanceof MondrianGuiDef.Schema) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Schema)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("schema"))));
        } else if (value instanceof MondrianGuiDef.NamedSet) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.NamedSet)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("namedSet"))));
        } else if (value instanceof MondrianGuiDef.CalculatedMember) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.CalculatedMember)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("calculatedMember"))));
        } else if (value instanceof MondrianGuiDef.CalculatedMemberProperty) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.CalculatedMemberProperty)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("nopic"))));
        } else if (value instanceof MondrianGuiDef.UserDefinedFunction) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.UserDefinedFunction)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("userDefinedFunction"))));
        } else if (value instanceof MondrianGuiDef.Role) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Role)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("role"))));
        } else if (value instanceof MondrianGuiDef.Parameter) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Parameter)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("parameter"))));
        } else if (value instanceof MondrianGuiDef.SchemaGrant) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.schemaGrant.title", "Schema Grant"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("schemaGrant"))));
        } else if (value instanceof MondrianGuiDef.CubeGrant) {
            String name = ((MondrianGuiDef.CubeGrant)((Object)value)).cube;
            if (name != null && name.trim().length() > 0) {
                this.setText(this.invalidFlag, name.trim());
            } else {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.cubeGrant.title", "Cube Grant"));
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("cubeGrant"))));
        } else if (value instanceof MondrianGuiDef.DimensionGrant) {
            String name = ((MondrianGuiDef.DimensionGrant)((Object)value)).dimension;
            if (name != null && name.trim().length() > 0) {
                this.setText(this.invalidFlag, name.trim());
            } else {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.dimensionGrant.title", "Dimension Grant"));
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("dimensionGrant"))));
        } else if (value instanceof MondrianGuiDef.HierarchyGrant) {
            String name = ((MondrianGuiDef.HierarchyGrant)((Object)value)).hierarchy;
            if (name != null && name.trim().length() > 0) {
                this.setText(this.invalidFlag, name.trim());
            } else {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.hierarchyGrant.title", "Hierarchy Grant"));
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("hierarchyGrant"))));
        } else if (value instanceof MondrianGuiDef.MemberGrant) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.memberGrant.title", "Member Grant"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("memberGrant"))));
        } else if (value instanceof MondrianGuiDef.Annotations) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.annotations.title", "Annotations"));
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("annotations"))));
        } else if (value instanceof MondrianGuiDef.Annotation) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.Annotation)((Object)value)).name);
            super.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("annotation"))));
        } else if (value instanceof MondrianGuiDef.SQL) {
            Object parent;
            TreePath parentpath;
            TreePath tpath = tree.getPathForRow(row);
            boolean setText = false;
            if (tpath != null && (parentpath = tpath.getParentPath()) != null && (parent = parentpath.getLastPathComponent()) instanceof MondrianGuiDef.Table) {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.filter.title", "Filter"));
                setText = true;
            }
            if (!setText) {
                this.setText(this.invalidFlag, ((MondrianGuiDef.SQL)((Object)value)).dialect);
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("sql"))));
        } else if (value instanceof MondrianGuiDef.View) {
            this.setText(this.workbench.getResourceConverter().getString("common.view.title", "View"));
        } else if (value instanceof MondrianGuiDef.VirtualCube) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCube)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("virtualCube"))));
        } else if (value instanceof MondrianGuiDef.VirtualCubeDimension) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCubeDimension)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("virtualCubeDimension"))));
        } else if (value instanceof MondrianGuiDef.VirtualCubeMeasure) {
            this.setText(this.invalidFlag, ((MondrianGuiDef.VirtualCubeMeasure)((Object)value)).name);
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("virtualCubeMeasure"))));
        } else if (value instanceof MondrianGuiDef.AggName) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggName.title", "Aggregate Name"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggTable"))));
        } else if (value instanceof MondrianGuiDef.AggForeignKey) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggForeignKey.title", "Aggregate Foreign Key"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggForeignKey"))));
        } else if (value instanceof MondrianGuiDef.AggIgnoreColumn) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggIgnoreColumn.title", "Aggregate Ignore Column"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggIgnoreColumn"))));
        } else if (value instanceof MondrianGuiDef.AggLevel) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggLevel.title", "Aggregate Level"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggLevel"))));
        } else if (value instanceof MondrianGuiDef.AggMeasure) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggMeasure.title", "Aggregate Measure"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggMeasure"))));
        } else if (value instanceof MondrianGuiDef.AggPattern) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggPattern.title", "Aggregate Pattern"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggPattern"))));
        } else if (value instanceof MondrianGuiDef.AggExclude) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggExclude.title", "Aggregate Exclude"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggExclude"))));
        } else if (value instanceof MondrianGuiDef.AggFactCount) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.aggFactCount.title", "Aggregate Fact Count"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("aggFactCount"))));
        } else if (value instanceof MondrianGuiDef.Closure) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.closure.title", "Closure"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("closure"))));
        } else if (value instanceof MondrianGuiDef.Union) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.union.title", "Union"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("union"))));
        } else if (value instanceof MondrianGuiDef.Annotations) {
            this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.annotations.title", "Annotations"));
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("annotations"))));
        } else if (value instanceof MondrianGuiDef.Annotation) {
            String name = ((MondrianGuiDef.Annotation)((Object)value)).name;
            if (name != null && name.trim().length() > 0) {
                this.setText(this.invalidFlag, name.trim());
            } else {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.annotation.title", "Annotation"));
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("annotation"))));
        } else if (value instanceof MondrianGuiDef.Hint) {
            String type = ((MondrianGuiDef.Hint)((Object)value)).type;
            if (type != null && type.trim().length() > 0) {
                this.setText(this.invalidFlag, type.trim());
            } else {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.hint.title", "Hint"));
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("hint"))));
        } else if (value instanceof MondrianGuiDef.RoleUsage) {
            String name = ((MondrianGuiDef.RoleUsage)((Object)value)).roleName;
            if (name != null && name.trim().length() > 0) {
                this.setText(this.invalidFlag, name.trim());
            } else {
                this.setText(this.invalidFlag, this.workbench.getResourceConverter().getString("common.roleUsage.title", "Role Usage"));
            }
            this.setIcon(new ImageIcon(this.myClassLoader.getResource(this.workbench.getResourceConverter().getGUIReference("roleUsage"))));
        } else if (value instanceof ElementDef) {
            this.setText(((ElementDef)value).getName());
        } else {
            super.setText("");
        }
        return this;
    }

    public String invalid(JTree tree, TreePath tpath, Object value) {
        return ValidationUtils.invalid(this.workbench.getResourceConverter(), new WorkbenchJdbcValidator(this.jdbcMetaData), tree.getModel(), tpath, value, this.jdbcMetaData.getRequireSchema());
    }

    private boolean isInvalid(JTree tree, Object value, int row) {
        return this.invalid(tree, tree.getPathForRow(row), value) != null;
    }

    public void setText(boolean invalidFlag, String myText) {
        if (invalidFlag) {
            myText = "<html><FONT COLOR=RED><b>x</b></FONT><FONT COLOR=" + this.getForeground().hashCode() + ">" + myText + "</FONT></html>";
        }
        this.setText(myText);
    }

    public void setJdbcMetaData(JdbcMetaData jdbcMetaData) {
        this.jdbcMetaData = jdbcMetaData;
    }
}

