/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import mondrian.gui.I18n;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.ParentInPath;
import mondrian.gui.PropertyTableModel;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.SchemaPropertyCellRenderer;
import mondrian.gui.Workbench;
import mondrian.olap.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaPropertyCellEditor
implements TableCellEditor {
    Workbench workbench;
    final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
    JTextField stringEditor;
    JTextArea cdataTextArea;
    JScrollPane jScrollPaneCDATA;
    JCheckBox booleanEditor;
    JTextField integerEditor;
    JTable tableEditor;
    Component activeEditor;
    JComboBox listEditor;
    JTable relationTable;
    JPanel relationRenderer;
    JdbcMetaData jdbcMetadata;
    ComboBoxModel allOptions;
    ComboBoxModel selOptions;
    String listEditorValue;
    MouseListener ml;
    ItemListener il;
    ActionListener al;
    String noSelect = "-- No Selection --";
    FocusAdapter editorFocus;
    Object originalValue;
    private String cacheCube = "";
    private String cacheHierarchy = "";
    private List<String> hlevels = new ArrayList<String>();

    public SchemaPropertyCellEditor(Workbench workbench, JdbcMetaData jdbcMetaData) {
        this(workbench);
        this.jdbcMetadata = jdbcMetaData;
    }

    public SchemaPropertyCellEditor(Workbench workbench) {
        this.workbench = workbench;
        this.noSelect = this.getResourceConverter().getString("schemaPropertyCellEditor.noSelection", this.noSelect);
        this.stringEditor = new JTextField();
        this.stringEditor.setFont(Font.decode("Dialog"));
        this.stringEditor.setBorder(null);
        this.cdataTextArea = new JTextArea();
        this.cdataTextArea.setLineWrap(true);
        this.cdataTextArea.setWrapStyleWord(true);
        this.cdataTextArea.setLayout(new BorderLayout());
        this.cdataTextArea.setEditable(true);
        this.cdataTextArea.setPreferredSize(new Dimension(100, 300));
        this.cdataTextArea.setMinimumSize(new Dimension(100, 100));
        this.jScrollPaneCDATA = new JScrollPane(this.cdataTextArea);
        this.jScrollPaneCDATA.setMaximumSize(this.cdataTextArea.getPreferredSize());
        this.booleanEditor = new JCheckBox();
        this.booleanEditor.setBackground(Color.white);
        this.integerEditor = new JTextField();
        this.integerEditor.setBorder(null);
        this.integerEditor.setHorizontalAlignment(4);
        this.integerEditor.setFont(Font.decode("Courier"));
        this.tableEditor = new JTable();
        this.listEditor = new JComboBox();
        this.listEditor.setEditable(true);
        this.listEditor.setMaximumSize(this.stringEditor.getMaximumSize());
        this.listEditor.setFont(Font.decode("Dialog"));
        this.listEditor.setBackground(Color.white);
        this.listEditor.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.al = new ActionListener(){
            boolean all = true;

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("comboBoxChanged") && SchemaPropertyCellEditor.this.listEditor.getSelectedIndex() == 0) {
                    if (this.all) {
                        SchemaPropertyCellEditor.this.listEditor.setModel(SchemaPropertyCellEditor.this.allOptions);
                    } else {
                        SchemaPropertyCellEditor.this.listEditor.setModel(SchemaPropertyCellEditor.this.selOptions);
                    }
                    SchemaPropertyCellEditor.this.listEditor.setSelectedIndex(-1);
                    boolean bl = this.all = !this.all;
                }
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }
        };
        JTextComponent editor = (JTextComponent)this.listEditor.getEditor().getEditorComponent();
        editor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }
        });
        editor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (SchemaPropertyCellEditor.this.listEditor.isDisplayable()) {
                    SchemaPropertyCellEditor.this.listEditor.setPopupVisible(true);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SchemaPropertyCellEditor.this.listEditor.setSelectedItem(SchemaPropertyCellEditor.this.listEditorValue);
                    SchemaPropertyCellEditor.this.listEditor.getEditor().setItem(SchemaPropertyCellEditor.this.listEditorValue);
                }
            }
        });
    }

    public MondrianGuiDef.RelationOrJoin getRelation(JTable table, int row, int column) {
        PropertyTableModel tableModel = (PropertyTableModel)table.getModel();
        Class<?> parentClassz = null;
        Object parent = null;
        if (tableModel.getParentTarget() != null) {
            parentClassz = tableModel.getParentTarget().getClass();
            parent = tableModel.getParentTarget();
        }
        Object value = tableModel.getValue();
        Class<?> targetClassz = tableModel.target.getClass();
        MondrianGuiDef.RelationOrJoin relation = null;
        if (targetClassz == MondrianGuiDef.Table.class) {
            relation = (MondrianGuiDef.Table)((Object)value);
        } else if (targetClassz == MondrianGuiDef.View.class) {
            relation = (MondrianGuiDef.View)((Object)value);
        } else if (targetClassz == MondrianGuiDef.Join.class) {
            relation = (MondrianGuiDef.Join)((Object)value);
        } else if (targetClassz == MondrianGuiDef.Hierarchy.class) {
            MondrianGuiDef.Hierarchy hProps = (MondrianGuiDef.Hierarchy)((Object)value);
            relation = hProps != null ? hProps.relation : null;
        } else if (targetClassz == MondrianGuiDef.Level.class) {
            MondrianGuiDef.Hierarchy hProps = (MondrianGuiDef.Hierarchy)((Object)parent);
            relation = hProps != null ? hProps.relation : null;
        } else if (targetClassz == MondrianGuiDef.Cube.class) {
            MondrianGuiDef.Cube hProps = (MondrianGuiDef.Cube)((Object)value);
            relation = hProps != null ? hProps.fact : null;
        }
        return relation;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        boolean nonTableRelation;
        PropertyTableModel tableModel = (PropertyTableModel)table.getModel();
        Class<?> parentClassz = null;
        Object parent = null;
        if (tableModel.getParentTarget() != null) {
            parentClassz = tableModel.getParentTarget().getClass();
            parent = tableModel.getParentTarget();
        }
        Class<?> targetClassz = tableModel.target.getClass();
        String propertyName = tableModel.getRowName(row);
        TreePath path = tableModel.getPath();
        String selectedFactTable = tableModel.getFactTable();
        String selectedFactTableSchema = tableModel.getFactTableSchema();
        this.listEditorValue = null;
        this.stringEditor.setEditable(true);
        MondrianGuiDef.RelationOrJoin currentRelation = this.getRelation(table, row, column);
        boolean bl = nonTableRelation = currentRelation != null && !(currentRelation instanceof MondrianGuiDef.Table) && !(currentRelation instanceof MondrianGuiDef.Join);
        if (targetClassz == MondrianGuiDef.UserDefinedFunction.class && propertyName.equals("className")) {
            List<String> udfs = this.getUdfs();
            DefaultComboBoxModel<String> cAlludfs = new DefaultComboBoxModel<String>(new Vector<String>(udfs));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAlludfs);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("formatString")) {
            List<String> formatStrs = this.getFormatStrings();
            DefaultComboBoxModel<String> cAllformatStrs = new DefaultComboBoxModel<String>(new Vector<String>(formatStrs));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllformatStrs);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("aggregator")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Measure._aggregator_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("datatype")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Measure._datatype_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Parameter.class && propertyName.equals("parameter")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Parameter._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.SQL.class && propertyName.equals("dialect")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.SQL._dialect_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("hideMemberIf")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._hideMemberIf_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("levelType")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._levelType_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Level._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Dimension.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Dimension._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.DimensionUsage.class && propertyName.equals("source")) {
            List<String> source = this.getSource();
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if ((tableModel.target instanceof MondrianGuiDef.Grant || tableModel.target instanceof MondrianGuiDef.MemberGrant) && propertyName.equals("access")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            DefaultComboBoxModel<String> cAccess = new DefaultComboBoxModel<String>(MondrianGuiDef.Grant._access_values);
            if (targetClassz == MondrianGuiDef.SchemaGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "none", "all_dimensions"});
            } else if (targetClassz == MondrianGuiDef.CubeGrant.class || targetClassz == MondrianGuiDef.DimensionGrant.class || targetClassz == MondrianGuiDef.MemberGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "none"});
            } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class) {
                cAccess = new DefaultComboBoxModel<String>(new String[]{"all", "none", "custom"});
            }
            this.listEditor.setModel(cAccess);
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.DimensionGrant.class && propertyName.equals("dimension") || targetClassz == MondrianGuiDef.HierarchyGrant.class && propertyName.equals("hierarchy")) {
            List<String> source = this.getDimensionsForHierarchyGrant(true);
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class && (propertyName.equals("topLevel") || propertyName.equals("bottomLevel"))) {
            List<String> source = this.getLevels(((MondrianGuiDef.HierarchyGrant)((Object)tableModel.target)).hierarchy);
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.HierarchyGrant.class && propertyName.equals("rollupPolicy")) {
            MondrianGuiDef.HierarchyGrant grant = (MondrianGuiDef.HierarchyGrant)((Object)tableModel.target);
            String[] rollupPolicies = new String[]{"", "full", "partial", "hidden"};
            DefaultComboBoxModel<String> cRollupPolicies = new DefaultComboBoxModel<String>(new Vector<String>(Arrays.asList(rollupPolicies)));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cRollupPolicies);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.RoleUsage.class && propertyName.equals("roleName")) {
            List<String> source = this.getRoles();
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(source.toArray(new String[0])));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.CalculatedMemberProperty.class && propertyName.equals("name")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            TreeSet<String> calcMemberPropertyNames = new TreeSet<String>();
            for (String name : Property.enumeration.getNames()) {
                Property prop = Property.lookup((String)name, (boolean)false);
                if (prop == null || prop.isInternal()) continue;
                calcMemberPropertyNames.add(name);
            }
            this.listEditor.setModel(new DefaultComboBoxModel<String>(calcMemberPropertyNames.toArray(new String[0])));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.CalculatedMember.class && propertyName.equals("dimension")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            List<String> calcMemberDimensions = this.getDimensionsFromParentCube(false);
            calcMemberDimensions.add(0, "Measures");
            this.listEditor.setModel(new DefaultComboBoxModel<String>(calcMemberDimensions.toArray(new String[0])));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if ((targetClassz == MondrianGuiDef.VirtualCubeDimension.class || targetClassz == MondrianGuiDef.VirtualCubeMeasure.class) && propertyName.equals("cubeName") || targetClassz == MondrianGuiDef.CubeGrant.class && propertyName.equals("cube")) {
            List<String> source = this.getCubes();
            DefaultComboBoxModel<String> cAllsource = new DefaultComboBoxModel<String>(new Vector<String>(source));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllsource);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Dimension.class && propertyName.equals("foreignKey") || targetClassz == MondrianGuiDef.DimensionUsage.class && propertyName.equals("foreignKey") || targetClassz == MondrianGuiDef.Measure.class && propertyName.equals("column")) {
            Vector<String> fks = new Vector<String>(this.jdbcMetadata.getFactTableFKs(selectedFactTableSchema, selectedFactTable));
            fks.add(0, this.getResourceConverter().getString("schemaPropertyCellEditor.allColumns", "<< All Columns >>"));
            Vector<String> allcols = new Vector<String>(this.jdbcMetadata.getAllColumns(selectedFactTableSchema, selectedFactTable));
            DefaultComboBoxModel<String> cFks = new DefaultComboBoxModel<String>(fks);
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            if (fks.size() > 1 && propertyName.equals("foreignKey")) {
                allcols.add(0, this.getResourceConverter().getString("schemaPropertyCellEditor.foreignKeys", "<< Foreign keys >>"));
                DefaultComboBoxModel<String> cAllcols = new DefaultComboBoxModel<String>(allcols);
                this.listEditor.setModel(cFks);
                this.selOptions = cFks;
                this.allOptions = cAllcols;
                this.listEditor.addActionListener(this.al);
            } else {
                DefaultComboBoxModel<String> cAllcols = new DefaultComboBoxModel<String>(allcols);
                this.listEditor.setModel(cAllcols);
            }
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKey")) {
            List<Object> allcols;
            MondrianGuiDef.Hierarchy hProps = (MondrianGuiDef.Hierarchy)((Object)tableModel.target);
            String pkTable = hProps.primaryKeyTable;
            String schemaName = null;
            String pk = "";
            MondrianGuiDef.RelationOrJoin relation = hProps.relation;
            if (relation instanceof MondrianGuiDef.Table) {
                pkTable = ((MondrianGuiDef.Table)relation).name;
                schemaName = ((MondrianGuiDef.Table)relation).schema;
                pk = this.jdbcMetadata.getTablePK(schemaName, pkTable);
            } else if (relation instanceof MondrianGuiDef.Join) {
                String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(hProps.relation, pkTable);
                schemaName = schemaAndTable[0];
                pkTable = schemaAndTable[1];
            }
            if (relation instanceof MondrianGuiDef.Table || relation instanceof MondrianGuiDef.Join) {
                allcols = this.jdbcMetadata.getAllColumns(schemaName, pkTable);
                pk = this.jdbcMetadata.getTablePK(schemaName, pkTable);
            } else {
                allcols = Collections.emptyList();
            }
            DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(new Vector(allcols));
            if (relation instanceof MondrianGuiDef.InlineTable) {
                this.listEditor.setEditable(false);
            } else {
                this.listEditor.setEditable(true);
            }
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            if (value == null || ((String)value).equals("")) {
                this.listEditor.setSelectedItem(pk);
            } else {
                this.listEditor.setSelectedItem((String)value);
                this.listEditorValue = (String)value;
            }
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("nameColumn") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("parentColumn") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("ordinalColumn") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("captionColumn") || targetClassz == MondrianGuiDef.Closure.class && propertyName.equals("parentColumn") || targetClassz == MondrianGuiDef.Closure.class && propertyName.equals("childColumn") || targetClassz == MondrianGuiDef.AggForeignKey.class && propertyName.equals("factColumn") || targetClassz == MondrianGuiDef.Value.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.Property.class && propertyName.equals("column")) {
            MondrianGuiDef.RelationOrJoin relation = null;
            if (targetClassz == MondrianGuiDef.Level.class || targetClassz == MondrianGuiDef.Property.class) {
                ParentInPath parentHierarchy = ParentInPath.getParentInPath(path, MondrianGuiDef.Hierarchy.class);
                if (parentHierarchy.parent == null) {
                    throw new IllegalArgumentException("");
                }
                relation = ((MondrianGuiDef.Hierarchy)((Object)parentHierarchy.parent)).relation;
                ParentInPath parentCube = ParentInPath.getParentInPath(path, MondrianGuiDef.Cube.class);
                if (parentCube.parent != null && relation == null) {
                    relation = ((MondrianGuiDef.Cube)((Object)parentCube.parent)).fact;
                }
            } else if (targetClassz == MondrianGuiDef.Closure.class) {
                relation = ((MondrianGuiDef.Closure)((Object)tableModel.target)).table;
            } else if (targetClassz == MondrianGuiDef.AggForeignKey.class) {
                ParentInPath parentCube = ParentInPath.getParentInPath(path, MondrianGuiDef.Cube.class);
                if (parentCube.parent != null && relation == null) {
                    relation = ((MondrianGuiDef.Cube)((Object)parentCube.parent)).fact;
                }
            } else if (targetClassz == MondrianGuiDef.Value.class) {
                ParentInPath parentInline = ParentInPath.getParentInPath(path, MondrianGuiDef.InlineTable.class);
                if (parentInline.parent == null) {
                    throw new IllegalArgumentException("");
                }
                relation = (MondrianGuiDef.InlineTable)((Object)parentInline.parent);
            }
            List<Object> allcols = Collections.emptyList();
            boolean columnsInSelection = false;
            if (relation instanceof MondrianGuiDef.Table) {
                String lTable = relation.name;
                String schemaName = relation.schema;
                if (lTable != null) {
                    allcols = this.jdbcMetadata.getAllColumns(schemaName, lTable);
                    columnsInSelection = true;
                }
            } else if (relation instanceof MondrianGuiDef.Join) {
                TreeSet<String> joinTables = new TreeSet<String>();
                if (tableModel.target instanceof MondrianGuiDef.Level) {
                    MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)tableModel.target);
                    if (level.table != null) {
                        joinTables.add(level.table);
                    }
                }
                if (joinTables.isEmpty()) {
                    SchemaExplorer.getTableNamesForJoin(relation, joinTables);
                }
                allcols = new ArrayList();
                for (String tableName : joinTables) {
                    String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(relation, tableName);
                    String string = schemaAndTable[0];
                    String lTable = schemaAndTable[1];
                    allcols.addAll(this.jdbcMetadata.getAllColumns(string, lTable));
                }
                columnsInSelection = true;
            } else if (relation instanceof MondrianGuiDef.InlineTable) {
                MondrianGuiDef.InlineTable inline = (MondrianGuiDef.InlineTable)relation;
                allcols = new ArrayList();
                for (MondrianGuiDef.ColumnDef columnDef : inline.columnDefs.array) {
                    allcols.add(columnDef.name);
                }
            }
            DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(new Vector(allcols));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            String valueString = (String)value;
            if (columnsInSelection) {
                String selectedItem = null;
                for (String string : allcols) {
                    String[] columnParts = string.split("->");
                    String columnName = columnParts[columnParts.length - 1].split(" - ")[0];
                    if (!columnName.equals(valueString)) continue;
                    selectedItem = string;
                    break;
                }
                this.listEditor.setSelectedItem(selectedItem);
            } else {
                this.listEditor.setSelectedItem(valueString);
            }
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Property.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.Property._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.ColumnDef.class && propertyName.equals("type")) {
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(new DefaultComboBoxModel<String>(MondrianGuiDef.ColumnDef._type_values));
            this.listEditor.setSelectedItem((String)value);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.AggFactCount.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggIgnoreColumn.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggLevel.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggMeasure.class && propertyName.equals("column") || targetClassz == MondrianGuiDef.AggForeignKey.class && propertyName.equals("factColumn") || targetClassz == MondrianGuiDef.AggForeignKey.class && propertyName.equals("aggColumn")) {
            MondrianGuiDef.AggName aggNameProps = (MondrianGuiDef.AggName)((Object)parent);
            String aggTableName = aggNameProps.name;
            List<Object> allcols = aggTableName != null ? this.jdbcMetadata.getAllColumns(selectedFactTableSchema, aggTableName) : Collections.emptyList();
            DefaultComboBoxModel cAllcols = new DefaultComboBoxModel(new Vector(allcols));
            this.listEditor.setEditable(false);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            String selectedItem = null;
            String valueString = (String)value;
            for (String string : allcols) {
                String[] columnParts = string.split("->");
                String columnName = columnParts[columnParts.length - 1].split(" - ")[0];
                if (!columnName.equals(valueString)) continue;
                selectedItem = string;
                break;
            }
            this.listEditor.setSelectedItem(selectedItem);
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Join.class && propertyName.equals("leftAlias") || targetClassz == MondrianGuiDef.Join.class && propertyName.equals("rightAlias")) {
            TreeSet<String> joinAliasesSet = new TreeSet<String>();
            SchemaExplorer.getTableNamesForJoin(currentRelation, joinAliasesSet);
            DefaultComboBoxModel<String> cAliases = new DefaultComboBoxModel<String>(new Vector<String>(joinAliasesSet));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAliases);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Join.class && propertyName.equals("leftKey") || targetClassz == MondrianGuiDef.Join.class && propertyName.equals("rightKey")) {
            MondrianGuiDef.Join join = (MondrianGuiDef.Join)currentRelation;
            MondrianGuiDef.RelationOrJoin leftOrRight = propertyName.equals("leftKey") ? join.left : join.right;
            String schemaName = null;
            String lTable = null;
            if (leftOrRight instanceof MondrianGuiDef.Table) {
                lTable = ((MondrianGuiDef.Table)leftOrRight).name;
                schemaName = ((MondrianGuiDef.Table)leftOrRight).schema;
            } else if (leftOrRight instanceof MondrianGuiDef.Join) {
                String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(leftOrRight, "");
                schemaName = schemaAndTable[0];
                lTable = schemaAndTable[1];
            }
            List<String> allcols = null;
            if (lTable != null) {
                allcols = this.jdbcMetadata.getAllColumns(schemaName, lTable);
            }
            DefaultComboBoxModel<String> cAllcols = new DefaultComboBoxModel<String>(new Vector<String>(allcols));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllcols);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if (targetClassz == MondrianGuiDef.Table.class && propertyName.equals("schema")) {
            List<String> allschemas = this.jdbcMetadata.getAllSchemas();
            DefaultComboBoxModel<String> cAllschemas = new DefaultComboBoxModel<String>(new Vector<String>(allschemas));
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllschemas);
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
        } else if ((targetClassz == MondrianGuiDef.CubeDimension.class || targetClassz == MondrianGuiDef.DimensionUsage.class || targetClassz == MondrianGuiDef.VirtualCubeDimension.class) && propertyName.equals("highCardinality")) {
            this.activeEditor = this.booleanEditor;
            this.booleanEditor.setSelected((Boolean)value);
        } else if (currentRelation != null && nonTableRelation && (targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKeyTable") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("table"))) {
            this.stringEditor.setEditable(false);
            this.stringEditor.setToolTipText(null);
            this.stringEditor.removeActionListener(this.al);
            this.stringEditor.setText("");
            this.activeEditor = this.stringEditor;
        } else if (parent != null && currentRelation instanceof MondrianGuiDef.Table && (targetClassz == MondrianGuiDef.Level.class && propertyName.equals("table") || targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKeyTable"))) {
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (targetClassz == MondrianGuiDef.Table.class && propertyName.equals("name") || targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals("primaryKeyTable") || targetClassz == MondrianGuiDef.Level.class && propertyName.equals("table") || targetClassz == MondrianGuiDef.AggName.class && propertyName.equals("name") || targetClassz == MondrianGuiDef.AggExclude.class && propertyName.equals("name")) {
            String schema = "";
            if (targetClassz == MondrianGuiDef.Table.class) {
                MondrianGuiDef.Table tProps = (MondrianGuiDef.Table)((Object)tableModel.target);
                schema = tProps.schema;
            } else if (targetClassz == MondrianGuiDef.AggName.class || targetClassz == MondrianGuiDef.AggExclude.class) {
                schema = tableModel.getFactTableSchema();
            }
            Vector<String> factTables = new Vector<String>(this.jdbcMetadata.getFactTables(schema));
            Vector<String> allTablesMinusFact = new Vector<String>(this.jdbcMetadata.getAllTables(schema, selectedFactTable));
            Vector<String> allTables = new Vector<String>(this.jdbcMetadata.getAllTables(schema));
            Vector<String> dimeTables = new Vector<String>(this.jdbcMetadata.getDimensionTables(schema, selectedFactTable));
            DefaultComboBoxModel<String> cFactTables = new DefaultComboBoxModel<String>(factTables);
            DefaultComboBoxModel<String> cAllTables = new DefaultComboBoxModel<String>(allTablesMinusFact.size() > 0 ? allTablesMinusFact : allTables);
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(dimeTables);
            ParentInPath parentCube = ParentInPath.getParentInPath(path, MondrianGuiDef.Cube.class);
            if (targetClassz == MondrianGuiDef.Level.class || targetClassz == MondrianGuiDef.Hierarchy.class) {
                MondrianGuiDef.RelationOrJoin relation = null;
                ParentInPath parentHierarchy = ParentInPath.getParentInPath(path, MondrianGuiDef.Hierarchy.class);
                if (parentHierarchy.parent == null) {
                    throw new IllegalArgumentException("");
                }
                relation = ((MondrianGuiDef.Hierarchy)((Object)parentHierarchy.parent)).relation;
                if (parentCube.parent != null && relation == null) {
                    relation = ((MondrianGuiDef.Cube)((Object)parentCube.parent)).fact;
                }
                if (relation instanceof MondrianGuiDef.Join) {
                    TreeSet<String> joinTables = new TreeSet<String>();
                    SchemaExplorer.getTableNamesForJoin(relation, joinTables);
                    cAllTables = new DefaultComboBoxModel<String>(new Vector<String>(joinTables));
                }
            }
            this.listEditor.setEditable(true);
            this.listEditor.setToolTipText(null);
            this.listEditor.removeActionListener(this.al);
            this.listEditor.setModel(cAllTables);
            this.allOptions = cAllTables;
            boolean toggleModel = false;
            if (parentCube.parent != null) {
                this.allOptions = cAllTables = new DefaultComboBoxModel<String>(allTables);
                if (factTables.size() > 0) {
                    cFactTables.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.allTables", "<< All Tables >>"), 0);
                    cAllTables.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.factTables", "<< Fact Tables >>"), 0);
                    this.listEditor.setModel(cFactTables);
                    this.selOptions = cFactTables;
                    toggleModel = true;
                }
            } else if (dimeTables.size() > 0) {
                defaultComboBoxModel.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.allTables", "<< All Tables >>"), 0);
                cAllTables.insertElementAt(this.workbench.getResourceConverter().getString("schemaPropertyCellEditor.dimensionTables", "<< Dimension Tables >>"), 0);
                this.listEditor.setModel(defaultComboBoxModel);
                this.selOptions = defaultComboBoxModel;
                toggleModel = true;
            }
            if (toggleModel) {
                this.listEditor.addActionListener(this.al);
            }
            this.listEditor.setSelectedItem((String)value);
            this.listEditorValue = (String)value;
            this.activeEditor = this.listEditor;
            if (targetClassz == MondrianGuiDef.Level.class && propertyName.equals(SchemaExplorer.DEF_LEVEL[1]) && parent != null || targetClassz == MondrianGuiDef.Hierarchy.class && propertyName.equals(SchemaExplorer.DEF_HIERARCHY[7]) && parent != null) {
                MondrianGuiDef.RelationOrJoin relation = null;
                if (parent instanceof MondrianGuiDef.Hierarchy) {
                    relation = ((MondrianGuiDef.Hierarchy)((Object)parent)).relation;
                } else if (parent instanceof MondrianGuiDef.Dimension) {
                    relation = ((MondrianGuiDef.Hierarchy)((Object)tableModel.target)).relation;
                }
                if (relation instanceof MondrianGuiDef.Table) {
                    this.activeEditor = this.stringEditor;
                    this.stringEditor.setText((String)value);
                }
            }
        } else if (propertyName.equals("cdata") || targetClassz == MondrianGuiDef.CalculatedMemberProperty.class && (propertyName.equals("expression") || propertyName.equals("value"))) {
            try {
                this.cdataTextArea.read(new StringReader((String)value), null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.activeEditor = this.jScrollPaneCDATA;
        } else if (value instanceof String) {
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value instanceof Boolean) {
            this.activeEditor = this.booleanEditor;
            this.booleanEditor.setSelected((Boolean)value);
        } else if (value instanceof Integer) {
            this.activeEditor = this.integerEditor;
            this.integerEditor.setText((String)value);
        } else if (value == null) {
            value = "";
            this.activeEditor = this.stringEditor;
            this.stringEditor.setText((String)value);
        } else if (value.getClass() == MondrianGuiDef.Join.class) {
            SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
            this.tableEditor.setDefaultEditor(Object.class, spce);
            SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
            this.tableEditor.setDefaultRenderer(Object.class, spcr);
            PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_JOIN);
            this.tableEditor.setModel(ptm);
            this.activeEditor = this.tableEditor;
        } else {
            if (value.getClass() == MondrianGuiDef.NameExpression.class) {
                return null;
            }
            if (value.getClass() == MondrianGuiDef.RelationOrJoin.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_RELATION);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
                return null;
            }
            if (value.getClass() == MondrianGuiDef.OrdinalExpression.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, (Object)((MondrianGuiDef.OrdinalExpression)((Object)value)).expressions[0], path, SchemaExplorer.DEF_SQL);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Formula.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetadata);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_FORMULA);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.CalculatedMemberProperty.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetadata);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_CALCULATED_MEMBER_PROPERTY);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Table.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetadata);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener(this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_TABLE);
                ptm.setFactTable(selectedFactTable);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.AggFactCount.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetadata);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener(this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_AGG_FACT_COUNT);
                ptm.setFactTable(selectedFactTable);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Closure.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench, this.jdbcMetadata);
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    spce.addCellEditorListener(this.listeners.get(i));
                }
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_CLOSURE);
                ptm.setFactTable(selectedFactTable);
                this.tableEditor.setModel(ptm);
                this.tableEditor.getColumnModel().getColumn(0).setMaxWidth(100);
                this.tableEditor.getColumnModel().getColumn(0).setMinWidth(100);
                spcr.setTableRendererHeight(this.tableEditor, null);
                this.activeEditor = this.tableEditor;
            } else if (value.getClass() == MondrianGuiDef.Property.class) {
                SchemaPropertyCellEditor spce = new SchemaPropertyCellEditor(this.workbench);
                this.tableEditor.setDefaultEditor(Object.class, spce);
                SchemaPropertyCellRenderer spcr = new SchemaPropertyCellRenderer(this.workbench);
                this.tableEditor.setDefaultRenderer(Object.class, spcr);
                PropertyTableModel ptm = new PropertyTableModel(this.workbench, value, path, SchemaExplorer.DEF_PROPERTY);
                this.tableEditor.setModel(ptm);
                this.activeEditor = this.tableEditor;
            } else {
                value = "";
                this.activeEditor = this.stringEditor;
                this.stringEditor.setText((String)value);
            }
        }
        this.activeEditor.setVisible(true);
        this.setOriginalValue();
        table.changeSelection(row, column, false, false);
        this.activeEditor.setBackground(new Color(224, 249, 255));
        this.activeEditor.requestFocusInWindow();
        return this.activeEditor;
    }

    private void setOriginalValue() {
        if (this.activeEditor == this.stringEditor) {
            this.originalValue = this.stringEditor.getText();
        } else if (this.activeEditor == this.booleanEditor) {
            this.originalValue = this.booleanEditor.isSelected();
        } else if (this.activeEditor == this.listEditor) {
            if (this.listEditor.isEditable()) {
                this.originalValue = this.listEditor.getEditor().getItem();
            } else {
                if (this.listEditor.getSelectedItem() == this.noSelect) {
                    this.originalValue = null;
                }
                this.originalValue = this.listEditor.getSelectedItem();
            }
        } else if (this.activeEditor == this.tableEditor) {
            this.originalValue = ((PropertyTableModel)this.tableEditor.getModel()).getValue();
        } else if (this.activeEditor == this.jScrollPaneCDATA) {
            StringWriter cdataTextAreaStr = new StringWriter();
            try {
                this.cdataTextArea.write(cdataTextAreaStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.originalValue = ((Object)cdataTextAreaStr).toString();
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelCellEditing() {
        if (this.activeEditor != null) {
            this.activeEditor.setVisible(false);
            this.fireEditingCancelled();
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.activeEditor == this.stringEditor) {
            return this.stringEditor.getText();
        }
        if (this.activeEditor == this.booleanEditor) {
            return this.booleanEditor.isSelected();
        }
        if (this.activeEditor == this.listEditor) {
            if (this.listEditor.isEditable()) {
                return this.listEditor.getEditor().getItem();
            }
            if (this.listEditor.getSelectedItem() == this.noSelect) {
                return null;
            }
            return this.listEditor.getSelectedItem();
        }
        if (this.activeEditor == this.tableEditor) {
            return ((PropertyTableModel)this.tableEditor.getModel()).getValue();
        }
        if (this.activeEditor == this.jScrollPaneCDATA) {
            StringWriter cdataTextAreaStr = new StringWriter();
            try {
                this.cdataTextArea.write(cdataTextAreaStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ((Object)cdataTextAreaStr).toString();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.activeEditor != null) {
            if (this.activeEditor == this.tableEditor && this.tableEditor.isEditing()) {
                ArrayList<JTable> nestedTableEditors = new ArrayList<JTable>();
                JTable nestedTableEditor = this.tableEditor;
                while (nestedTableEditor != null) {
                    nestedTableEditors.add(nestedTableEditor);
                    SchemaPropertyCellEditor sce = (SchemaPropertyCellEditor)nestedTableEditor.getCellEditor();
                    if (sce != null && sce.activeEditor == sce.tableEditor && sce.tableEditor.isEditing()) {
                        nestedTableEditor = sce.tableEditor;
                        continue;
                    }
                    nestedTableEditor = null;
                }
                for (int i = nestedTableEditors.size() - 1; i >= 0; --i) {
                    ((JTable)nestedTableEditors.get(i)).editingStopped(null);
                }
            }
            this.activeEditor.setVisible(false);
            this.fireEditingStopped();
        }
        return true;
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).editingStopped(ce);
        }
    }

    protected void fireEditingCancelled() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).editingCanceled(ce);
        }
    }

    private List<String> getUdfs() {
        ArrayList<String> udfs = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return udfs;
        }
        for (MondrianGuiDef.UserDefinedFunction u : s.userDefinedFunctions) {
            if (u.className == null || udfs.contains(u.className)) continue;
            udfs.add(u.className);
        }
        return udfs;
    }

    private List<String> getFormatStrings() {
        ArrayList<String> fs = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return fs;
        }
        for (MondrianGuiDef.Cube cube : s.cubes) {
            for (MondrianGuiDef.Measure m : cube.measures) {
                if (m.formatString == null || fs.contains(m.formatString)) continue;
                fs.add(m.formatString);
            }
        }
        return fs;
    }

    private MondrianGuiDef.Schema getSchema() {
        SchemaExplorer se = this.getSchemaExplorer();
        return se == null ? null : se.getSchema();
    }

    private Object getParentObject() {
        SchemaExplorer se = this.getSchemaExplorer();
        if (se != null) {
            return se.getParentObject();
        }
        return null;
    }

    private Object getCurrentObject() {
        SchemaExplorer se = this.getSchemaExplorer();
        if (se != null) {
            return se.getCurrentObject();
        }
        return null;
    }

    private TreePath getCurrentPath() {
        SchemaExplorer se = this.getSchemaExplorer();
        if (se != null) {
            return se.getCurrentPath();
        }
        return null;
    }

    private SchemaExplorer getSchemaExplorer() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            CellEditorListener cel = this.listeners.get(i);
            if (!(cel instanceof SchemaExplorer)) continue;
            return (SchemaExplorer)cel;
        }
        return null;
    }

    private List<String> getSource() {
        ArrayList<String> source = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return source;
        }
        for (MondrianGuiDef.Dimension u : s.dimensions) {
            source.add(u.name);
        }
        return source;
    }

    private List<String> getCubes() {
        ArrayList<String> source = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return source;
        }
        for (MondrianGuiDef.Cube u : s.cubes) {
            source.add(u.name);
        }
        return source;
    }

    private List<String> getRoles() {
        ArrayList<String> source = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return source;
        }
        for (MondrianGuiDef.Role u : s.roles) {
            if (u.union != null) continue;
            source.add(u.name);
        }
        return source;
    }

    private void generatePrimaryKeyTables(Object relation, List<String> v) {
        if (relation == null) {
            return;
        }
        if (relation instanceof MondrianGuiDef.Table) {
            String sname = ((MondrianGuiDef.Table)((Object)relation)).schema;
            v.add((sname == null || sname.equals("") ? "" : sname + "->") + ((MondrianGuiDef.Table)((Object)relation)).name);
            return;
        }
        MondrianGuiDef.Join currentJoin = (MondrianGuiDef.Join)((Object)relation);
        this.generatePrimaryKeyTables((Object)currentJoin.left, v);
        this.generatePrimaryKeyTables((Object)currentJoin.right, v);
    }

    private List<String> getDimensionsForHierarchyGrant(boolean parens) {
        ArrayList<String> dims = new ArrayList<String>();
        ParentInPath cubeGrant = ParentInPath.getParentInPath(this.getCurrentPath(), MondrianGuiDef.CubeGrant.class);
        if (cubeGrant.parent == null || cubeGrant.parent.getClass() != MondrianGuiDef.CubeGrant.class) {
            return dims;
        }
        MondrianGuiDef.CubeGrant parent = (MondrianGuiDef.CubeGrant)((Object)cubeGrant.parent);
        if (parent.cube == null || parent.cube.equals("")) {
            return dims;
        }
        return this.getDimensionsForCube(parent.cube, parens);
    }

    private List<String> getDimensionsForCube(String cubeName, boolean parens) {
        ArrayList<String> dims = new ArrayList<String>();
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return dims;
        }
        for (MondrianGuiDef.Cube cube : s.cubes) {
            if (!cube.name.equals(cubeName)) continue;
            for (MondrianGuiDef.CubeDimension dimension : cube.dimensions) {
                if (parens) {
                    dims.add("[" + dimension.name + "]");
                    continue;
                }
                dims.add(dimension.name);
            }
            break;
        }
        return dims;
    }

    private List<String> getDimensionsFromParentCube(boolean parens) {
        ArrayList<String> dims = new ArrayList<String>();
        ParentInPath cube = ParentInPath.getParentInPath(this.getCurrentPath(), MondrianGuiDef.Cube.class);
        if (cube.parent == null || cube.parent.getClass() != MondrianGuiDef.Cube.class) {
            return dims;
        }
        MondrianGuiDef.Cube parent = (MondrianGuiDef.Cube)((Object)cube.parent);
        if (parent.name == null || parent.name.equals("")) {
            return dims;
        }
        return this.getDimensionsForCube(parent.name, parens);
    }

    private List<String> getLevels(String hierarchy) {
        if (hierarchy == null || hierarchy.equals("")) {
            return this.hlevels;
        }
        MondrianGuiDef.Schema s = this.getSchema();
        if (s == null) {
            return this.hlevels;
        }
        Object po = this.getParentObject();
        if (po == null) {
            return this.hlevels;
        }
        MondrianGuiDef.CubeGrant parent = (MondrianGuiDef.CubeGrant)((Object)po);
        if (parent.cube == null || parent.cube.equals("")) {
            return this.hlevels;
        }
        String hierarchySearchName = hierarchy;
        if (hierarchy.startsWith("[") && hierarchy.endsWith("]")) {
            hierarchySearchName = hierarchy.substring(1, hierarchy.length() - 1);
        } else {
            hierarchy = "[" + hierarchy + "]";
        }
        if (this.cacheCube.equals(parent.cube) && this.cacheHierarchy.equals(hierarchySearchName)) {
            return this.hlevels;
        }
        this.hlevels = new ArrayList<String>();
        this.cacheCube = parent.cube;
        this.cacheHierarchy = hierarchySearchName;
        block0: for (MondrianGuiDef.Cube cube : s.cubes) {
            if (!cube.name.equals(this.cacheCube)) continue;
            for (MondrianGuiDef.CubeDimension dimension : cube.dimensions) {
                if (!dimension.name.equals(hierarchySearchName)) continue;
                MondrianGuiDef.Dimension d = SchemaPropertyCellEditor.lookupDimension(s, dimension);
                if (d == null || d.hierarchies == null || d.hierarchies.length == 0) break block0;
                for (MondrianGuiDef.Level level : d.hierarchies[0].levels) {
                    this.hlevels.add(hierarchy + ".[" + level.name + "]");
                }
                break block0;
            }
            break;
        }
        return this.hlevels;
    }

    private static MondrianGuiDef.Dimension lookupDimension(MondrianGuiDef.Schema schema, MondrianGuiDef.CubeDimension cubeDimension) {
        if (cubeDimension instanceof MondrianGuiDef.Dimension) {
            return (MondrianGuiDef.Dimension)cubeDimension;
        }
        MondrianGuiDef.DimensionUsage dimensionUsage = (MondrianGuiDef.DimensionUsage)cubeDimension;
        for (MondrianGuiDef.Dimension dimension : schema.dimensions) {
            if (!dimension.name.equals(dimensionUsage.source)) continue;
            return dimension;
        }
        return null;
    }

    private I18n getResourceConverter() {
        return this.workbench.getResourceConverter();
    }

    public void setJdbcMetaData(JdbcMetaData jdbcMetaData) {
        this.jdbcMetadata = jdbcMetaData;
    }
}

