/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultEditorKit;
import mondrian.gui.I18n;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.Workbench;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import org.apache.log4j.Logger;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.XOMUtil;
import org.olap4j.Axis;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.transform.AxisTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdxQuery
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(MdxQuery.class);
    Workbench.OlapConnectionHolder connection;
    JMenuItem queryMenuItem;
    int windowMenuIndex;
    Map<JInternalFrame, JMenuItem> schemaWindowMap;
    final Workbench workbench;
    SchemaExplorer schemaExplorer = null;
    File currentFile = null;
    private MondrianGuiDef.Schema schema;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane;
    private JScrollPane jScrollPane1;
    private JTextPane queryTextPane;
    private JSplitPane jSplitPane1;
    private JButton executeButton;
    private JComboBox schemaList;
    private JLabel schemaLabel;
    private JPanel schemaPanel;
    private JPanel queryPanel;
    private JPanel topPanel;
    private JButton connectButton;
    private JPopupMenu jPopupMenu;
    private JToolBar jToolBar1;
    private JButton toolbarOpenButton;
    private JButton toolbarSaveButton;
    private JButton toolbarSaveAsButton;
    private JButton toolbarGenerateMDXButton;

    public MdxQuery(Workbench workbench) {
        this.workbench = workbench;
        this.initComponents();
    }

    public MdxQuery(Workbench workbench, SchemaExplorer se) {
        this.workbench = workbench;
        this.schemaExplorer = se;
        this.initComponents();
    }

    public void setConnection(Workbench.OlapConnectionHolder c) {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
        this.connection = c;
    }

    public Workbench.OlapConnectionHolder getConnection() {
        return this.connection;
    }

    public void setMenuItem(JMenuItem mi) {
        this.queryMenuItem = mi;
    }

    public void setSchemaWindowMap(Map<JInternalFrame, JMenuItem> schemaWindowMap) {
        this.schemaWindowMap = schemaWindowMap;
        this.setCatalogs();
    }

    private void setCatalogs() {
        ArrayList<String> v = new ArrayList<String>();
        for (JMenuItem elem : this.schemaWindowMap.values()) {
            v.add(elem.getText());
        }
        DefaultComboBoxModel cCatalogs = new DefaultComboBoxModel(new Vector(v));
        this.schemaList.setModel(cCatalogs);
    }

    public void setWindowMenuIndex(int i) {
        this.windowMenuIndex = i;
    }

    public I18n getResourceConverter() {
        return this.workbench.getResourceConverter();
    }

    public MondrianGuiDef.Schema getSchema() {
        return this.schema;
    }

    public void setSchema(MondrianGuiDef.Schema schema) {
        this.schema = schema;
    }

    public boolean setSchema(File schemaFile) {
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            this.setSchema(new MondrianGuiDef.Schema(xmlParser.parse(schemaFile.toURL())));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public void initConnection(String smenutext) {
        this.schemaList.setSelectedItem(smenutext);
        this.connectButtonActionPerformed(null);
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.queryTextPane = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTabbedPane = new JTabbedPane();
        this.jToolBar1 = new JToolBar();
        this.toolbarOpenButton = new JButton();
        this.toolbarSaveButton = new JButton();
        this.toolbarSaveAsButton = new JButton();
        this.toolbarGenerateMDXButton = new JButton();
        this.connectButton = new JButton();
        this.executeButton = new JButton();
        this.jPopupMenu = new JPopupMenu();
        this.jPopupMenu.add(new DefaultEditorKit.CutAction());
        this.jPopupMenu.add(new DefaultEditorKit.CopyAction());
        this.jPopupMenu.add(new DefaultEditorKit.PasteAction());
        this.setLayout(new BorderLayout());
        this.toolbarOpenButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("open"))));
        this.toolbarOpenButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.open", "Open"));
        this.toolbarOpenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxQuery.this.openMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarOpenButton);
        this.toolbarSaveButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("save"))));
        this.toolbarSaveButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.save", "Save"));
        this.toolbarSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxQuery.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveButton);
        this.toolbarSaveAsButton.setIcon(new ImageIcon(this.getClass().getResource(this.getResourceConverter().getGUIReference("saveAs"))));
        this.toolbarSaveAsButton.setToolTipText(this.getResourceConverter().getString("workbench.toolbar.saveAs", "Save As"));
        this.toolbarSaveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxQuery.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveAsButton);
        this.toolbarGenerateMDXButton.setIcon(new ImageIcon(this.getClass().getResource("/" + this.getResourceConverter().getGUIReference("generateMdxQuery"))));
        this.toolbarGenerateMDXButton.setToolTipText(this.getResourceConverter().getString("queryPanel.generateMdxQuery.title", "Generate MDX Queries"));
        this.toolbarGenerateMDXButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxQuery.this.generateMDXMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarGenerateMDXButton);
        this.topPanel.setLayout(new FlowLayout(0));
        this.topPanel.add(this.jToolBar1);
        this.schemaPanel = new JPanel();
        this.schemaPanel.setLayout(new FlowLayout(0, 10, 0));
        this.schemaLabel = new JLabel();
        this.schemaLabel.setFont(new Font("Dialog", 1, 12));
        this.schemaLabel.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.schemaLabel.setHorizontalAlignment(0);
        this.schemaLabel.setText(this.getResourceConverter().getString("common.schema.title", "Schema"));
        this.schemaList = new JComboBox();
        this.schemaList.setBackground(Color.white);
        this.schemaList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.connectButton.setText(this.getResourceConverter().getString("queryPanel.connect.title", "Connect"));
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxQuery.this.connectButtonActionPerformed(evt);
            }
        });
        this.schemaPanel.add(this.schemaLabel);
        this.schemaPanel.add(this.schemaList);
        this.schemaPanel.add(this.connectButton);
        if (this.schemaExplorer == null) {
            this.topPanel.add(this.schemaPanel);
        }
        this.add((Component)this.topPanel, "North");
        this.queryPanel = new JPanel();
        this.queryPanel.setLayout(new BoxLayout(this.queryPanel, 1));
        this.queryTextPane.setFont(new Font("monospaced", 0, 12));
        this.queryTextPane.setText("");
        this.queryTextPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.checkPopupTrigger(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.checkPopupTrigger(e);
            }

            public void checkPopupTrigger(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int x = e.getX();
                    int y = e.getY();
                    MdxQuery.this.jPopupMenu.show(MdxQuery.this.queryTextPane, x, y);
                }
            }
        });
        this.jScrollPane1.setViewportView(this.queryTextPane);
        this.jScrollPane1.setAlignmentX(0.5f);
        this.queryPanel.add(this.jScrollPane1);
        this.executeButton.setText(this.getResourceConverter().getString("queryPanel.execute.title", "Execute"));
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxQuery.this.executeButtonActionPerformed(evt);
            }
        });
        this.executeButton.setAlignmentX(0.5f);
        this.queryPanel.add(this.executeButton);
        this.jScrollPane2.setViewportView(this.jTabbedPane);
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setTopComponent(this.queryPanel);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        if (this.connection == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.noConnection.alert", "No Mondrian connection. Select a Schema to connect."), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 2);
            return;
        }
        this.jTabbedPane.removeAll();
        String allQueryStr = this.queryTextPane.getText();
        if (allQueryStr == null || allQueryStr.length() == 0) {
            return;
        }
        String[] queryStrs = allQueryStr.split(";");
        if (queryStrs.length > 0) {
            int i = 0;
            for (String queryStr : queryStrs) {
                queryStr = queryStr.trim();
                StringBuffer sb = new StringBuffer();
                BufferedReader br = new BufferedReader(new StringReader(queryStr));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        sb.append(line).append(Util.nl);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if ((queryStr = sb.toString()).length() == 0) continue;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println(queryStr);
                pw.println();
                pw.println("----------------------------------");
                pw.println();
                try {
                    this.connection.printQuery(pw, queryStr);
                }
                catch (Exception ex) {
                    LOGGER.error((Object)queryStr, (Throwable)ex);
                    for (Throwable e = ex; e != null; e = e.getCause()) {
                        pw.println(e.getLocalizedMessage());
                        Exception prev = e;
                        if (e == prev) break;
                        pw.println();
                    }
                }
                pw.flush();
                JTextPane newPane = new JTextPane();
                newPane.setEditable(false);
                newPane.setFont(new Font("monospaced", 0, 12));
                newPane.setText(sw.getBuffer().toString());
                this.jTabbedPane.add("" + ++i, newPane);
            }
        }
        if (this.jTabbedPane.getTabCount() > 0) {
            this.jTabbedPane.setSelectedIndex(0);
        }
    }

    private void generateMDXMenuItemActionPerformed(ActionEvent evt) {
        int n;
        if (this.connection == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.noConnection.alert", "No Mondrian connection. Select a Schema to connect."), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            return;
        }
        if (this.queryTextPane.getText().trim().length() > 0 && (n = JOptionPane.showConfirmDialog(this, this.getResourceConverter().getString("queryPanel.overwriteQuery.alert", "There are already queries entered.\nDo you wish to overwrite them?"), this.getResourceConverter().getString("queryPanel.overwriteQuery.title", "Confirm Overwrite"), 0)) != 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (MondrianGuiDef.Cube cube : this.getSchema().cubes) {
            SelectNode query = new SelectNode(null, new ArrayList(), new ArrayList(), (ParseTreeNode)new IdentifierNode(new IdentifierNode.Segment[]{new IdentifierNode.NameSegment(cube.name)}), new AxisNode(null, false, (Axis)Axis.FILTER, new ArrayList(), null), new ArrayList());
            query.getAxisList().add(new AxisNode(null, false, (Axis)Axis.COLUMNS, new ArrayList(), (ParseTreeNode)new CallNode(null, "AllMembers", Syntax.Property, new ParseTreeNode[]{new IdentifierNode(new IdentifierNode.Segment[]{new IdentifierNode.NameSegment("Measures")})})));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)this.getQueryString((ParseTreeNode)query));
            }
            SelectNode shortQuery = null;
            HierarchizeTransform hierarchizeTransform = new HierarchizeTransform((Axis)Axis.ROWS);
            int i = 0;
            for (MondrianGuiDef.CubeDimension dim : cube.dimensions) {
                if (shortQuery == null) {
                    shortQuery = query.deepCopy();
                }
                shortQuery = this.addDimensionToQuery(shortQuery, dim);
                if (++i < 2) continue;
                shortQuery = hierarchizeTransform.apply(shortQuery);
                String mdx = this.getQueryString((ParseTreeNode)shortQuery);
                sb.append(mdx).append(";").append(Util.nl).append(Util.nl);
                i = 0;
                shortQuery = null;
            }
            if (shortQuery == null) continue;
            shortQuery = hierarchizeTransform.apply(shortQuery);
            String mdx = this.getQueryString((ParseTreeNode)shortQuery);
            sb.append(mdx).append(";").append(Util.nl).append(Util.nl);
        }
        this.queryTextPane.setText(sb.toString());
    }

    private String getQueryString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter(pw);
        node.unparse(parseTreeWriter);
        pw.flush();
        return sw.toString();
    }

    private SelectNode addDimensionToQuery(SelectNode query, MondrianGuiDef.CubeDimension dim) {
        SelectNode newQuery = query.deepCopy();
        String dimName = dim.name;
        MondrianGuiDef.Dimension monDimension = dim.getDimension(this.getSchema());
        String hierarchyName = dimName;
        MondrianGuiDef.Hierarchy selectedHierarchy = null;
        for (MondrianGuiDef.Hierarchy hierarchy : monDimension.hierarchies) {
            if (selectedHierarchy == null) {
                selectedHierarchy = hierarchy;
                continue;
            }
            if (hierarchy.name != null && hierarchy.name.length() != 0) continue;
            selectedHierarchy = hierarchy;
        }
        if (selectedHierarchy.name != null) {
            hierarchyName = hierarchyName + "." + selectedHierarchy.name;
        }
        CallNode newMember = null;
        ArrayList<IdentifierNode.NameSegment> args = new ArrayList<IdentifierNode.NameSegment>();
        args.add(new IdentifierNode.NameSegment(hierarchyName));
        if (selectedHierarchy.hasAll.booleanValue()) {
            if (selectedHierarchy.allMemberName != null && selectedHierarchy.allMemberName.length() > 0) {
                args.add(new IdentifierNode.NameSegment(selectedHierarchy.allMemberName));
            } else {
                args.add(new IdentifierNode.NameSegment("All " + hierarchyName + "s"));
            }
            newMember = new CallNode(null, "Children", Syntax.Property, new ParseTreeNode[]{new IdentifierNode(args)});
        } else {
            MondrianGuiDef.Level top = selectedHierarchy.levels[0];
            args.add(new IdentifierNode.NameSegment(top.name));
            newMember = new CallNode(null, "Members", Syntax.Property, new ParseTreeNode[]{new IdentifierNode(args)});
        }
        AxisNode currentColumnAxis = null;
        for (AxisNode an : newQuery.getAxisList()) {
            if (an.getAxis() != Axis.ROWS) continue;
            currentColumnAxis = an;
        }
        if (currentColumnAxis == null) {
            newQuery.getAxisList().add(new AxisNode(null, false, (Axis)Axis.ROWS, new ArrayList(), (ParseTreeNode)newMember));
        } else {
            CrossJoinTransform transform = new CrossJoinTransform((Axis)Axis.ROWS, (ParseTreeNode)newMember);
            newQuery = transform.apply(newQuery);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)hierarchyName);
            LOGGER.debug((Object)this.getQueryString((ParseTreeNode)newQuery));
        }
        return newQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMenuItemActionPerformed(ActionEvent evt) {
        int n;
        if (this.queryTextPane.getText().trim().length() > 0 && (n = JOptionPane.showConfirmDialog(this, this.getResourceConverter().getString("queryPanel.overwriteQuery.alert", "There are already queries entered.\nDo you wish to overwrite them?"), this.getResourceConverter().getString("queryPanel.overwriteQuery.title", "Confirm Overwrite"), 0)) != 0) {
            return;
        }
        JFileChooser jfc = new JFileChooser();
        try {
            jfc.setFileSelectionMode(0);
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".mdx") || pathname.isDirectory();
                }

                public String getDescription() {
                    return MdxQuery.this.getResourceConverter().getString("queryPanel.save.mdx.file.type", "MDX query files (*.mdx)");
                }
            });
            String lastUsed = this.workbench.getLastUsedUrl();
            if (lastUsed != null) {
                jfc.setCurrentDirectory(new File(new URI(lastUsed)));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Could not set file chooser", (Throwable)ex);
        }
        MondrianProperties.instance();
        if (jfc.showOpenDialog(this) != 0) {
            return;
        }
        this.currentFile = jfc.getSelectedFile();
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.currentFile);
            if (is == null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.read.file.stream.failure", "Could not read file stream: {0}.", this.currentFile.getAbsolutePath()), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 0);
                return;
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error((Object)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.read.file.exception", "Could not read file: {0}.\nException: {1}", this.currentFile.getAbsolutePath(), ex.getLocalizedMessage()), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 0);
            return;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int ch;
            while ((ch = ((InputStream)is).read()) > -1) {
                sb.append((char)ch);
            }
            this.queryTextPane.setText(sb.toString());
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.read.file.exception", "Could not read file: {0}.\nException: {1}", this.currentFile.getAbsolutePath(), ex.getLocalizedMessage()), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 0);
            return;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
            }
        }
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (this.currentFile == null || !this.currentFile.exists()) {
            this.saveAsMenuItemActionPerformed(evt);
            return;
        }
        this.saveQueryFile(this.currentFile, true);
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        try {
            jfc.setFileSelectionMode(0);
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".mdx") || pathname.isDirectory();
                }

                public String getDescription() {
                    return MdxQuery.this.getResourceConverter().getString("queryPanel.save.mdx.file.type", "MDX query files (*.mdx)");
                }
            });
            if (this.currentFile != null) {
                jfc.setSelectedFile(this.currentFile);
            } else {
                String lastUsed = this.workbench.getLastUsedUrl();
                if (lastUsed != null) {
                    jfc.setCurrentDirectory(new File(new URI(lastUsed)));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Could not set file chooser", (Throwable)ex);
        }
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        this.saveQueryFile(jfc.getSelectedFile(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveQueryFile(File aFile, boolean canOverwrite) {
        int n;
        if (this.queryTextPane.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.noQueryText.alert", "No queries are entered. Can't save"), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            return;
        }
        if (!aFile.getName().endsWith(".mdx")) {
            aFile = new File(aFile.getParent(), aFile.getName() + ".mdx");
        }
        if (aFile.exists() && !canOverwrite && (n = JOptionPane.showConfirmDialog(this, this.getResourceConverter().getFormattedString("queryPanel.overwriteQueryFile.alert", "There is already a file with this name: {0}.\nDo you wish to overwrite it?", aFile.getAbsolutePath()), this.getResourceConverter().getString("queryPanel.overwriteQuery.title", "Confirm Overwrite"), 0)) != 0) {
            return;
        }
        if (aFile.exists() && !aFile.canWrite()) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.save.file.not.writeable", "{0} is not writeable.", aFile.getAbsolutePath()), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 0);
            return;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(aFile);
            if (os == null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.save.file.create.failure", "Could not create file: {0}.", aFile.getAbsolutePath()), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 0);
                return;
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error((Object)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.save.file.create.exception", "Could not create file: {0}.\nException: {1}", aFile.getAbsolutePath(), ex.getLocalizedMessage()), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 0);
            return;
        }
        String str = this.queryTextPane.getText().trim();
        try {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                ((OutputStream)os).write(ch);
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.save.file.create.exception", "Could not create file: {0}.\nException: {1}", aFile.getAbsolutePath(), ex.getLocalizedMessage()), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 0);
            return;
        }
        finally {
            try {
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex);
            }
        }
        this.currentFile = aFile;
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        if (this.schemaExplorer == null) {
            this.connectButtonActionPerformedForFile(evt);
        } else {
            this.connectButtonActionPerformedForOpenSchema(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectButtonActionPerformedForOpenSchema(ActionEvent evt) {
        Container o;
        for (o = this; o != null && o.getClass() != JInternalFrame.class; o = o.getParent()) {
        }
        if (o == null) {
            return;
        }
        JInternalFrame jf = (JInternalFrame)o;
        if (this.schemaExplorer == null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.schemaNotOpen.alert", "Schema file is not open"), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            jf.dispose();
            return;
        }
        File sfile = this.schemaExplorer.createTempSchemaFile();
        if (sfile == null) {
            jf.dispose();
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Workbench.OlapConnectionHolder con = this.workbench.checkSchemaFile(sfile, this.workbench.getConnectionDetailsMap().get(this.schemaExplorer.getJdbcConnectionName()));
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (con != null && con.exception == null && this.setSchema(sfile)) {
                this.setConnection(con);
                this.queryMenuItem.setText(this.getResourceConverter().getFormattedString("queryPanel.successfulConnection.menuItem", "{0} MDX - {1}", Integer.toString(this.windowMenuIndex), this.schemaExplorer.getSchema().name));
                for (o = this; o != null; o = o.getParent()) {
                    if (o.getClass() != JInternalFrame.class) continue;
                    ((JInternalFrame)o).setTitle(this.getResourceConverter().getFormattedString("queryPanel.successfulConnection.internalFrame.title", "MDX Query - connected to {0} with connection {1}", this.schemaExplorer.getSchema().name, this.schemaExplorer.getJdbcConnectionName()));
                    break;
                }
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.successfulConnection.alert", "Mondrian connection Successful."), this.getResourceConverter().getString("common.informationDialog.title", "Information"), 1);
            } else {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.alert", "Mondrian connection could not be done for - {0}\n{1}", this.schemaExplorer.getSchema().name, con.exception == null ? "null connection" : con.exception.getLocalizedMessage()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.exception", "Mondrian connection could not be done for - {0}\n{1}", sfile == null ? this.getResourceConverter().getString("queryPanel.selectedSchema.alert", "selected Schema") : sfile.getName(), ex.getLocalizedMessage()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectButtonActionPerformedForFile(ActionEvent evt) {
        File sfile = null;
        try {
            String sfname = (String)this.schemaList.getSelectedItem();
            JInternalFrame sf = this.lookupFrame(sfname);
            if (sf == null) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.schemaNotOpen.alert", "Schema file is not open"), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
                return;
            }
            SchemaExplorer se = (SchemaExplorer)sf.getContentPane().getComponent(0);
            if (se.isNewFile()) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("queryPanel.saveSchemaFirst.alert", "You must first save the Schema to open a Mondrian connection"), this.getResourceConverter().getString("common.alertDialog.title", "Alert"), 2);
                sf.setSelected(true);
                return;
            }
            sfile = se.getSchemaFile();
            this.setCursor(Cursor.getPredefinedCursor(3));
            Workbench.OlapConnectionHolder con = this.workbench.checkSchemaFile(sfile, this.workbench.getConnectionDetailsMap().get(se.getJdbcConnectionName()));
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (con != null && con.exception == null && this.setSchema(sfile)) {
                this.connection = con;
                this.queryMenuItem.setText(this.getResourceConverter().getFormattedString("queryPanel.successfulConnection.menuItem", "{0} MDX - {1}", Integer.toString(this.windowMenuIndex), se.getSchemaFile().getName()));
                for (Container o = this; o != null; o = o.getParent()) {
                    if (o.getClass() != JInternalFrame.class) continue;
                    ((JInternalFrame)o).setTitle(this.getResourceConverter().getFormattedString("queryPanel.successfulConnection.internalFrame.title", "MDX Query - connected to {0} with connection {1}", se.getSchemaFile().getName(), se.getJdbcConnectionName()));
                    break;
                }
                JOptionPane.showMessageDialog(this, "Mondrian connection Successful.", this.getResourceConverter().getString("common.informationDialog.title", "Information"), 1);
            } else {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.alert", "Mondrian connection could not be done for - {0}\n{1}", se.getSchemaFile().getName(), con.exception == null ? "null connection" : con.exception.getLocalizedMessage()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("queryPanel.unsuccessfulConnection.exception", "Mondrian connection could not be done for - {0}\n{1}", sfile == null ? this.getResourceConverter().getString("queryPanel.selectedSchema.alert", "selected Schema") : sfile.getName(), ex.getLocalizedMessage()), this.getResourceConverter().getString("common.errorDialog.title", "Error"), 0);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void dispose() {
        this.setConnection(null);
    }

    private JInternalFrame lookupFrame(String sfname) {
        JInternalFrame sf = null;
        for (Map.Entry<JInternalFrame, JMenuItem> entry : this.schemaWindowMap.entrySet()) {
            if (!entry.getValue().getText().equals(sfname)) continue;
            sf = entry.getKey();
            break;
        }
        return sf;
    }

    private class HierarchizeTransform
    extends AxisTransform {
        HierarchizeTransform(Axis axis) {
            super(axis);
        }

        protected ParseTreeNode processAxisExp(ParseTreeNode arg0) {
            ArrayList<ParseTreeNode> callArgs = new ArrayList<ParseTreeNode>();
            callArgs.add(arg0);
            CallNode cn = new CallNode(null, "Hierarchize", Syntax.Function, callArgs);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)MdxQuery.this.getQueryString((ParseTreeNode)cn));
            }
            return cn;
        }

        public String getName() {
            return "HierarchizeTransform";
        }

        public String getDescription() {
            return "Hierachize a Set";
        }
    }

    private class CrossJoinTransform
    extends AxisTransform {
        ParseTreeNode node;

        CrossJoinTransform(Axis axis, ParseTreeNode node) {
            super(axis);
            this.node = node;
        }

        protected ParseTreeNode processAxisExp(ParseTreeNode arg0) {
            ArrayList<ParseTreeNode> callArgs = new ArrayList<ParseTreeNode>();
            callArgs.add(this.node);
            callArgs.add(arg0);
            CallNode cn = new CallNode(null, "*", Syntax.Infix, callArgs);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)MdxQuery.this.getQueryString((ParseTreeNode)cn));
            }
            return cn;
        }

        public String getName() {
            return "CrossJoinTransform";
        }

        public String getDescription() {
            return "Cross joins 2 sets";
        }
    }
}

