/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.Workbench;
import org.apache.log4j.Logger;

public class JdbcTreeModel
implements TreeModel {
    private static final Logger LOGGER = Logger.getLogger(JdbcTreeModel.class);
    private List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
    JdbcMetaData jdbcMetaData;
    Workbench workbench;
    List catalogs;
    Node root;

    public JdbcTreeModel(JdbcMetaData metaData, Workbench wb) {
        this.jdbcMetaData = metaData;
        this.workbench = wb;
        try {
            String schemaRootName = this.workbench.getResourceConverter().getString("jdbcExplorer.root.name", "Schemas");
            this.root = new Node(schemaRootName, 3, null);
            this.catalogs = new ArrayList();
            for (String schemaName : this.jdbcMetaData.getAllSchemas()) {
                Node cat = new Node(schemaName, 0, this.root);
                List<String> tables = this.jdbcMetaData.getAllTables(schemaName);
                for (String tableName : tables) {
                    if (!tableName.matches("(?!BIN\\$).+")) continue;
                    Node table = new Node(tableName, 1, cat);
                    cat.getChildren().add(table);
                }
                this.catalogs.add(cat);
            }
            this.root.children = this.catalogs;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"JdbcTreeModel", (Throwable)ex);
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof Node) {
            return ((Node)parent).getChildren().get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof Node) {
            return ((Node)parent).getChildren().size();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof Node) {
            return ((Node)parent).getChildren().indexOf(child);
        }
        return -1;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    class Node {
        static final int CATALOG = 0;
        static final int TABLE = 1;
        static final int COLUMN = 2;
        static final int ROOT = 3;
        String name;
        int type;
        List children;
        Node parent;

        public Node(String n, int t, Node p) {
            this.name = n;
            this.type = t;
            this.parent = p;
        }

        public String toString() {
            if (this.type == 3) {
                return JdbcTreeModel.this.workbench.getResourceConverter().getString("jdbcExplorer.root.name", "Schemas");
            }
            if (this.name == null || this.name.trim().length() == 0) {
                switch (this.type) {
                    case 0: {
                        return JdbcTreeModel.this.workbench.getResourceConverter().getString("jdbcExplorer.default.name.catalog", "Default Schema");
                    }
                    case 1: {
                        return JdbcTreeModel.this.workbench.getResourceConverter().getString("jdbcExplorer.default.name.table", "Table");
                    }
                    case 2: {
                        return JdbcTreeModel.this.workbench.getResourceConverter().getString("jdbcExplorer.default.name.column", "Column");
                    }
                }
            }
            return this.name;
        }

        public List getChildren() {
            if (this.children == null) {
                this.children = new ArrayList();
                if (this.type == 1) {
                    List<String> columnNames = JdbcTreeModel.this.jdbcMetaData.getAllColumns(this.parent.name, this.name);
                    for (String columnName : columnNames) {
                        Node column = new Node(columnName, 2, this);
                        this.children.add(column);
                    }
                }
            }
            return this.children;
        }
    }
}

