/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import mondrian.gui.JTreeUpdater;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.JdbcTreeModel;
import mondrian.gui.Workbench;
import org.apache.log4j.Logger;

public class JdbcExplorer
extends JPanel
implements TreeWillExpandListener {
    private static final Logger LOGGER = Logger.getLogger(JdbcExplorer.class);
    JdbcMetaData jdbcMetaData;
    JdbcTreeModel model;
    Workbench.ConnectionDetails connectionDetails;
    Workbench workbench;
    DefaultMutableTreeNode root;
    DefaultTreeModel treeModel;
    private JScrollPane jScrollPane1;
    private JTree tree;
    private JTreeUpdater updater;

    public JdbcExplorer(Workbench.ConnectionDetails connectionDetails, JdbcMetaData jdbcMetaData, Workbench wb) {
        this.connectionDetails = connectionDetails;
        this.workbench = wb;
        this.initComponents();
        this.setMetaData(jdbcMetaData);
    }

    public Workbench.ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    public String getConnectionName() {
        return this.getConnectionDetails().connectionName;
    }

    public void setMetaData(JdbcMetaData jdbcMetaData) {
        try {
            this.jdbcMetaData = jdbcMetaData;
            Node rootNode = new Node(null, NodeType.ROOT, null);
            this.root = new DefaultMutableTreeNode(rootNode);
            for (String schemaName : jdbcMetaData.getAllSchemas()) {
                DefaultMutableTreeNode catTreeNode;
                Node cat = new Node(schemaName, NodeType.CATALOG, null);
                cat.treeNode = catTreeNode = new DefaultMutableTreeNode(cat);
                this.root.add(catTreeNode);
                List<String> tables = jdbcMetaData.getAllTables(schemaName);
                for (String tableName : tables) {
                    DefaultMutableTreeNode tableTreeNode;
                    Node table = new Node(tableName, NodeType.TABLE, null);
                    table.treeNode = tableTreeNode = new DefaultMutableTreeNode(table);
                    catTreeNode.add(tableTreeNode);
                }
                cat.gotChildren = true;
            }
            rootNode.gotChildren = true;
            this.treeModel = new DefaultTreeModel(this.root, true);
            this.tree.setModel(this.treeModel);
            this.tree.addTreeWillExpandListener(this);
            this.updater = new JTreeUpdater(this.tree);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
    }

    public void resetMetaData(Workbench.ConnectionDetails connectionDetails, JdbcMetaData jdbcMetaData) {
        this.connectionDetails = connectionDetails;
        this.setMetaData(jdbcMetaData);
    }

    public JTreeUpdater getTreeUpdater() {
        return this.updater;
    }

    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        LOGGER.debug((Object)("path = " + event.getPath() + ", last object is a " + event.getPath().getLastPathComponent().getClass().getName()));
        DefaultMutableTreeNode theTreeNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        Node theNode = (Node)theTreeNode.getUserObject();
        theNode.setChildren();
        this.logNode(theTreeNode, "will Expand");
    }

    private void logNode(DefaultMutableTreeNode theTreeNode, String message) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)theTreeNode.getParent();
        Node theNode = (Node)theTreeNode.getUserObject();
        Node theParentNode = parentNode == null ? null : (Node)parentNode.getUserObject();
        Enumeration<TreeNode> children = theTreeNode.children();
        LOGGER.debug((Object)(message + ": " + theNode + ", " + (Object)((Object)theNode.type) + ", parent " + theParentNode + (theParentNode == null ? "" : ", " + (Object)((Object)theParentNode.type))));
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)children.nextElement();
            Node child = (Node)treeNode.getUserObject();
            LOGGER.debug((Object)("\t" + child.toString() + ", " + (Object)((Object)child.type)));
        }
    }

    public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.tree);
        this.add((Component)this.jScrollPane1, "Center");
    }

    class Node {
        final String name;
        final NodeType type;
        boolean gotChildren = false;
        DefaultMutableTreeNode treeNode;
        final JdbcMetaData.DbColumn columnInfo;

        public Node(String name, NodeType type, DefaultMutableTreeNode treeNode) {
            this(name, type, treeNode, null);
        }

        public Node(String name, NodeType type, DefaultMutableTreeNode treeNode, JdbcMetaData.DbColumn columnInfo) {
            this.name = name;
            this.type = type;
            this.treeNode = treeNode;
            this.columnInfo = columnInfo;
        }

        public String toString() {
            if (this.type == NodeType.ROOT) {
                return JdbcExplorer.this.workbench.getResourceConverter().getFormattedString("jdbcExplorer.root.name", "All Schemas", new Object[0]);
            }
            StringBuilder sb = new StringBuilder();
            if (this.name == null || this.name.trim().length() == 0) {
                switch (this.type) {
                    case CATALOG: {
                        sb.append(JdbcExplorer.this.workbench.getResourceConverter().getFormattedString("jdbcExplorer.default.name.catalog", "Default Schema", new Object[0]));
                        break;
                    }
                    case TABLE: {
                        sb.append(JdbcExplorer.this.workbench.getResourceConverter().getFormattedString("jdbcExplorer.default.name.table", "Table", new Object[0]));
                        break;
                    }
                    case COLUMN: {
                        sb.append(JdbcExplorer.this.workbench.getResourceConverter().getFormattedString("jdbcExplorer.default.name.column", "Column", new Object[0]));
                    }
                }
            } else {
                sb.append(this.name);
            }
            if (this.type != NodeType.COLUMN) {
                return sb.toString();
            }
            sb.append(" - ").append(this.columnInfo.displayType());
            return sb.toString();
        }

        public void setChildren() {
            if (!this.gotChildren && this.type == NodeType.TABLE) {
                DefaultMutableTreeNode theParentTreeNode = (DefaultMutableTreeNode)this.treeNode.getParent();
                Node theParentNode = (Node)theParentTreeNode.getUserObject();
                List<JdbcMetaData.DbColumn> columns = JdbcExplorer.this.jdbcMetaData.getAllDbColumns(theParentNode.name, this.name);
                for (JdbcMetaData.DbColumn column : columns) {
                    Node columnNode = new Node(column.name, NodeType.COLUMN, this.treeNode, column);
                    DefaultMutableTreeNode columnTreeNode = new DefaultMutableTreeNode(columnNode, false);
                    this.treeNode.add(columnTreeNode);
                }
            }
            this.gotChildren = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NodeType {
        CATALOG,
        TABLE,
        COLUMN,
        ROOT;

    }
}

