/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.battery;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.apache.maven.surefire.battery.AbstractBattery;
import org.apache.maven.surefire.battery.TestListenerInvocationHandler;
import org.apache.maven.surefire.battery.assertion.BatteryTestFailedException;
import org.apache.maven.surefire.report.ReporterManager;

public class JUnitBattery
extends AbstractBattery {
    public static final String TEST_CASE = "junit.framework.TestCase";
    public static final String TEST_RESULT = "junit.framework.TestResult";
    public static final String TEST_LISTENER = "junit.framework.TestListener";
    public static final String TEST = "junit.framework.Test";
    public static final String ADD_LISTENER_METHOD = "addListener";
    public static final String RUN_METHOD = "run";
    public static final String COUNT_TEST_CASES_METHOD = "countTestCases";
    public static final String SETUP_METHOD = "setUp";
    public static final String TEARDOWN_METHOD = "tearDown";
    private static final String TEST_SUITE = "junit.framework.TestSuite";
    private Object testObject;
    private Class[] interfacesImplementedByDynamicProxy;
    private Class testResultClass;
    private ClassLoader classLoader;
    private Class testClass;
    private Method addListenerMethod;
    private Method countTestCasesMethod;
    private Method runMethod;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;

    public JUnitBattery(String testClassName) throws Exception {
        this.processTestClass(this.getClass().getClassLoader().loadClass(testClassName), this.getClass().getClassLoader());
    }

    public JUnitBattery(String testClass, ClassLoader loader) throws Exception {
        this.processTestClass(loader.loadClass(testClass), loader);
    }

    public JUnitBattery(Class testClass, ClassLoader loader) throws Exception {
        this.processTestClass(testClass, loader);
    }

    public void processTestClass(Class testClass, ClassLoader loader) throws Exception {
        if (testClass == null) {
            throw new NullPointerException("testClass is null");
        }
        if (loader == null) {
            throw new NullPointerException("classLoader is null");
        }
        this.classLoader = loader;
        this.testClass = testClass;
        this.testResultClass = loader.loadClass(TEST_RESULT);
        Class<?> testCaseClass = loader.loadClass(TEST_CASE);
        Class<?> testSuiteClass = loader.loadClass(TEST_SUITE);
        Class<?> testListenerInterface = loader.loadClass(TEST_LISTENER);
        Class<?> testInterface = loader.loadClass(TEST);
        try {
            Object[] emptyArgs = new Class[]{};
            Method suiteMethod = testClass.getMethod("suite", (Class<?>[])emptyArgs);
            if (Modifier.isPublic(suiteMethod.getModifiers()) && Modifier.isStatic(suiteMethod.getModifiers())) {
                this.testObject = suiteMethod.invoke(null, emptyArgs);
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (this.testObject == null && testCaseClass.isAssignableFrom(testClass)) {
            Class[] constructorParamTypes = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = JUnitBattery.class$("java.lang.Class")) : class$java$lang$Class};
            Constructor<?> constructor = testSuiteClass.getConstructor(constructorParamTypes);
            Object[] constructorParams = new Object[]{testClass};
            this.testObject = constructor.newInstance(constructorParams);
        }
        if (this.testObject == null) {
            Constructor testConstructor = this.getTestConstructor(testClass);
            this.testObject = testConstructor.getParameterTypes().length == 0 ? testConstructor.newInstance(new Object[0]) : testConstructor.newInstance(testClass.getName());
        }
        this.interfacesImplementedByDynamicProxy = new Class[1];
        this.interfacesImplementedByDynamicProxy[0] = testListenerInterface;
        Class[] addListenerParamTypes = this.interfacesImplementedByDynamicProxy;
        this.addListenerMethod = this.testResultClass.getMethod(ADD_LISTENER_METHOD, addListenerParamTypes);
        if (testInterface.isAssignableFrom(testClass)) {
            this.countTestCasesMethod = testInterface.getMethod(COUNT_TEST_CASES_METHOD, new Class[0]);
            this.runMethod = testInterface.getMethod(RUN_METHOD, this.testResultClass);
        } else {
            try {
                this.countTestCasesMethod = testClass.getMethod(COUNT_TEST_CASES_METHOD, new Class[0]);
            }
            catch (Exception e) {
                this.countTestCasesMethod = null;
            }
            try {
                this.runMethod = testClass.getMethod(RUN_METHOD, this.testResultClass);
            }
            catch (Exception e) {
                this.runMethod = null;
            }
        }
    }

    protected Class getTestClass() {
        return this.testClass;
    }

    protected Object getTestClassInstance() {
        return this.testObject;
    }

    public void execute(ReporterManager reportManager) throws Exception {
        if (this.runMethod != null) {
            this.executeJUnit(reportManager);
        } else {
            super.execute(reportManager);
        }
    }

    protected void executeJUnit(ReporterManager reportManager) {
        try {
            Object instanceOfTestResult = this.testResultClass.newInstance();
            TestListenerInvocationHandler invocationHandler = new TestListenerInvocationHandler(reportManager, instanceOfTestResult, this.classLoader);
            Object testListener = Proxy.newProxyInstance(this.classLoader, this.interfacesImplementedByDynamicProxy, (InvocationHandler)invocationHandler);
            Object[] addTestListenerParams = new Object[]{testListener};
            this.addListenerMethod.invoke(instanceOfTestResult, addTestListenerParams);
            Object[] runParams = new Object[]{instanceOfTestResult};
            this.runMethod.invoke(this.testObject, runParams);
        }
        catch (IllegalArgumentException e) {
            throw new BatteryTestFailedException(this.testObject.getClass().getName(), e);
        }
        catch (InstantiationException e) {
            throw new BatteryTestFailedException(this.testObject.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new BatteryTestFailedException(this.testObject.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new BatteryTestFailedException(this.testObject.getClass().getName(), e);
        }
    }

    public int getTestCount() {
        try {
            if (this.countTestCasesMethod != null) {
                Integer integer = (Integer)this.countTestCasesMethod.invoke(this.testObject, (Object[])new Class[0]);
                return integer;
            }
            return super.getTestCount();
        }
        catch (IllegalAccessException e) {
            throw new BatteryTestFailedException(this.testObject.getClass().getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new BatteryTestFailedException(this.testObject.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new BatteryTestFailedException(this.testObject.getClass().getName(), e);
        }
    }

    public String getBatteryName() {
        return this.testClass.getName();
    }

    protected Constructor getTestConstructor(Class testClass) throws NoSuchMethodException {
        Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JUnitBattery.class$("java.lang.String")) : class$java$lang$String};
        try {
            return testClass.getConstructor(params);
        }
        catch (NoSuchMethodException e) {
            return testClass.getConstructor(new Class[0]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

