/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.battery;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.Surefire;
import org.apache.maven.surefire.battery.Battery;
import org.apache.maven.surefire.battery.assertion.BatteryAssert;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;

public abstract class AbstractBattery
extends BatteryAssert
implements Battery {
    private static final String TEST_METHOD_PREFIX = "test";
    private List testMethods;
    private List subBatteryClassNames;

    public void execute(ReporterManager reportManager) throws Exception {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        this.executeTestMethods(reportManager);
    }

    protected void executeTestMethods(ReporterManager reportManager) {
        if (reportManager == null) {
            throw new NullPointerException("reportManager is null");
        }
        if (this.testMethods == null) {
            this.discoverTestMethods();
        }
        Object[] args = new Object[]{};
        boolean abort = false;
        for (int i = 0; i < this.testMethods.size() && !abort; ++i) {
            abort = this.executeTestMethod((Method)this.testMethods.get(i), args, reportManager);
        }
    }

    protected boolean executeTestMethod(Method method, Object[] args, ReporterManager reportManager) {
        if (method == null || args == null || reportManager == null) {
            throw new NullPointerException();
        }
        String userFriendlyMethodName = method.getName() + '(';
        if (args.length != 0) {
            userFriendlyMethodName = userFriendlyMethodName + "Reporter";
        }
        userFriendlyMethodName = userFriendlyMethodName + ')';
        ReportEntry report = new ReportEntry(this, this.getTestName(userFriendlyMethodName), this.getClass().getName());
        reportManager.testStarting(report);
        try {
            this.setUpFixture();
        }
        catch (Exception e) {
            String rawString = Surefire.getResources().getString("setupFixtureFailed");
            MessageFormat msgFmt = new MessageFormat(rawString);
            Object[] stringArgs = new Object[]{method.getName()};
            String stringToPrint = msgFmt.format(stringArgs);
            report = new ReportEntry(this, this.getTestName(userFriendlyMethodName), stringToPrint, e);
            reportManager.testFailed(report);
            return true;
        }
        try {
            method.invoke(this.getTestClassInstance(), args);
            report = new ReportEntry(this, this.getTestName(userFriendlyMethodName), this.getClass().getName());
            reportManager.testSucceeded(report);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            report = new ReportEntry(this, this.getTestName(userFriendlyMethodName), msg, t);
            reportManager.testFailed(report);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            report = new ReportEntry(this, this.getTestName(userFriendlyMethodName), msg, e);
            reportManager.testFailed(report);
        }
        try {
            this.tearDownFixture();
        }
        catch (Exception e) {
            String rawString = Surefire.getResources().getString("cleanupFixtureFailed");
            MessageFormat msgFmt = new MessageFormat(rawString);
            Object[] stringArgs = new Object[]{method.getName()};
            String stringToPrint = msgFmt.format(stringArgs);
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            report = new ReportEntry(this, this.getTestName(userFriendlyMethodName), stringToPrint, e);
            reportManager.testFailed(report);
            return true;
        }
        return false;
    }

    public String getBatteryName() {
        return this.getClass().getName();
    }

    public String getTestName(String testMethodName) {
        if (testMethodName == null) {
            throw new NullPointerException("testMethodName is null");
        }
        return this.getClass() + "." + testMethodName;
    }

    public int getTestCount() {
        this.discoverTestMethods();
        return this.testMethods.size();
    }

    public void setUpFixture() throws Exception {
    }

    public void tearDownFixture() throws Exception {
    }

    protected Class getTestClass() {
        return this.getClass();
    }

    protected Object getTestClassInstance() {
        return this;
    }

    protected void discoverTestMethods() {
        if (this.testMethods != null) {
            return;
        }
        this.testMethods = new ArrayList();
        Method[] methods = this.getTestClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String firstFour;
            String simpleName;
            boolean hasNoParams;
            Method m = methods[i];
            Class<?>[] paramTypes = m.getParameterTypes();
            boolean isInstanceMethod = !Modifier.isStatic(m.getModifiers());
            boolean returnsVoid = m.getReturnType() == Void.TYPE;
            boolean bl = hasNoParams = paramTypes.length == 0;
            if (!isInstanceMethod || !returnsVoid || !hasNoParams || (simpleName = m.getName()).length() <= 4 || !(firstFour = simpleName.substring(0, 4)).equals(TEST_METHOD_PREFIX)) continue;
            this.testMethods.add(m);
        }
    }

    public void discoverBatteryClassNames() throws Exception {
    }

    public void addSubBatteryClassName(String batteryClassName) {
        this.getSubBatteryClassNames().add(batteryClassName);
    }

    public List getSubBatteryClassNames() {
        if (this.subBatteryClassNames == null) {
            this.subBatteryClassNames = new ArrayList();
        }
        return this.subBatteryClassNames;
    }
}

