/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acl.basic.SimpleAclEntry;

public class ThemeTest
extends BaseJasperServerTest {
    private static final Log log = LogFactory.getLog(ThemeTest.class);

    public ThemeTest() {
        this.setAutowireMode(1);
    }

    public ThemeTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public void testAddDefaultTheme() throws Exception {
        log.warn((Object)"Deleting folder : /themes");
        try {
            this.getRepositoryService().deleteFolder(null, "/themes");
        }
        catch (Exception ex) {
            // empty catch block
        }
        log.warn((Object)"Importing Themes...");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("theme_files_list.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String filePath = null;
        this.getOrCreateFolder("/", "themes", "Themes");
        while ((filePath = reader.readLine()) != null) {
            InputStream fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            this.processThemeFile(filePath, fileInputStream);
            fileInputStream.close();
        }
        reader.close();
        Role adminRole = this.getOrCreateRole(administratorRoleName);
        ObjectPermission objPerm = this.createObjectPermission("/themes/default", (Object)adminRole, SimpleAclEntry.READ);
        ExecutionContext executionContext = JasperServerUtil.getExecutionContext();
        executionContext.getAttributes().add("PRIVILEGED_OPERATION");
        this.getObjectPermissionService().putObjectPermission(executionContext, objPerm);
    }

    protected Folder getOrCreateFolder(String baseFolderURI, String name, String label) {
        Folder folder = this.getRepositoryService().getFolder(null, baseFolderURI + "/" + name);
        if (folder == null) {
            folder = new FolderImpl();
            folder.setName(name);
            folder.setLabel(label);
            Date now = new Date();
            folder.setCreationDate(now);
            folder.setUpdateDate(now);
            folder.setParentFolder(baseFolderURI);
            log.warn((Object)("creating folder : " + folder.getURIString()));
            this.getRepositoryService().saveFolder(null, folder);
        }
        return folder;
    }

    protected Folder getOrCreateFolder(String baseFolderURI, String name) {
        return this.getOrCreateFolder(baseFolderURI, name, name);
    }

    protected void processThemeFile(String filePath, InputStream fileInputStream) throws Exception {
        int length = fileInputStream.available();
        byte[] data = new byte[length];
        int off = 0;
        while ((off += fileInputStream.read(data, off, length - off)) < length) {
        }
        String[] pathParts = filePath.split("/");
        Folder parentFolder = null;
        String baseFolderURI = "";
        for (int i = 0; i < pathParts.length - 1; ++i) {
            if (parentFolder != null) {
                baseFolderURI = parentFolder.getURIString();
            }
            parentFolder = this.getOrCreateFolder(baseFolderURI, pathParts[i]);
        }
        String fileName = pathParts[pathParts.length - 1];
        FileResource fileResource = (FileResource)this.getRepositoryService().newResource(null, FileResource.class);
        fileResource.setName(fileName);
        fileResource.setLabel(fileName);
        fileResource.setParentFolder(parentFolder);
        Date now = new Date();
        fileResource.setCreationDate(now);
        fileResource.setUpdateDate(now);
        fileResource.setData(data);
        String type = fileName.toUpperCase().endsWith(".CSS") ? "css" : "img";
        fileResource.setFileType(type);
        log.debug((Object)("creating file : " + fileResource.getURIString()));
        this.getRepositoryService().saveResource(null, (Resource)fileResource);
    }

    protected void onTearDown() {
    }
}

