/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.util.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.DataTypeImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.util.test.BaseExportTestCase;
import java.io.InputStream;
import junit.textui.TestRunner;

public class ExportTest
extends BaseExportTestCase {
    static final String PATH_SEP = "/";
    static final String LABEL = "_label";
    static final String DESC = "_description";
    static final String DESC_TEXT = " for export-import testing";
    private RepositoryService repositoryService;
    private ExecutionContext context;
    static final String LINK_TARGET_FOLDER_NAME = "test_01E";
    static final String LINK_TARGET_IMAGE_NAME = "TestImage_01E";
    static final String LINK_TARGET_JNDI_NAME = "TestJNDI_01E";
    static final String LINK_TARGET_JDBC_NAME = "TestJDBC_01E";
    static final String LINK_TARGET_JRXML_NAME = "TestJRXML_01E";
    static final String LINK_FOLDER_NAME = "test_link_01E";
    static final String LINK_RU_NAME = "TestReportUnitWithLinks_01E";
    static final String LINK_RU_JNDI_NAME = "TestRUJNDI_01E";
    static final String LINK_JRXML_NAME = "TestLinkedJRXML_01E";
    static final String LINK_IMAGE_NAME1 = "TestLinkedImage_01E";
    static final String PREPEND_FOLDER1 = "imageDir1A_B12";
    static final String PREPEND_FOLDER2 = "imageDir2A_B12";
    static final String PREPEND_IMAGE_NAME = "TestImage03A_B12";
    static final String NEW_PREPEND_PATH = "/extra_01A_B12";
    static final String PREPEND_FOLDER1_PATH = "/images/imageDir1A_B12";
    static final String PREPEND_FOLDER2_PATH = "/images/imageDir1A_B12/imageDir2A_B12";
    static final String PREPEND_IMAGE_URI = "/images/imageDir1A_B12/imageDir2A_B12/TestImage03A_B12";
    static final String RU_FOLDER = "reportDir1B";
    static final String RU_NAME = "TestRUExportImport1B";
    static final String RU_REPORT_NAME = "TestRUReportExportImport1B";
    static final String RU_IMAGE_NAME = "TestRUImage1B";
    static final String RU_JNDI_NAME = "TestJNDIDS1B";
    static final String RU_FOLDER_PATH = "/reports/reportDir1B";
    static final String RU_URI = "/reports/reportDir1B/TestRUExportImport1B";
    static final String RU_JNDI_URI = "/reports/reportDir1B/TestJNDIDS1B";
    static final String FOLDER_FOLDER_NAME1 = "testFolder1C2";
    static final String FOLDER_FOLDER_NAME2 = "testFolder2C2";
    static final String FOLDER_FOLDER_NAME3 = "testFolder3C2";
    static final String FOLDER_FOLDER_NAME4 = "testFolder4C2";
    static final String FOLDER_IMAGE_NAME1 = "testImage1C2";
    static final String FOLDER_IMAGE_NAME3 = "testImage3C2";
    static final String FOLDER_IMAGE_NAME4 = "testImage4C2";
    static final String FOLDER_IMAGE_RU_NAME = "testRUImage1C2";
    static final String FOLDER_JRXML_NAME = "testJrxml1C2";
    static final String FOLDER_RU_NAME = "testReportUnit1C2";
    static final String INPUT_CONTROL_NAME = "numInputTest1D";
    static final String INPUT_CONTROL_DATATYPE_NAME = "numInputDataType1D";
    static final String INPUT_CONTROL_URI = "/datatypes/numInputTest1D";

    public ExportTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ExportTest.class);
    }

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.repositoryService = this.getRepositoryService();
        this.context = new ExecutionContextImpl();
    }

    public void onTearDown() throws Exception {
        super.onTearDown();
    }

    public void testFolderExport() {
        this.createFolderResources();
        FileResource fr1 = (FileResource)this.repositoryService.getResource(null, "/testFolder1C2/testImage1C2");
        ExportTest.assertNotNull((Object)fr1);
        ReportUnit ru1 = (ReportUnit)this.repositoryService.getResource(null, "/testFolder1C2/testReportUnit1C2");
        ExportTest.assertNotNull((Object)ru1);
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/testFolder1C2");
        this.performExport(exportParams);
        this.deleteFolderResources();
        FileResource fr_null = (FileResource)this.repositoryService.getResource(null, "/testFolder1C2/testImage1C2");
        ExportTest.assertNull((Object)fr_null);
        ReportUnit ru_null = (ReportUnit)this.repositoryService.getResource(null, "/testFolder1C2/testReportUnit1C2");
        ExportTest.assertNull((Object)ru_null);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        FileResource fr2 = (FileResource)this.repositoryService.getResource(null, "/testFolder1C2/testImage1C2");
        ExportTest.assertNotNull((Object)fr2);
        ReportUnit ru2 = (ReportUnit)this.repositoryService.getResource(null, "/testFolder1C2/testReportUnit1C2");
        ExportTest.assertNotNull((Object)ru2);
        FileResource fr3 = (FileResource)this.repositoryService.getResource(null, "/testFolder1C2/testFolder3C2/testImage3C2");
        ExportTest.assertNotNull((Object)fr3);
        this.deleteFolderResources();
    }

    private void createFolderResources() {
        FolderImpl folder = new FolderImpl();
        folder.setName(FOLDER_FOLDER_NAME1);
        folder.setLabel("testFolder1C2_label");
        folder.setDescription("testFolder1C2_description");
        folder.setParentFolder(PATH_SEP);
        this.repositoryService.saveFolder(null, (Folder)folder);
        FolderImpl folder2 = new FolderImpl();
        folder2.setName(FOLDER_FOLDER_NAME2);
        folder2.setLabel("testFolder2C2_label");
        folder2.setDescription("testFolder2C2_description");
        folder2.setParentFolder((Folder)folder);
        this.repositoryService.saveFolder(null, (Folder)folder2);
        FolderImpl folder3 = new FolderImpl();
        folder3.setName(FOLDER_FOLDER_NAME3);
        folder3.setLabel("testFolder3C2_label");
        folder3.setDescription("testFolder3C2_description");
        folder3.setParentFolder((Folder)folder);
        this.repositoryService.saveFolder(null, (Folder)folder3);
        FolderImpl folder4 = new FolderImpl();
        folder4.setName(FOLDER_FOLDER_NAME4);
        folder4.setLabel("testFolder4C2_label");
        folder4.setDescription("testFolder4C2_description");
        folder4.setParentFolder((Folder)folder3);
        this.repositoryService.saveFolder(null, (Folder)folder4);
        FileResource image1 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        image1.setFileType("img");
        image1.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image1.setName(FOLDER_IMAGE_NAME1);
        image1.setLabel("testImage1C2_label");
        image1.setDescription("testImage1C2_description");
        image1.setParentFolder((Folder)folder);
        this.repositoryService.saveResource(null, (Resource)image1);
        FileResource image3 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        image3.setFileType("img");
        image3.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image3.setName(FOLDER_IMAGE_NAME3);
        image3.setLabel("testImage3C2_label");
        image3.setDescription("testImage3C2_description");
        image3.setParentFolder((Folder)folder3);
        this.repositoryService.saveResource(null, (Resource)image3);
        FileResource image4 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        image4.setFileType("img");
        image4.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image4.setName(FOLDER_IMAGE_NAME4);
        image4.setLabel("testImage4C2_label");
        image4.setDescription("testImage4C2_description");
        image4.setParentFolder((Folder)folder4);
        this.repositoryService.saveResource(null, (Resource)image4);
        ReportUnit unit = (ReportUnit)this.repositoryService.newResource(null, ReportUnit.class);
        unit.setName(FOLDER_RU_NAME);
        unit.setLabel("testReportUnit1C2_label");
        unit.setDescription("testReportUnit1C2_description");
        unit.setParentFolder((Folder)folder);
        FileResource reportRes = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName(FOLDER_JRXML_NAME);
        reportRes.setLabel("testJrxml1C2_label");
        reportRes.setDescription("testJrxml1C2_description");
        reportRes.setParentFolder((Folder)folder);
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/TestReportExportImport01.jrxml");
        reportRes.readData(jrxml);
        unit.setMainReport(reportRes);
        unit.setDataSourceReference("/datasources/JServerJNDIDS");
        FileResource res1 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        res1.setFileType("img");
        res1.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        res1.setName(FOLDER_IMAGE_RU_NAME);
        res1.setLabel("testRUImage1C2_label");
        res1.setDescription("testRUImage1C2_description");
        unit.addResource(res1);
        this.repositoryService.saveResource(null, (Resource)unit);
    }

    private void deleteFolderResources() {
        this.repositoryService.deleteResource(null, "/testFolder1C2/testImage1C2");
        this.repositoryService.deleteResource(null, "/testFolder1C2/testFolder3C2/testImage3C2");
        this.repositoryService.deleteResource(null, "/testFolder1C2/testFolder3C2/testFolder4C2/testImage4C2");
        this.repositoryService.deleteResource(null, "/testFolder1C2/testReportUnit1C2");
        this.repositoryService.deleteFolder(null, "/testFolder1C2/testFolder3C2/testFolder4C2");
        this.repositoryService.deleteFolder(null, "/testFolder1C2/testFolder3C2");
        this.repositoryService.deleteFolder(null, "/testFolder1C2/testFolder2C2");
        this.repositoryService.deleteFolder(null, "/testFolder1C2");
    }

    public void skip_testReportUnitExport() throws Exception {
        this.createReportUnitResources();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", RU_URI);
        this.performExport(exportParams);
        this.deleteReportUnitResources();
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        this.deleteReportUnitResources();
    }

    public void skip_testLinkedResources() throws Exception {
        this.createLinkedResources();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/test_link_01E/TestReportUnitWithLinks_01E");
        this.performExport(exportParams);
        ReportUnit ru1 = (ReportUnit)this.repositoryService.getResource(null, "/test_link_01E/TestReportUnitWithLinks_01E");
        ExportTest.assertNotNull((Object)ru1);
        ExportTest.assertEquals((String)ru1.getName(), (String)LINK_RU_NAME);
        this.deleteLinkedResources();
        ReportUnit ru1_null = (ReportUnit)this.repositoryService.getResource(null, "/test_link_01E/TestReportUnitWithLinks_01E");
        ExportTest.assertNull((Object)ru1_null);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        ReportUnit ru2 = (ReportUnit)this.repositoryService.getResource(null, "/test_link_01E/TestReportUnitWithLinks_01E");
        ExportTest.assertNotNull((Object)ru2);
        ExportTest.assertEquals((String)ru2.getName(), (String)LINK_RU_NAME);
        this.deleteLinkedResources();
        ReportUnit ru2_null = (ReportUnit)this.repositoryService.getResource(null, "/test_link_01E/TestReportUnitWithLinks_01E");
        ExportTest.assertNull((Object)ru2_null);
    }

    public void testRandomPrependResource() {
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/reports/samples/SalesByMonth");
        this.performExport(exportParams);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir).addParameterValue("prepend-path", "/newLocation_07");
        this.performImport(importParams);
        Folder importFolder = this.repositoryService.getFolder(null, "/newLocation_07");
        ExportTest.assertNotNull((Object)importFolder);
        Folder mainSubfolder = this.repositoryService.getFolder(null, "/newLocation_07/reports/samples");
        ExportTest.assertNotNull((Object)mainSubfolder);
        ReportUnit report = (ReportUnit)this.repositoryService.getResource(null, "/newLocation_07/reports/samples/SalesByMonth");
        ExportTest.assertNotNull((Object)report);
        this.repositoryService.deleteFolder(null, "/newLocation_07");
        importFolder = this.repositoryService.getFolder(null, "/newLocation_07");
        ExportTest.assertNull((Object)importFolder);
    }

    public void testPrependPathSimple() {
        try {
            this.createPrependResources();
            String exportDir = this.createExportDir();
            Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", PREPEND_IMAGE_URI);
            this.performExport(exportParams);
            FileResource img1 = (FileResource)this.repositoryService.getResource(null, PREPEND_IMAGE_URI);
            ExportTest.assertNotNull((Object)img1);
            this.deletePrependResources1();
            FileResource img_null = (FileResource)this.repositoryService.getResource(null, PREPEND_IMAGE_URI);
            ExportTest.assertNull((Object)img_null);
            Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir).addParameterValue("prepend-path", NEW_PREPEND_PATH);
            this.performImport(importParams);
            FileResource img2 = (FileResource)this.repositoryService.getResource(null, "/extra_01A_B12/images/imageDir1A_B12/imageDir2A_B12/TestImage03A_B12");
            ExportTest.assertNotNull((Object)img2);
            this.deletePrependResources2();
        }
        catch (Exception e) {
            System.out.println("caught exception, e " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createPrependResources() {
        Folder imagesFolder = this.repositoryService.getFolder(null, "/images");
        if (imagesFolder == null) {
            imagesFolder = new FolderImpl();
            imagesFolder.setName("images");
            imagesFolder.setLabel("Test");
            imagesFolder.setParentFolder(PATH_SEP);
            this.repositoryService.saveFolder(null, imagesFolder);
        }
        FolderImpl folder1 = new FolderImpl();
        folder1.setName(PREPEND_FOLDER1);
        folder1.setLabel("Test Images 1");
        folder1.setDescription("Folder for export-import testing");
        folder1.setParentFolder(imagesFolder);
        this.repositoryService.saveFolder(null, (Folder)folder1);
        FolderImpl folder2 = new FolderImpl();
        folder2.setName(PREPEND_FOLDER2);
        folder2.setLabel("Test Images 2");
        folder2.setDescription("Folder for export-import testing");
        folder2.setParentFolder((Folder)folder1);
        this.repositoryService.saveFolder(null, (Folder)folder2);
        FileResource image = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        image.setFileType("img");
        image.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image.setName(PREPEND_IMAGE_NAME);
        image.setLabel("TestImage03A_B12_label");
        image.setDescription("Image for export-import testing");
        image.setParentFolder((Folder)folder2);
        this.repositoryService.saveResource(null, (Resource)image);
    }

    private void deletePrependResources1() {
        this.repositoryService.deleteResource(null, PREPEND_IMAGE_URI);
        this.repositoryService.deleteFolder(null, PREPEND_FOLDER2_PATH);
        this.repositoryService.deleteFolder(null, PREPEND_FOLDER1_PATH);
    }

    private void deletePrependResources2() {
        this.repositoryService.deleteResource(null, "/extra_01A_B12/images/imageDir1A_B12/imageDir2A_B12/TestImage03A_B12");
        this.repositoryService.deleteFolder(null, "/extra_01A_B12/images/imageDir1A_B12/imageDir2A_B12");
        this.repositoryService.deleteFolder(null, "/extra_01A_B12/images/imageDir1A_B12");
        this.repositoryService.deleteFolder(null, NEW_PREPEND_PATH);
    }

    public void testSimpleFileResource() {
        String MY_IMAGE_NAME = "myTestImage01E12345678";
        String EXTRA_DIR_NAME = "extra_45678";
        Folder imagesFolder = this.repositoryService.getFolder(null, "/myTestImages");
        if (imagesFolder == null) {
            imagesFolder = new FolderImpl();
            imagesFolder.setName("myTestImages");
            imagesFolder.setLabel("Test");
            imagesFolder.setDescription("Test");
            imagesFolder.setParentFolder(PATH_SEP);
            this.repositoryService.saveFolder(null, imagesFolder);
        }
        FileResource image = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        image.setFileType("img");
        image.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image.setName("myTestImage01E12345678");
        image.setLabel("myTestImage01E12345678_label");
        image.setDescription("myTestImage01E12345678 for export-import testing");
        image.setParentFolder(imagesFolder);
        this.repositoryService.saveResource(null, (Resource)image);
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/myTestImages/myTestImage01E12345678");
        this.performExport(exportParams);
        this.repositoryService.deleteResource(null, "/myTestImages/myTestImage01E12345678");
        this.repositoryService.deleteFolder(null, "/myTestImages");
        image = (FileResource)this.repositoryService.getResource(null, "/myTestImages/myTestImage01E12345678");
        ExportTest.assertNull((Object)image);
        imagesFolder = this.repositoryService.getFolder(null, "/myTestImages");
        ExportTest.assertNull((Object)imagesFolder);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir).addParameterValue("prepend-path", "extra_45678");
        this.performImport(importParams);
        FileResource img = (FileResource)this.repositoryService.getResource(null, "/extra_45678/myTestImages/myTestImage01E12345678");
        ExportTest.assertNotNull((Object)img);
        this.repositoryService.deleteResource(null, "/extra_45678/myTestImages/myTestImage01E12345678");
        this.repositoryService.deleteFolder(null, "/extra_45678");
        image = (FileResource)this.repositoryService.getResource(null, "/extra_45678/myTestImages/myTestImage01E12345678");
        ExportTest.assertNull((Object)image);
        imagesFolder = this.repositoryService.getFolder(null, "/extra_45678");
        ExportTest.assertNull((Object)imagesFolder);
    }

    public void testInputControl() {
        this.createInputControlResources();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", INPUT_CONTROL_URI);
        this.performExport(exportParams);
        this.deleteInputControlResources();
        InputControl ic_null = (InputControl)this.repositoryService.getResource(null, INPUT_CONTROL_URI);
        ExportTest.assertNull((Object)ic_null);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        InputControl ic_chk = (InputControl)this.repositoryService.getResource(null, INPUT_CONTROL_URI);
        ExportTest.assertNotNull((Object)ic_chk);
        ExportTest.assertEquals((String)INPUT_CONTROL_NAME, (String)ic_chk.getName());
        DataType dt_chk = (DataType)ic_chk.getDataType().getLocalResource();
        ExportTest.assertNotNull((Object)dt_chk);
        ExportTest.assertEquals((String)INPUT_CONTROL_DATATYPE_NAME, (String)dt_chk.getName());
        this.deleteInputControlResources();
        ic_null = (InputControl)this.repositoryService.getResource(null, INPUT_CONTROL_URI);
        ExportTest.assertNull((Object)ic_null);
    }

    private void createReportUnitResources() throws Exception {
        FolderImpl folder = new FolderImpl();
        folder.setName(RU_FOLDER);
        folder.setLabel("reportDir1B_label");
        folder.setDescription("Folder for export-import testing");
        folder.setParentFolder("/reports");
        this.repositoryService.saveFolder(null, (Folder)folder);
        ReportUnit unit = (ReportUnit)this.repositoryService.newResource(null, ReportUnit.class);
        unit.setName(RU_NAME);
        unit.setLabel("TestRUExportImport1B_label");
        unit.setDescription("Report Unit for export-import testing");
        unit.setParentFolder((Folder)folder);
        if (this.repositoryService.getResource(this.context, RU_JNDI_URI) == null) {
            JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.repositoryService.newResource(null, JndiJdbcReportDataSource.class);
            datasource.setName(RU_JNDI_NAME);
            datasource.setLabel("TestJNDIDS1B_label");
            datasource.setDescription("jndi data source for export-import testing");
            datasource.setJndiName(this.getJdbcProps().getProperty("test.jndi"));
            datasource.setParentFolder((Folder)folder);
            this.repositoryService.saveResource(null, (Resource)datasource);
        } else {
            JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.repositoryService.getResource(this.context, RU_JNDI_URI);
        }
        unit.setDataSourceReference(RU_JNDI_URI);
        FileResource reportRes = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        reportRes.setFileType("jrxml");
        reportRes.setName(RU_REPORT_NAME);
        reportRes.setLabel("TestRUReportExportImport1B_label");
        reportRes.setDescription("Report for export-import testing");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/TestReportExportImport01.jrxml");
        reportRes.readData(jrxml);
        unit.setMainReport(reportRes);
        FileResource image1 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        image1.setFileType("img");
        image1.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image1.setName(RU_IMAGE_NAME);
        image1.setLabel("TestRUImage1B_label");
        image1.setDescription("Image for export-import testing");
        unit.addResource(image1);
        this.repositoryService.saveResource(null, (Resource)unit);
    }

    private void deleteReportUnitResources() {
        this.repositoryService.deleteResource(null, RU_URI);
        this.repositoryService.deleteResource(null, RU_JNDI_URI);
        this.repositoryService.deleteFolder(null, RU_FOLDER_PATH);
    }

    private void createInputControlResources() {
        InputControl ic = (InputControl)this.repositoryService.newResource(null, InputControl.class);
        ic.setName(INPUT_CONTROL_NAME);
        ic.setLabel("numInputTest1D_label");
        ic.setDescription("numInputTest1D Description");
        ic.setType((byte)2);
        ic.setMandatory(false);
        ic.setReadOnly(true);
        ic.setVisible(true);
        DataTypeImpl dt = new DataTypeImpl();
        dt.setName(INPUT_CONTROL_DATATYPE_NAME);
        dt.setLabel("numInputDataType1D_label");
        dt.setDescription("numInputDataType1D Description");
        dt.setType((byte)2);
        dt.setMaxLength(new Integer(10));
        dt.setMaxValue((Comparable)new Integer(1000));
        dt.setStrictMax(true);
        ic.setDataType((DataType)dt);
        ic.setParentFolder("/datatypes");
        this.repositoryService.saveResource(this.context, (Resource)ic);
    }

    private void deleteInputControlResources() {
        this.repositoryService.deleteResource(null, INPUT_CONTROL_URI);
    }

    private void createLinkedResources() throws Exception {
        FolderImpl folder1 = new FolderImpl();
        folder1.setName(LINK_TARGET_FOLDER_NAME);
        folder1.setLabel("test_01E_label");
        folder1.setDescription("test_01E for export-import testing");
        folder1.setParentFolder(PATH_SEP);
        this.repositoryService.saveFolder(null, (Folder)folder1);
        FileResource image1 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        image1.setFileType("img");
        image1.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image1.setName(LINK_TARGET_IMAGE_NAME);
        image1.setLabel("TestImage_01E_label");
        image1.setDescription("TestImage_01E for export-import testing");
        image1.setParentFolder((Folder)folder1);
        this.repositoryService.saveResource(null, (Resource)image1);
        JndiJdbcReportDataSource datasource = (JndiJdbcReportDataSource)this.repositoryService.newResource(null, JndiJdbcReportDataSource.class);
        datasource.setName(LINK_TARGET_JNDI_NAME);
        datasource.setLabel("TestJNDI_01E_label");
        datasource.setDescription("TestJNDI_01E for export-import testing");
        datasource.setJndiName(this.getJdbcProps().getProperty("test.jndi"));
        datasource.setParentFolder((Folder)folder1);
        this.repositoryService.saveResource(null, (Resource)datasource);
        FileResource reportRes1 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        reportRes1.setFileType("jrxml");
        reportRes1.setName(LINK_TARGET_JRXML_NAME);
        reportRes1.setLabel("TestJRXML_01E_label");
        reportRes1.setDescription("TestJRXML_01E for export-import testing");
        InputStream jrxml = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/TestReportExportImport01.jrxml");
        reportRes1.readData(jrxml);
        reportRes1.setParentFolder((Folder)folder1);
        this.repositoryService.saveResource(null, (Resource)reportRes1);
        FolderImpl folder2 = new FolderImpl();
        folder2.setName(LINK_FOLDER_NAME);
        folder2.setLabel("test_link_01E_label");
        folder2.setDescription("test_link_01E for export-import testing");
        folder2.setParentFolder(PATH_SEP);
        this.repositoryService.saveFolder(null, (Folder)folder2);
        ReportUnit unit = (ReportUnit)this.repositoryService.newResource(null, ReportUnit.class);
        unit.setName(LINK_RU_NAME);
        unit.setLabel("TestReportUnitWithLinks_01E_label");
        unit.setDescription("TestReportUnitWithLinks_01E for export-import testing");
        unit.setParentFolder((Folder)folder2);
        FileResource reportRes2 = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        reportRes2.setFileType("jrxml");
        reportRes2.setName(LINK_JRXML_NAME);
        reportRes2.setLabel("TestLinkedJRXML_01E_label");
        reportRes2.setDescription("TestLinkedJRXML_01E for export-import testing");
        InputStream jrxml2 = ((Object)((Object)this)).getClass().getResourceAsStream("/reports/jasper/TestReportExportImport01.jrxml");
        reportRes2.readData(jrxml2);
        unit.setMainReportReference("/test_01E/TestJRXML_01E");
        FileResource imgLink = (FileResource)this.repositoryService.newResource(null, FileResource.class);
        imgLink.setFileType("img");
        imgLink.setName(LINK_IMAGE_NAME1);
        imgLink.setLabel("TestLinkedImage_01E_label");
        imgLink.setDescription("TestLinkedImage_01E for export-import testing");
        imgLink.setReferenceURI("/test_01E/TestImage_01E");
        unit.addResource(imgLink);
        JndiJdbcReportDataSource datasource2 = (JndiJdbcReportDataSource)this.repositoryService.newResource(null, JndiJdbcReportDataSource.class);
        datasource2.setName(LINK_RU_JNDI_NAME);
        datasource2.setLabel("TestRUJNDI_01E_label");
        datasource2.setDescription("TestRUJNDI_01E for export-import testing");
        datasource2.setJndiName(this.getJdbcProps().getProperty("test.jndi"));
        unit.setDataSourceReference("/test_01E/TestJNDI_01E");
        this.repositoryService.saveResource(null, (Resource)unit);
    }

    private void deleteLinkedResources() {
        this.repositoryService.deleteResource(null, "/test_link_01E/TestReportUnitWithLinks_01E");
        this.repositoryService.deleteFolder(null, "/test_link_01E");
        this.repositoryService.deleteResource(null, "/test_01E/TestImage_01E");
        this.repositoryService.deleteResource(null, "/test_01E/TestJNDI_01E");
        this.repositoryService.deleteResource(null, "/test_01E/TestJRXML_01E");
        this.repositoryService.deleteFolder(null, "/test_01E");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryExportImport() {
        FolderImpl folder = new FolderImpl();
        folder.setName("tmp_export");
        folder.setLabel("tmp_export");
        this.repositoryService.saveFolder(this.context, (Folder)folder);
        try {
            Query query = (Query)this.repositoryService.newResource(this.context, Query.class);
            query.setName("query");
            query.setLabel("query");
            query.setParentFolder("/tmp_export");
            query.setLanguage("sql");
            query.setSql("select * from dual");
            JdbcReportDataSource ds = (JdbcReportDataSource)this.repositoryService.newResource(this.context, JdbcReportDataSource.class);
            ds.setName("ds");
            ds.setLabel("ds");
            ds.setConnectionUrl("jdbc:mysql://localhost:3306/jasperserver");
            ds.setDriverClass("com.mysql.jdbc.Driver");
            ds.setUsername("user");
            ds.setPassword("passwd");
            query.setDataSource((ReportDataSource)ds);
            this.repositoryService.saveResource(this.context, (Resource)query);
            boolean queryDeleted = false;
            try {
                String exportDir = this.createExportDir();
                Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/tmp_export/query");
                this.performExport(exportParams);
                this.repositoryService.deleteResource(this.context, "/tmp_export/query");
                queryDeleted = true;
                Resource queryRes = this.repositoryService.getResource(this.context, "/tmp_export/query");
                ExportTest.assertNull((String)"Query deleted", (Object)queryRes);
                queryDeleted = false;
                Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
                this.performImport(importParams);
                queryRes = this.repositoryService.getResource(this.context, "/tmp_export/query");
                ExportTest.assertNotNull((String)"Query imported", (Object)queryRes);
                ExportTest.assertTrue((boolean)(queryRes instanceof Query));
                query = (Query)queryRes;
                ExportTest.assertEquals((String)"sql", (String)query.getLanguage());
                ResourceReference dsRef = query.getDataSource();
                ExportTest.assertNotNull((String)"Query datasource", (Object)dsRef);
                ExportTest.assertTrue((String)"Query datasource local", (boolean)dsRef.isLocal());
                ExportTest.assertNotNull((Object)dsRef.getLocalResource());
                ExportTest.assertTrue((boolean)(dsRef.getLocalResource() instanceof JdbcReportDataSource));
                ds = (JdbcReportDataSource)dsRef.getLocalResource();
                ExportTest.assertEquals((String)"ds", (String)ds.getName());
                ExportTest.assertEquals((String)"passwd", (String)ds.getPassword());
                this.repositoryService.deleteResource(this.context, "/tmp_export/query");
                queryDeleted = true;
            }
            finally {
                if (!queryDeleted) {
                    this.repositoryService.deleteResource(this.context, "/tmp_export/query");
                }
            }
        }
        finally {
            this.repositoryService.deleteFolder(null, "/tmp_export");
        }
    }
}

