/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.util.Date;
import java.util.List;
import junit.textui.TestRunner;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;

public class UserAuthorityServiceTest
extends BaseJasperServerTest {
    protected void onSetUp() throws Exception {
        super.onSetUp();
    }

    public UserAuthorityServiceTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public static void main(String[] args) {
        TestRunner.run(UserAuthorityServiceTest.class);
    }

    public void onTearDown() {
        this.getUserAuthorityService().deleteUser(null, "newUser");
        this.getUserAuthorityService().deleteRole(null, "newRole");
        this.getUserAuthorityService().deleteRole(null, "anotherRole");
        this.getUserAuthorityService().deleteUser(null, "TestUser");
        this.getUserAuthorityService().deleteRole(null, "TestRole0");
        this.getUserAuthorityService().deleteRole(null, "TestRole1");
        this.getUserAuthorityService().deleteRole(null, "TestRole2");
        this.getUserAuthorityService().deleteRole(null, "TestRole3");
        this.getUserAuthorityService().deleteRole(null, "TestRole4");
    }

    public Role addRole(User user, String roleName) {
        Role role = this.getUserAuthorityService().getRole(null, roleName);
        if (role == null) {
            role = this.getUserAuthorityService().newRole(null);
            role.setRoleName(roleName);
            role.setExternallyDefined(false);
            this.getUserAuthorityService().putRole(null, role);
        }
        this.getUserAuthorityService().addRole(null, user, role);
        return role;
    }

    private User findOrCreateUser(String username, String password, String fullName) {
        User workingUser = this.getUserAuthorityService().getUser(null, username);
        if (workingUser == null) {
            workingUser = this.getUserAuthorityService().newUser(null);
            workingUser.setUsername(username);
            workingUser.setPassword(password == null ? username : password);
            workingUser.setFullName(fullName);
            workingUser.setEnabled(true);
            workingUser.setExternallyDefined(false);
            workingUser.setPreviousPasswordChangeTime(new Date());
            this.getUserAuthorityService().putUser(null, workingUser);
        }
        return workingUser;
    }

    public void testNewUser() {
        User newUser = this.findOrCreateUser("newUser", "newPassword", "newUser");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "newRole");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
    }

    public void testOrdinaryUser() {
        User newUser = this.findOrCreateUser("joeuser", "joeuser", "Joe User");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_USER");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
    }

    public void testOrdinaryETLUser() {
        User newUser = this.findOrCreateUser("etluser", "etluser", "etluser");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_USER");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_ETL_ADMIN");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 2 ? 1 : 0) != 0);
    }

    public void testAdminETLUser() {
        User newUser = this.findOrCreateUser("etladmin", "etladmin", "etladmin");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_USER");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_ADMINISTRATOR");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 2 ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_ETL_ADMIN");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 3 ? 1 : 0) != 0);
    }

    public void testAdminUser() {
        User newUser = this.findOrCreateUser("admin", null, "admin");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_USER");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_ADMINISTRATOR");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 2 ? 1 : 0) != 0);
    }

    public void testJasperadminUser() {
        User newUser = this.findOrCreateUser("jasperadmin", "jasperadmin", "jasperadmin");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_USER");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_ADMINISTRATOR");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() != null || newUser.getRoles().size() == 2 ? 1 : 0) != 0);
    }

    public void testAnonymousUser() {
        User newUser = this.findOrCreateUser("anonymousUser", "", "anonymousUser");
        UserAuthorityServiceTest.assertTrue((newUser.getRoles() == null || newUser.getRoles().isEmpty() ? 1 : 0) != 0);
        this.addRole(newUser, "ROLE_ANONYMOUS");
        UserAuthorityServiceTest.assertTrue((String)"newUser.getRoles() wrong size", (newUser.getRoles() != null || newUser.getRoles().size() == 1 ? 1 : 0) != 0);
        UserDetailsService userDetailsService = (UserDetailsService)this.getUserAuthorityService();
        UserDetails details = userDetailsService.loadUserByUsername(newUser.getUsername());
        UserAuthorityServiceTest.assertTrue((String)"load by Acegi interface", (details != null ? 1 : 0) != 0);
        GrantedAuthority[] authorities = details.getAuthorities();
        UserAuthorityServiceTest.assertTrue((String)"authorities wrong size", (authorities != null || authorities.length == 1 ? 1 : 0) != 0);
        UserAuthorityServiceTest.assertTrue((String)"right authority", (boolean)authorities[0].getAuthority().equalsIgnoreCase("ROLE_ANONYMOUS"));
    }

    public void testUpdateUser() {
        User newUser = this.findOrCreateUser("newUser", "", "newUser");
        UserAuthorityServiceTest.assertNotNull((Object)newUser);
        UserAuthorityServiceTest.assertTrue((boolean)newUser.isEnabled());
        this.getUserAuthorityService().disableUser(null, newUser.getUsername());
        newUser = this.findOrCreateUser("newUser", "", "newUser");
        UserAuthorityServiceTest.assertTrue((String)"error: user still disabled", (!newUser.isEnabled() ? 1 : 0) != 0);
        this.addRole(newUser, "anotherRole");
        Role r = this.getUserAuthorityService().getRole(null, "anotherRole");
        UserAuthorityServiceTest.assertTrue((String)"error: 'anotherRole' does not exist", (r != null ? 1 : 0) != 0);
        UserAuthorityServiceTest.assertTrue((String)"error: newUser does not have anotherRole", (boolean)newUser.getRoles().contains(r));
        this.getUserAuthorityService().putUser(null, newUser);
        newUser.removeRole(r);
        UserAuthorityServiceTest.assertTrue((String)"error: newUser still contains anotherRole", (!newUser.getRoles().contains(r) ? 1 : 0) != 0);
        this.getUserAuthorityService().putUser(null, newUser);
        newUser = this.getUserAuthorityService().getUser(null, "newUser");
        UserAuthorityServiceTest.assertTrue((String)"error: after retrieval - newUser REALLY still contains anotherRole", (!newUser.getRoles().contains(r) ? 1 : 0) != 0);
    }

    public void testGetUsersAndRoles() {
        List results = this.getUserAuthorityService().getUsers(null, null);
        UserAuthorityServiceTest.assertTrue((String)("getUsers right size: expected at least 3, got " + results.size()), (results.size() >= 3 ? 1 : 0) != 0);
        results = this.getUserAuthorityService().getRoles(null, null);
        UserAuthorityServiceTest.assertTrue((String)("getRoles right size: expected at least 4, got " + results.size()), (results.size() >= 4 ? 1 : 0) != 0);
    }
}

