/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.service.impl.BaseRepositoryTest;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import junit.framework.Assert;
import org.springframework.security.acl.basic.SimpleAclEntry;

public class RepositoryMoveAndCopyTests
extends BaseRepositoryTest {
    public RepositoryMoveAndCopyTests() {
    }

    public RepositoryMoveAndCopyTests(String name) {
        super(name);
    }

    public void testResourceMove() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                Query query = (Query)RepositoryMoveAndCopyTests.this.newResource(Query.class, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTests.this.saveResource((Resource)query);
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceInexistent(ds.getURIString());
                JndiJdbcReportDataSource movedDS = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, folder.getURIString(), ds.getName());
                Assert.assertEquals((String)"ds-jndi", (String)movedDS.getJndiName());
                Query updatedQuery = (Query)RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, query.getURIString());
                RepositoryMoveAndCopyTests.this.assertExternalReference(updatedQuery.getDataSource(), movedDS.getURIString());
            }
        });
    }

    public void testFolderMove() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                Folder subFolder = RepositoryMoveAndCopyTests.this.saveNewFolder(folder, "s");
                Query query = (Query)RepositoryMoveAndCopyTests.this.newResource(Query.class, subFolder, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTests.this.saveResource((Resource)query);
                Folder destinationFolder = RepositoryMoveAndCopyTests.this.saveNewFolder("f");
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), destinationFolder.getURIString());
                RepositoryMoveAndCopyTests.this.assertFolderInexistent(folder.getURIString());
                Folder movedFolder = RepositoryMoveAndCopyTests.this.assertFolderExists(destinationFolder, folder.getName());
                Resource movedDS = RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, movedFolder, ds.getName());
                Folder movedSubFolder = RepositoryMoveAndCopyTests.this.assertFolderExists(movedFolder, subFolder.getName());
                Query movedQuery = (Query)RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, movedSubFolder, query.getName());
                RepositoryMoveAndCopyTests.this.assertExternalReference(movedQuery.getDataSource(), movedDS.getURIString());
            }
        });
    }

    public void testResourceCopy() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Query query = (Query)RepositoryMoveAndCopyTests.this.newResource(Query.class, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                query.setDataSource((ReportDataSource)ds);
                RepositoryMoveAndCopyTests.this.saveResource((Resource)query);
                String copyUri = RepositoryMoveAndCopyTests.this.makeUri("q2");
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), query.getURIString(), copyUri);
                RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, query.getURIString());
                Query queryCopy = (Query)RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, copyUri);
                Assert.assertEquals((String)"SQL", (String)queryCopy.getLanguage());
                Assert.assertEquals((String)"select", (String)queryCopy.getSql());
                JndiJdbcReportDataSource copyDS = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertLocalReference(query.getDataSource(), JndiJdbcReportDataSource.class);
                Assert.assertEquals((String)"ds-jndi", (String)copyDS.getJndiName());
            }
        });
    }

    public void testFolderCopy() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                Folder subFolder = RepositoryMoveAndCopyTests.this.saveNewFolder(folder, "s");
                Query query = (Query)RepositoryMoveAndCopyTests.this.newResource(Query.class, subFolder, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTests.this.saveResource((Resource)query);
                String copyUri = RepositoryMoveAndCopyTests.this.makeUri("m_copy");
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), copyUri);
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, folder, ds.getName());
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder, subFolder.getName());
                Query reQuery = (Query)RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, subFolder, query.getName());
                RepositoryMoveAndCopyTests.this.assertExternalReference(reQuery.getDataSource(), ds.getURIString());
                Folder folderCopy = RepositoryMoveAndCopyTests.this.assertFolderExists(copyUri);
                JndiJdbcReportDataSource dsCopy = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, folderCopy, ds.getName());
                Assert.assertEquals((String)"ds-jndi", (String)dsCopy.getJndiName());
                Folder subFolderCopy = RepositoryMoveAndCopyTests.this.assertFolderExists(folderCopy, subFolder.getName());
                Query queryCopy = (Query)RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, subFolderCopy, query.getName());
                Assert.assertEquals((String)"select", (String)queryCopy.getSql());
                RepositoryMoveAndCopyTests.this.assertExternalReference(queryCopy.getDataSource(), dsCopy.getURIString());
            }
        });
    }

    public void testResourceOverwriteSameType() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds2 = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds2.setJndiName("ds2-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds2);
                Resource copy = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), ds2.getURIString());
                Assert.assertNotNull((Object)copy);
                Assert.assertEquals((String)folder.getURIString(), (String)copy.getParentFolder());
                Assert.assertEquals((String)"ds_1", (String)copy.getName());
                Assert.assertTrue((boolean)(copy instanceof JndiJdbcReportDataSource));
                Assert.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy).getJndiName());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                JndiJdbcReportDataSource ds2Reloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds2.getURIString());
                Assert.assertEquals((String)"ds2-jndi", (String)ds2Reloaded.getJndiName());
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    Assert.assertEquals((String)"jsexception.move.resource.path.already.exists", (String)e.getMessage());
                }
                Assert.assertTrue((boolean)exception);
                JndiJdbcReportDataSource dsReloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                Assert.assertEquals((String)"ds-jndi", (String)dsReloaded.getJndiName());
                ds2Reloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds2.getURIString());
                Assert.assertEquals((String)"ds2-jndi", (String)ds2Reloaded.getJndiName());
            }
        });
    }

    public void testResourceOverwriteOtherType() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                DataType dt = (DataType)RepositoryMoveAndCopyTests.this.newResource(DataType.class, "ds");
                dt.setType((byte)1);
                RepositoryMoveAndCopyTests.this.saveResource((Resource)dt);
                Resource copy = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), dt.getURIString());
                Assert.assertNotNull((Object)copy);
                Assert.assertEquals((String)"/unit_tests_tmp", (String)copy.getParentFolder());
                Assert.assertEquals((String)"ds_1", (String)copy.getName());
                Assert.assertTrue((boolean)(copy instanceof JndiJdbcReportDataSource));
                Assert.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy).getJndiName());
                Resource copy2 = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), dt.getURIString());
                Assert.assertNotNull((Object)copy2);
                Assert.assertEquals((String)"/unit_tests_tmp", (String)copy2.getParentFolder());
                Assert.assertEquals((String)"ds_2", (String)copy2.getName());
                Assert.assertTrue((boolean)(copy2 instanceof JndiJdbcReportDataSource));
                Assert.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy2).getJndiName());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceExists(DataType.class, dt.getURIString());
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), "/unit_tests_tmp");
                }
                catch (JSException e) {
                    exception = true;
                    Assert.assertEquals((String)"jsexception.move.resource.path.already.exists", (String)e.getMessage());
                }
                Assert.assertTrue((boolean)exception);
                JndiJdbcReportDataSource dsReloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                Assert.assertEquals((String)"ds-jndi", (String)dsReloaded.getJndiName());
                RepositoryMoveAndCopyTests.this.assertResourceExists(DataType.class, dt.getURIString());
            }
        });
    }

    public void testResourceOverwriteFolder() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                Folder subFolder = RepositoryMoveAndCopyTests.this.saveNewFolder(folder, "ds");
                Resource copy = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), subFolder.getURIString());
                Assert.assertNotNull((Object)copy);
                Assert.assertEquals((String)folder.getURIString(), (String)copy.getParentFolder());
                Assert.assertEquals((String)"ds_1", (String)copy.getName());
                Assert.assertTrue((boolean)(copy instanceof JndiJdbcReportDataSource));
                Assert.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy).getJndiName());
                Resource copy2 = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), subFolder.getURIString());
                Assert.assertNotNull((Object)copy2);
                Assert.assertEquals((String)folder.getURIString(), (String)copy2.getParentFolder());
                Assert.assertEquals((String)"ds_2", (String)copy2.getName());
                Assert.assertTrue((boolean)(copy2 instanceof JndiJdbcReportDataSource));
                Assert.assertEquals((String)"ds-jndi", (String)((JndiJdbcReportDataSource)copy2).getJndiName());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceInexistent(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    Assert.assertEquals((String)"jsexception.move.resource.path.already.exists", (String)e.getMessage());
                }
                Assert.assertTrue((boolean)exception);
                JndiJdbcReportDataSource dsReloaded = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                Assert.assertEquals((String)"ds-jndi", (String)dsReloaded.getJndiName());
                RepositoryMoveAndCopyTests.this.assertFolderExists(subFolder.getURIString());
            }
        });
    }

    public void testResourcePermissions() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                RepositoryMoveAndCopyTests.this.setUserPermission(SimpleAclEntry.READ, ds.getURIString(), "joeuser");
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                String copyURI = RepositoryMoveAndCopyTests.this.makeUri("ds2");
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), copyURI);
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                JndiJdbcReportDataSource dsCopy = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, copyURI);
                List copyPermissions = RepositoryMoveAndCopyTests.this.getPermissions((Resource)dsCopy);
                Assert.assertTrue((copyPermissions == null || copyPermissions.isEmpty() ? 1 : 0) != 0);
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), ds.getURIString(), folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceInexistent(ds.getURIString());
                JndiJdbcReportDataSource movedDS = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, folder, ds.getName());
                RepositoryMoveAndCopyTests.this.assertUserPermission(SimpleAclEntry.READ, (Resource)movedDS, "joeuser");
            }
        });
    }

    public void SKIP_testReportUnit() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() throws IOException {
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                ReportUnit report = (ReportUnit)RepositoryMoveAndCopyTests.this.newResource(ReportUnit.class, "report");
                report.setDataSourceReference(ds.getURIString());
                report.setMainReport(RepositoryMoveAndCopyTests.this.newFileResource("main", "jrxml", "/reports/jasper/AllAccounts.jrxml"));
                report.addResource(RepositoryMoveAndCopyTests.this.newFileResource("img", "img", "/images/jasperreports.png"));
                InputControl ic = (InputControl)RepositoryMoveAndCopyTests.this.newResource(InputControl.class, "ic");
                ic.setType((byte)2);
                ic.setMandatory(true);
                DataType dt = (DataType)RepositoryMoveAndCopyTests.this.newResource(DataType.class, "dt");
                dt.setType((byte)1);
                dt.setMaxLength(new Integer(20));
                ic.setDataType(dt);
                report.addInputControl(ic);
                RepositoryMoveAndCopyTests.this.saveResource((Resource)report);
                ReportJobSource jobSource = new ReportJobSource();
                jobSource.setReportUnitURI(report.getURIString());
                Calendar future = Calendar.getInstance();
                future.add(1, 10);
                ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
                trigger.setStartDate(future.getTime());
                trigger.setOccurrenceCount(1);
                ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
                repositoryDestination.setFolderURI("/unit_tests_tmp");
                ReportJob job = new ReportJob();
                job.setLabel("foo");
                job.setSource(jobSource);
                job.setTrigger((ReportJobTrigger)trigger);
                job.setBaseOutputFilename("foo");
                job.addOutputFormat((byte)1);
                job.setContentRepositoryDestination(repositoryDestination);
                RepositoryMoveAndCopyTests.this.getReportSchedulingService().scheduleJob(RepositoryMoveAndCopyTests.this.getExecutionContext(), job);
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                String copyURI = folder.getURIString() + "/" + "report2";
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), report.getURIString(), copyURI);
                RepositoryMoveAndCopyTests.this.assertResourceExists(ReportUnit.class, report.getURIString());
                ReportUnit reportCopy = (ReportUnit)RepositoryMoveAndCopyTests.this.assertResourceExists(ReportUnit.class, copyURI);
                this.assertReportUnit(reportCopy);
                List copyJobs = RepositoryMoveAndCopyTests.this.getReportSchedulingService().getScheduledJobs(RepositoryMoveAndCopyTests.this.getExecutionContext(), reportCopy.getURIString());
                Assert.assertTrue((copyJobs == null || copyJobs.isEmpty() ? 1 : 0) != 0);
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveResource(RepositoryMoveAndCopyTests.this.getExecutionContext(), report.getURIString(), folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceInexistent(report.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                ReportUnit movedReport = (ReportUnit)RepositoryMoveAndCopyTests.this.assertResourceExists(ReportUnit.class, folder, report.getName());
                this.assertReportUnit(movedReport);
                List movedJobs = RepositoryMoveAndCopyTests.this.getReportSchedulingService().getScheduledJobs(RepositoryMoveAndCopyTests.this.getExecutionContext(), movedReport.getURIString());
                Assert.assertNotNull((Object)movedJobs);
                Assert.assertEquals((int)1, (int)movedJobs.size());
                ReportJobSummary movedJob = (ReportJobSummary)movedJobs.get(0);
                Assert.assertEquals((String)"foo", (String)movedJob.getLabel());
                Assert.assertEquals((String)movedReport.getURIString(), (String)movedJob.getReportUnitURI());
            }

            protected void assertReportUnit(ReportUnit report) throws IOException {
                RepositoryMoveAndCopyTests.this.assertExternalReference(report.getDataSource(), RepositoryMoveAndCopyTests.this.makeUri("ds"));
                FileResource main = (FileResource)RepositoryMoveAndCopyTests.this.assertLocalReference(report.getMainReport(), FileResource.class);
                Assert.assertEquals((String)"jrxml", (String)main.getFileType());
                RepositoryMoveAndCopyTests.this.assertFileData(main, "/reports/jasper/AllAccounts.jrxml");
                List resources = report.getResources();
                Assert.assertNotNull((Object)resources);
                Assert.assertEquals((int)1, (int)resources.size());
                FileResource img = (FileResource)RepositoryMoveAndCopyTests.this.assertLocalReference((ResourceReference)resources.get(0), FileResource.class);
                Assert.assertEquals((String)"img", (String)img.getFileType());
                RepositoryMoveAndCopyTests.this.assertFileData(img, "/images/jasperreports.png");
                List inputControls = report.getInputControls();
                Assert.assertNotNull((Object)inputControls);
                Assert.assertEquals((int)1, (int)inputControls.size());
                InputControl movedIC = (InputControl)RepositoryMoveAndCopyTests.this.assertLocalReference((ResourceReference)inputControls.get(0), InputControl.class);
                Assert.assertEquals((byte)2, (byte)movedIC.getType());
                Assert.assertTrue((boolean)movedIC.isMandatory());
                DataType movedDT = (DataType)RepositoryMoveAndCopyTests.this.assertLocalReference(movedIC.getDataType(), DataType.class);
                Assert.assertEquals((byte)1, (byte)movedDT.getType());
                Assert.assertEquals((Object)new Integer(20), (Object)movedDT.getMaxLength());
            }
        });
    }

    public void testFolderOverwriteResource() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                Folder destFolder = RepositoryMoveAndCopyTests.this.saveNewFolder("s");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, destFolder, "m");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                Folder copy = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), ds.getURIString());
                Assert.assertNotNull((Object)copy);
                Assert.assertEquals((String)destFolder.getURIString(), (String)copy.getParentFolder());
                Assert.assertEquals((String)"m_1", (String)copy.getName());
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, destFolder, "m");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    Assert.assertEquals((String)"jsexception.move.folder.path.already.exists", (String)e.getMessage());
                }
                Assert.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, destFolder, "m");
            }
        });
    }

    public void testFolderOverwrite() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                Folder destFolder = RepositoryMoveAndCopyTests.this.saveNewFolder("s");
                RepositoryMoveAndCopyTests.this.saveNewFolder(destFolder, "m");
                Folder copy = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                Assert.assertNotNull((Object)copy);
                Assert.assertEquals((String)"/unit_tests_tmp", (String)copy.getParentFolder());
                Assert.assertEquals((String)"s_1", (String)copy.getName());
                Folder copy2 = RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                Assert.assertNotNull((Object)copy2);
                Assert.assertEquals((String)"/unit_tests_tmp", (String)copy2.getParentFolder());
                Assert.assertEquals((String)"s_2", (String)copy2.getName());
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertFolderExists(destFolder, "m");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    Assert.assertEquals((String)"jsexception.move.folder.path.already.exists", (String)e.getMessage());
                }
                Assert.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertFolderExists(destFolder, "m");
            }
        });
    }

    public void testFolderMoveAncestor() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                Folder destFolder = RepositoryMoveAndCopyTests.this.saveNewFolder(folder, "s");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                }
                catch (JSException e) {
                    exception = true;
                    Assert.assertEquals((String)"jsexception.move.folder.source.uri.ancestor.destination", (String)e.getMessage());
                }
                Assert.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertFolderExists(destFolder.getURIString());
            }
        });
    }

    public void testFolderMoveSame() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                boolean exception = false;
                try {
                    RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), "/unit_tests_tmp");
                }
                catch (JSException e) {
                    exception = true;
                    Assert.assertEquals((String)"jsexception.move.folder.to.same.folder", (String)e.getMessage());
                }
                Assert.assertTrue((boolean)exception);
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
            }
        });
    }

    public void testFolderPermissions() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("f");
                RepositoryMoveAndCopyTests.this.setUserPermission(SimpleAclEntry.ADMINISTRATION, folder.getURIString(), "joeuser");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, folder, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                RepositoryMoveAndCopyTests.this.setUserPermission(SimpleAclEntry.READ_WRITE, ds.getURIString(), "joeuser");
                String copyURI = RepositoryMoveAndCopyTests.this.makeUri("f2");
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), copyURI);
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                Folder folderCopy = RepositoryMoveAndCopyTests.this.assertFolderExists(copyURI);
                List folderCopyPermissions = RepositoryMoveAndCopyTests.this.getPermissions((Resource)folderCopy);
                Assert.assertTrue((folderCopyPermissions == null || folderCopyPermissions.isEmpty() ? 1 : 0) != 0);
                JndiJdbcReportDataSource dsCopy = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, folderCopy, ds.getName());
                List dsCopyPermissions = RepositoryMoveAndCopyTests.this.getPermissions((Resource)dsCopy);
                Assert.assertTrue((dsCopyPermissions == null || dsCopyPermissions.isEmpty() ? 1 : 0) != 0);
                Folder destFolder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().moveFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), destFolder.getURIString());
                RepositoryMoveAndCopyTests.this.assertFolderInexistent(folder.getURIString());
                Folder movedFolder = RepositoryMoveAndCopyTests.this.assertFolderExists(destFolder, folder.getName());
                RepositoryMoveAndCopyTests.this.assertUserPermission(SimpleAclEntry.ADMINISTRATION, (Resource)movedFolder, "joeuser");
                JndiJdbcReportDataSource movedDs = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, movedFolder, ds.getName());
                RepositoryMoveAndCopyTests.this.assertUserPermission(SimpleAclEntry.READ_WRITE, (Resource)movedDs, "joeuser");
            }
        });
    }

    public void testFolderCopyAncestor() throws Exception {
        this.executeInTempFolder(new BaseRepositoryTest.Callback(){

            public void execute() {
                Folder folder = RepositoryMoveAndCopyTests.this.saveNewFolder("m");
                JndiJdbcReportDataSource ds = (JndiJdbcReportDataSource)RepositoryMoveAndCopyTests.this.newResource(JndiJdbcReportDataSource.class, "ds");
                ds.setJndiName("ds-jndi");
                RepositoryMoveAndCopyTests.this.saveResource((Resource)ds);
                Folder subFolder = RepositoryMoveAndCopyTests.this.saveNewFolder(folder, "s");
                Query query = (Query)RepositoryMoveAndCopyTests.this.newResource(Query.class, subFolder, "query");
                query.setLanguage("SQL");
                query.setSql("select");
                query.setDataSourceReference(ds.getURIString());
                RepositoryMoveAndCopyTests.this.saveResource((Resource)query);
                String copyUri = subFolder.getURIString() + "/" + "m2";
                RepositoryMoveAndCopyTests.this.getUnsecureRepositoryService().copyFolder(RepositoryMoveAndCopyTests.this.getExecutionContext(), folder.getURIString(), copyUri);
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder.getURIString());
                RepositoryMoveAndCopyTests.this.assertResourceExists(JndiJdbcReportDataSource.class, ds.getURIString());
                RepositoryMoveAndCopyTests.this.assertFolderExists(folder, subFolder.getName());
                Query reQuery = (Query)RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, subFolder, query.getName());
                RepositoryMoveAndCopyTests.this.assertExternalReference(reQuery.getDataSource(), ds.getURIString());
                Folder folderCopy = RepositoryMoveAndCopyTests.this.assertFolderExists(copyUri);
                RepositoryMoveAndCopyTests.this.assertFolderChildren(folderCopy, 1, 0);
                Folder subFolderCopy = RepositoryMoveAndCopyTests.this.assertFolderExists(folderCopy, subFolder.getName());
                RepositoryMoveAndCopyTests.this.assertFolderChildren(subFolderCopy, 0, 1);
                Query queryCopy = (Query)RepositoryMoveAndCopyTests.this.assertResourceExists(Query.class, subFolderCopy, query.getName());
                Assert.assertEquals((String)"select", (String)queryCopy.getSql());
                RepositoryMoveAndCopyTests.this.assertExternalReference(queryCopy.getDataSource(), ds.getURIString());
            }
        });
    }
}

