/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.view.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.AclService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.service.impl.UserAuthorityServiceTest;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.AclProvider;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.acl.basic.SimpleAclEntry;

public class ObjectPermissionServiceTest
extends BaseJasperServerTest {
    public static String reportsFolderPath = "/reports";
    public static String reportUnitFolder = reportsFolderPath + "/" + "samples";
    public static String reportUnitName = "AllAccounts";
    public static String reportUnitPath = reportUnitFolder + "/" + reportUnitName;
    public static String testUserName = "TestUser";
    public static String testRoleName = "ROLE_TEST";
    public static String portletRoleName = "ROLE_PORTLET";
    public static int readPermissionMask = SimpleAclEntry.READ;
    public static int adminPermissionMask = SimpleAclEntry.ADMINISTRATION;
    ReportUnit unit;
    Role userRole;
    Role adminRole;
    Role testRole;
    Role portletRole;
    User adminUser;
    User testUser;
    Folder root;
    Folder reportsFolder;

    public ObjectPermissionServiceTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    public static void main(String[] args) {
        TestRunner.run(UserAuthorityServiceTest.class);
    }

    protected void onSetUp() throws Exception {
        System.out.println("ObjectPermissionServiceTest Setup");
        this.setUpRoles();
        this.setUpUsers();
        this.setAuthenticatedUser(adminUserName);
        this.createObjectPermission("/", (Object)this.adminRole, SimpleAclEntry.ADMINISTRATION);
        this.root = this.getRepositoryService().getFolder(null, "/");
        ObjectPermissionServiceTest.assertTrue((String)"null root", (this.root != null ? 1 : 0) != 0);
        this.reportsFolder = this.getRepositoryService().getFolder(null, reportsFolderPath);
        ObjectPermissionServiceTest.assertTrue((String)"null reportsFolder", (this.reportsFolder != null ? 1 : 0) != 0);
        this.deleteObjectPermission((InternalURI)this.root, this.userRole);
        this.unit = (ReportUnit)this.getRepositoryService().getResource(null, reportUnitPath);
        ObjectPermissionServiceTest.assertNotNull((String)"Null ReportUnit", (Object)this.unit);
        ObjectPermissionServiceTest.assertEquals((String)"Unmatched ReportUnit name", (String)reportUnitName, (String)this.unit.getName());
    }

    private void setUpRoles() {
        this.userRole = this.getOrCreateRole(userRoleName);
        this.adminRole = this.getOrCreateRole(administratorRoleName);
        this.testRole = this.getOrCreateRole(testRoleName);
        this.portletRole = this.getOrCreateRole(portletRoleName);
    }

    private void setUpUsers() {
        this.testUser = this.findOrCreateUser(testUserName);
        this.getUserAuthorityService().addRole(null, this.testUser, this.testRole);
        this.adminUser = this.findOrCreateUser(adminUserName);
        this.getUserAuthorityService().addRole(null, this.adminUser, this.adminRole);
    }

    public void onTearDown() {
        System.out.println("ObjectPermissionServiceTest Tear down");
        User u = this.getUserAuthorityService().getUser(null, testUserName);
        Resource r = this.getRepositoryService().getResource(null, reportUnitPath);
        this.deleteObjectPermission((InternalURI)r, u);
        System.out.println("Deleting permission for " + userRoleName + " and " + administratorRoleName + " for " + reportUnitFolder);
        Folder f = this.getRepositoryService().getFolder(null, reportUnitFolder);
        this.deleteObjectPermission((InternalURI)f, this.userRole);
        this.deleteObjectPermission((InternalURI)f, this.adminRole);
        System.out.println("Deleting permission for " + userRoleName + " and " + "/");
        f = this.getRepositoryService().getFolder(null, "/");
        this.deleteObjectPermission((InternalURI)f, this.userRole);
        System.out.println("Removing role: " + this.adminRole.getRoleName() + " from user: " + this.testUser.getUsername());
        this.getUserAuthorityService().removeRole(null, this.testUser, this.adminRole);
        u = this.getUserAuthorityService().getUser(null, this.testUser.getUsername());
        System.out.println("test user assigned roles are: ");
        for (Role role : u.getRoles()) {
            System.out.println("\t" + role.getRoleName());
        }
        this.getUserAuthorityService().deleteUser(null, testUserName);
        this.getUserAuthorityService().deleteRole(null, testRoleName);
        this.createObjectPermission((InternalURI)this.root, (Object)this.userRole, SimpleAclEntry.READ);
    }

    public void testObjectPermissionSetup() {
        this.setAuthenticatedUser(adminUserName);
        List l = this.getObjectPermissionService().getObjectPermissionsForObjectAndRecipient(null, (Object)this.unit, (Object)this.adminRole);
        ObjectPermissionServiceTest.assertTrue((String)("getObjectPermissionsForObjectAndRecipient size not 0: " + (l == null ? "null" : new Integer(l.size()).toString())), (l == null || l.size() == 0 ? 1 : 0) != 0);
        ReportUnit ru = (ReportUnit)this.getRepositoryService().getResource(null, this.unit.getURI());
        ObjectPermissionServiceTest.assertTrue((String)("Null report unit for " + this.unit.getURI()), (ru != null ? 1 : 0) != 0);
        ObjectPermissionServiceTest.assertTrue((boolean)ru.getName().equals(reportUnitName));
        String p = ru.getParentFolder();
        Folder f = this.getRepositoryService().getFolder(null, p);
        ObjectPermissionServiceTest.assertTrue((String)("Invalid folder: " + p), (f != null ? 1 : 0) != 0);
        l = this.getObjectPermissionService().getObjectPermissionsForObject(null, (Object)f);
        System.out.println("ObjectPermission for unit folder: " + l);
        ObjectPermissionServiceTest.assertTrue((String)("getObjectPermissionsForObject size not 0: " + (l == null ? "null" : new Integer(l.size()).toString())), (l == null || l.size() == 0 ? 1 : 0) != 0);
    }

    public void testAclAccess() {
        Authentication aUser = this.setAuthenticatedUser(adminUserName);
        BasicAclEntry[] aclEntries = ((AclService)this.getObjectPermissionService()).getAcls((InternalURI)this.unit);
        ObjectPermissionServiceTest.assertTrue((String)"aclEntries = null", (aclEntries != null ? 1 : 0) != 0);
        this.printAclEntries("getAcls(unit)", aclEntries);
        ObjectPermissionServiceTest.assertTrue((String)("aclEntries.length = " + aclEntries.length + " not 2"), (aclEntries.length == 3 ? 1 : 0) != 0);
        AclEntry[] userEntries = ((AclProvider)this.getObjectPermissionService()).getAcls((Object)this.unit, aUser);
        ObjectPermissionServiceTest.assertTrue((String)"userEntries = null", (userEntries != null ? 1 : 0) != 0);
        this.printAclEntries("getAcls(unit, aUser)", (BasicAclEntry[])userEntries);
        ObjectPermissionServiceTest.assertTrue((String)("userEntries.length = " + userEntries.length + " not 1"), (userEntries.length == 2 ? 1 : 0) != 0);
        AclEntry found = null;
        for (int i = 0; i < userEntries.length && found == null; ++i) {
            Object entry = ((BasicAclEntry)userEntries[i]).getRecipient();
            found = entry instanceof Role && ((Role)entry).getRoleName().equals(administratorRoleName) ? userEntries[i] : null;
        }
        ObjectPermissionServiceTest.assertTrue((String)"Role recipient not found", (found != null ? 1 : 0) != 0);
    }

    public void testMethodAndObjectAccess() {
        this.setAuthenticatedUser(adminUserName);
        ObjectPermissionServiceTest.assertNotNull((String)"null testUserName", (Object)testUserName);
        Resource r = this.getRepositoryService().getResource(null, reportUnitPath);
        ObjectPermissionServiceTest.assertNotNull((String)"null Resource", (Object)r);
        this.exerciseResourcesListAccess(adminUserName, true, "ERROR: Administrator should have access to report unit via role at root", "Administrator has access to report unit");
        this.exerciseResourcesListAccess(testUserName, false, "ERROR: ROLE_TEST should not have access to report unit because there is no permissions for ROLE_TEST or this user", "ROLE_TEST does not have access to report unit");
        this.setAuthenticatedUser(adminUserName);
        ObjectPermission op = this.createObjectPermission((InternalURI)r, (Object)this.testUser, SimpleAclEntry.READ);
        this.exerciseResourcesListAccess(testUserName, true, "ERROR: Test user should have specific access to report unit", "Test user has access to report unit");
        this.setAuthenticatedUser(adminUserName);
        this.getObjectPermissionService().deleteObjectPermission(null, op);
        this.getUserAuthorityService().addRole(null, this.testUser, this.adminRole);
        this.exerciseResourcesListAccess(testUserName, true, "ERROR: ROLE_ADMINISTRATOR should have access to root level", "ROLE_ADMINISTRATOR given access to root level");
        Folder f = this.getRepositoryService().getFolder(null, reportUnitFolder);
        try {
            this.getRepositoryService().getResource(null, reportUnitFolder);
            System.out.println("OK: had access to " + reportUnitFolder);
        }
        catch (Exception e) {
            ObjectPermissionServiceTest.fail((String)("ERROR: had no access to " + reportUnitFolder + ": " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void printAclEntries(String name, BasicAclEntry[] aclEntries) {
        System.out.println("AclEntry set: " + name);
        for (int i = 0; aclEntries != null && aclEntries.length > 0 && i < aclEntries.length; ++i) {
            System.out.println("aclEntries[" + i + "]: " + aclEntries[i].getAclObjectIdentity() + "\n\tparent: " + aclEntries[i].getAclObjectParentIdentity() + "\n\trecipient: " + aclEntries[i].getRecipient() + "\n\tmask: " + aclEntries[i].getMask());
        }
    }

    private void exerciseResourcesListAccess(String userName, boolean expectToFind, String testDescription, String successMessage) {
        FilterCriteria criteria = FilterCriteria.createFilter(ReportUnit.class);
        this.setAuthenticatedUser(userName);
        boolean found = false;
        try {
            List l = this.getRepositoryService().loadResourcesList(criteria);
            System.out.println(testDescription + "\nloadResourcesList size: " + l.size());
            Iterator it = l.iterator();
            found = false;
            while (it.hasNext() && !found) {
                ResourceLookup rlu = (ResourceLookup)it.next();
                found = rlu.getURIString().equals(reportUnitPath);
            }
            if (found != expectToFind) {
                ObjectPermissionServiceTest.fail((String)(userName + ": loadResourcesList " + (expectToFind ? "did not contain " : "contained un") + "expected report unit for " + reportUnitName));
            }
        }
        catch (AccessDeniedException ex) {
            ObjectPermissionServiceTest.fail((String)(userName + ": loadResourcesList AccessDeniedException unexpected"));
        }
        System.out.println(successMessage);
    }
}

