/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSource;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.util.test.BaseJasperServerTest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.textui.TestRunner;

public class ReportSchedulingTest
extends BaseJasperServerTest {
    private ReportJobsPersistenceService reportJobsPersistenceService;
    private ExecutionContext executionContext;
    private LoggingService loggingService;
    long eventId = -1L;

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public void setLoggingService(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public ReportJobsPersistenceService getReportJobsPersistenceService() {
        return this.reportJobsPersistenceService;
    }

    public void setReportJobsPersistenceService(ReportJobsPersistenceService reportJobsPersistenceService) {
        this.reportJobsPersistenceService = reportJobsPersistenceService;
    }

    public ReportSchedulingTest(String name) {
        super(name);
        this.setAutowireMode(1);
    }

    protected void onSetUp() throws Exception {
        this.executionContext = new ExecutionContextImpl();
    }

    protected void onTearDown() {
        if (this.eventId >= 0L) {
            this.loggingService.delete(null, new long[]{this.eventId});
        }
    }

    public static void main(String[] args) {
        TestRunner.run(ReportSchedulingTest.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistence() {
        ReportJobSource source = new ReportJobSource();
        source.setReportUnitURI("/test/reportURI");
        Map params = new HashMap<String, Object>();
        params.put("param1", new Integer(5));
        params.put("param2", "value2");
        source.setParametersMap(params);
        Date startDate = new Date();
        ReportJobSimpleTrigger trigger = new ReportJobSimpleTrigger();
        trigger.setStartDate(startDate);
        trigger.setOccurrenceCount(20);
        trigger.setRecurrenceInterval(10);
        trigger.setRecurrenceIntervalUnit((byte)3);
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setFolderURI("/test/scheduled");
        repositoryDestination.setOutputDescription("report output");
        repositoryDestination.setSequentialFilenames(true);
        repositoryDestination.setTimestampPattern("yyyyMMdd");
        ReportJobMailNotification mailNotification = new ReportJobMailNotification();
        mailNotification.addTo("john@smith.com");
        mailNotification.setSubject("Scheduled report");
        mailNotification.setMessageText("Executed report");
        ReportJob job = new ReportJob();
        job.setLabel("foo");
        job.setDescription("bar");
        job.setSource(source);
        job.setTrigger((ReportJobTrigger)trigger);
        job.setBaseOutputFilename("foo");
        job.addOutputFormat((byte)1);
        job.addOutputFormat((byte)4);
        job.setContentRepositoryDestination(repositoryDestination);
        job.setMailNotification(mailNotification);
        job = this.reportJobsPersistenceService.saveJob(this.executionContext, job);
        ReportSchedulingTest.assertNotNull((Object)job);
        long jobId = job.getId();
        boolean deleted = true;
        try {
            job = this.reportJobsPersistenceService.loadJob(this.executionContext, new ReportJobIdHolder(jobId));
            ReportSchedulingTest.assertNotNull((Object)job);
            ReportSchedulingTest.assertEquals((String)"foo", (String)job.getLabel());
            Set outputFormats = job.getOutputFormats();
            ReportSchedulingTest.assertNotNull((Object)outputFormats);
            ReportSchedulingTest.assertEquals((int)2, (int)outputFormats.size());
            ReportSchedulingTest.assertTrue((boolean)outputFormats.contains(new Byte(1)));
            ReportSchedulingTest.assertTrue((boolean)outputFormats.contains(new Byte(4)));
            source = job.getSource();
            ReportSchedulingTest.assertNotNull((Object)source);
            ReportSchedulingTest.assertEquals((String)"/test/reportURI", (String)source.getReportUnitURI());
            params = source.getParametersMap();
            ReportSchedulingTest.assertNotNull(params);
            ReportSchedulingTest.assertEquals((int)2, (int)params.size());
            ReportSchedulingTest.assertTrue((boolean)params.containsKey("param1"));
            ReportSchedulingTest.assertEquals((Object)new Integer(5), params.get("param1"));
            ReportSchedulingTest.assertTrue((boolean)params.containsKey("param2"));
            ReportSchedulingTest.assertEquals((Object)"value2", params.get("param2"));
            ReportSchedulingTest.assertNotNull((Object)job.getTrigger());
            ReportSchedulingTest.assertTrue((boolean)(job.getTrigger() instanceof ReportJobSimpleTrigger));
            trigger = (ReportJobSimpleTrigger)job.getTrigger();
            ReportSchedulingTest.assertEquals((int)20, (int)trigger.getOccurrenceCount());
            ReportSchedulingTest.assertNotNull((Object)trigger.getRecurrenceIntervalUnit());
            ReportSchedulingTest.assertEquals((byte)3, (byte)trigger.getRecurrenceIntervalUnit());
            repositoryDestination = job.getContentRepositoryDestination();
            ReportSchedulingTest.assertNotNull((Object)repositoryDestination);
            ReportSchedulingTest.assertEquals((String)"/test/scheduled", (String)repositoryDestination.getFolderURI());
            ReportSchedulingTest.assertEquals((String)"report output", (String)repositoryDestination.getOutputDescription());
            ReportSchedulingTest.assertTrue((boolean)repositoryDestination.isSequentialFilenames());
            ReportSchedulingTest.assertEquals((String)"yyyyMMdd", (String)repositoryDestination.getTimestampPattern());
            ReportSchedulingTest.assertFalse((boolean)repositoryDestination.isOverwriteFiles());
            mailNotification = job.getMailNotification();
            ReportSchedulingTest.assertNotNull((Object)mailNotification);
            ReportSchedulingTest.assertEquals((String)"Scheduled report", (String)mailNotification.getSubject());
            List toAddresses = mailNotification.getToAddresses();
            ReportSchedulingTest.assertNotNull((Object)toAddresses);
            ReportSchedulingTest.assertEquals((int)1, (int)toAddresses.size());
            ReportSchedulingTest.assertEquals((Object)"john@smith.com", toAddresses.get(0));
            long origJobId = job.getId();
            int origJobVersion = job.getVersion();
            long origTriggerId = trigger.getId();
            int origTriggerVersion = trigger.getVersion();
            long origMailId = mailNotification.getId();
            int origMailVersion = mailNotification.getVersion();
            job.setDescription("updated");
            mailNotification.setSubject("updated subject");
            mailNotification.addTo("joan@smith.com");
            mailNotification.addCc("mary@smith.com");
            this.reportJobsPersistenceService.updateJob(this.executionContext, job);
            job = this.reportJobsPersistenceService.loadJob(this.executionContext, new ReportJobIdHolder(jobId));
            ReportSchedulingTest.assertNotNull((Object)job);
            ReportSchedulingTest.assertEquals((String)"foo", (String)job.getLabel());
            ReportSchedulingTest.assertEquals((String)"updated", (String)job.getDescription());
            ReportSchedulingTest.assertEquals((long)origJobId, (long)job.getId());
            ReportSchedulingTest.assertEquals((int)(origJobVersion + 1), (int)job.getVersion());
            ReportSchedulingTest.assertNotNull((Object)job.getTrigger());
            ReportSchedulingTest.assertTrue((boolean)(job.getTrigger() instanceof ReportJobSimpleTrigger));
            trigger = (ReportJobSimpleTrigger)job.getTrigger();
            ReportSchedulingTest.assertEquals((long)origTriggerId, (long)trigger.getId());
            ReportSchedulingTest.assertEquals((int)origTriggerVersion, (int)trigger.getVersion());
            mailNotification = job.getMailNotification();
            ReportSchedulingTest.assertNotNull((Object)mailNotification);
            ReportSchedulingTest.assertEquals((long)origMailId, (long)mailNotification.getId());
            ReportSchedulingTest.assertEquals((int)(origMailVersion + 1), (int)mailNotification.getVersion());
            ReportSchedulingTest.assertEquals((String)"updated subject", (String)mailNotification.getSubject());
            toAddresses = mailNotification.getToAddresses();
            ReportSchedulingTest.assertEquals((int)2, (int)toAddresses.size());
            ReportSchedulingTest.assertEquals((Object)"john@smith.com", toAddresses.get(0));
            ReportSchedulingTest.assertEquals((Object)"joan@smith.com", toAddresses.get(1));
            List ccAddresses = mailNotification.getCcAddresses();
            ReportSchedulingTest.assertNotNull((Object)ccAddresses);
            ReportSchedulingTest.assertEquals((int)1, (int)ccAddresses.size());
            ReportSchedulingTest.assertEquals((Object)"mary@smith.com", ccAddresses.get(0));
            List jobs = this.reportJobsPersistenceService.listJobs(this.executionContext, "/test/reportURI");
            ReportSchedulingTest.assertNotNull((Object)jobs);
            ReportSchedulingTest.assertTrue((1 <= jobs.size() ? 1 : 0) != 0);
            boolean found = false;
            for (Object element : jobs) {
                ReportSchedulingTest.assertTrue((boolean)(element instanceof ReportJobSummary));
                ReportJobSummary summary = (ReportJobSummary)element;
                if (summary.getId() != jobId) continue;
                found = true;
                ReportSchedulingTest.assertEquals((String)"foo", (String)summary.getLabel());
                break;
            }
            ReportSchedulingTest.assertTrue((boolean)found);
            this.reportJobsPersistenceService.deleteJob(this.executionContext, new ReportJobIdHolder(jobId));
            deleted = true;
            job = this.reportJobsPersistenceService.loadJob(this.executionContext, new ReportJobIdHolder(jobId));
            ReportSchedulingTest.assertNull((Object)job);
        }
        finally {
            if (!deleted) {
                this.reportJobsPersistenceService.deleteJob(this.executionContext, new ReportJobIdHolder(jobId));
            }
        }
    }

    public void testLogging() {
        LogEvent event = this.loggingService.instantiateLogEvent();
        event.setComponent("reportScheduler");
        event.setType((byte)1);
        event.setMessageCode("log.error.report.job.failed");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("Quartz Job: testJob");
        printWriter.println("Quartz Trigger: testTrigger");
        printWriter.println("Exceptions:");
        try {
            int[] i = new int[2];
            int j = i[5];
        }
        catch (Exception e) {
            e.printStackTrace(printWriter);
        }
        printWriter.flush();
        event.setText(writer.toString());
        event.setState((byte)1);
        this.loggingService.log(event);
        this.eventId = event.getId();
    }
}

