/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFileUtil {
    public static List<String> listProjectClassFiles(MavenProject project) {
        List sourceRootsList = project.getCompileSourceRoots();
        ArrayList<String> stringList = new ArrayList<String>();
        for (String sourceRoot : sourceRootsList) {
            File sourceDir = new File(sourceRoot);
            JavaFileUtil.listJavaFiles(sourceDir, sourceDir, stringList);
        }
        return stringList;
    }

    public static List<String> listJavaFiles(File sourceDir, File currentFile, List<String> result) {
        File[] currentList = currentFile.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".java");
            }
        });
        if (currentList == null) {
            return result;
        }
        for (File file : currentList) {
            if (file.isDirectory()) {
                JavaFileUtil.listJavaFiles(sourceDir, file, result);
                continue;
            }
            result.add(JavaFileUtil.convertJavaPathToClass(sourceDir, file));
        }
        return result;
    }

    public static String convertJavaPathToClass(File sourceDir, File file) {
        String javaPath = StringUtils.remove((String)file.getAbsolutePath(), (String)sourceDir.getAbsolutePath());
        return javaPath.replaceAll(".java", "").replaceAll("\\\\", ".").replaceAll("/", ".").replaceAll("^\\.", "");
    }
}

