/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.module;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.cobertura.configuration.ConfigInstrumentation;
import org.codehaus.mojo.cobertura.util.DependenciesMatchingUtil;
import org.codehaus.mojo.cobertura.util.ZipUtil;

public class DependenciesModuleManager {
    public void unpackModuleDependencies(MavenProject project, File outputDirectory, ConfigInstrumentation configInstrumentation) {
        Set artifacts = project.getArtifacts();
        List includesArtifactId = configInstrumentation.getIncludesArtifactId();
        List includesGroupId = configInstrumentation.getIncludesGroupId();
        List excludesGroupId = configInstrumentation.getExcludesGroupId();
        List excludesArtifactId = configInstrumentation.getExcludesArtifactId();
        for (Object object : artifacts) {
            Artifact artifact = (Artifact)object;
            File file = artifact.getFile();
            if (includesGroupId.size() == 0 || !DependenciesMatchingUtil.matchListRegex(includesGroupId, artifact.getGroupId()) || includesArtifactId.size() > 0 && !DependenciesMatchingUtil.matchListRegex(includesArtifactId, artifact.getArtifactId()) || excludesGroupId.size() > 0 && DependenciesMatchingUtil.matchListRegex(excludesGroupId, artifact.getGroupId()) || excludesArtifactId.size() > 0 && DependenciesMatchingUtil.matchListRegex(excludesArtifactId, artifact.getArtifactId())) continue;
            ZipUtil.unzipArchive(file, outputDirectory);
        }
    }
}

