/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.MessageCodesResolver;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebServiceExceptionAdvice
implements ThrowsAdvice,
MessageSourceAware {
    private MessageSource messageSource;
    private MessageCodesResolver messageCodesResolver = new DefaultMessageCodesResolver();

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public void afterThrowing(JSException ex) throws Throwable {
        String message = this.messageSource.getMessage(ex.getMessage(), ex.getArgs(), this.getLocale());
        Element stackTraceEl = this.createStackTraceElement(ex);
        throw new AxisFault("Client", message, null, new Element[]{stackTraceEl});
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    protected Element createStackTraceElement(JSException ex) throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element stackTraceEl = doc.createElementNS(Constants.QNAME_FAULTDETAIL_EXCEPTIONNAME.getNamespaceURI(), Constants.QNAME_FAULTDETAIL_EXCEPTIONNAME.getLocalPart());
        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        CDATASection data = doc.createCDATASection(writer.toString());
        stackTraceEl.appendChild(data);
        return stackTraceEl;
    }

    public void afterThrowing(JSValidationException ex) throws Throwable {
        StringBuffer msgBuffer = new StringBuffer();
        for (ValidationError error : ex.getErrors().getErrors()) {
            String[] codes = error.getField() == null ? this.messageCodesResolver.resolveMessageCodes(error.getErrorCode(), null) : this.messageCodesResolver.resolveMessageCodes(error.getErrorCode(), null, error.getField(), null);
            DefaultMessageSourceResolvable messageResolvable = new DefaultMessageSourceResolvable(codes, error.getErrorArguments(), error.getDefaultMessage());
            String message = this.messageSource.getMessage((MessageSourceResolvable)messageResolvable, this.getLocale());
            msgBuffer.append(message);
            msgBuffer.append('\n');
        }
        Element stackTraceEl = this.createStackTraceElement((JSException)ex);
        throw new AxisFault("Client", msgBuffer.toString(), null, new Element[]{stackTraceEl});
    }
}

