/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.authority;

import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.domain.client.UserImpl;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.axis2.authority.RoleBeanTraslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserBeanTraslator {
    RoleBeanTraslator roleBeanTraslator = new RoleBeanTraslator();

    public static WSUser toWSUser(User user) {
        WSUser wsUser = new WSUser();
        wsUser.setUsername(user.getUsername());
        wsUser.setFullName(user.getFullName());
        wsUser.setEmailAddress(user.getEmailAddress());
        wsUser.setEnabled(Boolean.valueOf(user.isEnabled()));
        wsUser.setExternallyDefined(Boolean.valueOf(user.isExternallyDefined()));
        wsUser.setPassword(user.getPassword());
        wsUser.setPreviousPasswordChangeTime(user.getPreviousPasswordChangeTime());
        wsUser.setTenantId(user.getTenantId());
        if (user.getRoles() != null) {
            wsUser.setRoles(RoleBeanTraslator.toWSRoleArray(user.getRoles()));
        }
        return wsUser;
    }

    public static User toUser(WSUser wsUser) {
        UserImpl user = new UserImpl();
        user.setUsername(wsUser.getUsername());
        user.setFullName(wsUser.getFullName());
        user.setEmailAddress(wsUser.getEmailAddress());
        if (wsUser.getEnabled() == null) {
            user.setEnabled(false);
        } else {
            user.setEnabled(wsUser.getEnabled().booleanValue());
        }
        if (wsUser.getExternallyDefined() == null) {
            user.setExternallyDefined(false);
        } else {
            user.setExternallyDefined(wsUser.getExternallyDefined().booleanValue());
        }
        user.setPassword(wsUser.getPassword());
        user.setPreviousPasswordChangeTime(wsUser.getPreviousPasswordChangeTime());
        user.setTenantId(wsUser.getTenantId());
        if (wsUser.getRoles() != null) {
            user.setRoles(RoleBeanTraslator.toRoleSet(wsUser.getRoles()));
        }
        return user;
    }

    public static WSUser[] toWSUserArray(List users) {
        if (users == null) {
            return null;
        }
        ArrayList<WSUser> wsUsers = new ArrayList<WSUser>();
        for (Object o : users) {
            User u = (User)o;
            wsUsers.add(UserBeanTraslator.toWSUser(u));
        }
        return wsUsers.toArray(new WSUser[wsUsers.size()]);
    }

    public static WSUser[] toWSUserArray(Set users) {
        if (users == null) {
            return null;
        }
        ArrayList<WSUser> wsUsers = new ArrayList<WSUser>();
        for (Object o : users) {
            User u = (User)o;
            wsUsers.add(UserBeanTraslator.toWSUser(u));
        }
        return wsUsers.toArray(new WSUser[wsUsers.size()]);
    }

    public static List<User> toUserList(WSUser[] wsUsers) {
        if (wsUsers == null) {
            return null;
        }
        ArrayList<User> userList = new ArrayList<User>();
        for (WSUser u : wsUsers) {
            userList.add(UserBeanTraslator.toUser(u));
        }
        return userList;
    }

    public static Set<User> toUserSet(WSUser[] wsUsers) {
        if (wsUsers == null) {
            return null;
        }
        HashSet<User> userSet = new HashSet<User>();
        for (WSUser u : wsUsers) {
            userSet.add(UserBeanTraslator.toUser(u));
        }
        return userSet;
    }
}

