/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.authority;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.ws.authority.WSObjectPermission;
import com.jaspersoft.jasperserver.ws.authority.WSRole;
import com.jaspersoft.jasperserver.ws.authority.WSUser;
import com.jaspersoft.jasperserver.ws.axis2.authority.RoleBeanTraslator;
import com.jaspersoft.jasperserver.ws.axis2.authority.UserBeanTraslator;
import java.util.List;

public class PermissionsTranslator {
    public static WSObjectPermission toWSObjectPermission(ObjectPermission objectPermission) {
        WSObjectPermission wsObjectPermission = new WSObjectPermission();
        wsObjectPermission.setPermissionMask(objectPermission.getPermissionMask());
        if (objectPermission.getPermissionRecipient() instanceof User) {
            wsObjectPermission.setPermissionRecipient((Object)UserBeanTraslator.toWSUser((User)objectPermission.getPermissionRecipient()));
        } else if (objectPermission.getPermissionRecipient() instanceof Role) {
            wsObjectPermission.setPermissionRecipient((Object)RoleBeanTraslator.toWSRole((Role)objectPermission.getPermissionRecipient()));
        }
        wsObjectPermission.setUri(objectPermission.getURI());
        return wsObjectPermission;
    }

    public static WSObjectPermission[] toWSTenantArray(List objectPermissionList) {
        WSObjectPermission[] wsObjectPermissions = new WSObjectPermission[objectPermissionList.size()];
        for (int i = 0; i < objectPermissionList.size(); ++i) {
            Object objectPermission = objectPermissionList.get(i);
            ObjectPermission wsObjectPermission = (ObjectPermission)objectPermission;
            wsObjectPermissions[i] = PermissionsTranslator.toWSObjectPermission(wsObjectPermission);
        }
        return wsObjectPermissions;
    }

    public static void populateObjectPermission(WSObjectPermission wsObjectPermission, ObjectPermission objectPermission) {
        objectPermission.setPermissionMask(wsObjectPermission.getPermissionMask());
        objectPermission.setURI(wsObjectPermission.getUri());
        if (wsObjectPermission.getPermissionRecipient() instanceof WSUser) {
            objectPermission.setPermissionRecipient((Object)UserBeanTraslator.toUser((WSUser)wsObjectPermission.getPermissionRecipient()));
        } else if (wsObjectPermission.getPermissionRecipient() instanceof WSRole) {
            objectPermission.setPermissionRecipient((Object)RoleBeanTraslator.toRole((WSRole)wsObjectPermission.getPermissionRecipient()));
        }
    }
}

