/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.inheritance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultDecorationModelInheritanceAssembler
implements DecorationModelInheritanceAssembler {
    public void assembleModelInheritance(String name, DecorationModel child, DecorationModel parent, String childBaseUrl, String parentBaseUrl) {
        String prefix = DefaultDecorationModelInheritanceAssembler.getParentPrefix(parentBaseUrl, childBaseUrl);
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (parent != null) {
            if (child.getBannerLeft() == null) {
                child.setBannerLeft(parent.getBannerLeft());
                this.resolveBannerPaths(child.getBannerLeft(), prefix, parentBaseUrl);
            }
            if (child.getBannerRight() == null) {
                child.setBannerRight(parent.getBannerRight());
                this.resolveBannerPaths(child.getBannerRight(), prefix, parentBaseUrl);
            }
            if (child.getPublishDate() == null) {
                child.setPublishDate(parent.getPublishDate());
            }
            if (child.getSkin() == null) {
                child.setSkin(parent.getSkin());
            }
            child.setPoweredBy(this.mergePoweredByLists(child.getPoweredBy(), parent.getPoweredBy(), prefix, parentBaseUrl));
            this.assembleBodyInheritance(name, childBaseUrl, child, parent, prefix, parentBaseUrl);
            this.assembleCustomInheritance(child, parent);
        }
    }

    public void resolvePaths(DecorationModel decoration, String baseUrl) {
        String prefix = ".";
        if (decoration.getBannerLeft() != null) {
            this.resolveBannerPaths(decoration.getBannerLeft(), prefix, baseUrl);
        }
        if (decoration.getBannerRight() != null) {
            this.resolveBannerPaths(decoration.getBannerRight(), prefix, baseUrl);
        }
        Iterator i = decoration.getPoweredBy().iterator();
        while (i.hasNext()) {
            Logo logo = (Logo)i.next();
            this.resolveLogoPaths(logo, prefix, baseUrl);
        }
        if (decoration.getBody() != null) {
            LinkItem linkItem;
            i = decoration.getBody().getLinks().iterator();
            while (i.hasNext()) {
                linkItem = (LinkItem)i.next();
                this.resolveLinkItemPaths(linkItem, prefix, baseUrl);
            }
            i = decoration.getBody().getBreadcrumbs().iterator();
            while (i.hasNext()) {
                linkItem = (LinkItem)i.next();
                this.resolveLinkItemPaths(linkItem, prefix, baseUrl);
            }
            i = decoration.getBody().getMenus().iterator();
            while (i.hasNext()) {
                Menu menu = (Menu)i.next();
                this.resolveMenuPaths(menu.getItems(), prefix, baseUrl);
            }
        }
    }

    private void resolveBannerPaths(Banner banner, String prefix, String baseUrl) {
        if (banner != null) {
            banner.setHref(this.resolvePath(banner.getHref(), prefix, baseUrl));
            banner.setSrc(this.resolvePath(banner.getSrc(), prefix, baseUrl));
        }
    }

    private String resolvePath(String href, String prefix, String baseUrl) {
        String path = null;
        if (href != null) {
            String relativePath = DefaultDecorationModelInheritanceAssembler.getParentPrefix(href, baseUrl);
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            path = PathTool.calculateLink((String)relativePath, (String)prefix);
        }
        return path;
    }

    private void assembleCustomInheritance(DecorationModel child, DecorationModel parent) {
        if (child.getCustom() == null) {
            child.setCustom(parent.getCustom());
        } else {
            child.setCustom(Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)child.getCustom()), (Xpp3Dom)((Xpp3Dom)parent.getCustom())));
        }
    }

    private void assembleBodyInheritance(String name, String childUrl, DecorationModel child, DecorationModel parent, String prefix, String baseUrl) {
        Body cBody = child.getBody();
        Body pBody = parent.getBody();
        if (cBody != null || pBody != null) {
            if (cBody == null) {
                cBody = new Body();
                child.setBody(cBody);
            }
            if (pBody == null) {
                pBody = new Body();
            }
            if (cBody.getHead() == null) {
                cBody.setHead(pBody.getHead());
            } else {
                cBody.setHead(Xpp3Dom.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)cBody.getHead()), (Xpp3Dom)((Xpp3Dom)pBody.getHead())));
            }
            cBody.setLinks(this.mergeLinkItemLists(cBody.getLinks(), pBody.getLinks(), prefix, baseUrl));
            if (cBody.getBreadcrumbs().isEmpty() && !pBody.getBreadcrumbs().isEmpty()) {
                LinkItem breadcrumb = new LinkItem();
                breadcrumb.setName(name);
                breadcrumb.setHref(childUrl);
                cBody.getBreadcrumbs().add(breadcrumb);
            }
            cBody.setBreadcrumbs(this.mergeLinkItemLists(cBody.getBreadcrumbs(), pBody.getBreadcrumbs(), prefix, baseUrl));
            cBody.setMenus(this.mergeMenus(cBody.getMenus(), pBody.getMenus(), prefix, baseUrl));
        }
    }

    private List mergeMenus(List dominant, List recessive, String prefix, String baseUrl) {
        ArrayList<Menu> menus = new ArrayList<Menu>();
        Iterator it = dominant.iterator();
        while (it.hasNext()) {
            Menu menu = (Menu)it.next();
            menus.add(menu);
        }
        int topCounter = 0;
        Iterator it2 = recessive.iterator();
        while (it2.hasNext()) {
            Menu menu = (Menu)it2.next();
            if ("top".equals(menu.getInherit())) {
                menus.add(topCounter, menu);
                ++topCounter;
                this.resolveMenuPaths(menu.getItems(), prefix, baseUrl);
                continue;
            }
            if (!"bottom".equals(menu.getInherit())) continue;
            menus.add(menu);
            this.resolveMenuPaths(menu.getItems(), prefix, baseUrl);
        }
        return menus;
    }

    private void resolveMenuPaths(List items, String prefix, String baseUrl) {
        Iterator i = items.iterator();
        while (i.hasNext()) {
            MenuItem item = (MenuItem)i.next();
            this.resolveLinkItemPaths(item, prefix, baseUrl);
            this.resolveMenuPaths(item.getItems(), prefix, baseUrl);
        }
    }

    private void resolveLinkItemPaths(LinkItem item, String prefix, String baseUrl) {
        if (item.getHref() != null) {
            item.setHref(this.resolvePath(item.getHref(), prefix, baseUrl));
        } else {
            item.setHref("");
        }
    }

    private void resolveLogoPaths(Logo logo, String prefix, String baseUrl) {
        logo.setImg(this.resolvePath(logo.getImg(), prefix, baseUrl));
        this.resolveLinkItemPaths(logo, prefix, baseUrl);
    }

    private List mergeLinkItemLists(List childList, List parentList, String prefix, String baseUrl) {
        LinkItem item;
        ArrayList<LinkItem> items = new ArrayList<LinkItem>();
        Iterator it = parentList.iterator();
        while (it.hasNext()) {
            item = (LinkItem)it.next();
            this.resolveLinkItemPaths(item, prefix, baseUrl);
            if (items.contains(item)) continue;
            items.add(item);
        }
        it = childList.iterator();
        while (it.hasNext()) {
            item = (LinkItem)it.next();
            if (items.contains(item)) continue;
            items.add(item);
        }
        return items;
    }

    private List mergePoweredByLists(List childList, List parentList, String prefix, String baseUrl) {
        Logo logo;
        ArrayList<Logo> logos = new ArrayList<Logo>();
        Iterator it = parentList.iterator();
        while (it.hasNext()) {
            logo = (Logo)it.next();
            if (!logos.contains(logo)) {
                logos.add(logo);
            }
            this.resolveLogoPaths(logo, prefix, baseUrl);
        }
        it = childList.iterator();
        while (it.hasNext()) {
            logo = (Logo)it.next();
            if (logos.contains(logo)) continue;
            logos.add(logo);
        }
        return logos;
    }

    private static String getParentPrefix(String parentUrl, String childUrl) {
        String prefix = parentUrl;
        if (childUrl.startsWith(parentUrl)) {
            prefix = DefaultDecorationModelInheritanceAssembler.getRelativePath(childUrl, parentUrl);
            String parentPath = "";
            StringTokenizer tok = new StringTokenizer(prefix, "/");
            while (tok.hasMoreTokens()) {
                parentPath = parentPath + "../";
                tok.nextToken();
            }
            prefix = parentPath;
        } else if (parentUrl.startsWith(childUrl)) {
            prefix = DefaultDecorationModelInheritanceAssembler.getRelativePath(parentUrl, childUrl);
        }
        return prefix;
    }

    private static String getRelativePath(String childUrl, String parentUrl) {
        String relative = childUrl.substring(parentUrl.length());
        if (relative.startsWith("/")) {
            relative = relative.substring(1);
        }
        return relative;
    }
}

