/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.List;
import org.directwebremoting.dwrp.AbstractOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public class ArrayOutboundVariable
extends AbstractOutboundVariable
implements OutboundVariable {
    private List ovs;

    public ArrayOutboundVariable(OutboundContext outboundContext) {
        super(outboundContext);
    }

    public void init(List aOvs) {
        this.ovs = aOvs;
        this.setChildren(this.ovs);
    }

    protected AbstractOutboundVariable.NotInlineDefinition getNotInlineDefinition() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.ovs.size(); ++i) {
            OutboundVariable nested = (OutboundVariable)this.ovs.get(i);
            String varName = this.getVariableName();
            if (nested == null) continue;
            buffer.append(varName);
            buffer.append('[');
            buffer.append(i);
            buffer.append("]=");
            buffer.append(nested.getAssignCode());
            buffer.append(';');
        }
        buffer.append("\r\n");
        return new AbstractOutboundVariable.NotInlineDefinition("var " + this.getVariableName() + "=[];", buffer.toString());
    }

    protected String getInlineDefinition() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        boolean first = true;
        for (int i = 0; i < this.ovs.size(); ++i) {
            OutboundVariable ov = (OutboundVariable)this.ovs.get(i);
            if (!first) {
                buffer.append(',');
            }
            buffer.append(ov.getAssignCode());
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String toString() {
        return "Array:" + this.toStringDefinitionHint() + ":" + this.ovs;
    }
}

