/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.filter.SearchAttributesHelper;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeSearchCriteriaFactory
implements SearchCriteriaFactory {
    private Map<String, String> resourceTypeMap;
    private ResourceFactory persistentClassMappings;
    private Map<String, SearchFilter> typeSpecificFilters;

    public void setResourceTypeMap(Map<String, String> resourceTypeMap) {
        this.resourceTypeMap = resourceTypeMap;
    }

    public void setPersistentClassMappings(ResourceFactory persistentClassMappings) {
        this.persistentClassMappings = persistentClassMappings;
    }

    public void setTypeSpecificFilters(Map<String, SearchFilter> typeSpecificFilters) {
        this.typeSpecificFilters = typeSpecificFilters;
    }

    public SearchCriteria create(ExecutionContext context, List<SearchFilter> filters) {
        SearchAttributes searchAttributes = SearchAttributesHelper.extract(context);
        if (searchAttributes != null && searchAttributes.getState() != null && searchAttributes.getState().getCustomFiltersMap() != null) {
            String resourceType = this.getResourceType(searchAttributes);
            SearchCriteria searchCriteria = SearchCriteria.forClass((Class)this.persistentClassMappings.getImplementationClass(resourceType));
            if (this.typeSpecificFilters.get(resourceType) != null) {
                this.typeSpecificFilters.get(resourceType).applyRestrictions(resourceType, context, searchCriteria);
            }
            if (filters != null) {
                for (SearchFilter filter : filters) {
                    filter.applyRestrictions(resourceType, context, searchCriteria);
                }
            }
            return searchCriteria;
        }
        throw new RuntimeException("Resource type filter not found in the custom filters map.");
    }

    public void applySorter(ExecutionContext context, SearchCriteria searchCriteria, SearchSorter sorter) {
        SearchAttributes searchAttributes = SearchAttributesHelper.extract(context);
        if (searchAttributes != null && searchAttributes.getState() != null && searchAttributes.getState().getCustomFiltersMap() != null) {
            String resourceType = this.getResourceType(searchAttributes);
            if (sorter != null) {
                sorter.applyOrder(resourceType, context, searchCriteria);
            }
        }
    }

    private String getResourceType(SearchAttributes searchAttributes) {
        String resourceTypeFilterOption = searchAttributes.getState().getCustomFiltersMap().get("resourceTypeFilter");
        String resourceType = Resource.class.getName();
        if (resourceTypeFilterOption != null) {
            resourceType = this.resourceTypeMap.get(resourceTypeFilterOption);
        }
        return resourceType;
    }
}

