/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.filter;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.common.SearchMode;
import com.jaspersoft.jasperserver.search.filter.BaseSearchFilter;
import com.jaspersoft.jasperserver.war.common.RoleAccessUrisResolver;
import com.jaspersoft.jasperserver.war.common.UriDescriptor;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class FolderFilter
extends BaseSearchFilter {
    private RoleAccessUrisResolver roleAccessUrisResolver;

    public void setRoleAccessUrisResolver(RoleAccessUrisResolver roleAccessUrisResolver) {
        this.roleAccessUrisResolver = roleAccessUrisResolver;
    }

    public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
        SearchAttributes searchAttributes = this.getSearchAttributes(context);
        if (searchAttributes != null && searchAttributes.getState() != null && searchAttributes.getState().getFolderUri() != null) {
            String folderUri = this.roleAccessUrisResolver.getAbsoluteUri(searchAttributes.getState().getFolderUri());
            String alias = criteria.getAlias("parent", "p");
            if (searchAttributes.getMode() == SearchMode.SEARCH) {
                this.addSearchModeFolderRestrictions(criteria, folderUri, alias);
            } else {
                criteria.add((Criterion)Restrictions.eq((String)(alias + ".URI"), (Object)folderUri));
            }
            this.addRoleAccessUrlsRestrictions(criteria);
        }
    }

    protected String createSubFoldersLikeUri(String folderUri) {
        return folderUri.endsWith("/") ? folderUri + "%" : folderUri + "/" + "%";
    }

    protected void addSearchModeFolderRestrictions(SearchCriteria criteria, String folderUri, String alias) {
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)(alias + ".URI"), (Object)this.createSubFoldersLikeUri(folderUri)), (Criterion)Restrictions.eq((String)(alias + ".URI"), (Object)folderUri)));
    }

    private void addRoleAccessUrlsRestrictions(SearchCriteria criteria) {
        String alias = criteria.getAlias("parent", "p");
        for (UriDescriptor uriDescriptor : this.roleAccessUrisResolver.getRestrictedUris()) {
            String uri = uriDescriptor.isAbsolute() ? uriDescriptor.getUri() : this.roleAccessUrisResolver.getAbsoluteUri(uriDescriptor.getUri());
            criteria.add((Criterion)Restrictions.ne((String)(alias + ".URI"), (Object)uri));
            String childrenUrlsExp = uri.endsWith("/") ? uri + "%" : uri + "/" + "%";
            criteria.add(Restrictions.not((Criterion)Restrictions.like((String)(alias + ".URI"), (Object)childrenUrlsExp)));
        }
    }
}

