/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.simple;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.chartthemes.simple.AxisSettings;
import net.sf.jasperreports.chartthemes.simple.ChartSettings;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.ColorProvider;
import net.sf.jasperreports.chartthemes.simple.FileImageProvider;
import net.sf.jasperreports.chartthemes.simple.GradientPaintProvider;
import net.sf.jasperreports.chartthemes.simple.LegendSettings;
import net.sf.jasperreports.chartthemes.simple.PlotSettings;
import net.sf.jasperreports.chartthemes.simple.TitleSettings;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.UnitType;

public class SimpleSettingsFactory {
    public static final Color COLOR_0 = new Color(250, 97, 18);
    public static final Color COLOR_1 = new Color(237, 38, 42);
    public static final Color COLOR_2 = new Color(0, 111, 60);
    public static final Color COLOR_3 = new Color(250, 223, 18);
    public static final Color COLOR_4 = new Color(47, 137, 187);
    public static final Color COLOR_5 = new Color(231, 133, 35);
    public static final Color COLOR_6 = new Color(229, 1, 140);
    public static final Color COLOR_7 = new Color(234, 171, 53);
    public static final List COLORS = new ArrayList(){
        {
            this.add(new ColorProvider(COLOR_0));
            this.add(new ColorProvider(COLOR_1));
            this.add(new ColorProvider(COLOR_2));
            this.add(new ColorProvider(COLOR_3));
            this.add(new ColorProvider(COLOR_4));
            this.add(new ColorProvider(COLOR_5));
            this.add(new ColorProvider(COLOR_6));
            this.add(new ColorProvider(COLOR_7));
        }
    };
    public static final List COLORS_DARKER = new ArrayList(){
        {
            this.add(new ColorProvider(COLOR_0.darker()));
            this.add(new ColorProvider(COLOR_1.darker()));
            this.add(new ColorProvider(COLOR_2.darker()));
            this.add(new ColorProvider(COLOR_3.darker()));
            this.add(new ColorProvider(COLOR_4.darker()));
            this.add(new ColorProvider(COLOR_5.darker()));
            this.add(new ColorProvider(COLOR_6.darker()));
            this.add(new ColorProvider(COLOR_7.darker()));
        }
    };
    public static final List GRADIENT_PAINTS = new ArrayList(){
        {
            this.add(new GradientPaintProvider(COLOR_0, COLOR_0.darker()));
            this.add(new GradientPaintProvider(COLOR_1, COLOR_1.darker()));
            this.add(new GradientPaintProvider(COLOR_2, COLOR_2.darker()));
            this.add(new GradientPaintProvider(COLOR_3, COLOR_3.darker()));
            this.add(new GradientPaintProvider(COLOR_4, COLOR_4.darker()));
            this.add(new GradientPaintProvider(COLOR_5, COLOR_5.darker()));
            this.add(new GradientPaintProvider(COLOR_6, COLOR_6.darker()));
            this.add(new GradientPaintProvider(COLOR_7, COLOR_7.darker()));
        }
    };
    public static final List STROKES = new ArrayList(){
        {
            this.add(new BasicStroke(2.0f));
            this.add(new BasicStroke(2.0f));
            this.add(new BasicStroke(2.0f));
            this.add(new BasicStroke(2.0f));
            this.add(new BasicStroke(2.0f));
            this.add(new BasicStroke(2.0f));
            this.add(new BasicStroke(2.0f));
            this.add(new BasicStroke(2.0f));
        }
    };
    public static final List OUTLINE_STROKES = new ArrayList(){
        {
            this.add(new BasicStroke(3.0f));
            this.add(new BasicStroke(3.0f));
            this.add(new BasicStroke(3.0f));
            this.add(new BasicStroke(3.0f));
            this.add(new BasicStroke(3.0f));
            this.add(new BasicStroke(3.0f));
            this.add(new BasicStroke(3.0f));
            this.add(new BasicStroke(3.0f));
        }
    };

    public static final ChartThemeSettings createChartThemeSettings() {
        ChartThemeSettings settings = new ChartThemeSettings();
        ChartSettings chartSettings = settings.getChartSettings();
        chartSettings.setBackgroundPaint(new GradientPaintProvider(Color.green, Color.blue));
        chartSettings.setBackgroundImage(new FileImageProvider("net/sf/jasperreports/chartthemes/simple/jasperreports.png"));
        chartSettings.setBackgroundImageAlignment(new Integer(9));
        chartSettings.setBackgroundImageAlpha(new Float(1.0f));
        chartSettings.setBorderVisible(Boolean.TRUE);
        chartSettings.setBorderPaint(new ColorProvider(Color.GREEN));
        chartSettings.setBorderStroke(new BasicStroke(1.0f));
        chartSettings.setAntiAlias(Boolean.TRUE);
        chartSettings.setTextAntiAlias(Boolean.TRUE);
        chartSettings.setPadding(new RectangleInsets(UnitType.ABSOLUTE, 1.1, 2.2, 3.3, 4.4));
        TitleSettings titleSettings = settings.getTitleSettings();
        titleSettings.setShowTitle(Boolean.TRUE);
        titleSettings.setPosition(EdgeEnum.TOP);
        titleSettings.setForegroundPaint(new ColorProvider(Color.black));
        titleSettings.setBackgroundPaint(new GradientPaintProvider(Color.green, Color.blue));
        titleSettings.getFont().setBold(Boolean.TRUE);
        titleSettings.getFont().setFontSize(22);
        titleSettings.setHorizontalAlignment(HorizontalAlignment.CENTER);
        titleSettings.setVerticalAlignment(VerticalAlignment.TOP);
        titleSettings.setPadding(new RectangleInsets(UnitType.ABSOLUTE, 1.1, 2.2, 3.3, 4.4));
        TitleSettings subtitleSettings = settings.getSubtitleSettings();
        subtitleSettings.setShowTitle(Boolean.TRUE);
        subtitleSettings.setPosition(EdgeEnum.TOP);
        subtitleSettings.setForegroundPaint(new ColorProvider(Color.red));
        subtitleSettings.setBackgroundPaint(new GradientPaintProvider(Color.green, Color.blue));
        subtitleSettings.getFont().setBold(Boolean.TRUE);
        subtitleSettings.setHorizontalAlignment(HorizontalAlignment.LEFT);
        subtitleSettings.setVerticalAlignment(VerticalAlignment.CENTER);
        subtitleSettings.setPadding(new RectangleInsets(UnitType.ABSOLUTE, 1.1, 2.2, 3.3, 4.4));
        LegendSettings legendSettings = settings.getLegendSettings();
        legendSettings.setShowLegend(Boolean.TRUE);
        legendSettings.setPosition(EdgeEnum.BOTTOM);
        legendSettings.setForegroundPaint(new ColorProvider(Color.black));
        legendSettings.setBackgroundPaint(new GradientPaintProvider(Color.green, Color.blue));
        legendSettings.getFont().setBold(Boolean.TRUE);
        legendSettings.setHorizontalAlignment(HorizontalAlignment.CENTER);
        legendSettings.setVerticalAlignment(VerticalAlignment.BOTTOM);
        legendSettings.setPadding(new RectangleInsets(UnitType.ABSOLUTE, 1.1, 2.2, 3.3, 4.4));
        PlotSettings plotSettings = settings.getPlotSettings();
        plotSettings.setOrientation(PlotOrientation.VERTICAL);
        plotSettings.setBackgroundPaint(new GradientPaintProvider(Color.green, Color.blue));
        plotSettings.setBackgroundImage(new FileImageProvider("net/sf/jasperreports/chartthemes/simple/jasperreports.png"));
        plotSettings.setBackgroundImageAlpha(new Float(0.5f));
        plotSettings.setBackgroundImageAlignment(new Integer(5));
        plotSettings.setLabelRotation(new Double(0.0));
        plotSettings.setPadding(new RectangleInsets(UnitType.ABSOLUTE, 1.1, 2.2, 3.3, 4.4));
        plotSettings.setOutlineVisible(Boolean.TRUE);
        plotSettings.setOutlinePaint(new ColorProvider(Color.red));
        plotSettings.setOutlineStroke(new BasicStroke(1.0f));
        plotSettings.setSeriesColorSequence(COLORS);
        plotSettings.setSeriesOutlinePaintSequence(COLORS_DARKER);
        plotSettings.setSeriesStrokeSequence(STROKES);
        plotSettings.setSeriesOutlineStrokeSequence(OUTLINE_STROKES);
        plotSettings.setDomainGridlineVisible(Boolean.TRUE);
        plotSettings.setDomainGridlinePaint(new ColorProvider(Color.DARK_GRAY));
        plotSettings.setDomainGridlineStroke(new BasicStroke(0.5f));
        plotSettings.setRangeGridlineVisible(Boolean.TRUE);
        plotSettings.setRangeGridlinePaint(new ColorProvider(Color.BLACK));
        plotSettings.setRangeGridlineStroke(new BasicStroke(0.5f));
        plotSettings.getTickLabelFont().setFontName("Courier");
        plotSettings.getTickLabelFont().setBold(Boolean.TRUE);
        plotSettings.getTickLabelFont().setFontSize(10);
        plotSettings.getDisplayFont().setFontName("Arial");
        plotSettings.getDisplayFont().setBold(Boolean.TRUE);
        plotSettings.getDisplayFont().setFontSize(12);
        AxisSettings domainAxisSettings = settings.getDomainAxisSettings();
        domainAxisSettings.setVisible(Boolean.TRUE);
        domainAxisSettings.setLocation(AxisLocation.BOTTOM_OR_RIGHT);
        domainAxisSettings.setLinePaint(new ColorProvider(Color.green));
        domainAxisSettings.setLineStroke(new BasicStroke(1.0f));
        domainAxisSettings.setLineVisible(Boolean.TRUE);
        domainAxisSettings.setLabelAngle(new Double(0.0));
        domainAxisSettings.setLabelPaint(new ColorProvider(Color.magenta));
        domainAxisSettings.getLabelFont().setBold(Boolean.TRUE);
        domainAxisSettings.getLabelFont().setItalic(Boolean.TRUE);
        domainAxisSettings.getLabelFont().setFontName("Comic Sans MS");
        domainAxisSettings.getLabelFont().setFontSize(12);
        domainAxisSettings.setLabelInsets(new RectangleInsets(UnitType.ABSOLUTE, 0.5, 0.5, 1.0, 1.0));
        domainAxisSettings.setLabelVisible(Boolean.TRUE);
        domainAxisSettings.setTickLabelPaint(new ColorProvider(Color.cyan));
        domainAxisSettings.getTickLabelFont().setBold(Boolean.TRUE);
        domainAxisSettings.getTickLabelFont().setItalic(Boolean.FALSE);
        domainAxisSettings.getTickLabelFont().setFontName("Arial");
        domainAxisSettings.getTickLabelFont().setFontSize(10);
        domainAxisSettings.setTickLabelInsets(new RectangleInsets(UnitType.ABSOLUTE, 0.5, 0.5, 0.5, 0.5));
        domainAxisSettings.setTickLabelsVisible(Boolean.TRUE);
        domainAxisSettings.setTickMarksInsideLength(new Float(0.1f));
        domainAxisSettings.setTickMarksOutsideLength(new Float(0.2f));
        domainAxisSettings.setTickMarksPaint(new ColorProvider(Color.ORANGE));
        domainAxisSettings.setTickMarksStroke(new BasicStroke(1.0f));
        domainAxisSettings.setTickMarksVisible(Boolean.TRUE);
        domainAxisSettings.setTickCount(new Integer(5));
        AxisSettings rangeAxisSettings = settings.getRangeAxisSettings();
        rangeAxisSettings.setVisible(Boolean.TRUE);
        rangeAxisSettings.setLocation(AxisLocation.TOP_OR_RIGHT);
        rangeAxisSettings.setLinePaint(new ColorProvider(Color.yellow));
        rangeAxisSettings.setLineStroke(new BasicStroke(1.0f));
        rangeAxisSettings.setLineVisible(Boolean.TRUE);
        rangeAxisSettings.setLabelAngle(new Double(1.5707963267948966));
        rangeAxisSettings.setLabelPaint(new ColorProvider(Color.green));
        rangeAxisSettings.getLabelFont().setBold(Boolean.TRUE);
        rangeAxisSettings.getLabelFont().setItalic(Boolean.TRUE);
        rangeAxisSettings.getLabelFont().setFontName("Comic Sans MS");
        rangeAxisSettings.getLabelFont().setFontSize(12);
        rangeAxisSettings.setLabelInsets(new RectangleInsets(UnitType.ABSOLUTE, 0.5, 0.5, 1.0, 1.0));
        rangeAxisSettings.setLabelVisible(Boolean.TRUE);
        rangeAxisSettings.setTickLabelPaint(new ColorProvider(Color.pink));
        rangeAxisSettings.getTickLabelFont().setBold(Boolean.FALSE);
        rangeAxisSettings.getTickLabelFont().setItalic(Boolean.TRUE);
        rangeAxisSettings.getTickLabelFont().setFontName("Arial");
        rangeAxisSettings.getTickLabelFont().setFontSize(10);
        rangeAxisSettings.setTickLabelInsets(new RectangleInsets(UnitType.ABSOLUTE, 0.5, 0.5, 0.5, 0.5));
        rangeAxisSettings.setTickLabelsVisible(Boolean.TRUE);
        rangeAxisSettings.setTickMarksInsideLength(new Float(0.2f));
        rangeAxisSettings.setTickMarksOutsideLength(new Float(0.1f));
        rangeAxisSettings.setTickMarksPaint(new ColorProvider(Color.black));
        rangeAxisSettings.setTickMarksStroke(new BasicStroke(1.0f));
        rangeAxisSettings.setTickMarksVisible(Boolean.TRUE);
        rangeAxisSettings.setTickCount(new Integer(6));
        return settings;
    }
}

