/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.security;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.PermissionOverride;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthorizationServiceException;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.acl.AclEntry;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.vote.BasicAclEntryVoter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSensitiveAclEntryVoter
extends BasicAclEntryVoter {
    public static final String DEFAULT_PERMS = "default";
    private static final Log logger = LogFactory.getLog(ContextSensitiveAclEntryVoter.class);
    private Map<String, int[]> requiredPermissionsMap;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getProcessConfigAttribute(), (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)this.getAclManager(), (String)"An aclManager is mandatory");
        if (this.requiredPermissionsMap == null || this.requiredPermissionsMap.size() == 0) {
            throw new IllegalArgumentException("One or more requiredPermissionsMap entries are mandatory");
        }
    }

    protected int[] getEffectivePermissions(Object secureObject) {
        if (!(secureObject instanceof MethodInvocation)) {
            throw new AuthorizationServiceException("Secure object: " + secureObject + " is not a MethodInvocation");
        }
        MethodInvocation invocation = (MethodInvocation)secureObject;
        Object[] args = invocation.getArguments();
        ExecutionContext ctx = null;
        PermissionOverride permOverride = null;
        if (args[0] instanceof ExecutionContext) {
            ctx = (ExecutionContext)args[0];
        }
        if (ctx != null && ctx.getAttributes() != null) {
            for (Object a : ctx.getAttributes()) {
                if (!(a instanceof PermissionOverride)) continue;
                permOverride = (PermissionOverride)a;
            }
        }
        String permsId = DEFAULT_PERMS;
        if (permOverride != null && this.requiredPermissionsMap != null && this.requiredPermissionsMap.containsKey(permOverride.getOverrideId())) {
            permsId = permOverride.getOverrideId();
        }
        int[] perms = this.requiredPermissionsMap.get(permsId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("looked up perms for " + permsId + ": " + perms));
        }
        if (perms == null) {
            throw new IllegalArgumentException("perms not found for key " + permsId);
        }
        return perms;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        int[] effectivePerms = this.getEffectivePermissions(object);
        for (ConfigAttribute attr : config.getConfigAttributes()) {
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (logger.isDebugEnabled()) {
                MethodInvocation invocation = (MethodInvocation)object;
                StringBuffer msg = new StringBuffer("calling " + invocation.getMethod().getName());
                if (domainObject instanceof String) {
                    msg.append(" on " + domainObject);
                }
                logger.debug((Object)msg);
            }
            if (domainObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to abstain - domainObject is null");
                }
                return 0;
            }
            if (effectivePerms[0] == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"no required perms, granting access");
                }
                return 1;
            }
            AclEntry[] acls = this.getAclManager().getAcls(domainObject, authentication);
            if (acls == null || acls.length == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to deny access - no ACLs returned for this principal");
                }
                return -1;
            }
            for (int i = 0; i < acls.length; ++i) {
                if (!(acls[i] instanceof BasicAclEntry)) continue;
                BasicAclEntry processableAcl = (BasicAclEntry)acls[i];
                for (int y = 0; y < effectivePerms.length; ++y) {
                    if (!processableAcl.isPermitted(effectivePerms[y])) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Voting to grant access");
                    }
                    return 1;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Voting to deny access - ACLs returned, but insufficient permissions for this principal");
            }
            return -1;
        }
        return 0;
    }

    public void setRequiredPermissionsMap(Map<String, int[]> overridePermissionsMap) {
        this.requiredPermissionsMap = overridePermissionsMap;
    }

    public Map<String, int[]> getRequiredPermissionsMap() {
        return this.requiredPermissionsMap;
    }
}

