/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationDetailImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationResultImpl;
import com.jaspersoft.jasperserver.api.common.util.StaticCharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapClientConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.MondrianConnectionDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.RepositoryCatalogLocator;
import com.jaspersoft.jasperserver.api.metadata.olap.service.impl.XmlaConnectionDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.tonbeller.jpivot.core.Model;
import com.tonbeller.jpivot.core.ModelFactory;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.tags.MondrianOlapModelTag;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_OlapModelTag;
import com.tonbeller.wcf.controller.RequestContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.servlet.http.HttpSession;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.CatalogLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class OlapConnectionServiceImpl
implements OlapConnectionService,
ReportDataSourceServiceFactory {
    private static final Log log = LogFactory.getLog(OlapConnectionServiceImpl.class);
    private UserAuthorityService userService;
    private TenantService tenantService;
    private CatalogLocator repositoryCatalogLocator = new RepositoryCatalogLocator();
    private RepositoryService mRepository;
    private StaticCharacterEncodingProvider encodingProvider;

    public OlapModel createOlapModel(ExecutionContext context, OlapUnit olapUnit) {
        OlapClientConnection clientConn = (OlapClientConnection)this.dereference(context, olapUnit.getOlapClientConnection());
        if (clientConn instanceof XMLAConnection) {
            return this.createXmlaModel(context, olapUnit);
        }
        String mdx = olapUnit.getMdxQuery();
        MondrianConnection conn = (MondrianConnection)clientConn;
        MondrianModel model = null;
        try {
            model = (MondrianModel)ModelFactory.instance((URL)this.getDefaultMondrianConfig());
        }
        catch (Exception e) {
            throw new JSException((Throwable)e);
        }
        model.setMdxQuery(mdx);
        model.setConnectProperties(this.getMondrianConnectProperties(context, conn));
        model.setDynLocale(String.valueOf(LocaleContextHolder.getLocale()));
        model.setCatalogLocator(this.repositoryCatalogLocator);
        return model;
    }

    protected URL getDefaultMondrianConfig() {
        return MondrianOlapModelTag.class.getResource("/com/tonbeller/jpivot/mondrian/config.xml");
    }

    protected URL getDefaultXMLAConfig() {
        return XMLA_OlapModelTag.class.getResource("config.xml");
    }

    public OlapModel createXmlaModel(ExecutionContext context, OlapUnit xmlaUnit) {
        Model model;
        String mdx = xmlaUnit.getMdxQuery();
        XMLAConnection xmlaConn = (XMLAConnection)this.dereference(context, xmlaUnit.getOlapClientConnection());
        URL url = this.getDefaultXMLAConfig();
        try {
            model = ModelFactory.instance((URL)url);
        }
        catch (Exception e) {
            throw new JSException((Throwable)e);
        }
        if (!(model instanceof XMLA_Model)) {
            throw new JSException("jsexception.invalid.class.attribute.for.model.tag", new Object[]{this.getDefaultXMLAConfig()});
        }
        XMLA_Model xmlaModel = (XMLA_Model)model;
        xmlaModel.setCatalog(xmlaConn.getCatalog());
        if (this.lacksAuthentication(xmlaConn)) {
            MetadataUserDetails user = this.getCurrentUserDetails();
            String fullyQualifiedName = user.getUsername();
            if (user.getTenantId() != null) {
                fullyQualifiedName = fullyQualifiedName + this.tenantService.getUserOrgIdDelimiter() + user.getTenantId();
            }
            xmlaModel.setUser(fullyQualifiedName);
            xmlaModel.setPassword(user.getPassword());
        } else {
            xmlaModel.setUser(xmlaConn.getUsername());
            xmlaModel.setPassword(xmlaConn.getPassword());
        }
        xmlaModel.setDataSource(xmlaConn.getDataSource());
        xmlaModel.setMdxQuery(mdx);
        xmlaModel.setID(xmlaConn.getCatalog() + "-" + xmlaUnit.hashCode());
        xmlaModel.setUri(xmlaConn.getURI());
        log.debug((Object)("XMLA USERNAME = " + xmlaModel.getUser()));
        log.debug((Object)("XMLA PASSWORD = " + xmlaModel.getPassword()));
        return xmlaModel;
    }

    protected boolean lacksAuthentication(XMLAConnection xmlaConn) {
        return xmlaConn.getUsername() == null || xmlaConn.getPassword() == null || xmlaConn.getUsername().equals("") || xmlaConn.getPassword().equals("");
    }

    protected MetadataUserDetails getCurrentUserDetails() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            return (MetadataUserDetails)auth.getPrincipal();
        }
        return null;
    }

    public ValidationResult validate(ExecutionContext context, OlapUnit unit) {
        return this.validate(context, unit, null, null, null);
    }

    public ValidationResult validate(ExecutionContext context, OlapUnit unit, FileResource schema, OlapClientConnection conn, ReportDataSource dataSource) {
        ValidationResultImpl result = new ValidationResultImpl();
        this.validateMDX(context, result, unit, schema, conn, dataSource);
        return result;
    }

    protected void validateMDX(ExecutionContext context, ValidationResultImpl result, OlapUnit unit) {
        this.validateMDX(context, result, unit, null, null, null);
    }

    protected void validateMDX(ExecutionContext context, ValidationResultImpl result, OlapUnit unit, FileResource schema, OlapClientConnection conn, ReportDataSource dataSource) {
        MondrianConnection resource = null;
        if (conn instanceof MondrianConnection) {
            resource = (MondrianConnection)conn;
        }
        if (resource == null) {
            resource = this.getConnectionResource(context, unit);
        }
        if (resource == null) {
            return;
        }
        try {
            Connection monConnection = this.getMondrianConnection(context, resource, dataSource);
            monConnection.parseQuery(unit.getMdxQuery());
        }
        catch (Exception e) {
            ValidationDetailImpl detail = new ValidationDetailImpl();
            detail.setValidationClass(OlapUnit.class);
            detail.setName(unit.getName());
            detail.setLabel(unit.getLabel());
            detail.setResult("ERROR");
            detail.setException(e);
            detail.setMessage(e.getMessage());
            result.addValidationDetail((ValidationDetail)detail);
            log.warn((Object)("Validation Failed for Olap Unit: " + unit.getName()), (Throwable)e);
        }
    }

    public MondrianConnection getConnection(ExecutionContext context, String resourceName) {
        return (MondrianConnection)this.getRepository().getResource(context, resourceName);
    }

    public MondrianConnection getConnectionResource(ExecutionContext context, OlapUnit unit) {
        Resource clientConn = this.dereference(context, unit.getOlapClientConnection());
        if (clientConn instanceof MondrianConnection) {
            return (MondrianConnection)clientConn;
        }
        if (clientConn instanceof XMLAConnection) {
            // empty if block
        }
        return null;
    }

    public Connection getMondrianConnection(ExecutionContext context, String connResourceName) {
        MondrianConnection conn = this.getConnection(context, connResourceName);
        if (conn == null) {
            log.error((Object)("missing MondrianConnection resource: " + connResourceName));
            throw new JSException("jsexception.mondrian.no.connection.for.resource", new Object[]{connResourceName});
        }
        return this.getMondrianConnection(context, conn);
    }

    private Connection getMondrianConnection(ExecutionContext context, MondrianConnection conn) {
        return this.getMondrianConnection(context, conn, null);
    }

    protected Connection getMondrianConnection(ExecutionContext context, MondrianConnection conn, ReportDataSource dataSource) {
        Util.PropertyList connectProps = this.getMondrianConnectProperties(context, conn, dataSource);
        if (log.isDebugEnabled()) {
            log.debug((Object)("connection properties prepared: " + connectProps));
        }
        return DriverManager.getConnection((Util.PropertyList)connectProps, (CatalogLocator)this.repositoryCatalogLocator);
    }

    public void initializeAndShow(OlapModelProxy omp, String viewUri, OlapModel model, OlapUnit unit) throws Exception {
        omp.initializeAndShow(viewUri, model);
    }

    public OlapModel initializeOlapModel(ExecutionContext executionContext, OlapUnit olapUnit, HttpSession sess) {
        RequestContext context = RequestContext.instance();
        OlapModel model = this.createOlapModel(executionContext, olapUnit);
        if (model == null) {
            throw new JSException("jsexception.no.olap.model.created.for", new Object[]{olapUnit.getURIString()});
        }
        model = (OlapModel)model.getTopDecorator();
        model.setLocale(context.getLocale());
        model.setServletContext(sess.getServletContext());
        model.setID(olapUnit.getURIString());
        OlapModelProxy omp = OlapModelProxy.instance((String)olapUnit.getURIString(), (HttpSession)sess, (boolean)false);
        try {
            this.initializeAndShow(omp, olapUnit.getURIString(), model, olapUnit);
        }
        catch (Exception e) {
            throw new JSException((Throwable)e);
        }
        return omp;
    }

    public String getFileResourceData(ExecutionContext context, FileResource file) {
        InputStream data;
        RepositoryService rep = this.getRepository();
        StringBuffer fileString = new StringBuffer();
        if (file.hasData()) {
            data = file.getDataStream();
        } else {
            log.debug((Object)("FILE URI STRING = " + file.getURIString()));
            FileResourceData resourceData = rep.getResourceData(context, file.getURIString());
            data = resourceData.getDataStream();
        }
        log.debug((Object)("FILE = " + file));
        String encoding = this.getEncodingProvider().getCharacterEncoding();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(data, encoding));
            while ((line = in.readLine()) != null) {
                fileString.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return fileString.toString();
    }

    public Util.PropertyList getMondrianConnectProperties(ExecutionContext context, MondrianConnection conn) {
        return this.getMondrianConnectProperties(context, conn, null);
    }

    public Util.PropertyList getMondrianConnectProperties(ExecutionContext context, MondrianConnection conn, ReportDataSource dataSource) {
        if (dataSource == null && (dataSource = (ReportDataSource)this.dereference(context, conn.getDataSource())) == null) {
            throw new JSException("null data source on dereference of mondrian connection " + conn.getURIString() + " for " + (conn.getDataSource().isLocal() ? "local: " + conn.getDataSource().getLocalResource().getURIString() : conn.getDataSource().getReferenceURI()));
        }
        Util.PropertyList connectProps = new Util.PropertyList();
        connectProps.put(RolapConnectionProperties.Provider.toString(), "mondrian");
        String transformedUri = this.repositoryCatalogLocator.locate(this.transformUri(conn.getSchema().getReferenceURI()));
        transformedUri = connectProps.put(RolapConnectionProperties.Catalog.toString(), transformedUri);
        connectProps.put(RolapConnectionProperties.UseContentChecksum.toString(), "true");
        if (dataSource instanceof JdbcReportDataSource) {
            JdbcReportDataSource jdbcDataSource = (JdbcReportDataSource)dataSource;
            connectProps.put(RolapConnectionProperties.Jdbc.toString(), jdbcDataSource.getConnectionUrl());
            String driverClassName = jdbcDataSource.getDriverClass();
            connectProps.put(RolapConnectionProperties.JdbcDrivers.toString(), driverClassName);
            try {
                log.info((Object)("Loading jdbc driver: " + driverClassName));
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)("CANNOT LOAD DRIVER: " + driverClassName));
                throw new JSException((Throwable)cnfe);
            }
            if (jdbcDataSource.getUsername() != null && jdbcDataSource.getUsername().trim().length() > 0) {
                connectProps.put(RolapConnectionProperties.JdbcUser.toString(), jdbcDataSource.getUsername());
            }
            if (jdbcDataSource.getPassword() != null && jdbcDataSource.getPassword().trim().length() > 0) {
                connectProps.put(RolapConnectionProperties.JdbcPassword.toString(), jdbcDataSource.getPassword());
            }
        } else {
            JndiJdbcReportDataSource jndiDataSource = (JndiJdbcReportDataSource)dataSource;
            String jndiURI = jndiDataSource.getJndiName() != null && !jndiDataSource.getJndiName().startsWith("java:") ? "java:comp/env/" : "";
            jndiURI = jndiURI + jndiDataSource.getJndiName();
            connectProps.put(RolapConnectionProperties.DataSource.toString(), jndiURI);
        }
        return connectProps;
    }

    protected String transformUri(String uri) {
        return uri;
    }

    public Resource dereference(ExecutionContext context, ResourceReference ref) {
        if (ref.isLocal()) {
            return ref.getLocalResource();
        }
        context = ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)context);
        return this.getRepository().getResource(context, ref.getReferenceURI());
    }

    public void saveResource(ExecutionContext context, String path, Resource resource) {
        String targetUri;
        RepositoryService rep = this.getRepository();
        if (rep.resourceExists(context, targetUri = path + (path.endsWith("/") ? "" : "/") + resource.getName())) {
            return;
        }
        Folder folder = this.mkdirs(context, path);
        resource.setParentFolder(folder);
        rep.saveResource(context, resource);
    }

    public Folder mkdirs(ExecutionContext context, String path) {
        RepositoryService rep = this.getRepository();
        String[] splitPath = path.split("/");
        String folderName = "/";
        Folder parentFolder = null;
        Folder folder = rep.getFolder(context, folderName);
        for (int i = 0; i < splitPath.length; ++i) {
            log.debug((Object)("Current path element is " + splitPath[i]));
            if ("".equals(splitPath[i])) continue;
            log.debug((Object)("Folder name '" + folderName + "' yields folder '" + folder + "'"));
            if (!folderName.equals("/")) {
                folderName = folderName + "/";
            }
            folderName = folderName + splitPath[i];
            parentFolder = folder;
            folder = rep.getFolder(context, folderName);
            if (folder != null) continue;
            folder = new FolderImpl();
            folder.setName(splitPath[i]);
            folder.setLabel(splitPath[i]);
            folder.setDescription(splitPath[i] + " folder");
            folder.setParentFolder(parentFolder);
            rep.saveFolder(context, folder);
        }
        log.debug((Object)("Folder name '" + folderName + "' yields folder '" + folder + "'"));
        return folder;
    }

    public RepositoryService getRepository() {
        return this.mRepository;
    }

    public void setRepository(RepositoryService repository) {
        this.mRepository = repository;
    }

    public StaticCharacterEncodingProvider getEncodingProvider() {
        return this.encodingProvider;
    }

    public void setEncodingProvider(StaticCharacterEncodingProvider encodingProviderIn) {
        this.encodingProvider = encodingProviderIn;
    }

    public ReportDataSourceService createService(ReportDataSource dataSource) {
        Object dsService;
        if (dataSource instanceof MondrianConnection) {
            MondrianConnection mondrianConnection = (MondrianConnection)dataSource;
            Connection connection = this.getMondrianConnection(null, mondrianConnection);
            dsService = new MondrianConnectionDataSourceService(connection);
        } else if (dataSource instanceof XMLAConnection) {
            String tenantSeparator;
            XMLAConnection xmlaConnection = (XMLAConnection)dataSource;
            String string = tenantSeparator = this.tenantService != null ? this.tenantService.getUserOrgIdDelimiter() : null;
            if (this.lacksAuthentication(xmlaConnection)) {
                MetadataUserDetails user = this.getCurrentUserDetails();
                dsService = new XmlaConnectionDataSourceService(xmlaConnection, tenantSeparator, user);
            } else {
                dsService = new XmlaConnectionDataSourceService(xmlaConnection, tenantSeparator);
            }
        } else {
            throw new JSException("jsexception.invalid.olap.datasource", new Object[]{dataSource.getClass()});
        }
        return dsService;
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

