/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoInputControl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoQuery;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;
import java.util.ArrayList;
import java.util.List;

public class RepoReportUnit
extends RepoResource {
    private RepoResource dataSource = null;
    private RepoQuery query = null;
    private List resources;
    private List inputControls;
    private RepoFileResource mainReport = null;
    private String inputControlRenderingView;
    private String reportRenderingView;
    private boolean alwaysPromptControls;
    private byte controlsLayout;

    public RepoResource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(RepoResource dataSource) {
        this.dataSource = dataSource;
    }

    public RepoQuery getQuery() {
        return this.query;
    }

    public void setQuery(RepoQuery query) {
        this.query = query;
    }

    public List getInputControls() {
        return this.inputControls;
    }

    public void setInputControls(List inputControls) {
        this.inputControls = inputControls;
    }

    public List getResources() {
        return this.resources;
    }

    public void setResources(List resources) {
        this.resources = resources;
    }

    public RepoFileResource getMainReport() {
        return this.mainReport;
    }

    public void setMainReport(RepoFileResource mainReport) {
        this.mainReport = mainReport;
    }

    public String getInputControlRenderingView() {
        return this.inputControlRenderingView;
    }

    public void setInputControlRenderingView(String inputControlRenderingView) {
        this.inputControlRenderingView = inputControlRenderingView;
    }

    public String getReportRenderingView() {
        return this.reportRenderingView;
    }

    public void setReportRenderingView(String reportRenderingView) {
        this.reportRenderingView = reportRenderingView;
    }

    public boolean isAlwaysPromptControls() {
        return this.alwaysPromptControls;
    }

    public void setAlwaysPromptControls(boolean alwaysPromptControls) {
        this.alwaysPromptControls = alwaysPromptControls;
    }

    public byte getControlsLayout() {
        return this.controlsLayout;
    }

    public void setControlsLayout(byte controlsLayout) {
        this.controlsLayout = controlsLayout;
    }

    public ValidationResult validate() {
        return null;
    }

    protected Class getClientItf() {
        return ReportUnit.class;
    }

    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        ReportUnit unit = (ReportUnit)clientRes;
        unit.setDataSource(this.getClientReference(this.getDataSource(), resourceFactory));
        unit.setMainReport(this.getClientReference(this.getMainReport(), resourceFactory));
        unit.setQuery(this.getClientReference(this.getQuery(), resourceFactory));
        List resList = this.getResources();
        for (RepoFileResource fileRes : resList) {
            unit.addResource(this.getClientReference(fileRes, resourceFactory));
        }
        List inputCtrls = this.getInputControls();
        for (RepoInputControl inputControl : inputCtrls) {
            unit.addInputControl(this.getClientReference(inputControl, resourceFactory));
        }
        unit.setInputControlRenderingView(this.getInputControlRenderingView());
        unit.setReportRenderingView(this.getReportRenderingView());
        unit.setAlwaysPromptControls(this.isAlwaysPromptControls());
        unit.setControlsLayout(this.getControlsLayout());
    }

    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        ReportUnit unit = (ReportUnit)clientRes;
        this.copyResources(referenceResolver, unit);
        this.copyDataSource(referenceResolver, unit);
        this.copyMainReport(referenceResolver, unit);
        ResourceReference unitQuery = unit.getQuery();
        this.setQuery((RepoQuery)this.getReference(unitQuery, RepoQuery.class, referenceResolver));
        List clientInputCtrls = unit.getInputControls();
        ArrayList<RepoResource> inputCtrls = new ArrayList<RepoResource>();
        if (clientInputCtrls != null && !clientInputCtrls.isEmpty()) {
            for (ResourceReference inputCtrlRef : clientInputCtrls) {
                inputCtrls.add(this.getReference(inputCtrlRef, RepoInputControl.class, referenceResolver));
            }
        }
        this.setInputControls(inputCtrls);
        this.setInputControlRenderingView(unit.getInputControlRenderingView());
        this.setReportRenderingView(unit.getReportRenderingView());
        this.setAlwaysPromptControls(unit.isAlwaysPromptControls());
        this.setControlsLayout(unit.getControlsLayout());
    }

    private void copyMainReport(ReferenceResolver referenceResolver, ReportUnit unit) {
        ResourceReference report = unit.getMainReport();
        RepoFileResource repoReport = (RepoFileResource)this.getReference(report, RepoFileResource.class, referenceResolver);
        this.setMainReport(repoReport);
    }

    private void copyDataSource(ReferenceResolver referenceResolver, ReportUnit unit) {
        ResourceReference ds = unit.getDataSource();
        RepoResource repoDS = this.getReference(ds, RepoReportDataSource.class, referenceResolver);
        if (repoDS != null && !(repoDS instanceof RepoReportDataSource)) {
            throw new JSException("jsexception.report.unit.datasource.has.an.invalid.type", new Object[]{repoDS.getClass().getName()});
        }
        this.setDataSource(repoDS);
    }

    private void copyResources(ReferenceResolver referenceResolver, ReportUnit unit) {
        List clientResources = unit.getResources();
        ArrayList<RepoFileResource> resList = new ArrayList<RepoFileResource>();
        if (clientResources != null && !clientResources.isEmpty()) {
            for (ResourceReference resourceRef : clientResources) {
                RepoFileResource repoRes = (RepoFileResource)this.getReference(resourceRef, RepoFileResource.class, referenceResolver);
                resList.add(repoRes);
            }
        }
        this.setResources(resList);
    }
}

