/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.util;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.spring.StaticApplicationContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryFileSystem;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class RepositoryFileObject
extends AbstractFileObject
implements FileObject {
    private static final Log log = LogFactory.getLog(RepositoryFileObject.class);
    RepositoryService repositoryService;
    FileResource fileResource = null;
    FileResourceData resourceData = null;
    Folder folder = null;
    String scheme;

    protected RepositoryFileObject(RepositoryFileSystem fs, String scheme, FileName fileName) {
        super(fileName, (AbstractFileSystem)fs);
        this.scheme = scheme;
    }

    protected FileType doGetType() throws Exception {
        if (this.folder != null) {
            return FileType.FOLDER;
        }
        if (this.fileResource != null) {
            return FileType.FILE;
        }
        return FileType.IMAGINARY;
    }

    protected String[] doListChildren() throws Exception {
        if (this.doGetType() != FileType.FOLDER) {
            return new String[0];
        }
        FilterCriteria filter = FilterCriteria.createFilter();
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)this.getName().getPath()));
        ResourceLookup[] resourceResults = this.getRepositoryService().findResource(null, filter);
        List subFolders = this.getRepositoryService().getSubFolders(null, this.getName().getPath());
        String[] results = new String[resourceResults.length + subFolders.size()];
        int pos = 0;
        for (ResourceLookup lookup : resourceResults) {
            results[pos++] = lookup.getName();
        }
        for (Object aFolder : subFolders) {
            results[pos++] = ((Folder)aFolder).getName();
        }
        return results;
    }

    protected long doGetContentSize() throws Exception {
        if (this.doGetType() != FileType.FILE) {
            return 0L;
        }
        if (this.fileResource == null) {
            throw new JSException("no resource. URI: " + this.getName());
        }
        if (this.resourceData != null) {
            return this.resourceData.dataSize();
        }
        if (this.fileResource.hasData()) {
            return this.fileResource.getData().length;
        }
        return 0L;
    }

    protected void doAttach() throws Exception {
        String resourceName = this.getName().getPath();
        log.debug((Object)("Loading resource: " + resourceName));
        this.fileResource = (FileResource)this.getRepositoryService().getResource(null, resourceName);
        if (this.fileResource == null) {
            this.folder = this.getRepositoryService().getFolder(null, resourceName);
        } else {
            log.debug((Object)("has data: " + (this.fileResource == null ? "null" : "" + this.fileResource.hasData())));
            log.debug((Object)("isReference: " + (this.fileResource == null ? "null" : "" + this.fileResource.isReference())));
            if (this.fileResource != null && !this.fileResource.hasData()) {
                this.resourceData = this.getRepositoryService().getResourceData(null, this.fileResource.getURIString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream doGetInputStream() throws Exception {
        if (this.fileResource == null) {
            throw new JSException("no resource. URI: " + this.getName());
        }
        InputStream data = this.resourceData != null ? this.resourceData.getDataStream() : this.fileResource.getDataStream();
        BufferedInputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOut = new BufferedOutputStream(out);
        try {
            in = new BufferedInputStream(data);
            byte[] buf = new byte[10000];
            int numRead = 0;
            while ((numRead = ((InputStream)in).read(buf)) != -1) {
                bufferedOut.write(buf, 0, numRead);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            bufferedOut.flush();
        }
        return new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
    }

    public RepositoryService getRepositoryService() {
        Properties springConfiguration;
        if (this.repositoryService != null) {
            return this.repositoryService;
        }
        ApplicationContext ctx = StaticApplicationContext.getApplicationContext();
        if (ctx == null) {
            throw new JSException("StaticApplicationContext not configured in Spring");
        }
        try {
            springConfiguration = (Properties)ctx.getBean("springConfiguration");
        }
        catch (NoSuchBeanDefinitionException e) {
            springConfiguration = new Properties();
            log.debug((Object)"RepositoryFileObject#doAttach : no spring configuration properties");
        }
        String repositoryServiceName = "repositoryService";
        if (this.scheme.equals("repo")) {
            if (springConfiguration.containsKey("bean.repositoryService")) {
                repositoryServiceName = springConfiguration.getProperty("bean.repositoryService");
            }
        } else if (springConfiguration.containsKey("bean.internalRepositoryService")) {
            repositoryServiceName = springConfiguration.getProperty("bean.internalRepositoryService");
        }
        this.repositoryService = (RepositoryService)ctx.getBean(repositoryServiceName);
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

