/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class RepoQuery
extends RepoResource {
    private static final int MAX_QUERY_TEXT = 3600;
    private RepoResource dataSource = null;
    private String language;
    private String sql;

    public RepoResource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(RepoResource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    protected Class getClientItf() {
        return Query.class;
    }

    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        Query query = (Query)clientRes;
        this.copyDataSource(referenceResolver, query);
        this.setLanguage(query.getLanguage());
        String queryText = query.getSql();
        if (queryText.length() > 3600) {
            byte[] compressed;
            try {
                compressed = RepoQuery.compress(queryText);
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected i/o exception on compression", e);
            }
            queryText = new BASE64Encoder().encode(compressed);
        }
        this.setSql(queryText);
    }

    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        Query query = (Query)clientRes;
        query.setDataSource(this.getClientReference(this.getDataSource(), resourceFactory));
        query.setLanguage(this.getLanguage());
        String queryText = this.getSql();
        try {
            String normalizedBuffer = queryText.replaceAll("\\s+", System.getProperty("line.separator"));
            byte[] gzipped = new BASE64Decoder().decodeBuffer(normalizedBuffer);
            queryText = RepoQuery.uncompress(gzipped);
        }
        catch (Exception e) {
            // empty catch block
        }
        query.setSql(queryText);
    }

    public static String uncompress(byte[] compressed) throws IOException {
        String line;
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        GZIPInputStream gzis = new GZIPInputStream(bais);
        BufferedReader br = new BufferedReader(new InputStreamReader(gzis));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static byte[] compress(String string) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        OutputStreamWriter osw = new OutputStreamWriter(gzos);
        osw.write(string);
        osw.flush();
        osw.close();
        return baos.toByteArray();
    }

    private void copyDataSource(ReferenceResolver referenceResolver, Query query) {
        ResourceReference ds = query.getDataSource();
        if (ds != null) {
            RepoResource repoDS = this.getReference(ds, RepoReportDataSource.class, referenceResolver);
            if (repoDS != null && !(repoDS instanceof RepoReportDataSource)) {
                throw new JSException("jsexception.query.datasource.has.an.invalid.type", new Object[]{repoDS.getClass().getName()});
            }
            this.setDataSource(repoDS);
        } else {
            this.setDataSource(null);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

