/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCache;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.CachedItem;
import com.jaspersoft.jasperserver.api.metadata.common.util.LocalLockManager;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockHandle;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class HibernateRepositoryCache
extends HibernateDaoImpl
implements RepositoryCache {
    private static final Log log = LogFactory.getLog(HibernateRepositoryCache.class);
    private RepositoryService repository;
    private LockManager lockManager = new LocalLockManager();

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public InputStream cache(ExecutionContext context, FileResource resource, RepositoryCacheableItem cacheableItem) {
        CachedItem cachedItem = this.getCachedItem(context, resource, cacheableItem);
        while (cachedItem.isItemReference()) {
            cachedItem = cachedItem.getReference();
        }
        return new ByteArrayInputStream(cachedItem.getDataBytes());
    }

    public InputStream cache(ExecutionContext context, String uri, RepositoryCacheableItem cacheableItem) {
        FileResource resource = (FileResource)this.repository.getResource(context, uri);
        return this.cache(context, resource, cacheableItem);
    }

    protected LockHandle lock(FileResource resource, RepositoryCacheableItem cacheableItem) {
        return this.lockManager.lock(cacheableItem.getCacheName(), resource.getURIString());
    }

    protected void unlock(LockHandle lock) {
        this.lockManager.unlock(lock);
    }

    protected Pair getLockKey(FileResource resource, RepositoryCacheableItem cacheableItem) {
        return new Pair((Object)resource.getURIString(), (Object)cacheableItem.getCacheName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CachedItem getCachedItem(ExecutionContext context, FileResource resource, RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking in repository cache \"" + cacheableItem.getCacheName() + "\" for resource \"" + resource.getURIString() + "\", version " + resource.getVersion() + "\", version date " + resource.getCreationDate()));
        }
        LockHandle lock = this.lock(resource, cacheableItem);
        try {
            FileResource ref;
            CachedItem refItem;
            CachedItem cachedItem = this.getCachedItem(resource.getURIString(), cacheableItem);
            if (cachedItem == null || cachedItem.getVersion() < resource.getVersion() || cachedItem.getVersionDate() == null || cachedItem.getVersionDate().before(resource.getCreationDate())) {
                cachedItem = resource.isReference() ? this.saveRefence(context, resource, cachedItem, cacheableItem) : this.saveData(context, resource, cachedItem, cacheableItem);
            } else if (resource.isReference() && !(refItem = this.getCachedItem(context, ref = (FileResource)this.repository.getResource(context, resource.getReferenceURI()), cacheableItem)).equals(cachedItem.getReference())) {
                this.updateReference(cachedItem, refItem);
            }
            CachedItem cachedItem2 = cachedItem;
            return cachedItem2;
        }
        finally {
            this.unlock(lock);
        }
    }

    protected CachedItem getCachedItem(String uri, RepositoryCacheableItem cacheableItem) {
        DetachedCriteria criteria = DetachedCriteria.forClass(CachedItem.class);
        criteria.add((Criterion)Restrictions.naturalId().set("cacheName", (Object)cacheableItem.getCacheName()).set("uri", (Object)uri));
        List list = this.getHibernateTemplate().findByCriteria(criteria);
        CachedItem item = null;
        if (list.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("did not find \"" + uri + "\" in cache " + cacheableItem.getCacheName()));
            }
            item = null;
        } else {
            item = (CachedItem)list.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("found \"" + uri + "\" in cache " + cacheableItem.getCacheName() + ". isReference: " + item.isItemReference()));
            }
        }
        return item;
    }

    protected CachedItem saveRefence(ExecutionContext context, FileResource resource, CachedItem item, RepositoryCacheableItem cacheableItem) {
        FileResource ref = (FileResource)this.repository.getResource(context, resource.getReferenceURI());
        CachedItem refItem = this.getCachedItem(context, ref, cacheableItem);
        CachedItem saveItem = item == null ? new CachedItem() : item;
        saveItem.setCacheName(cacheableItem.getCacheName());
        saveItem.setData(null);
        saveItem.setReference(refItem);
        saveItem.setUri(resource.getURIString());
        saveItem.setVersion(resource.getVersion());
        saveItem.setVersionDate(resource.getCreationDate());
        if (item == null) {
            this.getHibernateTemplate().save((Object)saveItem);
        } else {
            this.getHibernateTemplate().update((Object)saveItem);
        }
        return saveItem;
    }

    protected CachedItem saveData(ExecutionContext context, FileResource resource, CachedItem item, RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving repository cache \"" + cacheableItem.getCacheName() + "\" for resource \"" + resource.getURIString() + "\", version " + resource.getVersion() + "\", version date " + resource.getCreationDate()));
        }
        byte[] data = cacheableItem.getData(context, resource);
        CachedItem saveItem = item == null ? new CachedItem() : item;
        saveItem.setCacheName(cacheableItem.getCacheName());
        saveItem.setDataBytes(data);
        saveItem.setReference(null);
        saveItem.setUri(resource.getURIString());
        saveItem.setVersion(resource.getVersion());
        saveItem.setVersionDate(resource.getCreationDate());
        if (item == null) {
            this.getHibernateTemplate().save((Object)saveItem);
        } else {
            this.getHibernateTemplate().update((Object)saveItem);
        }
        return saveItem;
    }

    protected void updateReference(CachedItem item, CachedItem refItem) {
        item.setReference(refItem);
        this.getHibernateTemplate().update((Object)item);
    }

    public void clearCache(final String uri, final RepositoryCacheableItem cacheableItem) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryCache.this.removeCached(uri, cacheableItem);
                return null;
            }
        }, false);
    }

    protected void removeCached(String uri, RepositoryCacheableItem cacheableItem) {
        CachedItem cachedItem;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing cache " + cacheableItem.getCacheName() + " for resource " + uri));
        }
        if ((cachedItem = this.getCachedItem(uri, cacheableItem)) != null) {
            this.getHibernateTemplate().delete((Object)cachedItem);
        }
    }

    public void clearCache(final RepositoryCacheableItem cacheableItem) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            public Object execute() {
                HibernateRepositoryCache.this.removeCached(cacheableItem);
                return null;
            }
        }, false);
    }

    protected void removeCached(RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entire cache " + cacheableItem.getCacheName()));
        }
        this.getHibernateTemplate().bulkUpdate("delete CachedItem where cacheName = ?", (Object)cacheableItem.getCacheName());
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }
}

