/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateDaoImpl
extends HibernateDaoSupport {
    private static final Log log = LogFactory.getLog(HibernateDaoImpl.class);
    private final ThreadLocal operationDate = new ThreadLocal();

    protected final Object executeCallback(DaoCallback callback) {
        try {
            Object ret = callback.execute();
            return ret;
        }
        catch (DataAccessException e) {
            log.error((Object)"Hibernate DataAccessException", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected final Object executeWriteCallback(DaoCallback callback) {
        return this.executeWriteCallback(callback, true);
    }

    protected final Object executeWriteCallback(DaoCallback callback, boolean flush) {
        this.startOperation();
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int origFlushMode = hibernateTemplate.getFlushMode();
        try {
            hibernateTemplate.setFlushMode(3);
            Object ret = callback.execute();
            if (flush) {
                hibernateTemplate.flush();
            }
            Object object = ret;
            return object;
        }
        catch (DataAccessException e) {
            log.error((Object)"Hibernate DataAccessException", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            hibernateTemplate.setFlushMode(origFlushMode);
            this.endOperation();
        }
    }

    protected void startOperation() {
        this.operationDate.set(new Date());
    }

    protected Date getOperationTimestamp() {
        return (Date)this.operationDate.get();
    }

    protected void endOperation() {
        this.operationDate.set(null);
    }

    protected static interface DaoCallback {
        public Object execute();
    }
}

