/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.rmi;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.WizardDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.PageSize;
import java.awt.Frame;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;

public class IReportTCPServer
implements Runnable {
    static IReportTCPServer mainInstance = null;

    public static IReportTCPServer getMainInstance() {
        if (mainInstance == null) {
            try {
                mainInstance = new IReportTCPServer();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return mainInstance;
    }

    public static void runServer() {
        if (MainFrame.getMainInstance().getProperties().getProperty("enableRMIServer", "false").equals("true")) {
            Thread t = new Thread(IReportTCPServer.getMainInstance());
            t.start();
        }
    }

    public void run() {
        ServerSocket serverSocket = null;
        Socket clientSocket = null;
        int port = 2100;
        try {
            port = Integer.parseInt(MainFrame.getMainInstance().getProperties().getProperty("RMIServerPort", "2100"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            serverSocket = new ServerSocket(port);
            MainFrame.getMainInstance().logOnConsole("Demone listening on port: " + serverSocket.getLocalPort());
        }
        catch (IOException e) {
            MainFrame.getMainInstance().logOnConsole("Error opening the socket : " + e.getMessage());
            return;
        }
        while (true) {
            DataInputStream is = null;
            PrintStream os = null;
            clientSocket = null;
            try {
                clientSocket = serverSocket.accept();
                is = new DataInputStream(clientSocket.getInputStream());
                final String line = is.readLine();
                os = new PrintStream(clientSocket.getOutputStream());
                if (line == null) {
                    os.write(new String("-Unknow command!").getBytes());
                    os.close();
                    clientSocket.close();
                    continue;
                }
                os.write(new String("+OK Give me five!").getBytes());
                os.close();
                clientSocket.close();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            block5: {
                                try {
                                    if (line.toUpperCase().startsWith("PING")) break block5;
                                    if (line.toUpperCase().startsWith("WIZARD ")) {
                                        IReportTCPServer.this.runWizard(line.substring(7));
                                        break block5;
                                    }
                                    if (line.toUpperCase().startsWith("OPENFILE ")) {
                                        IReportTCPServer.this.openFile(line.substring(9));
                                        break block5;
                                    }
                                    if (line.toUpperCase().startsWith("SETVISIBLE ")) {
                                        IReportTCPServer.this.setVisible(Boolean.valueOf(line.substring(11).trim()));
                                        break block5;
                                    }
                                    throw new Exception("Unknow command: " + line);
                                }
                                catch (Throwable tr) {
                                    tr.printStackTrace();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
            catch (IOException e) {
            }
        }
    }

    public boolean runWizard(String destFile) {
        MainFrame mainFrame = MainFrame.getMainInstance();
        if (mainFrame == null) {
            return false;
        }
        mainFrame.logOnConsole("Invocato wizard");
        mainFrame.logOnConsole("Pronto ad invocare la nuova finestra..." + Thread.currentThread().getName());
        try {
            WizardDialog wd = new WizardDialog((Frame)mainFrame, true);
            mainFrame.logOnConsole("Lancio wizard");
            wd.setVisible(true);
            wd.requestFocus();
            Report report = null;
            if (wd.getDialogResult() == 0) {
                report = wd.getReport();
                if (report == null) {
                    report = this.createBlankReport();
                }
            } else {
                report = this.createBlankReport();
            }
            if (report != null) {
                mainFrame.openNewReportWindow(report);
                report.setFilename(destFile);
                report.saveXMLFile();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return true;
    }

    private Report createBlankReport() {
        Report newReport = new Report();
        newReport.setName(I18n.getString("untitledReport", "untitled_report_") + "1");
        newReport.setUsingMultiLineExpressions(false);
        newReport.setWidth(PageSize.A4.x);
        newReport.setHeight(PageSize.A4.y);
        newReport.setTopMargin(20);
        newReport.setLeftMargin(30);
        newReport.setRightMargin(30);
        newReport.setBottomMargin(20);
        newReport.setColumnCount(1);
        newReport.setColumnWidth(newReport.getWidth() - newReport.getLeftMargin() - newReport.getRightMargin());
        newReport.setColumnSpacing(0);
        return newReport;
    }

    public boolean ping() {
        return true;
    }

    public boolean setVisible(boolean b) {
        MainFrame.getMainInstance().setVisible(b);
        if (MainFrame.getMainInstance().getState() == 1) {
            MainFrame.getMainInstance().setState(0);
        }
        return MainFrame.getMainInstance().requestFocusInWindow();
    }

    public boolean openFile(String file) {
        this.setVisible(true);
        try {
            JReportFrame jrf = MainFrame.getMainInstance().openFile(file);
            jrf.setSelected(true);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

